/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.analysis;

import java.util.List;
import java.util.Set;

public class CatalogSchemaIdentifierNameResolver {
    public static final String DEFAULT_CATALOG_NAME = "@opensearch";
    public static final String DEFAULT_SCHEMA_NAME = "default";
    public static final String INFORMATION_SCHEMA_NAME = "information_schema";
    private String catalogName = "@opensearch";
    private String schemaName = "default";
    private String identifierName;
    private static final String DOT = ".";

    public CatalogSchemaIdentifierNameResolver(List<String> parts, Set<String> allowedCatalogs) {
        List<String> remainingParts = this.captureSchemaName(this.captureCatalogName(parts, allowedCatalogs));
        this.identifierName = String.join((CharSequence)DOT, remainingParts);
    }

    public String getIdentifierName() {
        return this.identifierName;
    }

    public String getCatalogName() {
        return this.catalogName;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    private List<String> captureCatalogName(List<String> parts, Set<String> allowedCatalogs) {
        if (parts.size() > 1 && allowedCatalogs.contains(parts.get(0)) || DEFAULT_CATALOG_NAME.equals(parts.get(0))) {
            this.catalogName = parts.get(0);
            return parts.subList(1, parts.size());
        }
        return parts;
    }

    private List<String> captureSchemaName(List<String> parts) {
        if (parts.size() > 1 && (DEFAULT_SCHEMA_NAME.equals(parts.get(0)) || INFORMATION_SCHEMA_NAME.contains(parts.get(0)))) {
            this.schemaName = parts.get(0);
            return parts.subList(1, parts.size());
        }
        return parts;
    }
}

