/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.opensearch.storage.script.sort;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.opensearch.search.sort.FieldSortBuilder;
import org.opensearch.search.sort.SortBuilder;
import org.opensearch.search.sort.SortBuilders;
import org.opensearch.search.sort.SortOrder;
import org.opensearch.sql.ast.tree.Sort;
import org.opensearch.sql.expression.Expression;
import org.opensearch.sql.expression.ReferenceExpression;
import org.opensearch.sql.opensearch.storage.script.ScriptUtils;

public class SortQueryBuilder {
    private Map<Sort.SortOrder, SortOrder> sortOrderMap = new ImmutableMap.Builder().put((Object)Sort.SortOrder.ASC, (Object)SortOrder.ASC).put((Object)Sort.SortOrder.DESC, (Object)SortOrder.DESC).build();
    private Map<Sort.NullOrder, String> missingMap = new ImmutableMap.Builder().put((Object)Sort.NullOrder.NULL_FIRST, (Object)"_first").put((Object)Sort.NullOrder.NULL_LAST, (Object)"_last").build();

    public SortBuilder<?> build(Expression expression, Sort.SortOption option) {
        if (expression instanceof ReferenceExpression) {
            return this.fieldBuild((ReferenceExpression)expression, option);
        }
        throw new IllegalStateException("unsupported expression " + expression.getClass());
    }

    private FieldSortBuilder fieldBuild(ReferenceExpression ref, Sort.SortOption option) {
        return ((FieldSortBuilder)SortBuilders.fieldSort((String)ScriptUtils.convertTextToKeyword(ref.getAttr(), ref.type())).order(this.sortOrderMap.get(option.getSortOrder()))).missing((Object)this.missingMap.get(option.getNullOrder()));
    }
}

