/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.prometheus.authinterceptors;

import com.babbel.mobile.android.commons.okhttpawssigner.OkHttpAwsV4Signer;
import java.io.IOException;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import lombok.NonNull;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

public class AwsSigningInterceptor
implements Interceptor {
    private OkHttpAwsV4Signer okHttpAwsV4Signer;
    private String accessKey;
    private String secretKey;

    public AwsSigningInterceptor(@NonNull String accessKey, @NonNull String secretKey, @NonNull String region, @NonNull String serviceName) {
        if (accessKey == null) {
            throw new NullPointerException("accessKey is marked non-null but is null");
        }
        if (secretKey == null) {
            throw new NullPointerException("secretKey is marked non-null but is null");
        }
        if (region == null) {
            throw new NullPointerException("region is marked non-null but is null");
        }
        if (serviceName == null) {
            throw new NullPointerException("serviceName is marked non-null but is null");
        }
        this.okHttpAwsV4Signer = new OkHttpAwsV4Signer(region, serviceName);
        this.accessKey = accessKey;
        this.secretKey = secretKey;
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        DateTimeFormatter timestampFormat = DateTimeFormatter.ofPattern("yyyyMMdd'T'HHmmss'Z'").withZone(ZoneId.of("GMT"));
        Request newRequest = request.newBuilder().addHeader("x-amz-date", timestampFormat.format(ZonedDateTime.now())).addHeader("host", request.url().host()).build();
        Request signed = this.okHttpAwsV4Signer.sign(newRequest, this.accessKey, this.secretKey);
        return chain.proceed(signed);
    }
}

