/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.legacy.query.join;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.opensearch.client.Client;
import org.opensearch.sql.legacy.domain.Condition;
import org.opensearch.sql.legacy.domain.Field;
import org.opensearch.sql.legacy.domain.JoinSelect;
import org.opensearch.sql.legacy.domain.Where;
import org.opensearch.sql.legacy.domain.hints.Hint;
import org.opensearch.sql.legacy.domain.hints.HintType;
import org.opensearch.sql.legacy.exception.SqlParseException;
import org.opensearch.sql.legacy.query.join.HashJoinElasticRequestBuilder;
import org.opensearch.sql.legacy.query.join.JoinRequestBuilder;
import org.opensearch.sql.legacy.query.join.OpenSearchJoinQueryAction;
import org.opensearch.sql.legacy.query.planner.HashJoinQueryPlanRequestBuilder;

public class OpenSearchHashJoinQueryAction
extends OpenSearchJoinQueryAction {
    public OpenSearchHashJoinQueryAction(Client client, JoinSelect joinSelect) {
        super(client, joinSelect);
    }

    @Override
    protected void fillSpecificRequestBuilder(JoinRequestBuilder requestBuilder) throws SqlParseException {
        String t1Alias = this.joinSelect.getFirstTable().getAlias();
        String t2Alias = this.joinSelect.getSecondTable().getAlias();
        List<List<Map.Entry<Field, Field>>> comparisonFields = this.getComparisonFields(t1Alias, t2Alias, this.joinSelect.getConnectedWhere());
        ((HashJoinElasticRequestBuilder)requestBuilder).setT1ToT2FieldsComparison(comparisonFields);
    }

    @Override
    protected JoinRequestBuilder createSpecificBuilder() {
        if (this.isLegacy()) {
            return new HashJoinElasticRequestBuilder();
        }
        return new HashJoinQueryPlanRequestBuilder(this.client, this.sqlRequest);
    }

    @Override
    protected void updateRequestWithHints(JoinRequestBuilder requestBuilder) {
        super.updateRequestWithHints(requestBuilder);
        for (Hint hint : this.joinSelect.getHints()) {
            if (hint.getType() != HintType.HASH_WITH_TERMS_FILTER) continue;
            ((HashJoinElasticRequestBuilder)requestBuilder).setUseTermFiltersOptimization(true);
        }
    }

    private boolean isLegacy() {
        for (Hint hint : this.joinSelect.getHints()) {
            if (hint.getType() != HintType.JOIN_ALGORITHM_USE_LEGACY) continue;
            return true;
        }
        return false;
    }

    private List<Map.Entry<Field, Field>> getComparisonFields(String t1Alias, String t2Alias, List<Condition> connectedConditions) throws SqlParseException {
        ArrayList<Map.Entry<Field, Field>> comparisonFields = new ArrayList<Map.Entry<Field, Field>>();
        for (Condition condition : connectedConditions) {
            Field t2Field;
            Field t1Field;
            if (condition.getOPERATOR() != Condition.OPERATOR.EQ) {
                throw new SqlParseException(String.format("HashJoin should only be with EQ conditions, got:%s on condition:%s", condition.getOPERATOR().name(), condition.toString()));
            }
            String firstField = condition.getName();
            String secondField = condition.getValue().toString();
            if (firstField.startsWith(t1Alias)) {
                t1Field = new Field(this.removeAlias(firstField, t1Alias), null);
                t2Field = new Field(this.removeAlias(secondField, t2Alias), null);
            } else {
                t1Field = new Field(this.removeAlias(secondField, t1Alias), null);
                t2Field = new Field(this.removeAlias(firstField, t2Alias), null);
            }
            comparisonFields.add(new AbstractMap.SimpleEntry<Field, Field>(t1Field, t2Field));
        }
        return comparisonFields;
    }

    private List<List<Map.Entry<Field, Field>>> getComparisonFields(String t1Alias, String t2Alias, Where connectedWhere) throws SqlParseException {
        ArrayList<List<Map.Entry<Field, Field>>> comparisonFields = new ArrayList<List<Map.Entry<Field, Field>>>();
        if (connectedWhere == null) {
            return comparisonFields;
        }
        boolean allAnds = true;
        for (Where innerWhere : connectedWhere.getWheres()) {
            if (innerWhere.getConn() != Where.CONN.OR) continue;
            allAnds = false;
            break;
        }
        if (allAnds) {
            List<Map.Entry<Field, Field>> innerComparisonFields = this.getComparisonFieldsFromWhere(t1Alias, t2Alias, connectedWhere);
            comparisonFields.add(innerComparisonFields);
        } else {
            for (Where innerWhere : connectedWhere.getWheres()) {
                comparisonFields.add(this.getComparisonFieldsFromWhere(t1Alias, t2Alias, innerWhere));
            }
        }
        return comparisonFields;
    }

    private List<Map.Entry<Field, Field>> getComparisonFieldsFromWhere(String t1Alias, String t2Alias, Where where) throws SqlParseException {
        ArrayList<Condition> conditions = new ArrayList<Condition>();
        if (where instanceof Condition) {
            conditions.add((Condition)where);
        } else {
            for (Where innerWhere : where.getWheres()) {
                if (!(innerWhere instanceof Condition)) {
                    throw new SqlParseException("if connectedCondition is AND then all inner wheres should be Conditions");
                }
                conditions.add((Condition)innerWhere);
            }
        }
        return this.getComparisonFields(t1Alias, t2Alias, conditions);
    }

    private String removeAlias(String field, String alias) {
        return field.replace(alias + ".", "");
    }
}

