/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.commons.alerting.model;

import com.cronutils.model.CronType;
import com.cronutils.model.definition.CronDefinitionBuilder;
import com.cronutils.parser.CronParser;
import java.io.IOException;
import java.time.DateTimeException;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.time.zone.ZoneRulesException;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.xcontent.XContentParser;
import org.opensearch.common.xcontent.XContentParserUtils;
import org.opensearch.commons.alerting.model.CronSchedule;
import org.opensearch.commons.alerting.model.IntervalSchedule;
import org.opensearch.commons.notifications.model.BaseModel;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 \u00112\u00020\u0001:\u0002\u0011\u0012B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00042\b\u0010\u0006\u001a\u0004\u0018\u00010\u0004H&J\u001e\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\b2\b\u0010\t\u001a\u0004\u0018\u00010\u0004H&J\u001e\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\b2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0004H&J\u0012\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0005\u001a\u00020\u0004H&J\u0012\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0004H&\u0082\u0001\u0002\u0013\u0014\u00a8\u0006\u0015"}, d2={"Lorg/opensearch/commons/alerting/model/Schedule;", "Lorg/opensearch/commons/notifications/model/BaseModel;", "()V", "getExpectedNextExecutionTime", "Ljava/time/Instant;", "enabledTime", "expectedPreviousExecutionTime", "getPeriodEndingAt", "Lkotlin/Pair;", "endTime", "getPeriodStartingAt", "startTime", "nextTimeToExecute", "Ljava/time/Duration;", "runningOnTime", "", "lastExecutionTime", "Companion", "TYPE", "Lorg/opensearch/commons/alerting/model/CronSchedule;", "Lorg/opensearch/commons/alerting/model/IntervalSchedule;", "common-utils"})
public abstract class Schedule
implements BaseModel {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String CRON_FIELD = "cron";
    @NotNull
    public static final String EXPRESSION_FIELD = "expression";
    @NotNull
    public static final String TIMEZONE_FIELD = "timezone";
    @NotNull
    public static final String PERIOD_FIELD = "period";
    @NotNull
    public static final String INTERVAL_FIELD = "interval";
    @NotNull
    public static final String UNIT_FIELD = "unit";
    @NotNull
    private static final CronParser cronParser = new CronParser(CronDefinitionBuilder.instanceDefinitionFor((CronType)CronType.UNIX));

    private Schedule() {
    }

    @Nullable
    public abstract Duration nextTimeToExecute(@NotNull Instant var1);

    @Nullable
    public abstract Instant getExpectedNextExecutionTime(@NotNull Instant var1, @Nullable Instant var2);

    @NotNull
    public abstract Pair<Instant, Instant> getPeriodStartingAt(@Nullable Instant var1);

    @NotNull
    public abstract Pair<Instant, Instant> getPeriodEndingAt(@Nullable Instant var1);

    public abstract boolean runningOnTime(@Nullable Instant var1);

    @JvmStatic
    @NotNull
    public static final Schedule parse(@NotNull XContentParser xcp) throws IOException {
        return Companion.parse(xcp);
    }

    @JvmStatic
    private static final ZoneId getTimeZone(String timeZone) throws IllegalArgumentException {
        return Schedule.Companion.getTimeZone(timeZone);
    }

    @JvmStatic
    @NotNull
    public static final Schedule readFrom(@NotNull StreamInput sin) throws IOException {
        return Companion.readFrom(sin);
    }

    public /* synthetic */ Schedule(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lorg/opensearch/commons/alerting/model/Schedule$TYPE;", "", "(Ljava/lang/String;I)V", "CRON", "INTERVAL", "common-utils"})
    public static final class TYPE
    extends Enum<TYPE> {
        public static final /* enum */ TYPE CRON = new TYPE();
        public static final /* enum */ TYPE INTERVAL = new TYPE();
        private static final /* synthetic */ TYPE[] $VALUES;

        public static TYPE[] values() {
            return (TYPE[])$VALUES.clone();
        }

        public static TYPE valueOf(String value) {
            return Enum.valueOf(TYPE.class, value);
        }

        static {
            $VALUES = tYPEArray = new TYPE[]{TYPE.CRON, TYPE.INTERVAL};
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0004H\u0003J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0007J\u0010\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0017H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0018"}, d2={"Lorg/opensearch/commons/alerting/model/Schedule$Companion;", "", "()V", "CRON_FIELD", "", "EXPRESSION_FIELD", "INTERVAL_FIELD", "PERIOD_FIELD", "TIMEZONE_FIELD", "UNIT_FIELD", "cronParser", "Lcom/cronutils/parser/CronParser;", "getCronParser", "()Lcom/cronutils/parser/CronParser;", "getTimeZone", "Ljava/time/ZoneId;", "timeZone", "parse", "Lorg/opensearch/commons/alerting/model/Schedule;", "xcp", "Lorg/opensearch/common/xcontent/XContentParser;", "readFrom", "sin", "Lorg/opensearch/common/io/stream/StreamInput;", "common-utils"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final CronParser getCronParser() {
            return cronParser;
        }

        @JvmStatic
        @NotNull
        public final Schedule parse(@NotNull XContentParser xcp) throws IOException {
            Intrinsics.checkNotNullParameter((Object)xcp, (String)"xcp");
            String expression = null;
            ZoneId timezone = null;
            Integer interval = null;
            ChronoUnit unit = null;
            Schedule schedule = null;
            TYPE type = null;
            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
            while (xcp.nextToken() != XContentParser.Token.END_OBJECT) {
                String string;
                String string2;
                String cronFieldName;
                String fieldname = xcp.currentName();
                xcp.nextToken();
                if (type != null) {
                    throw new IllegalArgumentException("You can only specify one type of schedule.");
                }
                String string3 = fieldname;
                if (Intrinsics.areEqual((Object)string3, (Object)Schedule.CRON_FIELD)) {
                    type = TYPE.CRON;
                    while (xcp.nextToken() != XContentParser.Token.END_OBJECT) {
                        cronFieldName = xcp.currentName();
                        xcp.nextToken();
                        string2 = cronFieldName;
                        if (Intrinsics.areEqual((Object)string2, (Object)Schedule.EXPRESSION_FIELD)) {
                            expression = xcp.textOrNull();
                            continue;
                        }
                        if (!Intrinsics.areEqual((Object)string2, (Object)Schedule.TIMEZONE_FIELD)) continue;
                        string = xcp.text();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"xcp.text()");
                        timezone = this.getTimeZone(string);
                    }
                    continue;
                }
                if (Intrinsics.areEqual((Object)string3, (Object)Schedule.PERIOD_FIELD)) {
                    type = TYPE.INTERVAL;
                    while (xcp.nextToken() != XContentParser.Token.END_OBJECT) {
                        cronFieldName = xcp.currentName();
                        xcp.nextToken();
                        string2 = cronFieldName;
                        if (Intrinsics.areEqual((Object)string2, (Object)Schedule.INTERVAL_FIELD)) {
                            interval = xcp.intValue();
                            continue;
                        }
                        if (!Intrinsics.areEqual((Object)string2, (Object)Schedule.UNIT_FIELD)) continue;
                        string = xcp.text();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"xcp.text()");
                        Locale locale = Locale.getDefault();
                        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault()");
                        String string4 = string.toUpperCase(locale);
                        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String).toUpperCase(locale)");
                        unit = ChronoUnit.valueOf(string4);
                    }
                    continue;
                }
                throw new IllegalArgumentException("Invalid field: [" + fieldname + "] found in schedule.");
            }
            if (type == TYPE.CRON) {
                String string = expression;
                if (string == null) {
                    boolean $i$a$-requireNotNull-Schedule$Companion$parse$62 = false;
                    String $i$a$-requireNotNull-Schedule$Companion$parse$62 = "Expression in cron schedule is null.";
                    throw new IllegalArgumentException($i$a$-requireNotNull-Schedule$Companion$parse$62.toString());
                }
                ZoneId zoneId = timezone;
                if (zoneId == null) {
                    String string5 = string;
                    boolean $i$a$-requireNotNull-Schedule$Companion$parse$72 = false;
                    String string6 = string5;
                    String $i$a$-requireNotNull-Schedule$Companion$parse$72 = "Timezone in cron schedule is null.";
                    throw new IllegalArgumentException($i$a$-requireNotNull-Schedule$Companion$parse$72.toString());
                }
                DefaultConstructorMarker defaultConstructorMarker = null;
                int n = 4;
                Instant instant = null;
                ZoneId zoneId2 = zoneId;
                String string7 = string;
                schedule = new CronSchedule(string7, zoneId2, instant, n, defaultConstructorMarker);
            } else if (type == TYPE.INTERVAL) {
                Integer n = interval;
                if (n == null) {
                    boolean $i$a$-requireNotNull-Schedule$Companion$parse$82 = false;
                    String $i$a$-requireNotNull-Schedule$Companion$parse$82 = "Interval in period schedule is null.";
                    throw new IllegalArgumentException($i$a$-requireNotNull-Schedule$Companion$parse$82.toString());
                }
                int n2 = ((Number)n).intValue();
                ChronoUnit chronoUnit = unit;
                if (chronoUnit == null) {
                    int n3 = n2;
                    boolean $i$a$-requireNotNull-Schedule$Companion$parse$92 = false;
                    String string = "Unit in period schedule is null.";
                    int n4 = n3;
                    String $i$a$-requireNotNull-Schedule$Companion$parse$92 = string;
                    throw new IllegalArgumentException($i$a$-requireNotNull-Schedule$Companion$parse$92.toString());
                }
                DefaultConstructorMarker defaultConstructorMarker = null;
                int n5 = 4;
                Instant instant = null;
                ChronoUnit chronoUnit2 = chronoUnit;
                int n6 = n2;
                schedule = new IntervalSchedule(n6, chronoUnit2, instant, n5, defaultConstructorMarker);
            }
            Schedule schedule2 = schedule;
            if (schedule2 == null) {
                boolean bl = false;
                String string = "Schedule is null.";
                throw new IllegalArgumentException(string.toString());
            }
            return schedule2;
        }

        @JvmStatic
        private final ZoneId getTimeZone(String timeZone) throws IllegalArgumentException {
            try {
                ZoneId zoneId = ZoneId.of(timeZone);
                Intrinsics.checkNotNullExpressionValue((Object)zoneId, (String)"of(timeZone)");
                return zoneId;
            }
            catch (ZoneRulesException zre) {
                throw new IllegalArgumentException("Timezone " + timeZone + " is not supported");
            }
            catch (DateTimeException dte) {
                throw new IllegalArgumentException("Timezone " + timeZone + " is not supported");
            }
        }

        @JvmStatic
        @NotNull
        public final Schedule readFrom(@NotNull StreamInput sin) throws IOException {
            Intrinsics.checkNotNullParameter((Object)sin, (String)"sin");
            TYPE type = (TYPE)sin.readEnum(TYPE.class);
            if (type == TYPE.CRON) {
                return new CronSchedule(sin);
            }
            return new IntervalSchedule(sin);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

