/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.common.output.execute.anomalylocalization;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import lombok.Generated;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.common.xcontent.ToXContent;
import org.opensearch.common.xcontent.XContentBuilder;
import org.opensearch.common.xcontent.XContentParser;
import org.opensearch.common.xcontent.XContentParserUtils;
import org.opensearch.ml.common.FunctionName;
import org.opensearch.ml.common.annotation.ExecuteOutput;
import org.opensearch.ml.common.output.Output;
import org.opensearch.ml.common.output.execute.anomalylocalization.Counter;

@ExecuteOutput(algorithms={FunctionName.ANOMALY_LOCALIZATION})
public class AnomalyLocalizationOutput
implements Output {
    public static final String FIELD_RESULTS = "results";
    public static final String FIELD_NAME = "name";
    public static final String FIELD_RESULT = "result";
    private Map<String, Result> results = new HashMap<String, Result>();

    public AnomalyLocalizationOutput(StreamInput in) throws IOException {
        this.results = in.readMap(StreamInput::readString, Result::new);
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeMap(this.results, StreamOutput::writeString, (o, r) -> r.writeTo(o));
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) {
        builder.startArray(FIELD_RESULTS);
        for (Map.Entry<String, Result> entry : this.results.entrySet()) {
            builder.startObject();
            builder.field(FIELD_NAME, entry.getKey());
            builder.field(FIELD_RESULT, (ToXContent)entry.getValue());
            builder.endObject();
        }
        builder.endArray();
        return builder;
    }

    public static AnomalyLocalizationOutput parse(XContentParser parser) throws IOException {
        AnomalyLocalizationOutput output = new AnomalyLocalizationOutput();
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
        block6: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            switch (parser.currentName()) {
                case "results": {
                    AnomalyLocalizationOutput.parseResultMapEntry(parser, output);
                    continue block6;
                }
            }
            parser.skipChildren();
        }
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.END_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        return output;
    }

    private static void parseResultMapEntry(XContentParser parser, AnomalyLocalizationOutput output) throws IOException {
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
        while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
            String key = null;
            Result result = new Result();
            block9: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
                switch (parser.currentName()) {
                    case "name": {
                        parser.nextToken();
                        key = parser.text();
                        continue block9;
                    }
                    case "result": {
                        AnomalyLocalizationOutput.parseResult(parser, result);
                        continue block9;
                    }
                }
                parser.skipChildren();
            }
            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.END_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
            output.getResults().put(key, result);
        }
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.END_ARRAY, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
    }

    private static void parseResult(XContentParser parser, Result result) throws IOException {
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
        while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            switch (parser.currentName()) {
                case "buckets": {
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
                    while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                        Bucket bucket = new Bucket();
                        AnomalyLocalizationOutput.parseBucket(parser, bucket);
                        result.getBuckets().add(bucket);
                    }
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.END_ARRAY, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
                }
            }
        }
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.END_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
    }

    private static void parseBucket(XContentParser parser, Bucket bucket) throws IOException {
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        block12: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            switch (parser.currentName()) {
                case "start_time": {
                    parser.nextToken();
                    bucket.setStartTime(parser.longValue());
                    continue block12;
                }
                case "end_time": {
                    parser.nextToken();
                    bucket.setEndTime(parser.longValue());
                    continue block12;
                }
                case "overall_aggregate_value": {
                    parser.nextToken();
                    bucket.setOverallAggValue(parser.doubleValue());
                    continue block12;
                }
                case "entities": {
                    AnomalyLocalizationOutput.parseEntities(parser, bucket);
                    continue block12;
                }
            }
            parser.skipChildren();
        }
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.END_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
    }

    private static void parseEntities(XContentParser parser, Bucket bucket) throws IOException {
        ArrayList<Entity> entities = new ArrayList<Entity>();
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
        while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
            Entity entity = new Entity();
            block13: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
                switch (parser.currentName()) {
                    case "key": {
                        ArrayList<String> key = new ArrayList<String>();
                        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
                        while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                            key.add(parser.text());
                        }
                        entity.setKey(key);
                        continue block13;
                    }
                    case "contribution_value": {
                        parser.nextToken();
                        entity.setContributionValue(parser.doubleValue());
                        continue block13;
                    }
                    case "base_value": {
                        parser.nextToken();
                        entity.setBaseValue(parser.doubleValue());
                        continue block13;
                    }
                    case "new_value": {
                        parser.nextToken();
                        entity.setNewValue(parser.doubleValue());
                        continue block13;
                    }
                }
                parser.skipChildren();
            }
            entities.add(entity);
        }
        bucket.setEntities(entities);
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.END_ARRAY, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
    }

    @Generated
    public Map<String, Result> getResults() {
        return this.results;
    }

    @Generated
    public void setResults(Map<String, Result> results) {
        this.results = results;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AnomalyLocalizationOutput)) {
            return false;
        }
        AnomalyLocalizationOutput other = (AnomalyLocalizationOutput)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<String, Result> this$results = this.getResults();
        Map<String, Result> other$results = other.getResults();
        return !(this$results == null ? other$results != null : !((Object)this$results).equals(other$results));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AnomalyLocalizationOutput;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<String, Result> $results = this.getResults();
        result = result * 59 + ($results == null ? 43 : ((Object)$results).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "AnomalyLocalizationOutput(results=" + this.getResults() + ")";
    }

    @Generated
    public AnomalyLocalizationOutput() {
    }

    public static class Result
    implements Output {
        public static final String FIELD_BUCKETS = "buckets";
        private List<Bucket> buckets = new ArrayList<Bucket>();

        public Result(StreamInput in) throws IOException {
            this.buckets = in.readList(Bucket::new);
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeList(this.buckets);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) {
            builder.startObject();
            builder.field(FIELD_BUCKETS, (Object)this.buckets.toArray());
            builder.endObject();
            return builder;
        }

        @Generated
        public List<Bucket> getBuckets() {
            return this.buckets;
        }

        @Generated
        public void setBuckets(List<Bucket> buckets) {
            this.buckets = buckets;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Result)) {
                return false;
            }
            Result other = (Result)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<Bucket> this$buckets = this.getBuckets();
            List<Bucket> other$buckets = other.getBuckets();
            return !(this$buckets == null ? other$buckets != null : !((Object)this$buckets).equals(other$buckets));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Result;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<Bucket> $buckets = this.getBuckets();
            result = result * 59 + ($buckets == null ? 43 : ((Object)$buckets).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "AnomalyLocalizationOutput.Result(buckets=" + this.getBuckets() + ")";
        }

        @Generated
        public Result() {
        }
    }

    public static class Bucket
    implements Output {
        public static final String FIELD_START_TIME = "start_time";
        public static final String FIELD_END_TIME = "end_time";
        public static final String FIELD_OVERALL_VALUE = "overall_aggregate_value";
        public static final String FIELD_ENTITIES = "entities";
        private long startTime;
        private long endTime;
        private double overallAggValue;
        private List<Entity> entities = null;
        private Optional<Bucket> base = Optional.empty();
        private Optional<Counter> counter = Optional.empty();
        private AtomicBoolean completed = null;

        public Bucket(StreamInput in) throws IOException {
            this.startTime = in.readLong();
            this.endTime = in.readLong();
            this.overallAggValue = in.readDouble();
            if (in.readBoolean()) {
                this.entities = in.readList(Entity::new);
            }
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeLong(this.startTime);
            out.writeLong(this.endTime);
            out.writeDouble(this.overallAggValue);
            if (this.entities == null) {
                out.writeBoolean(false);
            } else {
                out.writeBoolean(true);
                out.writeList(this.entities);
            }
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) {
            builder.startObject();
            builder.field(FIELD_START_TIME, this.startTime);
            builder.field(FIELD_END_TIME, this.endTime);
            builder.field(FIELD_OVERALL_VALUE, this.overallAggValue);
            if (this.entities != null && !this.entities.isEmpty()) {
                builder.field(FIELD_ENTITIES, this.entities);
            }
            builder.endObject();
            return builder;
        }

        @Generated
        public long getStartTime() {
            return this.startTime;
        }

        @Generated
        public long getEndTime() {
            return this.endTime;
        }

        @Generated
        public double getOverallAggValue() {
            return this.overallAggValue;
        }

        @Generated
        public List<Entity> getEntities() {
            return this.entities;
        }

        @Generated
        public Optional<Bucket> getBase() {
            return this.base;
        }

        @Generated
        public Optional<Counter> getCounter() {
            return this.counter;
        }

        @Generated
        public AtomicBoolean getCompleted() {
            return this.completed;
        }

        @Generated
        public void setStartTime(long startTime) {
            this.startTime = startTime;
        }

        @Generated
        public void setEndTime(long endTime) {
            this.endTime = endTime;
        }

        @Generated
        public void setOverallAggValue(double overallAggValue) {
            this.overallAggValue = overallAggValue;
        }

        @Generated
        public void setEntities(List<Entity> entities) {
            this.entities = entities;
        }

        @Generated
        public void setBase(Optional<Bucket> base) {
            this.base = base;
        }

        @Generated
        public void setCounter(Optional<Counter> counter) {
            this.counter = counter;
        }

        @Generated
        public void setCompleted(AtomicBoolean completed) {
            this.completed = completed;
        }

        @Generated
        public Bucket() {
        }

        @Generated
        public String toString() {
            return "AnomalyLocalizationOutput.Bucket(startTime=" + this.getStartTime() + ", endTime=" + this.getEndTime() + ", overallAggValue=" + this.getOverallAggValue() + ", entities=" + this.getEntities() + ")";
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Bucket)) {
                return false;
            }
            Bucket other = (Bucket)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getStartTime() != other.getStartTime()) {
                return false;
            }
            if (this.getEndTime() != other.getEndTime()) {
                return false;
            }
            if (Double.compare(this.getOverallAggValue(), other.getOverallAggValue()) != 0) {
                return false;
            }
            List<Entity> this$entities = this.getEntities();
            List<Entity> other$entities = other.getEntities();
            return !(this$entities == null ? other$entities != null : !((Object)this$entities).equals(other$entities));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Bucket;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $startTime = this.getStartTime();
            result = result * 59 + (int)($startTime >>> 32 ^ $startTime);
            long $endTime = this.getEndTime();
            result = result * 59 + (int)($endTime >>> 32 ^ $endTime);
            long $overallAggValue = Double.doubleToLongBits(this.getOverallAggValue());
            result = result * 59 + (int)($overallAggValue >>> 32 ^ $overallAggValue);
            List<Entity> $entities = this.getEntities();
            result = result * 59 + ($entities == null ? 43 : ((Object)$entities).hashCode());
            return result;
        }
    }

    public static class Entity
    implements Output {
        public static final String FIELD_KEY = "key";
        public static final String FIELD_CONTRIBUTION_VALUE = "contribution_value";
        public static final String FIELD_BASE_VALUE = "base_value";
        public static final String FIELD_NEW_VALUE = "new_value";
        private List<String> key;
        private double contributionValue;
        private double baseValue;
        private double newValue;

        public Entity(StreamInput in) throws IOException {
            this.key = in.readList(StreamInput::readString);
            this.contributionValue = in.readDouble();
            this.baseValue = in.readDouble();
            this.newValue = in.readDouble();
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeStringCollection(this.key);
            out.writeDouble(this.contributionValue);
            out.writeDouble(this.baseValue);
            out.writeDouble(this.newValue);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) {
            builder.startObject();
            builder.field(FIELD_KEY, this.key);
            builder.field(FIELD_CONTRIBUTION_VALUE, this.contributionValue);
            builder.field(FIELD_BASE_VALUE, this.baseValue);
            builder.field(FIELD_NEW_VALUE, this.newValue);
            builder.endObject();
            return builder;
        }

        @Generated
        public List<String> getKey() {
            return this.key;
        }

        @Generated
        public double getContributionValue() {
            return this.contributionValue;
        }

        @Generated
        public double getBaseValue() {
            return this.baseValue;
        }

        @Generated
        public double getNewValue() {
            return this.newValue;
        }

        @Generated
        public void setKey(List<String> key) {
            this.key = key;
        }

        @Generated
        public void setContributionValue(double contributionValue) {
            this.contributionValue = contributionValue;
        }

        @Generated
        public void setBaseValue(double baseValue) {
            this.baseValue = baseValue;
        }

        @Generated
        public void setNewValue(double newValue) {
            this.newValue = newValue;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Entity)) {
                return false;
            }
            Entity other = (Entity)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (Double.compare(this.getContributionValue(), other.getContributionValue()) != 0) {
                return false;
            }
            if (Double.compare(this.getBaseValue(), other.getBaseValue()) != 0) {
                return false;
            }
            if (Double.compare(this.getNewValue(), other.getNewValue()) != 0) {
                return false;
            }
            List<String> this$key = this.getKey();
            List<String> other$key = other.getKey();
            return !(this$key == null ? other$key != null : !((Object)this$key).equals(other$key));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Entity;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $contributionValue = Double.doubleToLongBits(this.getContributionValue());
            result = result * 59 + (int)($contributionValue >>> 32 ^ $contributionValue);
            long $baseValue = Double.doubleToLongBits(this.getBaseValue());
            result = result * 59 + (int)($baseValue >>> 32 ^ $baseValue);
            long $newValue = Double.doubleToLongBits(this.getNewValue());
            result = result * 59 + (int)($newValue >>> 32 ^ $newValue);
            List<String> $key = this.getKey();
            result = result * 59 + ($key == null ? 43 : ((Object)$key).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "AnomalyLocalizationOutput.Entity(key=" + this.getKey() + ", contributionValue=" + this.getContributionValue() + ", baseValue=" + this.getBaseValue() + ", newValue=" + this.getNewValue() + ")";
        }

        @Generated
        public Entity() {
        }
    }
}

