/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.emoji;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.awt.geom.Dimension2D;
import net.sourceforge.plantuml.graphic.AbstractTextBlock;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.log.Logme;
import net.sourceforge.plantuml.security.SImageIO;
import net.sourceforge.plantuml.sprite.Sprite;
import net.sourceforge.plantuml.ugraphic.AffineTransformType;
import net.sourceforge.plantuml.ugraphic.PixelImage;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UImage;
import net.sourceforge.plantuml.ugraphic.color.ColorMapper;
import net.sourceforge.plantuml.ugraphic.color.ColorMapperMonochrome;
import net.sourceforge.plantuml.ugraphic.color.HColor;

public class SpriteSvgNanoParser
implements Sprite {
    private final UImage img;

    public SpriteSvgNanoParser(BufferedImage img) {
        this.img = new UImage(new PixelImage(Objects.requireNonNull(img), AffineTransformType.TYPE_BILINEAR));
    }

    @Override
    public TextBlock asTextBlock(final HColor color, final double scale, final ColorMapper colorMapper) {
        return new AbstractTextBlock(){

            @Override
            public void drawU(UGraphic ug) {
                if (colorMapper instanceof ColorMapperMonochrome) {
                    ug.draw(SpriteSvgNanoParser.this.img.monochrome().scale(scale));
                } else if (color == null) {
                    ug.draw(SpriteSvgNanoParser.this.img.scale(scale));
                } else {
                    ug.draw(SpriteSvgNanoParser.this.img.muteColor(colorMapper.toColor(color)).scale(scale));
                }
            }

            @Override
            public Dimension2D calculateDimension(StringBounder stringBounder) {
                return new Dimension2DDouble((double)SpriteSvgNanoParser.this.img.getWidth() * scale, (double)SpriteSvgNanoParser.this.img.getHeight() * scale);
            }
        };
    }

    public static Sprite fromInternal(String name) {
        if (name.endsWith(".png")) {
            throw new IllegalArgumentException();
        }
        InputStream is = SpriteSvgNanoParser.getInternalSprite(name + ".png");
        if (is == null) {
            return null;
        }
        try {
            return new SpriteSvgNanoParser(SImageIO.read(is));
        }
        catch (IOException e) {
            Logme.error(e);
            return null;
        }
    }

    public static InputStream getInternalSprite(String inner) {
        String path = "/sprites/" + inner;
        InputStream is = SpriteSvgNanoParser.class.getResourceAsStream(path);
        return is;
    }
}

