/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.mindmap;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.SkinParamColors;
import net.sourceforge.plantuml.activitydiagram3.ftile.vertical.FtileBoxOld;
import net.sourceforge.plantuml.awt.geom.Dimension2D;
import net.sourceforge.plantuml.creole.CreoleMode;
import net.sourceforge.plantuml.cucadiagram.Rankdir;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.graphic.UDrawable;
import net.sourceforge.plantuml.graphic.color.ColorType;
import net.sourceforge.plantuml.graphic.color.Colors;
import net.sourceforge.plantuml.mindmap.Finger;
import net.sourceforge.plantuml.mindmap.Idea;
import net.sourceforge.plantuml.mindmap.IdeaShape;
import net.sourceforge.plantuml.mindmap.SymetricalTee;
import net.sourceforge.plantuml.mindmap.SymetricalTeePositioned;
import net.sourceforge.plantuml.mindmap.Tetris;
import net.sourceforge.plantuml.style.ClockwiseTopRightBottomLeft;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UPath;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.ugraphic.color.HColor;

public class FingerImpl
implements Finger,
UDrawable {
    private final Idea idea;
    private final ISkinParam skinParam;
    private final int direction;
    private boolean drawPhalanx = true;
    private final List<FingerImpl> nail = new ArrayList<FingerImpl>();
    private Tetris tetris = null;

    public static FingerImpl build(Idea idea, ISkinParam skinParam, boolean direction) {
        FingerImpl result = new FingerImpl(idea, skinParam, direction);
        for (Idea child : idea.getChildren()) {
            result.addInNail(FingerImpl.build(child, skinParam, direction));
        }
        return result;
    }

    private boolean isTopToBottom() {
        return this.skinParam.getRankdir() == Rankdir.TOP_TO_BOTTOM;
    }

    public void addInNail(FingerImpl child) {
        this.nail.add(child);
    }

    private FingerImpl(Idea idea, ISkinParam skinParam, boolean direction) {
        this.idea = idea;
        this.skinParam = skinParam;
        this.direction = direction ? 1 : -1;
    }

    private ClockwiseTopRightBottomLeft getMargin() {
        return this.getStyle().getMargin();
    }

    @Override
    public void drawU(UGraphic ug) {
        StringBounder stringBounder = ug.getStringBounder();
        TextBlock phalanx = this.getPhalanx();
        Dimension2D dimPhalanx = phalanx.calculateDimension(stringBounder);
        if (this.drawPhalanx) {
            double posY;
            double posX;
            if (this.isTopToBottom()) {
                posX = -this.getPhalanxThickness(stringBounder) / 2.0;
                posY = this.direction == 1 ? 0.0 : -dimPhalanx.getHeight();
            } else {
                posX = this.direction == 1 ? 0.0 : -dimPhalanx.getWidth();
                posY = -this.getPhalanxThickness(stringBounder) / 2.0;
            }
            phalanx.drawU(ug.apply(new UTranslate(posX, posY)));
        }
        Point2D.Double p1 = this.isTopToBottom() ? new Point2D.Double(0.0, (double)this.direction * dimPhalanx.getHeight()) : new Point2D.Double((double)this.direction * dimPhalanx.getWidth(), 0.0);
        for (int i = 0; i < this.nail.size(); ++i) {
            FingerImpl child = this.nail.get(i);
            SymetricalTeePositioned stp = this.getTetris(stringBounder).getElements().get(i);
            Point2D.Double p2 = this.isTopToBottom() ? new Point2D.Double(stp.getY(), (double)this.direction * (dimPhalanx.getHeight() + this.getX12())) : new Point2D.Double((double)this.direction * (dimPhalanx.getWidth() + this.getX12()), stp.getY());
            child.drawU(ug.apply(new UTranslate(p2)));
            this.drawLine(ug.apply(this.getLinkColor()).apply(this.getUStroke()), p1, p2);
        }
    }

    private HColor getLinkColor() {
        Style styleArrow = this.getStyleArrow();
        return styleArrow.value(PName.LineColor).asColor(this.skinParam.getThemeStyle(), this.skinParam.getIHtmlColorSet());
    }

    private UStroke getUStroke() {
        Style styleArrow = this.getStyleArrow();
        return styleArrow.getStroke();
    }

    private void drawLine(UGraphic ug, Point2D p1, Point2D p2) {
        UPath path = new UPath();
        path.moveTo(p1);
        if (this.isTopToBottom()) {
            double delta1 = this.direction * 3;
            double delta2 = this.direction * 10;
            path.lineTo(p1.getX(), p1.getY() + delta1);
            path.cubicTo(p1.getX(), p1.getY() + delta2, p2.getX(), p2.getY() - delta2, p2.getX(), p2.getY() - delta1);
        } else {
            double delta1 = this.direction * 10;
            double delta2 = this.direction * 25;
            path.lineTo(p1.getX() + delta1, p1.getY());
            path.cubicTo(p1.getX() + delta2, p1.getY(), p2.getX() - delta2, p2.getY(), p2.getX() - delta1, p2.getY());
        }
        path.lineTo(p2);
        ug.draw(path);
    }

    private Tetris getTetris(StringBounder stringBounder) {
        if (this.tetris == null) {
            this.tetris = new Tetris(this.idea.getLabel().toString());
            for (FingerImpl child : this.nail) {
                this.tetris.add(child.asSymetricalTee(stringBounder));
            }
            this.tetris.balance();
        }
        return this.tetris;
    }

    private SymetricalTee asSymetricalTee(StringBounder stringBounder) {
        double thickness1 = this.getPhalanxThickness(stringBounder);
        double elongation1 = this.getPhalanxElongation(stringBounder);
        if (this.nail.size() == 0) {
            return new SymetricalTee(thickness1, elongation1, 0.0, 0.0);
        }
        double thickness2 = this.getNailThickness(stringBounder);
        double elongation2 = this.getNailElongation(stringBounder);
        return new SymetricalTee(thickness1, elongation1 + this.getX1(), thickness2, this.getX2() + elongation2);
    }

    private double getX1() {
        if (this.isTopToBottom()) {
            return this.getMargin().getTop();
        }
        return this.getMargin().getLeft();
    }

    private double getX2() {
        if (this.isTopToBottom()) {
            return this.getMargin().getBottom() + 5.0;
        }
        return this.getMargin().getRight() + 30.0;
    }

    public double getX12() {
        return this.getX1() + this.getX2();
    }

    @Override
    public double getPhalanxThickness(StringBounder stringBounder) {
        if (this.isTopToBottom()) {
            return this.getPhalanx().calculateDimension(stringBounder).getWidth();
        }
        return this.getPhalanx().calculateDimension(stringBounder).getHeight();
    }

    @Override
    public double getPhalanxElongation(StringBounder stringBounder) {
        if (this.isTopToBottom()) {
            return this.getPhalanx().calculateDimension(stringBounder).getHeight();
        }
        return this.getPhalanx().calculateDimension(stringBounder).getWidth();
    }

    private TextBlock getPhalanx() {
        if (!this.drawPhalanx) {
            return TextBlockUtils.empty(0.0, 0.0);
        }
        Style style = this.getStyle();
        if (this.idea.getShape() == IdeaShape.BOX) {
            SkinParamColors foo = new SkinParamColors(this.skinParam, Colors.empty().add(ColorType.BACK, this.idea.getBackColor()));
            TextBlock box = FtileBoxOld.createMindMap(style, foo, this.idea.getLabel());
            ClockwiseTopRightBottomLeft margin = this.getMargin();
            if (this.isTopToBottom()) {
                return TextBlockUtils.withMargin(box, margin.getLeft(), margin.getRight(), 0.0, 0.0);
            }
            return TextBlockUtils.withMargin(box, 0.0, 0.0, margin.getTop(), margin.getBottom());
        }
        assert (this.idea.getShape() == IdeaShape.NONE);
        TextBlock text = this.idea.getLabel().create0(style.getFontConfiguration(this.skinParam.getThemeStyle(), this.skinParam.getIHtmlColorSet()), style.getHorizontalAlignment(), this.skinParam, style.wrapWidth(), CreoleMode.FULL, null, null);
        if (this.direction == 1) {
            return TextBlockUtils.withMargin(text, 3.0, 0.0, 1.0, 1.0);
        }
        return TextBlockUtils.withMargin(text, 0.0, 3.0, 1.0, 1.0);
    }

    private Style getStyle() {
        if (this.nail.size() != this.idea.getChildren().size()) {
            throw new IllegalStateException();
        }
        return this.idea.getStyle();
    }

    private Style getStyleArrow() {
        return this.idea.getStyleArrow();
    }

    @Override
    public double getNailThickness(StringBounder stringBounder) {
        return this.getTetris(stringBounder).getHeight();
    }

    @Override
    public double getNailElongation(StringBounder stringBounder) {
        return this.getTetris(stringBounder).getWidth();
    }

    @Override
    public double getFullThickness(StringBounder stringBounder) {
        double thickness1 = this.getPhalanxThickness(stringBounder);
        double thickness2 = this.getNailThickness(stringBounder);
        return Math.max(thickness1, thickness2);
    }

    @Override
    public double getFullElongation(StringBounder stringBounder) {
        return this.getPhalanxElongation(stringBounder) + this.getNailElongation(stringBounder);
    }

    @Override
    public void doNotDrawFirstPhalanx() {
        this.drawPhalanx = false;
    }
}

