/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.profiles;

import java.util.Collection;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLAsymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataAllValuesFrom;
import org.semanticweb.owlapi.model.OWLDataComplementOf;
import org.semanticweb.owlapi.model.OWLDataExactCardinality;
import org.semanticweb.owlapi.model.OWLDataIntersectionOf;
import org.semanticweb.owlapi.model.OWLDataMaxCardinality;
import org.semanticweb.owlapi.model.OWLDataMinCardinality;
import org.semanticweb.owlapi.model.OWLDataOneOf;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLDataUnionOf;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLDatatypeDefinitionAxiom;
import org.semanticweb.owlapi.model.OWLDatatypeRestriction;
import org.semanticweb.owlapi.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointUnionAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLFacetRestriction;
import org.semanticweb.owlapi.model.OWLFunctionalDataPropertyAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLHasKeyAxiom;
import org.semanticweb.owlapi.model.OWLInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLIrreflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLNegativeDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectAllValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectComplementOf;
import org.semanticweb.owlapi.model.OWLObjectExactCardinality;
import org.semanticweb.owlapi.model.OWLObjectHasSelf;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLObjectInverseOf;
import org.semanticweb.owlapi.model.OWLObjectMaxCardinality;
import org.semanticweb.owlapi.model.OWLObjectMinCardinality;
import org.semanticweb.owlapi.model.OWLObjectOneOf;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLObjectUnionOf;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyID;
import org.semanticweb.owlapi.model.OWLReflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLSameIndividualAxiom;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.OWLSubDataPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubPropertyChainOfAxiom;
import org.semanticweb.owlapi.model.OWLSymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLTransitiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.SWRLRule;
import org.semanticweb.owlapi.model.parameters.Imports;
import org.semanticweb.owlapi.profiles.OWLProfileViolation;
import org.semanticweb.owlapi.profiles.ProfileVisitorBase;
import org.semanticweb.owlapi.profiles.Profiles;
import org.semanticweb.owlapi.util.OWLOntologyWalker;

public class ProfileVisitor
extends ProfileVisitorBase {
    public ProfileVisitor(OWLOntologyWalker walker, Collection<OWLProfileViolation> violations, Collection<Profiles> profiles) {
        super(walker, violations, profiles);
    }

    @Override
    public void visit(IRI iri) {
        this.relativeIRI(iri);
    }

    @Override
    public void visit(OWLDatatypeDefinitionAxiom axiom) {
        this.undeclaredDatatype(axiom.getDatatype());
        this.dl(() -> this.reservedForDatatype(axiom), () -> this.cycleInDefinition(axiom));
        this.rl(() -> this.illegalAxiom());
    }

    @Override
    public void visit(OWLDatatypeRestriction node) {
        OWLDatatype datatype = node.getDatatype();
        this.getCurrentOntology().getImportsClosure().stream().flatMap(o -> o.getAxioms(AxiomType.DATATYPE_DEFINITION).stream()).filter(ax -> datatype.equals(ax.getDatatype())).forEach(ax -> this.definedDatatype(node));
        node.getFacetRestrictions().forEach(r -> this.illegalFacet(node, datatype, (OWLFacetRestriction)r));
        this.el(() -> this.illegalDataRange(node));
        this.ql(() -> this.illegalDataRange(node));
        this.rl(() -> this.illegalDataRange(node));
    }

    @Override
    public void visit(OWLLiteral node) {
        this.notInLexicalSpace(node);
    }

    @Override
    public void visit(OWLOntology ontology) {
        this.propertyManager = null;
        OWLOntologyID id = ontology.getOntologyID();
        if (!id.isAnonymous()) {
            this.ontologyIRINotAbsolute(id);
            this.versionNotAbsolute(id);
        }
        this.dl(() -> this.reservedForOntologyIRI(ontology.getOntologyID()), () -> this.reservedForVersionIRI(ontology.getOntologyID()));
    }

    @Override
    public void visit(OWLAnnotationProperty property) {
        this.dl(() -> this.reservedForAnnotation(property), () -> this.undeclaredAnnotation(property), () -> this.punningAnnotation(property));
    }

    @Override
    public void visit(OWLAsymmetricObjectPropertyAxiom axiom) {
        this.dl(() -> this.asymmetricNonSimple(axiom));
        this.el(() -> this.illegalAxiom());
    }

    @Override
    public void visit(OWLClass ce) {
        this.dl(() -> this.reservedForClass(ce), () -> this.undeclaredClass(ce), () -> this.punningDatatypeAndClass(ce));
    }

    @Override
    public void visit(OWLDataIntersectionOf node) {
        this.dl(() -> this.insufficientOperands(node));
    }

    @Override
    public void visit(OWLDataOneOf node) {
        this.dl(() -> this.emptyOneOf(node));
        this.el(() -> this.multipleOneOf(node));
        this.ql(() -> this.illegalDataRange(node));
        this.rl(() -> this.illegalDataRange(node));
    }

    @Override
    public void visit(OWLDataProperty property) {
        this.dl(() -> this.reservedForDataProperty(property), () -> this.undeclaredDataProperty(property), () -> this.illegalDataPropertyPunning(property));
    }

    @Override
    public void visit(OWLDatatype node) {
        this.dl(() -> this.unknownDatatype(node), () -> this.undeclaredDatatype(node), () -> this.punningDatatypeAndClass(node));
        this.el(() -> this.elDataRange(node));
        this.ql(() -> this.illegalQLDatatype(node));
        this.rl(() -> this.illegalRLDatatype(node));
    }

    @Override
    public void visit(OWLDataUnionOf node) {
        this.dl(() -> this.insufficientOperands(node));
        this.el(() -> this.illegalDataRange(node));
        this.ql(() -> this.illegalDataRange(node));
        this.rl(() -> this.illegalDataRange(node));
    }

    @Override
    public void visit(OWLDifferentIndividualsAxiom axiom) {
        this.dl(() -> this.insufficientIndividuals(axiom));
    }

    @Override
    public void visit(OWLDisjointClassesAxiom axiom) {
        this.dl(() -> this.insufficientOperands(axiom));
        this.ql(() -> axiom.getClassExpressions().stream().filter(ce -> !ProfileVisitor.isOWL2QLSubClassExpression(ce)).forEach(this::nonSubclass));
        this.rl(() -> axiom.getClassExpressions().stream().filter(ce -> (Boolean)ce.accept(equivalentClassExpressionChecker) == false).forEach(this::nonSubclass));
    }

    @Override
    public void visit(OWLDisjointDataPropertiesAxiom axiom) {
        this.dl(() -> this.insufficientProperties(axiom));
        this.el(() -> this.illegalAxiom());
    }

    @Override
    public void visit(OWLDisjointObjectPropertiesAxiom axiom) {
        this.dl(() -> this.insufficientProperties(axiom), () -> axiom.getProperties().stream().filter(this.getPropertyManager()::isNonSimple).forEach(this::disjointNonSimple));
        this.el(() -> this.illegalAxiom());
    }

    @Override
    public void visit(OWLDisjointUnionAxiom axiom) {
        this.dl(() -> this.insufficientOperands(axiom));
        this.el(() -> this.illegalAxiom());
        this.ql(() -> this.illegalAxiom());
        this.rl(() -> this.illegalAxiom());
    }

    @Override
    public void visit(OWLEquivalentClassesAxiom axiom) {
        this.dl(() -> this.insufficientOperands(axiom));
        this.ql(() -> axiom.getClassExpressions().stream().filter(ce -> !ProfileVisitor.isOWL2QLSubClassExpression(ce)).forEach(this::nonSubclass));
        this.rl(() -> axiom.getClassExpressions().stream().filter(ce -> (Boolean)ce.accept(equivalentClassExpressionChecker) == false).forEach(this::nonEquivalentClass));
    }

    @Override
    public void visit(OWLEquivalentDataPropertiesAxiom axiom) {
        this.dl(() -> this.insufficientProperties(axiom));
    }

    @Override
    public void visit(OWLEquivalentObjectPropertiesAxiom axiom) {
        this.dl(() -> this.insufficientProperties(axiom));
    }

    @Override
    public void visit(OWLFunctionalObjectPropertyAxiom axiom) {
        this.dl(() -> this.functionalNonSimple(axiom));
        this.el(() -> this.illegalAxiom());
        this.ql(() -> this.illegalAxiom());
    }

    @Override
    public void visit(OWLHasKeyAxiom axiom) {
        this.dl(() -> this.emptyProperties(axiom));
        this.ql(() -> this.illegalAxiom());
        this.rl(() -> this.nonSubClassRL(axiom.getClassExpression()));
    }

    @Override
    public void visit(OWLInverseFunctionalObjectPropertyAxiom axiom) {
        this.dl(() -> this.inverseFunctionalNonSimple(axiom));
        this.el(() -> this.illegalAxiom());
        this.ql(() -> this.illegalAxiom());
    }

    @Override
    public void visit(OWLIrreflexiveObjectPropertyAxiom axiom) {
        this.dl(() -> this.irreflexiveNonSimple(axiom));
        this.el(() -> this.illegalAxiom());
    }

    @Override
    public void visit(OWLReflexiveObjectPropertyAxiom axiom) {
        this.rl(() -> this.illegalAxiom());
    }

    @Override
    public void visit(OWLNamedIndividual individual) {
        this.dl(() -> this.reservedForIndividual(individual));
    }

    @Override
    public void visit(OWLObjectExactCardinality ce) {
        this.dl(() -> this.nonSimple(ce));
        this.el(() -> this.illegalClass(ce));
    }

    @Override
    public void visit(OWLObjectHasSelf ce) {
        this.dl(() -> this.hasSelfNonSimple(ce));
    }

    @Override
    public void visit(OWLObjectIntersectionOf ce) {
        this.dl(() -> this.insufficientOperands(ce));
    }

    @Override
    public void visit(OWLObjectMaxCardinality ce) {
        this.dl(() -> this.nonSimple(ce));
        this.el(() -> this.illegalClass(ce));
    }

    @Override
    public void visit(OWLObjectMinCardinality ce) {
        this.dl(() -> this.nonSimple(ce));
        this.el(() -> this.illegalClass(ce));
    }

    @Override
    public void visit(OWLObjectOneOf ce) {
        this.dl(() -> this.emptyOneOf(ce));
        this.el(() -> this.multipleOneOf(ce));
    }

    @Override
    public void visit(OWLObjectProperty property) {
        this.dl(() -> this.reservedForObjectProperty(property), () -> this.undeclaredObjectProperty(property), () -> this.illegalObjectPropertyPunning(property));
    }

    @Override
    public void visit(OWLObjectUnionOf ce) {
        this.dl(() -> this.insufficientOperands(ce));
        this.el(() -> this.illegalClass(ce));
    }

    @Override
    public void visit(OWLSameIndividualAxiom axiom) {
        this.dl(() -> this.insufficientIndividuals(axiom));
        this.ql(() -> this.illegalAxiom());
    }

    @Override
    public void visit(OWLSubDataPropertyOfAxiom axiom) {
        this.dl(() -> this.topAsSubProperty(axiom));
    }

    @Override
    public void visit(OWLSubPropertyChainOfAxiom axiom) {
        this.dl(() -> this.insufficientProperties(axiom), () -> this.chainCycle(axiom));
        this.el(() -> this.getCurrentOntology().getAxioms(AxiomType.OBJECT_PROPERTY_RANGE, Imports.INCLUDED).forEach(this::chainRange));
        this.ql(() -> this.illegalAxiom());
    }

    @Override
    public void visit(OWLAnonymousIndividual individual) {
        this.el(() -> this.anonIndividual(individual));
        this.ql(() -> this.anonIndividual(individual));
    }

    @Override
    public void visit(OWLClassAssertionAxiom axiom) {
        this.el(() -> axiom.getClassExpression().accept(this));
        this.ql(() -> this.nonAtomic(axiom));
        this.rl(() -> this.nonSuperClassRL(axiom.getClassExpression()));
    }

    @Override
    public void visit(OWLDataAllValuesFrom ce) {
        this.el(() -> this.illegalClass(ce));
    }

    @Override
    public void visit(OWLDataComplementOf node) {
        this.el(() -> this.illegalDataRange(node));
        this.ql(() -> this.illegalDataRange(node));
        this.rl(() -> this.illegalDataRange(node));
    }

    @Override
    public void visit(OWLDataExactCardinality ce) {
        this.el(() -> this.illegalClass(ce));
    }

    @Override
    public void visit(OWLDataMaxCardinality ce) {
        this.el(() -> this.illegalClass(ce));
    }

    @Override
    public void visit(OWLDataMinCardinality ce) {
        this.el(() -> this.illegalClass(ce));
    }

    @Override
    public void visit(OWLInverseObjectPropertiesAxiom axiom) {
        this.el(() -> this.illegalAxiom());
    }

    @Override
    public void visit(OWLObjectAllValuesFrom ce) {
        this.el(() -> this.illegalClass(ce));
    }

    @Override
    public void visit(OWLObjectComplementOf ce) {
        this.el(() -> this.illegalClass(ce));
    }

    @Override
    public void visit(OWLObjectInverseOf property) {
        this.el(() -> this.inverse(property));
    }

    @Override
    public void visit(OWLSymmetricObjectPropertyAxiom axiom) {
        this.el(() -> this.illegalAxiom());
    }

    @Override
    public void visit(SWRLRule rule) {
        this.el(() -> this.illegalAxiom());
        this.ql(() -> this.illegalAxiom());
        this.rl(() -> this.illegalAxiom());
    }

    @Override
    public void visit(OWLDataPropertyDomainAxiom axiom) {
        this.ql(() -> this.nonSuperClassQL(axiom.getDomain()));
        this.rl(() -> this.nonSuperClassRL(axiom.getDomain()));
    }

    @Override
    public void visit(OWLFunctionalDataPropertyAxiom axiom) {
        this.ql(() -> this.illegalAxiom());
    }

    @Override
    public void visit(OWLNegativeDataPropertyAssertionAxiom axiom) {
        this.ql(() -> this.illegalAxiom());
    }

    @Override
    public void visit(OWLNegativeObjectPropertyAssertionAxiom axiom) {
        this.ql(() -> this.illegalAxiom());
    }

    @Override
    public void visit(OWLObjectPropertyDomainAxiom axiom) {
        this.ql(() -> this.nonSuperClassQL(axiom.getDomain()));
        this.rl(() -> this.nonSuperClassRL(axiom.getDomain()));
    }

    @Override
    public void visit(OWLObjectPropertyRangeAxiom axiom) {
        this.ql(() -> this.nonSuperClassQL((OWLClassExpression)axiom.getRange()));
        this.rl(() -> this.nonSuperClassRL((OWLClassExpression)axiom.getRange()));
    }

    @Override
    public void visit(OWLSubClassOfAxiom axiom) {
        this.ql(() -> this.nonSubClassQL(axiom), () -> this.nonSuperClassQL(axiom.getSuperClass()));
        this.rl(() -> this.nonSubClassRL(axiom.getSubClass()), () -> this.nonSuperClassRL(axiom.getSuperClass()));
    }

    @Override
    public void visit(OWLTransitiveObjectPropertyAxiom axiom) {
        this.ql(() -> this.illegalAxiom());
    }
}

