/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.editor;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.model.classexpression.OWLExpressionParserException;
import org.protege.editor.owl.model.parser.OWLLiteralParser;
import org.protege.editor.owl.model.util.LiteralChecker;
import org.protege.editor.owl.ui.UIHelper;
import org.protege.editor.owl.ui.clsdescriptioneditor.OWLAutoCompleter;
import org.protege.editor.owl.ui.clsdescriptioneditor.OWLExpressionChecker;
import org.protege.editor.owl.ui.editor.OWLObjectEditor;
import org.protege.editor.owl.ui.editor.OWLObjectEditorHandler;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.vocab.OWL2Datatype;

public class OWLConstantEditor
extends JPanel
implements OWLObjectEditor<OWLLiteral> {
    private final OWLEditorKit editorKit;
    private final JTextArea annotationContent = new JTextArea(8, 40);
    private final JComboBox<String> langComboBox;
    private final JComboBox<OWLDatatype> datatypeComboBox;
    private final JLabel langLabel = new JLabel("Lang");
    private final OWLDataFactory dataFactory;
    private String lastLanguage;
    private OWLDatatype lastDatatype;
    private final JLabel messageLabel = new JLabel();

    public OWLConstantEditor(OWLEditorKit owlEditorKit) {
        this.editorKit = owlEditorKit;
        this.dataFactory = owlEditorKit.getModelManager().getOWLDataFactory();
        this.annotationContent.setWrapStyleWord(true);
        this.annotationContent.setLineWrap(true);
        this.annotationContent.setBorder(null);
        UIHelper uiHelper = new UIHelper(owlEditorKit);
        this.langComboBox = uiHelper.getLanguageSelector();
        this.datatypeComboBox = uiHelper.getDatatypeSelector();
        this.datatypeComboBox.addActionListener(e -> {
            OWLDatatype owlDatatype = this.getSelectedDatatype();
            boolean langEnabled = owlDatatype == null || owlDatatype.isRDFPlainLiteral();
            this.validateContent();
            this.setLangEnabled(langEnabled);
        });
        this.annotationContent.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                OWLConstantEditor.this.validateContent();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                OWLConstantEditor.this.validateContent();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }
        });
        this.addHierarchyListener(e -> {
            if (this.isShowing()) {
                this.annotationContent.requestFocus();
            }
        });
        OWLConstantEditor.removeNonSelectableDatatypes(this.datatypeComboBox);
        this.setupAutoCompleter(owlEditorKit);
        this.layoutComponents();
    }

    private void validateContent() {
        this.clearErrorMessage();
        if (this.getLexicalValue().isEmpty()) {
            return;
        }
        Optional<OWLDatatype> datatype = Optional.ofNullable(this.getSelectedDatatype());
        datatype.ifPresent(d -> {
            if (!LiteralChecker.isLiteralIsInLexicalSpace(this.getEditedObject())) {
                this.annotationContent.setForeground(Color.RED);
                String message = String.format("The entered value is not valid for the specified datatype (%s)", this.editorKit.getOWLModelManager().getRendering((OWLObject)d));
                this.displayErrorMessage(message);
            }
        });
    }

    private void displayErrorMessage(String message) {
        this.messageLabel.setText(message);
        this.messageLabel.setForeground(Color.RED);
        this.annotationContent.setToolTipText(message);
    }

    private void clearErrorMessage() {
        this.messageLabel.setText("");
        this.messageLabel.setForeground(null);
        this.annotationContent.setToolTipText(null);
        this.annotationContent.setForeground(null);
    }

    private static void removeNonSelectableDatatypes(JComboBox<OWLDatatype> datatypeComboBox) {
        for (int i = 0; i < datatypeComboBox.getItemCount(); ++i) {
            OWLDatatype datatype = datatypeComboBox.getItemAt(i);
            if (datatype == null) continue;
            if (datatype.isRDFPlainLiteral()) {
                datatypeComboBox.removeItemAt(i);
                continue;
            }
            if (!datatype.isBuiltIn() || !datatype.getBuiltInDatatype().equals((Object)OWL2Datatype.OWL_REAL)) continue;
            datatypeComboBox.removeItemAt(i);
        }
    }

    private void setLangEnabled(boolean b) {
        this.langLabel.setEnabled(b);
        this.langComboBox.setEnabled(b);
    }

    @Override
    public boolean canEdit(Object object) {
        return object instanceof OWLLiteral;
    }

    public boolean isPreferred(Object object) {
        return object instanceof OWLLiteral;
    }

    @Override
    @Nonnull
    public JComponent getEditorComponent() {
        return this;
    }

    @Override
    @Nullable
    public OWLLiteral getEditedObject() {
        this.lastDatatype = null;
        this.lastLanguage = null;
        String value = this.getLexicalValue();
        if (this.isLangSelected()) {
            this.lastLanguage = this.getSelectedLang();
            return this.dataFactory.getOWLLiteral(value, this.getSelectedLang());
        }
        if (this.isDatatypeSelected()) {
            this.lastDatatype = this.getSelectedDatatype();
            return this.dataFactory.getOWLLiteral(value, this.getSelectedDatatype());
        }
        OWLLiteralParser parser = new OWLLiteralParser(this.dataFactory);
        return parser.parseLiteral(value);
    }

    private String getLexicalValue() {
        return this.annotationContent.getText().trim();
    }

    @Override
    public Set<OWLLiteral> getEditedObjects() {
        return Collections.singleton(this.getEditedObject());
    }

    @Override
    public boolean setEditedObject(OWLLiteral constant) {
        this.clear();
        if (constant != null) {
            this.annotationContent.setText(constant.getLiteral());
            if (!constant.isRDFPlainLiteral()) {
                this.datatypeComboBox.setSelectedItem(constant.getDatatype());
            } else {
                this.langComboBox.setSelectedItem(constant.getLang());
            }
        }
        return true;
    }

    @Override
    public boolean isMultiEditSupported() {
        return false;
    }

    @Override
    @Nonnull
    public String getEditorTypeName() {
        return "Literal";
    }

    @Override
    public void clear() {
        this.annotationContent.setText("");
        this.datatypeComboBox.setSelectedItem(this.lastDatatype);
        this.langComboBox.setSelectedItem(this.lastLanguage);
    }

    private boolean isLangSelected() {
        return this.langComboBox.getSelectedItem() != null && !this.langComboBox.getSelectedItem().equals("");
    }

    private boolean isDatatypeSelected() {
        return this.datatypeComboBox.getSelectedItem() != null;
    }

    private String getSelectedLang() {
        return (String)this.langComboBox.getSelectedItem();
    }

    private OWLDatatype getSelectedDatatype() {
        return (OWLDatatype)this.datatypeComboBox.getSelectedItem();
    }

    private void setupAutoCompleter(OWLEditorKit owlEditorKit) {
        new OWLAutoCompleter(owlEditorKit, this.annotationContent, new OWLExpressionChecker(){

            @Override
            public void check(String text) throws OWLExpressionParserException {
                throw new OWLExpressionParserException(text, 0, text.length(), true, true, true, true, true, true, new HashSet<String>());
            }

            public Object createObject(String text) throws OWLExpressionParserException {
                return null;
            }
        });
    }

    private void layoutComponents() {
        this.setLayout(new GridBagLayout());
        this.add((Component)new JScrollPane(this.annotationContent), new GridBagConstraints(1, 1, 5, 1, 100.0, 100.0, 18, 1, new Insets(7, 7, 7, 7), 0, 0));
        this.add((Component)this.messageLabel, new GridBagConstraints(1, 0, 5, 1, 0.0, 0.0, 18, 0, new Insets(7, 7, 0, 7), 0, 0));
        this.add((Component)new JLabel("Type"), new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 7, 0, 7), 0, 0));
        this.add(this.datatypeComboBox, new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 40, 0));
        this.add((Component)this.langLabel, new GridBagConstraints(3, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 20, 0, 0), 0, 0));
        this.langLabel.setEnabled(true);
        this.add(this.langComboBox, new GridBagConstraints(4, 3, 1, 1, 100.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 40, 0));
    }

    @Override
    public void dispose() {
    }

    @Override
    public void setHandler(OWLObjectEditorHandler<OWLLiteral> owlLiteralOWLObjectEditorHandler) {
    }

    @Override
    public OWLObjectEditorHandler<OWLLiteral> getHandler() {
        return null;
    }
}

