# Image

## Container Images

Simply specify an image name (and a tag).

```
$ trivy image [YOUR_IMAGE_NAME]
```

For example:

```
$ trivy image python:3.4-alpine
```

<details>
<summary>Result</summary>

```
2019-05-16T01:20:43.180+0900    INFO    Updating vulnerability database...
2019-05-16T01:20:53.029+0900    INFO    Detecting Alpine vulnerabilities...

python:3.4-alpine3.9 (alpine 3.9.2)
===================================
Total: 1 (UNKNOWN: 0, LOW: 0, MEDIUM: 1, HIGH: 0, CRITICAL: 0)

+---------+------------------+----------+-------------------+---------------+--------------------------------+
| LIBRARY | VULNERABILITY ID | SEVERITY | INSTALLED VERSION | FIXED VERSION |             TITLE              |
+---------+------------------+----------+-------------------+---------------+--------------------------------+
| openssl | CVE-2019-1543    | MEDIUM   | 1.1.1a-r1         | 1.1.1b-r1     | openssl: ChaCha20-Poly1305     |
|         |                  |          |                   |               | with long nonces               |
+---------+------------------+----------+-------------------+---------------+--------------------------------+
```

</details>

## Tar Files

```
$ docker pull ruby:3.1-alpine3.15
$ docker save ruby:3.1-alpine3.15 -o ruby-3.1.tar
$ trivy image --input ruby-3.1.tar
```

<details>
<summary>Result</summary>

```
2022-02-03T10:08:19.127Z        INFO    Detected OS: alpine
2022-02-03T10:08:19.127Z        WARN    This OS version is not on the EOL list: alpine 3.15
2022-02-03T10:08:19.127Z        INFO    Detecting Alpine vulnerabilities...
2022-02-03T10:08:19.127Z        INFO    Number of language-specific files: 2
2022-02-03T10:08:19.127Z        INFO    Detecting gemspec vulnerabilities...
2022-02-03T10:08:19.128Z        INFO    Detecting node-pkg vulnerabilities...
2022-02-03T10:08:19.128Z        WARN    This OS version is no longer supported by the distribution: alpine 3.15.0
2022-02-03T10:08:19.128Z        WARN    The vulnerability detection may be insufficient because security updates are not provided

ruby-3.1.tar (alpine 3.15.0)
============================
Total: 3 (UNKNOWN: 0, LOW: 0, MEDIUM: 0, HIGH: 3, CRITICAL: 0)

+----------+------------------+----------+-------------------+---------------+---------------------------------------+
| LIBRARY  | VULNERABILITY ID | SEVERITY | INSTALLED VERSION | FIXED VERSION |                 TITLE                 |
+----------+------------------+----------+-------------------+---------------+---------------------------------------+
| gmp      | CVE-2021-43618   | HIGH     | 6.2.1-r0          | 6.2.1-r1      | gmp: Integer overflow and resultant   |
|          |                  |          |                   |               | buffer overflow via crafted input     |
|          |                  |          |                   |               | -->avd.aquasec.com/nvd/cve-2021-43618 |
+----------+                  +          +                   +               +                                       +
| gmp-dev  |                  |          |                   |               |                                       |
|          |                  |          |                   |               |                                       |
|          |                  |          |                   |               |                                       |
+----------+                  +          +                   +               +                                       +
| libgmpxx |                  |          |                   |               |                                       |
|          |                  |          |                   |               |                                       |
|          |                  |          |                   |               |                                       |
+----------+------------------+----------+-------------------+---------------+---------------------------------------+

Node.js (node-pkg)
==================
Total: 0 (UNKNOWN: 0, LOW: 0, MEDIUM: 0, HIGH: 0, CRITICAL: 0)


Ruby (gemspec)
==============
Total: 0 (UNKNOWN: 0, LOW: 0, MEDIUM: 0, HIGH: 0, CRITICAL: 0)
```

</details>

