/* chess-pgn.c generated by valac 0.56.3, the Vala compiler
 * generated from chess-pgn.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 *
 * Copyright (C) 2010-2014 Robert Ancell
 * Copyright (C) 2015-2016 Sahil Sareen
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */
/* This is the Seven Tag Roster (STR). They have to appear at the top, in this order. */

#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include "libchess.h"
#include <glib-object.h>
#include <gio/gio.h>
#include <errno.h>
#include <glib/gi18n-lib.h>
#include <stdio.h>

enum  {
	PGN_GAME_0_PROPERTY,
	PGN_GAME_EVENT_PROPERTY,
	PGN_GAME_SITE_PROPERTY,
	PGN_GAME_DATE_PROPERTY,
	PGN_GAME_TIME_PROPERTY,
	PGN_GAME_ROUND_PROPERTY,
	PGN_GAME_WHITE_PROPERTY,
	PGN_GAME_BLACK_PROPERTY,
	PGN_GAME_RESULT_PROPERTY,
	PGN_GAME_ANNOTATOR_PROPERTY,
	PGN_GAME_TIME_CONTROL_PROPERTY,
	PGN_GAME_WHITE_TIME_LEFT_PROPERTY,
	PGN_GAME_BLACK_TIME_LEFT_PROPERTY,
	PGN_GAME_CLOCK_TYPE_PROPERTY,
	PGN_GAME_TIMER_INCREMENT_PROPERTY,
	PGN_GAME_SET_UP_PROPERTY,
	PGN_GAME_FEN_PROPERTY,
	PGN_GAME_TERMINATION_PROPERTY,
	PGN_GAME_WHITE_AI_PROPERTY,
	PGN_GAME_WHITE_LEVEL_PROPERTY,
	PGN_GAME_BLACK_AI_PROPERTY,
	PGN_GAME_BLACK_LEVEL_PROPERTY,
	PGN_GAME_NUM_PROPERTIES
};
static GParamSpec* pgn_game_properties[PGN_GAME_NUM_PROPERTIES];
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
typedef enum  {
	STATE_TAGS,
	STATE_MOVE_TEXT,
	STATE_LINE_COMMENT,
	STATE_BRACE_COMMENT,
	STATE_TAG_START,
	STATE_TAG_NAME,
	STATE_PRE_TAG_VALUE,
	STATE_TAG_VALUE,
	STATE_POST_TAG_VALUE,
	STATE_SYMBOL,
	STATE_PERIOD,
	STATE_NAG,
	STATE_ERROR
} State;

#define TYPE_STATE (state_get_type ())
enum  {
	PGN_0_PROPERTY,
	PGN_NUM_PROPERTIES
};
static GParamSpec* pgn_properties[PGN_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

static gpointer pgn_game_parent_class = NULL;
gchar* pgn_game_RESULT_IN_PROGRESS = NULL;
gchar* pgn_game_RESULT_DRAW = NULL;
gchar* pgn_game_RESULT_WHITE = NULL;
gchar* pgn_game_RESULT_BLACK = NULL;
gchar* pgn_game_TERMINATE_ABANDONED = NULL;
gchar* pgn_game_TERMINATE_ADJUDICATION = NULL;
gchar* pgn_game_TERMINATE_DEATH = NULL;
gchar* pgn_game_TERMINATE_EMERGENCY = NULL;
gchar* pgn_game_TERMINATE_NORMAL = NULL;
gchar* pgn_game_TERMINATE_RULES_INFRACTION = NULL;
gchar* pgn_game_TERMINATE_TIME_FORFEIT = NULL;
gchar* pgn_game_TERMINATE_UNTERMINATED = NULL;
static gpointer pgn_parent_class = NULL;

VALA_EXTERN gint str_index (const gchar* name);
VALA_EXTERN gint compare_tag (const gchar* name0,
                  const gchar* name1);
static void _g_free0_ (gpointer var);
static inline void _g_list_free__g_free0_ (GList* self);
static void pgn_game_finalize (GObject * obj);
static GType pgn_game_get_type_once (void);
static void _vala_pgn_game_get_property (GObject * object,
                                  guint property_id,
                                  GValue * value,
                                  GParamSpec * pspec);
static void _vala_pgn_game_set_property (GObject * object,
                                  guint property_id,
                                  const GValue * value,
                                  GParamSpec * pspec);
VALA_EXTERN GType state_get_type (void) G_GNUC_CONST ;
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static void pgn_insert_tag (PGN* self,
                     PGNGame* game,
                     const gchar* tag_name,
                     const gchar* tag_value);
static void pgn_finalize (GObject * obj);
static GType pgn_get_type_once (void);

gint
str_index (const gchar* name)
{
	gint result;
	g_return_val_if_fail (name != NULL, 0);
	if (g_strcmp0 (name, "Event") == 0) {
		result = 0;
		return result;
	} else {
		if (g_strcmp0 (name, "Site") == 0) {
			result = 1;
			return result;
		} else {
			if (g_strcmp0 (name, "Date") == 0) {
				result = 2;
				return result;
			} else {
				if (g_strcmp0 (name, "Round") == 0) {
					result = 3;
					return result;
				} else {
					if (g_strcmp0 (name, "White") == 0) {
						result = 4;
						return result;
					} else {
						if (g_strcmp0 (name, "Black") == 0) {
							result = 5;
							return result;
						} else {
							if (g_strcmp0 (name, "Result") == 0) {
								result = 6;
								return result;
							} else {
								result = 7;
								return result;
							}
						}
					}
				}
			}
		}
	}
}

gint
compare_tag (const gchar* name0,
             const gchar* name1)
{
	gint str_index0 = 0;
	gint str_index1 = 0;
	gboolean _tmp0_ = FALSE;
	gint result;
	g_return_val_if_fail (name0 != NULL, 0);
	g_return_val_if_fail (name1 != NULL, 0);
	str_index0 = str_index (name0);
	str_index1 = str_index (name1);
	if (str_index0 == 7) {
		_tmp0_ = str_index1 == 7;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GCompareFunc _tmp1_;
		_tmp1_ = ((GCompareFunc) g_strcmp0);
		result = _tmp1_ (name0, name1);
		return result;
	} else {
		result = str_index0 - str_index1;
		return result;
	}
}

GQuark
pgn_error_quark (void)
{
	return g_quark_from_static_string ("pgn-error-quark");
}

static GType
pgn_error_get_type_once (void)
{
	static const GEnumValue values[] = {{PGN_ERROR_LOAD_ERROR, "PGN_ERROR_LOAD_ERROR", "load-error"}, {0, NULL, NULL}};
	GType pgn_error_type_id;
	pgn_error_type_id = g_enum_register_static ("PGNError", values);
	return pgn_error_type_id;
}

GType
pgn_error_get_type (void)
{
	static volatile gsize pgn_error_type_id__once = 0;
	if (g_once_init_enter (&pgn_error_type_id__once)) {
		GType pgn_error_type_id;
		pgn_error_type_id = pgn_error_get_type_once ();
		g_once_init_leave (&pgn_error_type_id__once, pgn_error_type_id);
	}
	return pgn_error_type_id__once;
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static inline void
_g_list_free__g_free0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_free0_);
}

PGNGame*
pgn_game_construct (GType object_type)
{
	PGNGame * self = NULL;
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GHashTable* _tmp2_;
	GHashTable* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	GHashTable* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	GHashTable* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	GHashTable* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	GHashTable* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	GHashTable* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	GHashTable* _tmp21_;
	gchar* _tmp22_;
	const gchar* _tmp23_;
	gchar* _tmp24_;
	self = (PGNGame*) g_object_new (object_type, NULL);
	_tmp0_ = g_str_hash;
	_tmp1_ = g_str_equal;
	_tmp2_ = g_hash_table_new_full (_tmp0_, _tmp1_, _g_free0_, _g_free0_);
	_g_hash_table_unref0 (self->tags);
	self->tags = _tmp2_;
	_tmp3_ = self->tags;
	_tmp4_ = g_strdup ("Event");
	_tmp5_ = g_strdup ("?");
	g_hash_table_insert (_tmp3_, _tmp4_, _tmp5_);
	_tmp6_ = self->tags;
	_tmp7_ = g_strdup ("Site");
	_tmp8_ = g_strdup ("?");
	g_hash_table_insert (_tmp6_, _tmp7_, _tmp8_);
	_tmp9_ = self->tags;
	_tmp10_ = g_strdup ("Date");
	_tmp11_ = g_strdup ("????.??.??");
	g_hash_table_insert (_tmp9_, _tmp10_, _tmp11_);
	_tmp12_ = self->tags;
	_tmp13_ = g_strdup ("Round");
	_tmp14_ = g_strdup ("?");
	g_hash_table_insert (_tmp12_, _tmp13_, _tmp14_);
	_tmp15_ = self->tags;
	_tmp16_ = g_strdup ("White");
	_tmp17_ = g_strdup ("?");
	g_hash_table_insert (_tmp15_, _tmp16_, _tmp17_);
	_tmp18_ = self->tags;
	_tmp19_ = g_strdup ("Black");
	_tmp20_ = g_strdup ("?");
	g_hash_table_insert (_tmp18_, _tmp19_, _tmp20_);
	_tmp21_ = self->tags;
	_tmp22_ = g_strdup ("Result");
	_tmp23_ = pgn_game_RESULT_IN_PROGRESS;
	_tmp24_ = g_strdup (_tmp23_);
	g_hash_table_insert (_tmp21_, _tmp22_, _tmp24_);
	return self;
}

PGNGame*
pgn_game_new (void)
{
	return pgn_game_construct (TYPE_PGN_GAME);
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

gchar*
pgn_game_escape (PGNGame* self,
                 const gchar* value)
{
	gchar* a = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (value != NULL, NULL);
	_tmp0_ = string_replace (value, "\\", "\\\\");
	a = _tmp0_;
	_tmp1_ = string_replace (a, "\"", "\\\"");
	result = _tmp1_;
	_g_free0 (a);
	return result;
}

static guint8*
string_get_data (const gchar* self,
                 gint* result_length1)
{
	guint8* result;
	guint8* res = NULL;
	gint res_length1;
	gint _res_size_;
	gint _tmp0_;
	gint _tmp1_;
	guint8* _tmp2_;
	gint _tmp2__length1;
	g_return_val_if_fail (self != NULL, NULL);
	res = (guint8*) self;
	res_length1 = -1;
	_res_size_ = res_length1;
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	res_length1 = (gint) _tmp1_;
	_tmp2_ = res;
	_tmp2__length1 = res_length1;
	if (result_length1) {
		*result_length1 = _tmp2__length1;
	}
	result = _tmp2_;
	return result;
}

void
pgn_game_write (PGNGame* self,
                GFile* file,
                GError** error)
{
	GString* data = NULL;
	GString* _tmp0_;
	GList* keys = NULL;
	GHashTable* _tmp1_;
	GList* _tmp2_;
	GList* _tmp3_;
	GString* _tmp13_;
	gint i = 0;
	GList* _tmp14_;
	GString* _tmp23_;
	const gchar* _tmp24_;
	const gchar* _tmp25_;
	GString* _tmp26_;
	GString* _tmp27_;
	const gchar* _tmp28_;
	guint8* _tmp29_;
	gint _tmp29__length1;
	gint _tmp30_ = 0;
	guint8* _tmp31_;
	gint _tmp31__length1;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	_tmp0_ = g_string_new ("");
	data = _tmp0_;
	_tmp1_ = self->tags;
	_tmp2_ = g_hash_table_get_keys (_tmp1_);
	keys = _tmp2_;
	keys = g_list_sort (keys, (GCompareFunc) compare_tag);
	_tmp3_ = keys;
	{
		GList* key_collection = NULL;
		GList* key_it = NULL;
		key_collection = _tmp3_;
		for (key_it = key_collection; key_it != NULL; key_it = key_it->next) {
			const gchar* key = NULL;
			key = (const gchar*) key_it->data;
			{
				GString* _tmp4_;
				const gchar* _tmp5_;
				GHashTable* _tmp6_;
				const gchar* _tmp7_;
				gconstpointer _tmp8_;
				gchar* _tmp9_;
				gchar* _tmp10_;
				gchar* _tmp11_;
				gchar* _tmp12_;
				_tmp4_ = data;
				_tmp5_ = key;
				_tmp6_ = self->tags;
				_tmp7_ = key;
				_tmp8_ = g_hash_table_lookup (_tmp6_, _tmp7_);
				_tmp9_ = pgn_game_escape (self, (const gchar*) _tmp8_);
				_tmp10_ = _tmp9_;
				_tmp11_ = g_strdup_printf ("[%s \"%s\"]\n", _tmp5_, _tmp10_);
				_tmp12_ = _tmp11_;
				g_string_append (_tmp4_, _tmp12_);
				_g_free0 (_tmp12_);
				_g_free0 (_tmp10_);
			}
		}
	}
	_tmp13_ = data;
	g_string_append (_tmp13_, "\n");
	i = 0;
	_tmp14_ = self->moves;
	{
		GList* move_collection = NULL;
		GList* move_it = NULL;
		move_collection = _tmp14_;
		for (move_it = move_collection; move_it != NULL; move_it = move_it->next) {
			gchar* _tmp15_;
			gchar* move = NULL;
			_tmp15_ = g_strdup ((const gchar*) move_it->data);
			move = _tmp15_;
			{
				GString* _tmp19_;
				const gchar* _tmp20_;
				GString* _tmp21_;
				gint _tmp22_;
				if ((i % 2) == 0) {
					GString* _tmp16_;
					gchar* _tmp17_;
					gchar* _tmp18_;
					_tmp16_ = data;
					_tmp17_ = g_strdup_printf ("%d. ", (i / 2) + 1);
					_tmp18_ = _tmp17_;
					g_string_append (_tmp16_, _tmp18_);
					_g_free0 (_tmp18_);
				}
				_tmp19_ = data;
				_tmp20_ = move;
				g_string_append (_tmp19_, _tmp20_);
				_tmp21_ = data;
				g_string_append (_tmp21_, " ");
				_tmp22_ = i;
				i = _tmp22_ + 1;
				_g_free0 (move);
			}
		}
	}
	_tmp23_ = data;
	_tmp24_ = pgn_game_get_result (self);
	_tmp25_ = _tmp24_;
	g_string_append (_tmp23_, _tmp25_);
	_tmp26_ = data;
	g_string_append (_tmp26_, "\n");
	_tmp27_ = data;
	_tmp28_ = _tmp27_->str;
	_tmp29_ = string_get_data (_tmp28_, &_tmp30_);
	_tmp29__length1 = _tmp30_;
	_tmp31_ = _tmp29_;
	_tmp31__length1 = _tmp29__length1;
	g_file_replace_contents (file, _tmp31_, (gsize) _tmp31__length1, NULL, FALSE, G_FILE_CREATE_NONE, NULL, NULL, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		(keys == NULL) ? NULL : (keys = (g_list_free (keys), NULL));
		_g_string_free0 (data);
		return;
	}
	(keys == NULL) ? NULL : (keys = (g_list_free (keys), NULL));
	_g_string_free0 (data);
}

const gchar*
pgn_game_get_event (PGNGame* self)
{
	const gchar* result;
	GHashTable* _tmp0_;
	gconstpointer _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->tags;
	_tmp1_ = g_hash_table_lookup (_tmp0_, "Event");
	result = (const gchar*) _tmp1_;
	return result;
}

void
pgn_game_set_event (PGNGame* self,
                    const gchar* value)
{
	GHashTable* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->tags;
	_tmp1_ = g_strdup ("Event");
	_tmp2_ = g_strdup (value);
	g_hash_table_insert (_tmp0_, _tmp1_, _tmp2_);
	g_object_notify_by_pspec ((GObject *) self, pgn_game_properties[PGN_GAME_EVENT_PROPERTY]);
}

const gchar*
pgn_game_get_site (PGNGame* self)
{
	const gchar* result;
	GHashTable* _tmp0_;
	gconstpointer _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->tags;
	_tmp1_ = g_hash_table_lookup (_tmp0_, "Site");
	result = (const gchar*) _tmp1_;
	return result;
}

void
pgn_game_set_site (PGNGame* self,
                   const gchar* value)
{
	GHashTable* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->tags;
	_tmp1_ = g_strdup ("Site");
	_tmp2_ = g_strdup (value);
	g_hash_table_insert (_tmp0_, _tmp1_, _tmp2_);
	g_object_notify_by_pspec ((GObject *) self, pgn_game_properties[PGN_GAME_SITE_PROPERTY]);
}

const gchar*
pgn_game_get_date (PGNGame* self)
{
	const gchar* result;
	GHashTable* _tmp0_;
	gconstpointer _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->tags;
	_tmp1_ = g_hash_table_lookup (_tmp0_, "Date");
	result = (const gchar*) _tmp1_;
	return result;
}

void
pgn_game_set_date (PGNGame* self,
                   const gchar* value)
{
	GHashTable* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->tags;
	_tmp1_ = g_strdup ("Date");
	_tmp2_ = g_strdup (value);
	g_hash_table_insert (_tmp0_, _tmp1_, _tmp2_);
	g_object_notify_by_pspec ((GObject *) self, pgn_game_properties[PGN_GAME_DATE_PROPERTY]);
}

const gchar*
pgn_game_get_time (PGNGame* self)
{
	const gchar* result;
	GHashTable* _tmp0_;
	gconstpointer _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->tags;
	_tmp1_ = g_hash_table_lookup (_tmp0_, "Time");
	result = (const gchar*) _tmp1_;
	return result;
}

void
pgn_game_set_time (PGNGame* self,
                   const gchar* value)
{
	GHashTable* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->tags;
	_tmp1_ = g_strdup ("Time");
	_tmp2_ = g_strdup (value);
	g_hash_table_insert (_tmp0_, _tmp1_, _tmp2_);
	g_object_notify_by_pspec ((GObject *) self, pgn_game_properties[PGN_GAME_TIME_PROPERTY]);
}

const gchar*
pgn_game_get_round (PGNGame* self)
{
	const gchar* result;
	GHashTable* _tmp0_;
	gconstpointer _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->tags;
	_tmp1_ = g_hash_table_lookup (_tmp0_, "Round");
	result = (const gchar*) _tmp1_;
	return result;
}

void
pgn_game_set_round (PGNGame* self,
                    const gchar* value)
{
	GHashTable* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->tags;
	_tmp1_ = g_strdup ("Round");
	_tmp2_ = g_strdup (value);
	g_hash_table_insert (_tmp0_, _tmp1_, _tmp2_);
	g_object_notify_by_pspec ((GObject *) self, pgn_game_properties[PGN_GAME_ROUND_PROPERTY]);
}

const gchar*
pgn_game_get_white (PGNGame* self)
{
	const gchar* result;
	GHashTable* _tmp0_;
	gconstpointer _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->tags;
	_tmp1_ = g_hash_table_lookup (_tmp0_, "White");
	result = (const gchar*) _tmp1_;
	return result;
}

void
pgn_game_set_white (PGNGame* self,
                    const gchar* value)
{
	GHashTable* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->tags;
	_tmp1_ = g_strdup ("White");
	_tmp2_ = g_strdup (value);
	g_hash_table_insert (_tmp0_, _tmp1_, _tmp2_);
	g_object_notify_by_pspec ((GObject *) self, pgn_game_properties[PGN_GAME_WHITE_PROPERTY]);
}

const gchar*
pgn_game_get_black (PGNGame* self)
{
	const gchar* result;
	GHashTable* _tmp0_;
	gconstpointer _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->tags;
	_tmp1_ = g_hash_table_lookup (_tmp0_, "Black");
	result = (const gchar*) _tmp1_;
	return result;
}

void
pgn_game_set_black (PGNGame* self,
                    const gchar* value)
{
	GHashTable* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->tags;
	_tmp1_ = g_strdup ("Black");
	_tmp2_ = g_strdup (value);
	g_hash_table_insert (_tmp0_, _tmp1_, _tmp2_);
	g_object_notify_by_pspec ((GObject *) self, pgn_game_properties[PGN_GAME_BLACK_PROPERTY]);
}

const gchar*
pgn_game_get_result (PGNGame* self)
{
	const gchar* result;
	GHashTable* _tmp0_;
	gconstpointer _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->tags;
	_tmp1_ = g_hash_table_lookup (_tmp0_, "Result");
	result = (const gchar*) _tmp1_;
	return result;
}

void
pgn_game_set_result (PGNGame* self,
                     const gchar* value)
{
	GHashTable* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->tags;
	_tmp1_ = g_strdup ("Result");
	_tmp2_ = g_strdup (value);
	g_hash_table_insert (_tmp0_, _tmp1_, _tmp2_);
	g_object_notify_by_pspec ((GObject *) self, pgn_game_properties[PGN_GAME_RESULT_PROPERTY]);
}

const gchar*
pgn_game_get_annotator (PGNGame* self)
{
	const gchar* result;
	GHashTable* _tmp0_;
	gconstpointer _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->tags;
	_tmp1_ = g_hash_table_lookup (_tmp0_, "Annotator");
	result = (const gchar*) _tmp1_;
	return result;
}

void
pgn_game_set_annotator (PGNGame* self,
                        const gchar* value)
{
	GHashTable* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->tags;
	_tmp1_ = g_strdup ("Annotator");
	_tmp2_ = g_strdup (value);
	g_hash_table_insert (_tmp0_, _tmp1_, _tmp2_);
	g_object_notify_by_pspec ((GObject *) self, pgn_game_properties[PGN_GAME_ANNOTATOR_PROPERTY]);
}

const gchar*
pgn_game_get_time_control (PGNGame* self)
{
	const gchar* result;
	GHashTable* _tmp0_;
	gconstpointer _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->tags;
	_tmp1_ = g_hash_table_lookup (_tmp0_, "TimeControl");
	result = (const gchar*) _tmp1_;
	return result;
}

void
pgn_game_set_time_control (PGNGame* self,
                           const gchar* value)
{
	GHashTable* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->tags;
	_tmp1_ = g_strdup ("TimeControl");
	_tmp2_ = g_strdup (value);
	g_hash_table_insert (_tmp0_, _tmp1_, _tmp2_);
	g_object_notify_by_pspec ((GObject *) self, pgn_game_properties[PGN_GAME_TIME_CONTROL_PROPERTY]);
}

const gchar*
pgn_game_get_white_time_left (PGNGame* self)
{
	const gchar* result;
	GHashTable* _tmp0_;
	gconstpointer _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->tags;
	_tmp1_ = g_hash_table_lookup (_tmp0_, "X-GNOME-WhiteTimeLeft");
	result = (const gchar*) _tmp1_;
	return result;
}

void
pgn_game_set_white_time_left (PGNGame* self,
                              const gchar* value)
{
	GHashTable* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->tags;
	_tmp1_ = g_strdup ("X-GNOME-WhiteTimeLeft");
	_tmp2_ = g_strdup (value);
	g_hash_table_insert (_tmp0_, _tmp1_, _tmp2_);
	g_object_notify_by_pspec ((GObject *) self, pgn_game_properties[PGN_GAME_WHITE_TIME_LEFT_PROPERTY]);
}

const gchar*
pgn_game_get_black_time_left (PGNGame* self)
{
	const gchar* result;
	GHashTable* _tmp0_;
	gconstpointer _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->tags;
	_tmp1_ = g_hash_table_lookup (_tmp0_, "X-GNOME-BlackTimeLeft");
	result = (const gchar*) _tmp1_;
	return result;
}

void
pgn_game_set_black_time_left (PGNGame* self,
                              const gchar* value)
{
	GHashTable* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->tags;
	_tmp1_ = g_strdup ("X-GNOME-BlackTimeLeft");
	_tmp2_ = g_strdup (value);
	g_hash_table_insert (_tmp0_, _tmp1_, _tmp2_);
	g_object_notify_by_pspec ((GObject *) self, pgn_game_properties[PGN_GAME_BLACK_TIME_LEFT_PROPERTY]);
}

const gchar*
pgn_game_get_clock_type (PGNGame* self)
{
	const gchar* result;
	GHashTable* _tmp0_;
	gconstpointer _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->tags;
	_tmp1_ = g_hash_table_lookup (_tmp0_, "X-GNOME-ClockType");
	result = (const gchar*) _tmp1_;
	return result;
}

void
pgn_game_set_clock_type (PGNGame* self,
                         const gchar* value)
{
	GHashTable* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->tags;
	_tmp1_ = g_strdup ("X-GNOME-ClockType");
	_tmp2_ = g_strdup (value);
	g_hash_table_insert (_tmp0_, _tmp1_, _tmp2_);
	g_object_notify_by_pspec ((GObject *) self, pgn_game_properties[PGN_GAME_CLOCK_TYPE_PROPERTY]);
}

const gchar*
pgn_game_get_timer_increment (PGNGame* self)
{
	const gchar* result;
	GHashTable* _tmp0_;
	gconstpointer _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->tags;
	_tmp1_ = g_hash_table_lookup (_tmp0_, "X-GNOME-TimerIncrement");
	result = (const gchar*) _tmp1_;
	return result;
}

void
pgn_game_set_timer_increment (PGNGame* self,
                              const gchar* value)
{
	GHashTable* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->tags;
	_tmp1_ = g_strdup ("X-GNOME-TimerIncrement");
	_tmp2_ = g_strdup (value);
	g_hash_table_insert (_tmp0_, _tmp1_, _tmp2_);
	g_object_notify_by_pspec ((GObject *) self, pgn_game_properties[PGN_GAME_TIMER_INCREMENT_PROPERTY]);
}

gboolean
pgn_game_get_set_up (PGNGame* self)
{
	gboolean result;
	gchar* v = NULL;
	GHashTable* _tmp0_;
	gconstpointer _tmp1_;
	gchar* _tmp2_;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	const gchar* _tmp5_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->tags;
	_tmp1_ = g_hash_table_lookup (_tmp0_, "SetUp");
	_tmp2_ = g_strdup ((const gchar*) _tmp1_);
	v = _tmp2_;
	_tmp5_ = v;
	if (_tmp5_ != NULL) {
		const gchar* _tmp6_;
		_tmp6_ = v;
		_tmp4_ = g_strcmp0 (_tmp6_, "1") == 0;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		_tmp3_ = TRUE;
	} else {
		_tmp3_ = FALSE;
	}
	result = _tmp3_;
	_g_free0 (v);
	return result;
}

void
pgn_game_set_set_up (PGNGame* self,
                     gboolean value)
{
	const gchar* _tmp0_ = NULL;
	GHashTable* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_if_fail (self != NULL);
	if (value) {
		_tmp0_ = "1";
	} else {
		_tmp0_ = "0";
	}
	_tmp1_ = self->tags;
	_tmp2_ = g_strdup ("SetUp");
	_tmp3_ = g_strdup (_tmp0_);
	g_hash_table_insert (_tmp1_, _tmp2_, _tmp3_);
	g_object_notify_by_pspec ((GObject *) self, pgn_game_properties[PGN_GAME_SET_UP_PROPERTY]);
}

const gchar*
pgn_game_get_fen (PGNGame* self)
{
	const gchar* result;
	GHashTable* _tmp0_;
	gconstpointer _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->tags;
	_tmp1_ = g_hash_table_lookup (_tmp0_, "FEN");
	result = (const gchar*) _tmp1_;
	return result;
}

void
pgn_game_set_fen (PGNGame* self,
                  const gchar* value)
{
	GHashTable* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->tags;
	_tmp1_ = g_strdup ("FEN");
	_tmp2_ = g_strdup (value);
	g_hash_table_insert (_tmp0_, _tmp1_, _tmp2_);
	g_object_notify_by_pspec ((GObject *) self, pgn_game_properties[PGN_GAME_FEN_PROPERTY]);
}

const gchar*
pgn_game_get_termination (PGNGame* self)
{
	const gchar* result;
	GHashTable* _tmp0_;
	gconstpointer _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->tags;
	_tmp1_ = g_hash_table_lookup (_tmp0_, "Termination");
	result = (const gchar*) _tmp1_;
	return result;
}

void
pgn_game_set_termination (PGNGame* self,
                          const gchar* value)
{
	GHashTable* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->tags;
	_tmp1_ = g_strdup ("Termination");
	_tmp2_ = g_strdup (value);
	g_hash_table_insert (_tmp0_, _tmp1_, _tmp2_);
	g_object_notify_by_pspec ((GObject *) self, pgn_game_properties[PGN_GAME_TERMINATION_PROPERTY]);
}

const gchar*
pgn_game_get_white_ai (PGNGame* self)
{
	const gchar* result;
	GHashTable* _tmp0_;
	gconstpointer _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->tags;
	_tmp1_ = g_hash_table_lookup (_tmp0_, "X-GNOME-WhiteAI");
	result = (const gchar*) _tmp1_;
	return result;
}

void
pgn_game_set_white_ai (PGNGame* self,
                       const gchar* value)
{
	GHashTable* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->tags;
	_tmp1_ = g_strdup ("X-GNOME-WhiteAI");
	_tmp2_ = g_strdup (value);
	g_hash_table_insert (_tmp0_, _tmp1_, _tmp2_);
	g_object_notify_by_pspec ((GObject *) self, pgn_game_properties[PGN_GAME_WHITE_AI_PROPERTY]);
}

const gchar*
pgn_game_get_white_level (PGNGame* self)
{
	const gchar* result;
	GHashTable* _tmp0_;
	gconstpointer _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->tags;
	_tmp1_ = g_hash_table_lookup (_tmp0_, "X-GNOME-WhiteLevel");
	result = (const gchar*) _tmp1_;
	return result;
}

void
pgn_game_set_white_level (PGNGame* self,
                          const gchar* value)
{
	GHashTable* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->tags;
	_tmp1_ = g_strdup ("X-GNOME-WhiteLevel");
	_tmp2_ = g_strdup (value);
	g_hash_table_insert (_tmp0_, _tmp1_, _tmp2_);
	g_object_notify_by_pspec ((GObject *) self, pgn_game_properties[PGN_GAME_WHITE_LEVEL_PROPERTY]);
}

const gchar*
pgn_game_get_black_ai (PGNGame* self)
{
	const gchar* result;
	GHashTable* _tmp0_;
	gconstpointer _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->tags;
	_tmp1_ = g_hash_table_lookup (_tmp0_, "X-GNOME-BlackAI");
	result = (const gchar*) _tmp1_;
	return result;
}

void
pgn_game_set_black_ai (PGNGame* self,
                       const gchar* value)
{
	GHashTable* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->tags;
	_tmp1_ = g_strdup ("X-GNOME-BlackAI");
	_tmp2_ = g_strdup (value);
	g_hash_table_insert (_tmp0_, _tmp1_, _tmp2_);
	g_object_notify_by_pspec ((GObject *) self, pgn_game_properties[PGN_GAME_BLACK_AI_PROPERTY]);
}

const gchar*
pgn_game_get_black_level (PGNGame* self)
{
	const gchar* result;
	GHashTable* _tmp0_;
	gconstpointer _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->tags;
	_tmp1_ = g_hash_table_lookup (_tmp0_, "X-GNOME-BlackLevel");
	result = (const gchar*) _tmp1_;
	return result;
}

void
pgn_game_set_black_level (PGNGame* self,
                          const gchar* value)
{
	GHashTable* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->tags;
	_tmp1_ = g_strdup ("X-GNOME-BlackLevel");
	_tmp2_ = g_strdup (value);
	g_hash_table_insert (_tmp0_, _tmp1_, _tmp2_);
	g_object_notify_by_pspec ((GObject *) self, pgn_game_properties[PGN_GAME_BLACK_LEVEL_PROPERTY]);
}

static void
pgn_game_class_init (PGNGameClass * klass,
                     gpointer klass_data)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	pgn_game_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->get_property = _vala_pgn_game_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_pgn_game_set_property;
	G_OBJECT_CLASS (klass)->finalize = pgn_game_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), PGN_GAME_EVENT_PROPERTY, pgn_game_properties[PGN_GAME_EVENT_PROPERTY] = g_param_spec_string ("event", "event", "event", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PGN_GAME_SITE_PROPERTY, pgn_game_properties[PGN_GAME_SITE_PROPERTY] = g_param_spec_string ("site", "site", "site", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PGN_GAME_DATE_PROPERTY, pgn_game_properties[PGN_GAME_DATE_PROPERTY] = g_param_spec_string ("date", "date", "date", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PGN_GAME_TIME_PROPERTY, pgn_game_properties[PGN_GAME_TIME_PROPERTY] = g_param_spec_string ("time", "time", "time", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PGN_GAME_ROUND_PROPERTY, pgn_game_properties[PGN_GAME_ROUND_PROPERTY] = g_param_spec_string ("round", "round", "round", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PGN_GAME_WHITE_PROPERTY, pgn_game_properties[PGN_GAME_WHITE_PROPERTY] = g_param_spec_string ("white", "white", "white", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PGN_GAME_BLACK_PROPERTY, pgn_game_properties[PGN_GAME_BLACK_PROPERTY] = g_param_spec_string ("black", "black", "black", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PGN_GAME_RESULT_PROPERTY, pgn_game_properties[PGN_GAME_RESULT_PROPERTY] = g_param_spec_string ("result", "result", "result", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PGN_GAME_ANNOTATOR_PROPERTY, pgn_game_properties[PGN_GAME_ANNOTATOR_PROPERTY] = g_param_spec_string ("annotator", "annotator", "annotator", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PGN_GAME_TIME_CONTROL_PROPERTY, pgn_game_properties[PGN_GAME_TIME_CONTROL_PROPERTY] = g_param_spec_string ("time-control", "time-control", "time-control", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PGN_GAME_WHITE_TIME_LEFT_PROPERTY, pgn_game_properties[PGN_GAME_WHITE_TIME_LEFT_PROPERTY] = g_param_spec_string ("white-time-left", "white-time-left", "white-time-left", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PGN_GAME_BLACK_TIME_LEFT_PROPERTY, pgn_game_properties[PGN_GAME_BLACK_TIME_LEFT_PROPERTY] = g_param_spec_string ("black-time-left", "black-time-left", "black-time-left", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PGN_GAME_CLOCK_TYPE_PROPERTY, pgn_game_properties[PGN_GAME_CLOCK_TYPE_PROPERTY] = g_param_spec_string ("clock-type", "clock-type", "clock-type", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PGN_GAME_TIMER_INCREMENT_PROPERTY, pgn_game_properties[PGN_GAME_TIMER_INCREMENT_PROPERTY] = g_param_spec_string ("timer-increment", "timer-increment", "timer-increment", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PGN_GAME_SET_UP_PROPERTY, pgn_game_properties[PGN_GAME_SET_UP_PROPERTY] = g_param_spec_boolean ("set-up", "set-up", "set-up", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PGN_GAME_FEN_PROPERTY, pgn_game_properties[PGN_GAME_FEN_PROPERTY] = g_param_spec_string ("fen", "fen", "fen", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PGN_GAME_TERMINATION_PROPERTY, pgn_game_properties[PGN_GAME_TERMINATION_PROPERTY] = g_param_spec_string ("termination", "termination", "termination", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PGN_GAME_WHITE_AI_PROPERTY, pgn_game_properties[PGN_GAME_WHITE_AI_PROPERTY] = g_param_spec_string ("white-ai", "white-ai", "white-ai", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PGN_GAME_WHITE_LEVEL_PROPERTY, pgn_game_properties[PGN_GAME_WHITE_LEVEL_PROPERTY] = g_param_spec_string ("white-level", "white-level", "white-level", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PGN_GAME_BLACK_AI_PROPERTY, pgn_game_properties[PGN_GAME_BLACK_AI_PROPERTY] = g_param_spec_string ("black-ai", "black-ai", "black-ai", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PGN_GAME_BLACK_LEVEL_PROPERTY, pgn_game_properties[PGN_GAME_BLACK_LEVEL_PROPERTY] = g_param_spec_string ("black-level", "black-level", "black-level", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	_tmp0_ = g_strdup ("*");
	pgn_game_RESULT_IN_PROGRESS = _tmp0_;
	_tmp1_ = g_strdup ("1/2-1/2");
	pgn_game_RESULT_DRAW = _tmp1_;
	_tmp2_ = g_strdup ("1-0");
	pgn_game_RESULT_WHITE = _tmp2_;
	_tmp3_ = g_strdup ("0-1");
	pgn_game_RESULT_BLACK = _tmp3_;
	_tmp4_ = g_strdup ("abandoned");
	pgn_game_TERMINATE_ABANDONED = _tmp4_;
	_tmp5_ = g_strdup ("adjudication");
	pgn_game_TERMINATE_ADJUDICATION = _tmp5_;
	_tmp6_ = g_strdup ("death");
	pgn_game_TERMINATE_DEATH = _tmp6_;
	_tmp7_ = g_strdup ("emergency");
	pgn_game_TERMINATE_EMERGENCY = _tmp7_;
	_tmp8_ = g_strdup ("normal");
	pgn_game_TERMINATE_NORMAL = _tmp8_;
	_tmp9_ = g_strdup ("rules infraction");
	pgn_game_TERMINATE_RULES_INFRACTION = _tmp9_;
	_tmp10_ = g_strdup ("time forfeit");
	pgn_game_TERMINATE_TIME_FORFEIT = _tmp10_;
	_tmp11_ = g_strdup ("unterminated");
	pgn_game_TERMINATE_UNTERMINATED = _tmp11_;
}

static void
pgn_game_instance_init (PGNGame * self,
                        gpointer klass)
{
}

static void
pgn_game_finalize (GObject * obj)
{
	PGNGame * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PGN_GAME, PGNGame);
	_g_hash_table_unref0 (self->tags);
	(self->moves == NULL) ? NULL : (self->moves = (_g_list_free__g_free0_ (self->moves), NULL));
	G_OBJECT_CLASS (pgn_game_parent_class)->finalize (obj);
}

static GType
pgn_game_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PGNGameClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) pgn_game_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PGNGame), 0, (GInstanceInitFunc) pgn_game_instance_init, NULL };
	GType pgn_game_type_id;
	pgn_game_type_id = g_type_register_static (G_TYPE_OBJECT, "PGNGame", &g_define_type_info, 0);
	return pgn_game_type_id;
}

GType
pgn_game_get_type (void)
{
	static volatile gsize pgn_game_type_id__once = 0;
	if (g_once_init_enter (&pgn_game_type_id__once)) {
		GType pgn_game_type_id;
		pgn_game_type_id = pgn_game_get_type_once ();
		g_once_init_leave (&pgn_game_type_id__once, pgn_game_type_id);
	}
	return pgn_game_type_id__once;
}

static void
_vala_pgn_game_get_property (GObject * object,
                             guint property_id,
                             GValue * value,
                             GParamSpec * pspec)
{
	PGNGame * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_PGN_GAME, PGNGame);
	switch (property_id) {
		case PGN_GAME_EVENT_PROPERTY:
		g_value_set_string (value, pgn_game_get_event (self));
		break;
		case PGN_GAME_SITE_PROPERTY:
		g_value_set_string (value, pgn_game_get_site (self));
		break;
		case PGN_GAME_DATE_PROPERTY:
		g_value_set_string (value, pgn_game_get_date (self));
		break;
		case PGN_GAME_TIME_PROPERTY:
		g_value_set_string (value, pgn_game_get_time (self));
		break;
		case PGN_GAME_ROUND_PROPERTY:
		g_value_set_string (value, pgn_game_get_round (self));
		break;
		case PGN_GAME_WHITE_PROPERTY:
		g_value_set_string (value, pgn_game_get_white (self));
		break;
		case PGN_GAME_BLACK_PROPERTY:
		g_value_set_string (value, pgn_game_get_black (self));
		break;
		case PGN_GAME_RESULT_PROPERTY:
		g_value_set_string (value, pgn_game_get_result (self));
		break;
		case PGN_GAME_ANNOTATOR_PROPERTY:
		g_value_set_string (value, pgn_game_get_annotator (self));
		break;
		case PGN_GAME_TIME_CONTROL_PROPERTY:
		g_value_set_string (value, pgn_game_get_time_control (self));
		break;
		case PGN_GAME_WHITE_TIME_LEFT_PROPERTY:
		g_value_set_string (value, pgn_game_get_white_time_left (self));
		break;
		case PGN_GAME_BLACK_TIME_LEFT_PROPERTY:
		g_value_set_string (value, pgn_game_get_black_time_left (self));
		break;
		case PGN_GAME_CLOCK_TYPE_PROPERTY:
		g_value_set_string (value, pgn_game_get_clock_type (self));
		break;
		case PGN_GAME_TIMER_INCREMENT_PROPERTY:
		g_value_set_string (value, pgn_game_get_timer_increment (self));
		break;
		case PGN_GAME_SET_UP_PROPERTY:
		g_value_set_boolean (value, pgn_game_get_set_up (self));
		break;
		case PGN_GAME_FEN_PROPERTY:
		g_value_set_string (value, pgn_game_get_fen (self));
		break;
		case PGN_GAME_TERMINATION_PROPERTY:
		g_value_set_string (value, pgn_game_get_termination (self));
		break;
		case PGN_GAME_WHITE_AI_PROPERTY:
		g_value_set_string (value, pgn_game_get_white_ai (self));
		break;
		case PGN_GAME_WHITE_LEVEL_PROPERTY:
		g_value_set_string (value, pgn_game_get_white_level (self));
		break;
		case PGN_GAME_BLACK_AI_PROPERTY:
		g_value_set_string (value, pgn_game_get_black_ai (self));
		break;
		case PGN_GAME_BLACK_LEVEL_PROPERTY:
		g_value_set_string (value, pgn_game_get_black_level (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_pgn_game_set_property (GObject * object,
                             guint property_id,
                             const GValue * value,
                             GParamSpec * pspec)
{
	PGNGame * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_PGN_GAME, PGNGame);
	switch (property_id) {
		case PGN_GAME_EVENT_PROPERTY:
		pgn_game_set_event (self, g_value_get_string (value));
		break;
		case PGN_GAME_SITE_PROPERTY:
		pgn_game_set_site (self, g_value_get_string (value));
		break;
		case PGN_GAME_DATE_PROPERTY:
		pgn_game_set_date (self, g_value_get_string (value));
		break;
		case PGN_GAME_TIME_PROPERTY:
		pgn_game_set_time (self, g_value_get_string (value));
		break;
		case PGN_GAME_ROUND_PROPERTY:
		pgn_game_set_round (self, g_value_get_string (value));
		break;
		case PGN_GAME_WHITE_PROPERTY:
		pgn_game_set_white (self, g_value_get_string (value));
		break;
		case PGN_GAME_BLACK_PROPERTY:
		pgn_game_set_black (self, g_value_get_string (value));
		break;
		case PGN_GAME_RESULT_PROPERTY:
		pgn_game_set_result (self, g_value_get_string (value));
		break;
		case PGN_GAME_ANNOTATOR_PROPERTY:
		pgn_game_set_annotator (self, g_value_get_string (value));
		break;
		case PGN_GAME_TIME_CONTROL_PROPERTY:
		pgn_game_set_time_control (self, g_value_get_string (value));
		break;
		case PGN_GAME_WHITE_TIME_LEFT_PROPERTY:
		pgn_game_set_white_time_left (self, g_value_get_string (value));
		break;
		case PGN_GAME_BLACK_TIME_LEFT_PROPERTY:
		pgn_game_set_black_time_left (self, g_value_get_string (value));
		break;
		case PGN_GAME_CLOCK_TYPE_PROPERTY:
		pgn_game_set_clock_type (self, g_value_get_string (value));
		break;
		case PGN_GAME_TIMER_INCREMENT_PROPERTY:
		pgn_game_set_timer_increment (self, g_value_get_string (value));
		break;
		case PGN_GAME_SET_UP_PROPERTY:
		pgn_game_set_set_up (self, g_value_get_boolean (value));
		break;
		case PGN_GAME_FEN_PROPERTY:
		pgn_game_set_fen (self, g_value_get_string (value));
		break;
		case PGN_GAME_TERMINATION_PROPERTY:
		pgn_game_set_termination (self, g_value_get_string (value));
		break;
		case PGN_GAME_WHITE_AI_PROPERTY:
		pgn_game_set_white_ai (self, g_value_get_string (value));
		break;
		case PGN_GAME_WHITE_LEVEL_PROPERTY:
		pgn_game_set_white_level (self, g_value_get_string (value));
		break;
		case PGN_GAME_BLACK_AI_PROPERTY:
		pgn_game_set_black_ai (self, g_value_get_string (value));
		break;
		case PGN_GAME_BLACK_LEVEL_PROPERTY:
		pgn_game_set_black_level (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static GType
state_get_type_once (void)
{
	static const GEnumValue values[] = {{STATE_TAGS, "STATE_TAGS", "tags"}, {STATE_MOVE_TEXT, "STATE_MOVE_TEXT", "move-text"}, {STATE_LINE_COMMENT, "STATE_LINE_COMMENT", "line-comment"}, {STATE_BRACE_COMMENT, "STATE_BRACE_COMMENT", "brace-comment"}, {STATE_TAG_START, "STATE_TAG_START", "tag-start"}, {STATE_TAG_NAME, "STATE_TAG_NAME", "tag-name"}, {STATE_PRE_TAG_VALUE, "STATE_PRE_TAG_VALUE", "pre-tag-value"}, {STATE_TAG_VALUE, "STATE_TAG_VALUE", "tag-value"}, {STATE_POST_TAG_VALUE, "STATE_POST_TAG_VALUE", "post-tag-value"}, {STATE_SYMBOL, "STATE_SYMBOL", "symbol"}, {STATE_PERIOD, "STATE_PERIOD", "period"}, {STATE_NAG, "STATE_NAG", "nag"}, {STATE_ERROR, "STATE_ERROR", "error"}, {0, NULL, NULL}};
	GType state_type_id;
	state_type_id = g_enum_register_static ("State", values);
	return state_type_id;
}

GType
state_get_type (void)
{
	static volatile gsize state_type_id__once = 0;
	if (g_once_init_enter (&state_type_id__once)) {
		GType state_type_id;
		state_type_id = state_get_type_once ();
		g_once_init_leave (&state_type_id__once, state_type_id);
	}
	return state_type_id__once;
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

static gboolean
int64_try_parse (const gchar* str,
                 gint64* _result_,
                 const gchar** unparsed,
                 guint _base)
{
	gint64 _vala__result_ = 0LL;
	const gchar* _vala_unparsed = NULL;
	gchar* endptr = NULL;
	gchar* _tmp0_ = NULL;
	gint64 _tmp1_;
	gchar* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gboolean result;
	g_return_val_if_fail (str != NULL, FALSE);
	errno = 0;
	_tmp1_ = g_ascii_strtoll (str, &_tmp0_, _base);
	endptr = _tmp0_;
	_vala__result_ = _tmp1_;
	_tmp2_ = endptr;
	_tmp3_ = strlen (str);
	_tmp4_ = _tmp3_;
	if (_tmp2_ == (((gchar*) str) + _tmp4_)) {
		gboolean _tmp5_ = FALSE;
		_vala_unparsed = "";
		if (errno != ERANGE) {
			_tmp5_ = errno != EINVAL;
		} else {
			_tmp5_ = FALSE;
		}
		result = _tmp5_;
		if (_result_) {
			*_result_ = _vala__result_;
		}
		if (unparsed) {
			*unparsed = _vala_unparsed;
		}
		return result;
	} else {
		gchar* _tmp6_;
		_tmp6_ = endptr;
		_vala_unparsed = (const gchar*) _tmp6_;
		result = FALSE;
		if (_result_) {
			*_result_ = _vala__result_;
		}
		if (unparsed) {
			*unparsed = _vala_unparsed;
		}
		return result;
	}
}

static void
pgn_insert_tag (PGN* self,
                PGNGame* game,
                const gchar* tag_name,
                const gchar* tag_value)
{
	const gchar* _tmp0_;
	GQuark _tmp2_ = 0U;
	static GQuark _tmp1_label0 = 0;
	static GQuark _tmp1_label1 = 0;
	static GQuark _tmp1_label2 = 0;
	static GQuark _tmp1_label3 = 0;
	static GQuark _tmp1_label4 = 0;
	static GQuark _tmp1_label5 = 0;
	static GQuark _tmp1_label6 = 0;
	static GQuark _tmp1_label7 = 0;
	static GQuark _tmp1_label8 = 0;
	static GQuark _tmp1_label9 = 0;
	static GQuark _tmp1_label10 = 0;
	static GQuark _tmp1_label11 = 0;
	static GQuark _tmp1_label12 = 0;
	static GQuark _tmp1_label13 = 0;
	static GQuark _tmp1_label14 = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (game != NULL);
	g_return_if_fail (tag_name != NULL);
	g_return_if_fail (tag_value != NULL);
	_tmp0_ = tag_name;
	_tmp2_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
	if (_tmp2_ == ((0 != _tmp1_label0) ? _tmp1_label0 : (_tmp1_label0 = g_quark_from_static_string ("TimeControl")))) {
		switch (0) {
			default:
			{
				if (int64_try_parse (tag_value, NULL, NULL, (guint) 0) == TRUE) {
					GHashTable* _tmp3_;
					gchar* _tmp4_;
					gchar* _tmp5_;
					_tmp3_ = game->tags;
					_tmp4_ = g_strdup ("TimeControl");
					_tmp5_ = g_strdup (tag_value);
					g_hash_table_insert (_tmp3_, _tmp4_, _tmp5_);
				} else {
					g_warning (_ ("Invalid %s : %s in PGN, setting timer to infinity."), tag_name, tag_value);
				}
				break;
			}
		}
	} else if ((_tmp2_ == ((0 != _tmp1_label1) ? _tmp1_label1 : (_tmp1_label1 = g_quark_from_static_string ("WhiteTimeLeft")))) || (_tmp2_ == ((0 != _tmp1_label2) ? _tmp1_label2 : (_tmp1_label2 = g_quark_from_static_string ("X-GNOME-WhiteTimeLeft"))))) {
		switch (0) {
			default:
			{
				if (int64_try_parse (tag_value, NULL, NULL, (guint) 0) == FALSE) {
					g_warning (_ ("Invalid %s : %s in PGN, setting timer to infinity."), tag_name, tag_value);
				} else {
					GHashTable* _tmp6_;
					gchar* _tmp7_;
					gchar* _tmp8_;
					_tmp6_ = game->tags;
					_tmp7_ = g_strdup ("X-GNOME-WhiteTimeLeft");
					_tmp8_ = g_strdup (tag_value);
					g_hash_table_insert (_tmp6_, _tmp7_, _tmp8_);
				}
				break;
			}
		}
	} else if ((_tmp2_ == ((0 != _tmp1_label3) ? _tmp1_label3 : (_tmp1_label3 = g_quark_from_static_string ("BlackTimeLeft")))) || (_tmp2_ == ((0 != _tmp1_label4) ? _tmp1_label4 : (_tmp1_label4 = g_quark_from_static_string ("X-GNOME-BlackTimeLeft"))))) {
		switch (0) {
			default:
			{
				if (int64_try_parse (tag_value, NULL, NULL, (guint) 0) == FALSE) {
					g_warning (_ ("Invalid %s : %s in PGN, setting timer to infinity."), tag_name, tag_value);
				} else {
					GHashTable* _tmp9_;
					gchar* _tmp10_;
					gchar* _tmp11_;
					_tmp9_ = game->tags;
					_tmp10_ = g_strdup ("X-GNOME-BlackTimeLeft");
					_tmp11_ = g_strdup (tag_value);
					g_hash_table_insert (_tmp9_, _tmp10_, _tmp11_);
				}
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label5) ? _tmp1_label5 : (_tmp1_label5 = g_quark_from_static_string ("X-GNOME-ClockType")))) {
		switch (0) {
			default:
			{
				if (chess_clock_type_string_to_enum (tag_value) == CHESS_CLOCK_TYPE_INVALID) {
					GHashTable* _tmp12_;
					gchar* _tmp13_;
					gchar* _tmp14_;
					g_warning (_ ("Invalid clock type in PGN: %s, using a simple clock."), tag_value);
					_tmp12_ = game->tags;
					_tmp13_ = g_strdup ("X-GNOME-ClockType");
					_tmp14_ = g_strdup ("simple");
					g_hash_table_insert (_tmp12_, _tmp13_, _tmp14_);
				}
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label6) ? _tmp1_label6 : (_tmp1_label6 = g_quark_from_static_string ("X-GNOME-TimerIncrement")))) {
		switch (0) {
			default:
			{
				if (int64_try_parse (tag_value, NULL, NULL, (guint) 0) == FALSE) {
					GHashTable* _tmp15_;
					gchar* _tmp16_;
					gchar* _tmp17_;
					GHashTable* _tmp18_;
					gchar* _tmp19_;
					gchar* _tmp20_;
					g_warning (_ ("Invalid timer increment in PGN: %s, using a simple clock."), tag_value);
					_tmp15_ = game->tags;
					_tmp16_ = g_strdup ("X-GNOME-ClockType");
					_tmp17_ = g_strdup ("simple");
					g_hash_table_insert (_tmp15_, _tmp16_, _tmp17_);
					_tmp18_ = game->tags;
					_tmp19_ = g_strdup ("X-GNOME-TimerIncrement");
					_tmp20_ = g_strdup ("0");
					g_hash_table_insert (_tmp18_, _tmp19_, _tmp20_);
				}
				break;
			}
		}
	} else if ((_tmp2_ == ((0 != _tmp1_label7) ? _tmp1_label7 : (_tmp1_label7 = g_quark_from_static_string ("WhiteAI")))) || (_tmp2_ == ((0 != _tmp1_label8) ? _tmp1_label8 : (_tmp1_label8 = g_quark_from_static_string ("X-GNOME-WhiteAI"))))) {
		switch (0) {
			default:
			{
				GHashTable* _tmp21_;
				gchar* _tmp22_;
				gchar* _tmp23_;
				_tmp21_ = game->tags;
				_tmp22_ = g_strdup ("X-GNOME-WhiteAI");
				_tmp23_ = g_strdup (tag_value);
				g_hash_table_insert (_tmp21_, _tmp22_, _tmp23_);
				break;
			}
		}
	} else if ((_tmp2_ == ((0 != _tmp1_label9) ? _tmp1_label9 : (_tmp1_label9 = g_quark_from_static_string ("WhiteLevel")))) || (_tmp2_ == ((0 != _tmp1_label10) ? _tmp1_label10 : (_tmp1_label10 = g_quark_from_static_string ("X-GNOME-WhiteLevel"))))) {
		switch (0) {
			default:
			{
				GHashTable* _tmp24_;
				gchar* _tmp25_;
				gchar* _tmp26_;
				_tmp24_ = game->tags;
				_tmp25_ = g_strdup ("X-GNOME-WhiteLevel");
				_tmp26_ = g_strdup (tag_value);
				g_hash_table_insert (_tmp24_, _tmp25_, _tmp26_);
				break;
			}
		}
	} else if ((_tmp2_ == ((0 != _tmp1_label11) ? _tmp1_label11 : (_tmp1_label11 = g_quark_from_static_string ("BlackAI")))) || (_tmp2_ == ((0 != _tmp1_label12) ? _tmp1_label12 : (_tmp1_label12 = g_quark_from_static_string ("X-GNOME-BlackAI"))))) {
		switch (0) {
			default:
			{
				GHashTable* _tmp27_;
				gchar* _tmp28_;
				gchar* _tmp29_;
				_tmp27_ = game->tags;
				_tmp28_ = g_strdup ("X-GNOME-BlackAI");
				_tmp29_ = g_strdup (tag_value);
				g_hash_table_insert (_tmp27_, _tmp28_, _tmp29_);
				break;
			}
		}
	} else if ((_tmp2_ == ((0 != _tmp1_label13) ? _tmp1_label13 : (_tmp1_label13 = g_quark_from_static_string ("BlackLevel")))) || (_tmp2_ == ((0 != _tmp1_label14) ? _tmp1_label14 : (_tmp1_label14 = g_quark_from_static_string ("X-GNOME-BlackLevel"))))) {
		switch (0) {
			default:
			{
				GHashTable* _tmp30_;
				gchar* _tmp31_;
				gchar* _tmp32_;
				_tmp30_ = game->tags;
				_tmp31_ = g_strdup ("X-GNOME-BlackLevel");
				_tmp32_ = g_strdup (tag_value);
				g_hash_table_insert (_tmp30_, _tmp31_, _tmp32_);
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				GHashTable* _tmp33_;
				gchar* _tmp34_;
				gchar* _tmp35_;
				_tmp33_ = game->tags;
				_tmp34_ = g_strdup (tag_name);
				_tmp35_ = g_strdup (tag_value);
				g_hash_table_insert (_tmp33_, _tmp34_, _tmp35_);
				break;
			}
		}
	}
}

static gchar
string_get (const gchar* self,
            glong index)
{
	gchar _tmp0_;
	gchar result;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = ((gchar*) self)[index];
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gchar*
string_slice (const gchar* self,
              glong start,
              glong end)
{
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gchar* _tmp4_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	if (start < ((glong) 0)) {
		start = string_length + start;
	}
	if (end < ((glong) 0)) {
		end = string_length + end;
	}
	if (start >= ((glong) 0)) {
		_tmp2_ = start <= string_length;
	} else {
		_tmp2_ = FALSE;
	}
	g_return_val_if_fail (_tmp2_, NULL);
	if (end >= ((glong) 0)) {
		_tmp3_ = end <= string_length;
	} else {
		_tmp3_ = FALSE;
	}
	g_return_val_if_fail (_tmp3_, NULL);
	g_return_val_if_fail (start <= end, NULL);
	_tmp4_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
	result = _tmp4_;
	return result;
}

PGN*
pgn_construct_from_string (GType object_type,
                           const gchar* data,
                           GError** error)
{
	PGN * self = NULL;
	State state = 0;
	State home_state = 0;
	PGNGame* game = NULL;
	PGNGame* _tmp0_;
	gboolean in_escape = FALSE;
	gsize token_start = 0UL;
	gsize line_offset = 0UL;
	gchar* tag_name = NULL;
	gchar* _tmp1_;
	GString* tag_value = NULL;
	GString* _tmp2_;
	gint line = 0;
	gint rav_level = 0;
	gboolean _tmp72_ = FALSE;
	PGNGame* _tmp73_;
	GList* _tmp74_;
	GList* _tmp79_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (data != NULL, NULL);
	self = (PGN*) g_object_new (object_type, NULL);
	state = STATE_TAGS;
	home_state = STATE_TAGS;
	_tmp0_ = pgn_game_new ();
	game = _tmp0_;
	in_escape = FALSE;
	token_start = (gsize) 0;
	line_offset = (gsize) 0;
	_tmp1_ = g_strdup ("");
	tag_name = _tmp1_;
	_tmp2_ = g_string_new ("");
	tag_value = _tmp2_;
	line = 1;
	rav_level = 0;
	{
		gsize offset = 0UL;
		offset = (gsize) 0;
		{
			gboolean _tmp3_ = FALSE;
			_tmp3_ = TRUE;
			while (TRUE) {
				gint _tmp5_;
				gint _tmp6_;
				gunichar c = 0U;
				if (!_tmp3_) {
					gsize _tmp4_;
					_tmp4_ = offset;
					offset = _tmp4_ + 1;
				}
				_tmp3_ = FALSE;
				_tmp5_ = strlen (data);
				_tmp6_ = _tmp5_;
				if (!(offset <= ((gsize) _tmp6_))) {
					break;
				}
				c = (gunichar) string_get (data, (glong) offset);
				if (c == ((gunichar) '\n')) {
					gint _tmp7_;
					_tmp7_ = line;
					line = _tmp7_ + 1;
					line_offset = offset + 1;
				}
				switch (state) {
					case STATE_TAGS:
					{
						home_state = STATE_TAGS;
						if (c == ((gunichar) ';')) {
							state = STATE_LINE_COMMENT;
						} else {
							if (c == ((gunichar) '{')) {
								state = STATE_BRACE_COMMENT;
							} else {
								if (c == ((gunichar) '[')) {
									state = STATE_TAG_START;
								} else {
									if (!g_unichar_isspace (c)) {
										gsize _tmp8_;
										_tmp8_ = offset;
										offset = _tmp8_ - 1;
										state = STATE_MOVE_TEXT;
										continue;
									}
								}
							}
						}
						break;
					}
					case STATE_MOVE_TEXT:
					{
						home_state = STATE_MOVE_TEXT;
						if (c == ((gunichar) ';')) {
							state = STATE_LINE_COMMENT;
						} else {
							if (c == ((gunichar) '{')) {
								state = STATE_BRACE_COMMENT;
							} else {
								if (c == ((gunichar) '*')) {
									if (rav_level == 0) {
										PGNGame* _tmp9_;
										const gchar* _tmp10_;
										PGNGame* _tmp11_;
										PGNGame* _tmp12_;
										PGNGame* _tmp13_;
										_tmp9_ = game;
										_tmp10_ = pgn_game_RESULT_IN_PROGRESS;
										pgn_game_set_result (_tmp9_, _tmp10_);
										_tmp11_ = game;
										_tmp12_ = _g_object_ref0 (_tmp11_);
										self->games = g_list_append (self->games, _tmp12_);
										_tmp13_ = pgn_game_new ();
										_g_object_unref0 (game);
										game = _tmp13_;
										state = STATE_TAGS;
									}
								} else {
									if (c == ((gunichar) '.')) {
										gsize _tmp14_;
										_tmp14_ = offset;
										offset = _tmp14_ - 1;
										state = STATE_PERIOD;
									} else {
										if (g_unichar_isalnum (c)) {
											token_start = offset;
											state = STATE_SYMBOL;
										} else {
											if (c == ((gunichar) '$')) {
												token_start = offset + 1;
												state = STATE_NAG;
											} else {
												if (c == ((gunichar) '(')) {
													gint _tmp15_;
													_tmp15_ = rav_level;
													rav_level = _tmp15_ + 1;
													continue;
												} else {
													if (c == ((gunichar) ')')) {
														if (rav_level == 0) {
															state = STATE_ERROR;
														} else {
															gint _tmp16_;
															_tmp16_ = rav_level;
															rav_level = _tmp16_ - 1;
														}
													} else {
														if (!g_unichar_isspace (c)) {
															state = STATE_ERROR;
														}
													}
												}
											}
										}
									}
								}
							}
						}
						break;
					}
					case STATE_LINE_COMMENT:
					{
						if (c == ((gunichar) '\n')) {
							state = home_state;
						}
						break;
					}
					case STATE_BRACE_COMMENT:
					{
						if (c == ((gunichar) '}')) {
							state = home_state;
						}
						break;
					}
					case STATE_TAG_START:
					{
						if (g_unichar_isspace (c)) {
							continue;
						} else {
							if (g_unichar_isalnum (c)) {
								token_start = offset;
								state = STATE_TAG_NAME;
							} else {
								state = STATE_ERROR;
							}
						}
						break;
					}
					case STATE_TAG_NAME:
					{
						if (g_unichar_isspace (c)) {
							gchar* _tmp17_;
							_tmp17_ = string_slice (data, (glong) token_start, (glong) offset);
							_g_free0 (tag_name);
							tag_name = _tmp17_;
							state = STATE_PRE_TAG_VALUE;
						} else {
							gboolean _tmp18_ = FALSE;
							gboolean _tmp19_ = FALSE;
							gboolean _tmp20_ = FALSE;
							gboolean _tmp21_ = FALSE;
							gboolean _tmp22_ = FALSE;
							gboolean _tmp23_ = FALSE;
							if (g_unichar_isalnum (c)) {
								_tmp23_ = TRUE;
							} else {
								_tmp23_ = c == ((gunichar) '_');
							}
							if (_tmp23_) {
								_tmp22_ = TRUE;
							} else {
								_tmp22_ = c == ((gunichar) '+');
							}
							if (_tmp22_) {
								_tmp21_ = TRUE;
							} else {
								_tmp21_ = c == ((gunichar) '#');
							}
							if (_tmp21_) {
								_tmp20_ = TRUE;
							} else {
								_tmp20_ = c == ((gunichar) '=');
							}
							if (_tmp20_) {
								_tmp19_ = TRUE;
							} else {
								_tmp19_ = c == ((gunichar) ':');
							}
							if (_tmp19_) {
								_tmp18_ = TRUE;
							} else {
								_tmp18_ = c == ((gunichar) '-');
							}
							if (_tmp18_) {
								continue;
							} else {
								state = STATE_ERROR;
							}
						}
						break;
					}
					case STATE_PRE_TAG_VALUE:
					{
						if (g_unichar_isspace (c)) {
							continue;
						} else {
							if (c == ((gunichar) '"')) {
								GString* _tmp24_;
								state = STATE_TAG_VALUE;
								_tmp24_ = tag_value;
								g_string_erase (_tmp24_, (gssize) 0, (gssize) -1);
								in_escape = FALSE;
							} else {
								state = STATE_ERROR;
							}
						}
						break;
					}
					case STATE_TAG_VALUE:
					{
						gboolean _tmp25_ = FALSE;
						if (c == ((gunichar) '\\')) {
							_tmp25_ = !in_escape;
						} else {
							_tmp25_ = FALSE;
						}
						if (_tmp25_) {
							in_escape = TRUE;
						} else {
							gboolean _tmp26_ = FALSE;
							if (c == ((gunichar) '"')) {
								_tmp26_ = !in_escape;
							} else {
								_tmp26_ = FALSE;
							}
							if (_tmp26_) {
								state = STATE_POST_TAG_VALUE;
							} else {
								if (g_unichar_isprint (c)) {
									GString* _tmp27_;
									_tmp27_ = tag_value;
									g_string_append_unichar (_tmp27_, c);
									in_escape = FALSE;
								} else {
									state = STATE_ERROR;
								}
							}
						}
						break;
					}
					case STATE_POST_TAG_VALUE:
					{
						if (g_unichar_isspace (c)) {
							continue;
						} else {
							if (c == ((gunichar) ']')) {
								PGNGame* _tmp28_;
								const gchar* _tmp29_;
								GString* _tmp30_;
								const gchar* _tmp31_;
								_tmp28_ = game;
								_tmp29_ = tag_name;
								_tmp30_ = tag_value;
								_tmp31_ = _tmp30_->str;
								pgn_insert_tag (self, _tmp28_, _tmp29_, _tmp31_);
								state = STATE_TAGS;
							} else {
								state = STATE_ERROR;
							}
						}
						break;
					}
					case STATE_SYMBOL:
					{
						gboolean _tmp32_ = FALSE;
						gboolean _tmp33_ = FALSE;
						gboolean _tmp34_ = FALSE;
						gboolean _tmp35_ = FALSE;
						gboolean _tmp36_ = FALSE;
						gboolean _tmp37_ = FALSE;
						gboolean _tmp38_ = FALSE;
						if (g_unichar_isalnum (c)) {
							_tmp38_ = TRUE;
						} else {
							_tmp38_ = c == ((gunichar) '_');
						}
						if (_tmp38_) {
							_tmp37_ = TRUE;
						} else {
							_tmp37_ = c == ((gunichar) '+');
						}
						if (_tmp37_) {
							_tmp36_ = TRUE;
						} else {
							_tmp36_ = c == ((gunichar) '#');
						}
						if (_tmp36_) {
							_tmp35_ = TRUE;
						} else {
							_tmp35_ = c == ((gunichar) '=');
						}
						if (_tmp35_) {
							_tmp34_ = TRUE;
						} else {
							_tmp34_ = c == ((gunichar) ':');
						}
						if (_tmp34_) {
							_tmp33_ = TRUE;
						} else {
							_tmp33_ = c == ((gunichar) '-');
						}
						if (_tmp33_) {
							_tmp32_ = TRUE;
						} else {
							_tmp32_ = c == ((gunichar) '/');
						}
						if (_tmp32_) {
							continue;
						} else {
							gchar* symbol = NULL;
							gchar* _tmp39_;
							gboolean is_number = FALSE;
							gsize _tmp46_;
							gboolean _tmp47_ = FALSE;
							gboolean _tmp48_ = FALSE;
							const gchar* _tmp49_;
							const gchar* _tmp50_;
							_tmp39_ = string_slice (data, (glong) token_start, (glong) offset);
							symbol = _tmp39_;
							is_number = TRUE;
							{
								gint i = 0;
								i = 0;
								{
									gboolean _tmp40_ = FALSE;
									_tmp40_ = TRUE;
									while (TRUE) {
										const gchar* _tmp42_;
										gint _tmp43_;
										gint _tmp44_;
										const gchar* _tmp45_;
										if (!_tmp40_) {
											gint _tmp41_;
											_tmp41_ = i;
											i = _tmp41_ + 1;
										}
										_tmp40_ = FALSE;
										_tmp42_ = symbol;
										_tmp43_ = strlen (_tmp42_);
										_tmp44_ = _tmp43_;
										if (!(i < _tmp44_)) {
											break;
										}
										_tmp45_ = symbol;
										if (!g_ascii_isdigit (string_get (_tmp45_, (glong) i))) {
											is_number = FALSE;
										}
									}
								}
							}
							state = STATE_MOVE_TEXT;
							_tmp46_ = offset;
							offset = _tmp46_ - 1;
							_tmp49_ = symbol;
							_tmp50_ = pgn_game_RESULT_DRAW;
							if (g_strcmp0 (_tmp49_, _tmp50_) == 0) {
								_tmp48_ = TRUE;
							} else {
								const gchar* _tmp51_;
								const gchar* _tmp52_;
								_tmp51_ = symbol;
								_tmp52_ = pgn_game_RESULT_WHITE;
								_tmp48_ = g_strcmp0 (_tmp51_, _tmp52_) == 0;
							}
							if (_tmp48_) {
								_tmp47_ = TRUE;
							} else {
								const gchar* _tmp53_;
								const gchar* _tmp54_;
								_tmp53_ = symbol;
								_tmp54_ = pgn_game_RESULT_BLACK;
								_tmp47_ = g_strcmp0 (_tmp53_, _tmp54_) == 0;
							}
							if (_tmp47_) {
								if (rav_level == 0) {
									PGNGame* _tmp55_;
									const gchar* _tmp56_;
									PGNGame* _tmp57_;
									PGNGame* _tmp58_;
									PGNGame* _tmp59_;
									_tmp55_ = game;
									_tmp56_ = symbol;
									pgn_game_set_result (_tmp55_, _tmp56_);
									_tmp57_ = game;
									_tmp58_ = _g_object_ref0 (_tmp57_);
									self->games = g_list_append (self->games, _tmp58_);
									_tmp59_ = pgn_game_new ();
									_g_object_unref0 (game);
									game = _tmp59_;
									state = STATE_TAGS;
								}
							} else {
								if (!is_number) {
									if (rav_level == 0) {
										PGNGame* _tmp60_;
										const gchar* _tmp61_;
										gchar* _tmp62_;
										_tmp60_ = game;
										_tmp61_ = symbol;
										_tmp62_ = g_strdup (_tmp61_);
										_tmp60_->moves = g_list_append (_tmp60_->moves, _tmp62_);
									}
								}
							}
							_g_free0 (symbol);
						}
						break;
					}
					case STATE_PERIOD:
					{
						state = STATE_MOVE_TEXT;
						break;
					}
					case STATE_NAG:
					{
						if (g_unichar_isdigit (c)) {
							continue;
						} else {
							gsize _tmp63_;
							state = STATE_MOVE_TEXT;
							_tmp63_ = offset;
							offset = _tmp63_ - 1;
						}
						break;
					}
					case STATE_ERROR:
					{
						gsize char_offset = 0UL;
						FILE* _tmp64_;
						FILE* _tmp65_;
						gchar* _tmp66_;
						gchar* _tmp67_;
						FILE* _tmp71_;
						char_offset = (offset - line_offset) - 1;
						_tmp64_ = stderr;
						fprintf (_tmp64_, "%d.%d: error: Unexpected character\n", line, (gint) (char_offset + 1));
						_tmp65_ = stderr;
						_tmp66_ = string_slice (data, (glong) line_offset, (glong) offset);
						_tmp67_ = _tmp66_;
						fprintf (_tmp65_, "%s\n", _tmp67_);
						_g_free0 (_tmp67_);
						{
							gint i = 0;
							i = 0;
							{
								gboolean _tmp68_ = FALSE;
								_tmp68_ = TRUE;
								while (TRUE) {
									FILE* _tmp70_;
									if (!_tmp68_) {
										gint _tmp69_;
										_tmp69_ = i;
										i = _tmp69_ + 1;
									}
									_tmp68_ = FALSE;
									if (!(((gsize) i) < char_offset)) {
										break;
									}
									_tmp70_ = stderr;
									fprintf (_tmp70_, " ");
								}
							}
						}
						_tmp71_ = stderr;
						fprintf (_tmp71_, "^\n");
						_g_string_free0 (tag_value);
						_g_free0 (tag_name);
						_g_object_unref0 (game);
						return self;
					}
					default:
					break;
				}
			}
		}
	}
	_tmp73_ = game;
	_tmp74_ = _tmp73_->moves;
	if (g_list_length (_tmp74_) > ((guint) 0)) {
		_tmp72_ = TRUE;
	} else {
		PGNGame* _tmp75_;
		GHashTable* _tmp76_;
		_tmp75_ = game;
		_tmp76_ = _tmp75_->tags;
		_tmp72_ = g_hash_table_size (_tmp76_) > ((guint) 0);
	}
	if (_tmp72_) {
		PGNGame* _tmp77_;
		PGNGame* _tmp78_;
		_tmp77_ = game;
		_tmp78_ = _g_object_ref0 (_tmp77_);
		self->games = g_list_append (self->games, _tmp78_);
	}
	_tmp79_ = self->games;
	if (_tmp79_ == NULL) {
		GError* _tmp80_;
		_tmp80_ = g_error_new_literal (PGN_ERROR, PGN_ERROR_LOAD_ERROR, "No games in PGN file");
		_inner_error0_ = _tmp80_;
		if (_inner_error0_->domain == PGN_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_string_free0 (tag_value);
			_g_free0 (tag_name);
			_g_object_unref0 (game);
			_g_object_unref0 (self);
			return NULL;
		} else {
			_g_string_free0 (tag_value);
			_g_free0 (tag_name);
			_g_object_unref0 (game);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_g_string_free0 (tag_value);
	_g_free0 (tag_name);
	_g_object_unref0 (game);
	return self;
}

PGN*
pgn_new_from_string (const gchar* data,
                     GError** error)
{
	return pgn_construct_from_string (TYPE_PGN, data, error);
}

PGN*
pgn_construct_from_file (GType object_type,
                         GFile* file,
                         GError** error)
{
	PGN * self = NULL;
	guint8* contents = NULL;
	gint contents_length1 = 0;
	gint _contents_size_ = 0;
	guint8* _tmp0_ = NULL;
	gsize _tmp1_ = 0;
	guint8* _tmp2_;
	gint _tmp2__length1;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (file != NULL, NULL);
	g_file_load_contents (file, NULL, &_tmp0_, &_tmp1_, NULL, &_inner_error0_);
	contents = (g_free (contents), NULL);
	contents = _tmp0_;
	contents_length1 = _tmp1_;
	_contents_size_ = contents_length1;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		contents = (g_free (contents), NULL);
		_g_object_unref0 (self);
		return NULL;
	}
	_tmp2_ = contents;
	_tmp2__length1 = contents_length1;
	self = (PGN*) pgn_construct_from_string (object_type, (const gchar*) _tmp2_, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		contents = (g_free (contents), NULL);
		_g_object_unref0 (self);
		return NULL;
	}
	contents = (g_free (contents), NULL);
	return self;
}

PGN*
pgn_new_from_file (GFile* file,
                   GError** error)
{
	return pgn_construct_from_file (TYPE_PGN, file, error);
}

PGN*
pgn_construct (GType object_type)
{
	PGN * self = NULL;
	self = (PGN*) g_object_new (object_type, NULL);
	return self;
}

PGN*
pgn_new (void)
{
	return pgn_construct (TYPE_PGN);
}

static void
pgn_class_init (PGNClass * klass,
                gpointer klass_data)
{
	pgn_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = pgn_finalize;
}

static void
pgn_instance_init (PGN * self,
                   gpointer klass)
{
}

static void
pgn_finalize (GObject * obj)
{
	PGN * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PGN, PGN);
	(self->games == NULL) ? NULL : (self->games = (_g_list_free__g_object_unref0_ (self->games), NULL));
	G_OBJECT_CLASS (pgn_parent_class)->finalize (obj);
}

static GType
pgn_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PGNClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) pgn_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PGN), 0, (GInstanceInitFunc) pgn_instance_init, NULL };
	GType pgn_type_id;
	pgn_type_id = g_type_register_static (G_TYPE_OBJECT, "PGN", &g_define_type_info, 0);
	return pgn_type_id;
}

GType
pgn_get_type (void)
{
	static volatile gsize pgn_type_id__once = 0;
	if (g_once_init_enter (&pgn_type_id__once)) {
		GType pgn_type_id;
		pgn_type_id = pgn_get_type_once ();
		g_once_init_leave (&pgn_type_id__once, pgn_type_id);
	}
	return pgn_type_id__once;
}

