
#ifndef KRUNNER_EXPORT_H
#define KRUNNER_EXPORT_H

#ifdef KRUNNER_STATIC_DEFINE
#  define KRUNNER_EXPORT
#  define KRUNNER_NO_EXPORT
#else
#  ifndef KRUNNER_EXPORT
#    ifdef KF5Runner_EXPORTS
        /* We are building this library */
#      define KRUNNER_EXPORT __attribute__((visibility("default")))
#    else
        /* We are using this library */
#      define KRUNNER_EXPORT __attribute__((visibility("default")))
#    endif
#  endif

#  ifndef KRUNNER_NO_EXPORT
#    define KRUNNER_NO_EXPORT __attribute__((visibility("hidden")))
#  endif
#endif

#ifndef KRUNNER_DECL_DEPRECATED
#  define KRUNNER_DECL_DEPRECATED __attribute__ ((__deprecated__))
#endif

#ifndef KRUNNER_DECL_DEPRECATED_EXPORT
#  define KRUNNER_DECL_DEPRECATED_EXPORT KRUNNER_EXPORT KRUNNER_DECL_DEPRECATED
#endif

#ifndef KRUNNER_DECL_DEPRECATED_NO_EXPORT
#  define KRUNNER_DECL_DEPRECATED_NO_EXPORT KRUNNER_NO_EXPORT KRUNNER_DECL_DEPRECATED
#endif

#if 0 /* DEFINE_NO_DEPRECATED */
#  ifndef KRUNNER_NO_DEPRECATED
#    define KRUNNER_NO_DEPRECATED
#  endif
#endif

#define KRUNNER_DECL_DEPRECATED_TEXT(text) __attribute__ ((__deprecated__(text)))

#define ECM_GENERATEEXPORTHEADER_VERSION_VALUE(major, minor, patch) ((major<<16)|(minor<<8)|(patch))

/* Take any defaults from group settings */
#if !defined(KRUNNER_NO_DEPRECATED) && !defined(KRUNNER_DISABLE_DEPRECATED_BEFORE_AND_AT)
#  ifdef KF_NO_DEPRECATED
#    define KRUNNER_NO_DEPRECATED
#  elif defined(KF_DISABLE_DEPRECATED_BEFORE_AND_AT)
#    define KRUNNER_DISABLE_DEPRECATED_BEFORE_AND_AT KF_DISABLE_DEPRECATED_BEFORE_AND_AT
#  endif
#endif
#if !defined(KRUNNER_DISABLE_DEPRECATED_BEFORE_AND_AT) && defined(KF_DISABLE_DEPRECATED_BEFORE_AND_AT)
#  define KRUNNER_DISABLE_DEPRECATED_BEFORE_AND_AT KF_DISABLE_DEPRECATED_BEFORE_AND_AT
#endif

#if !defined(KRUNNER_NO_DEPRECATED_WARNINGS) && !defined(KRUNNER_DEPRECATED_WARNINGS_SINCE)
#  ifdef KF_NO_DEPRECATED_WARNINGS
#    define KRUNNER_NO_DEPRECATED_WARNINGS
#  elif defined(KF_DEPRECATED_WARNINGS_SINCE)
#    define KRUNNER_DEPRECATED_WARNINGS_SINCE KF_DEPRECATED_WARNINGS_SINCE
#  endif
#endif
#if !defined(KRUNNER_DEPRECATED_WARNINGS_SINCE) && defined(KF_DEPRECATED_WARNINGS_SINCE)
#  define KRUNNER_DEPRECATED_WARNINGS_SINCE KF_DEPRECATED_WARNINGS_SINCE
#endif

#if defined(KRUNNER_NO_DEPRECATED)
#  undef KRUNNER_DEPRECATED
#  define KRUNNER_DEPRECATED_EXPORT KRUNNER_EXPORT
#  define KRUNNER_DEPRECATED_NO_EXPORT KRUNNER_NO_EXPORT
#elif defined(KRUNNER_NO_DEPRECATED_WARNINGS)
#  define KRUNNER_DEPRECATED
#  define KRUNNER_DEPRECATED_EXPORT KRUNNER_EXPORT
#  define KRUNNER_DEPRECATED_NO_EXPORT KRUNNER_NO_EXPORT
#else
#  define KRUNNER_DEPRECATED KRUNNER_DECL_DEPRECATED
#  define KRUNNER_DEPRECATED_EXPORT KRUNNER_DECL_DEPRECATED_EXPORT
#  define KRUNNER_DEPRECATED_NO_EXPORT KRUNNER_DECL_DEPRECATED_NO_EXPORT
#endif

/* No deprecated API had been removed from build */
#define KRUNNER_EXCLUDE_DEPRECATED_BEFORE_AND_AT 0

#define KRUNNER_BUILD_DEPRECATED_SINCE(major, minor) 1

#ifdef KRUNNER_NO_DEPRECATED
#  define KRUNNER_DISABLE_DEPRECATED_BEFORE_AND_AT 0x56500
#endif
#ifdef KRUNNER_NO_DEPRECATED_WARNINGS
#  define KRUNNER_DEPRECATED_WARNINGS_SINCE 0
#endif

#ifndef KRUNNER_DEPRECATED_WARNINGS_SINCE
#  ifdef KRUNNER_DISABLE_DEPRECATED_BEFORE_AND_AT
#    define KRUNNER_DEPRECATED_WARNINGS_SINCE KRUNNER_DISABLE_DEPRECATED_BEFORE_AND_AT
#  else
#    define KRUNNER_DEPRECATED_WARNINGS_SINCE 0x56500
#  endif
#endif

#ifndef KRUNNER_DISABLE_DEPRECATED_BEFORE_AND_AT
#  define KRUNNER_DISABLE_DEPRECATED_BEFORE_AND_AT 0
#endif

#ifdef KRUNNER_DEPRECATED
#  define KRUNNER_ENABLE_DEPRECATED_SINCE(major, minor) (ECM_GENERATEEXPORTHEADER_VERSION_VALUE(major, minor, 0) > KRUNNER_DISABLE_DEPRECATED_BEFORE_AND_AT)
#else
#  define KRUNNER_ENABLE_DEPRECATED_SINCE(major, minor) 0
#endif

#if KRUNNER_DEPRECATED_WARNINGS_SINCE >= 0x51c00
#  define KRUNNER_DEPRECATED_VERSION_5_28(text) KRUNNER_DECL_DEPRECATED_TEXT(text)
#else
#  define KRUNNER_DEPRECATED_VERSION_5_28(text)
#endif

#if KRUNNER_DEPRECATED_WARNINGS_SINCE >= 0x54700
#  define KRUNNER_DEPRECATED_VERSION_5_71(text) KRUNNER_DECL_DEPRECATED_TEXT(text)
#else
#  define KRUNNER_DEPRECATED_VERSION_5_71(text)
#endif

#if KRUNNER_DEPRECATED_WARNINGS_SINCE >= 0x54800
#  define KRUNNER_DEPRECATED_VERSION_5_72(text) KRUNNER_DECL_DEPRECATED_TEXT(text)
#else
#  define KRUNNER_DEPRECATED_VERSION_5_72(text)
#endif

#if KRUNNER_DEPRECATED_WARNINGS_SINCE >= 0x54900
#  define KRUNNER_DEPRECATED_VERSION_5_73(text) KRUNNER_DECL_DEPRECATED_TEXT(text)
#else
#  define KRUNNER_DEPRECATED_VERSION_5_73(text)
#endif

#if KRUNNER_DEPRECATED_WARNINGS_SINCE >= 0x54c00
#  define KRUNNER_DEPRECATED_VERSION_5_76(text) KRUNNER_DECL_DEPRECATED_TEXT(text)
#else
#  define KRUNNER_DEPRECATED_VERSION_5_76(text)
#endif

#if KRUNNER_DEPRECATED_WARNINGS_SINCE >= 0x54d00
#  define KRUNNER_DEPRECATED_VERSION_5_77(text) KRUNNER_DECL_DEPRECATED_TEXT(text)
#else
#  define KRUNNER_DEPRECATED_VERSION_5_77(text)
#endif

#if KRUNNER_DEPRECATED_WARNINGS_SINCE >= 0x54f00
#  define KRUNNER_DEPRECATED_VERSION_5_79(text) KRUNNER_DECL_DEPRECATED_TEXT(text)
#else
#  define KRUNNER_DEPRECATED_VERSION_5_79(text)
#endif

#if KRUNNER_DEPRECATED_WARNINGS_SINCE >= 0x55100
#  define KRUNNER_DEPRECATED_VERSION_5_81(text) KRUNNER_DECL_DEPRECATED_TEXT(text)
#else
#  define KRUNNER_DEPRECATED_VERSION_5_81(text)
#endif

#if KRUNNER_DEPRECATED_WARNINGS_SINCE >= 0x55200
#  define KRUNNER_DEPRECATED_VERSION_5_82(text) KRUNNER_DECL_DEPRECATED_TEXT(text)
#else
#  define KRUNNER_DEPRECATED_VERSION_5_82(text)
#endif

#if KRUNNER_DEPRECATED_WARNINGS_SINCE >= 0x55500
#  define KRUNNER_DEPRECATED_VERSION_5_85(text) KRUNNER_DECL_DEPRECATED_TEXT(text)
#else
#  define KRUNNER_DEPRECATED_VERSION_5_85(text)
#endif

#if KRUNNER_DEPRECATED_WARNINGS_SINCE >= 0x55600
#  define KRUNNER_DEPRECATED_VERSION_5_86(text) KRUNNER_DECL_DEPRECATED_TEXT(text)
#else
#  define KRUNNER_DEPRECATED_VERSION_5_86(text)
#endif

#if KRUNNER_DEPRECATED_WARNINGS_SINCE >= 0x55800
#  define KRUNNER_DEPRECATED_VERSION_5_88(text) KRUNNER_DECL_DEPRECATED_TEXT(text)
#else
#  define KRUNNER_DEPRECATED_VERSION_5_88(text)
#endif

#if KRUNNER_DEPRECATED_WARNINGS_SINCE >= 0x56300
#  define KRUNNER_DEPRECATED_VERSION_5_99(text) KRUNNER_DECL_DEPRECATED_TEXT(text)
#else
#  define KRUNNER_DEPRECATED_VERSION_5_99(text)
#endif
#define KRUNNER_DEPRECATED_VERSION_5(minor, text)      KRUNNER_DEPRECATED_VERSION_5_##minor(text)
#define KRUNNER_DEPRECATED_VERSION(major, minor, text) KRUNNER_DEPRECATED_VERSION_##major(minor, "Since "#major"."#minor". " text)
#define KRUNNER_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text) KRUNNER_DEPRECATED_VERSION_##major(minor, "Since "#textmajor"."#textminor". " text)
#if defined(__cpp_enumerator_attributes) && __cpp_enumerator_attributes >= 201411
#  define KRUNNER_ENUMERATOR_DEPRECATED_VERSION(major, minor, text) KRUNNER_DEPRECATED_VERSION(major, minor, text)
#  define KRUNNER_ENUMERATOR_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text) KRUNNER_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text)
#else
#  define KRUNNER_ENUMERATOR_DEPRECATED_VERSION(major, minor, text)
#  define KRUNNER_ENUMERATOR_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text)
#endif

#endif /* KRUNNER_EXPORT_H */


#ifndef ECM_GENERATEEXPORTHEADER_KRUNNER_EXPORT_H
#define ECM_GENERATEEXPORTHEADER_KRUNNER_EXPORT_H


#define KRUNNER_DECL_DEPRECATED_TEXT(text) __attribute__ ((__deprecated__(text)))

#define ECM_GENERATEEXPORTHEADER_VERSION_VALUE(major, minor, patch) ((major<<16)|(minor<<8)|(patch))

/* Take any defaults from group settings */
#if !defined(KRUNNER_NO_DEPRECATED) && !defined(KRUNNER_DISABLE_DEPRECATED_BEFORE_AND_AT)
#  ifdef KF_NO_DEPRECATED
#    define KRUNNER_NO_DEPRECATED
#  elif defined(KF_DISABLE_DEPRECATED_BEFORE_AND_AT)
#    define KRUNNER_DISABLE_DEPRECATED_BEFORE_AND_AT KF_DISABLE_DEPRECATED_BEFORE_AND_AT
#  endif
#endif
#if !defined(KRUNNER_DISABLE_DEPRECATED_BEFORE_AND_AT) && defined(KF_DISABLE_DEPRECATED_BEFORE_AND_AT)
#  define KRUNNER_DISABLE_DEPRECATED_BEFORE_AND_AT KF_DISABLE_DEPRECATED_BEFORE_AND_AT
#endif

#if !defined(KRUNNER_NO_DEPRECATED_WARNINGS) && !defined(KRUNNER_DEPRECATED_WARNINGS_SINCE)
#  ifdef KF_NO_DEPRECATED_WARNINGS
#    define KRUNNER_NO_DEPRECATED_WARNINGS
#  elif defined(KF_DEPRECATED_WARNINGS_SINCE)
#    define KRUNNER_DEPRECATED_WARNINGS_SINCE KF_DEPRECATED_WARNINGS_SINCE
#  endif
#endif
#if !defined(KRUNNER_DEPRECATED_WARNINGS_SINCE) && defined(KF_DEPRECATED_WARNINGS_SINCE)
#  define KRUNNER_DEPRECATED_WARNINGS_SINCE KF_DEPRECATED_WARNINGS_SINCE
#endif

#if defined(KRUNNER_NO_DEPRECATED)
#  undef KRUNNER_DEPRECATED
#  define KRUNNER_DEPRECATED_EXPORT KRUNNER_EXPORT
#  define KRUNNER_DEPRECATED_NO_EXPORT KRUNNER_NO_EXPORT
#elif defined(KRUNNER_NO_DEPRECATED_WARNINGS)
#  define KRUNNER_DEPRECATED
#  define KRUNNER_DEPRECATED_EXPORT KRUNNER_EXPORT
#  define KRUNNER_DEPRECATED_NO_EXPORT KRUNNER_NO_EXPORT
#else
#  define KRUNNER_DEPRECATED KRUNNER_DECL_DEPRECATED
#  define KRUNNER_DEPRECATED_EXPORT KRUNNER_DECL_DEPRECATED_EXPORT
#  define KRUNNER_DEPRECATED_NO_EXPORT KRUNNER_DECL_DEPRECATED_NO_EXPORT
#endif

/* No deprecated API had been removed from build */
#define KRUNNER_EXCLUDE_DEPRECATED_BEFORE_AND_AT 0

#define KRUNNER_BUILD_DEPRECATED_SINCE(major, minor) 1

#ifdef KRUNNER_NO_DEPRECATED
#  define KRUNNER_DISABLE_DEPRECATED_BEFORE_AND_AT 0x56500
#endif
#ifdef KRUNNER_NO_DEPRECATED_WARNINGS
#  define KRUNNER_DEPRECATED_WARNINGS_SINCE 0
#endif

#ifndef KRUNNER_DEPRECATED_WARNINGS_SINCE
#  ifdef KRUNNER_DISABLE_DEPRECATED_BEFORE_AND_AT
#    define KRUNNER_DEPRECATED_WARNINGS_SINCE KRUNNER_DISABLE_DEPRECATED_BEFORE_AND_AT
#  else
#    define KRUNNER_DEPRECATED_WARNINGS_SINCE 0x56500
#  endif
#endif

#ifndef KRUNNER_DISABLE_DEPRECATED_BEFORE_AND_AT
#  define KRUNNER_DISABLE_DEPRECATED_BEFORE_AND_AT 0
#endif

#ifdef KRUNNER_DEPRECATED
#  define KRUNNER_ENABLE_DEPRECATED_SINCE(major, minor) (ECM_GENERATEEXPORTHEADER_VERSION_VALUE(major, minor, 0) > KRUNNER_DISABLE_DEPRECATED_BEFORE_AND_AT)
#else
#  define KRUNNER_ENABLE_DEPRECATED_SINCE(major, minor) 0
#endif

#if KRUNNER_DEPRECATED_WARNINGS_SINCE >= 0x51c00
#  define KRUNNER_DEPRECATED_VERSION_5_28(text) KRUNNER_DECL_DEPRECATED_TEXT(text)
#else
#  define KRUNNER_DEPRECATED_VERSION_5_28(text)
#endif

#if KRUNNER_DEPRECATED_WARNINGS_SINCE >= 0x54700
#  define KRUNNER_DEPRECATED_VERSION_5_71(text) KRUNNER_DECL_DEPRECATED_TEXT(text)
#else
#  define KRUNNER_DEPRECATED_VERSION_5_71(text)
#endif

#if KRUNNER_DEPRECATED_WARNINGS_SINCE >= 0x54800
#  define KRUNNER_DEPRECATED_VERSION_5_72(text) KRUNNER_DECL_DEPRECATED_TEXT(text)
#else
#  define KRUNNER_DEPRECATED_VERSION_5_72(text)
#endif

#if KRUNNER_DEPRECATED_WARNINGS_SINCE >= 0x54900
#  define KRUNNER_DEPRECATED_VERSION_5_73(text) KRUNNER_DECL_DEPRECATED_TEXT(text)
#else
#  define KRUNNER_DEPRECATED_VERSION_5_73(text)
#endif

#if KRUNNER_DEPRECATED_WARNINGS_SINCE >= 0x54c00
#  define KRUNNER_DEPRECATED_VERSION_5_76(text) KRUNNER_DECL_DEPRECATED_TEXT(text)
#else
#  define KRUNNER_DEPRECATED_VERSION_5_76(text)
#endif

#if KRUNNER_DEPRECATED_WARNINGS_SINCE >= 0x54d00
#  define KRUNNER_DEPRECATED_VERSION_5_77(text) KRUNNER_DECL_DEPRECATED_TEXT(text)
#else
#  define KRUNNER_DEPRECATED_VERSION_5_77(text)
#endif

#if KRUNNER_DEPRECATED_WARNINGS_SINCE >= 0x54f00
#  define KRUNNER_DEPRECATED_VERSION_5_79(text) KRUNNER_DECL_DEPRECATED_TEXT(text)
#else
#  define KRUNNER_DEPRECATED_VERSION_5_79(text)
#endif

#if KRUNNER_DEPRECATED_WARNINGS_SINCE >= 0x55100
#  define KRUNNER_DEPRECATED_VERSION_5_81(text) KRUNNER_DECL_DEPRECATED_TEXT(text)
#else
#  define KRUNNER_DEPRECATED_VERSION_5_81(text)
#endif

#if KRUNNER_DEPRECATED_WARNINGS_SINCE >= 0x55200
#  define KRUNNER_DEPRECATED_VERSION_5_82(text) KRUNNER_DECL_DEPRECATED_TEXT(text)
#else
#  define KRUNNER_DEPRECATED_VERSION_5_82(text)
#endif

#if KRUNNER_DEPRECATED_WARNINGS_SINCE >= 0x55500
#  define KRUNNER_DEPRECATED_VERSION_5_85(text) KRUNNER_DECL_DEPRECATED_TEXT(text)
#else
#  define KRUNNER_DEPRECATED_VERSION_5_85(text)
#endif

#if KRUNNER_DEPRECATED_WARNINGS_SINCE >= 0x55600
#  define KRUNNER_DEPRECATED_VERSION_5_86(text) KRUNNER_DECL_DEPRECATED_TEXT(text)
#else
#  define KRUNNER_DEPRECATED_VERSION_5_86(text)
#endif

#if KRUNNER_DEPRECATED_WARNINGS_SINCE >= 0x55800
#  define KRUNNER_DEPRECATED_VERSION_5_88(text) KRUNNER_DECL_DEPRECATED_TEXT(text)
#else
#  define KRUNNER_DEPRECATED_VERSION_5_88(text)
#endif

#if KRUNNER_DEPRECATED_WARNINGS_SINCE >= 0x56300
#  define KRUNNER_DEPRECATED_VERSION_5_99(text) KRUNNER_DECL_DEPRECATED_TEXT(text)
#else
#  define KRUNNER_DEPRECATED_VERSION_5_99(text)
#endif
#define KRUNNER_DEPRECATED_VERSION_5(minor, text)      KRUNNER_DEPRECATED_VERSION_5_##minor(text)
#define KRUNNER_DEPRECATED_VERSION(major, minor, text) KRUNNER_DEPRECATED_VERSION_##major(minor, "Since "#major"."#minor". " text)
#define KRUNNER_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text) KRUNNER_DEPRECATED_VERSION_##major(minor, "Since "#textmajor"."#textminor". " text)
#if defined(__cpp_enumerator_attributes) && __cpp_enumerator_attributes >= 201411
#  define KRUNNER_ENUMERATOR_DEPRECATED_VERSION(major, minor, text) KRUNNER_DEPRECATED_VERSION(major, minor, text)
#  define KRUNNER_ENUMERATOR_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text) KRUNNER_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text)
#else
#  define KRUNNER_ENUMERATOR_DEPRECATED_VERSION(major, minor, text)
#  define KRUNNER_ENUMERATOR_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text)
#endif


#endif /* ECM_GENERATEEXPORTHEADER_KRUNNER_EXPORT_H */
