/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.ajp;

import java.nio.ByteBuffer;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.buf.ByteChunk;
import org.apache.tomcat.util.buf.HexUtils;
import org.apache.tomcat.util.buf.MessageBytes;
import org.apache.tomcat.util.res.StringManager;

public class AjpMessage {
    private static final Log log = LogFactory.getLog(AjpMessage.class);
    protected static final StringManager sm = StringManager.getManager(AjpMessage.class);
    protected final byte[] buf;
    protected int pos;
    protected int len;

    public AjpMessage(int n) {
        this.buf = new byte[n];
    }

    public void reset() {
        this.len = 4;
        this.pos = 4;
    }

    public void end() {
        this.len = this.pos;
        int n = this.len - 4;
        this.buf[0] = 65;
        this.buf[1] = 66;
        this.buf[2] = (byte)(n >>> 8 & 0xFF);
        this.buf[3] = (byte)(n & 0xFF);
    }

    public byte[] getBuffer() {
        return this.buf;
    }

    public int getLen() {
        return this.len;
    }

    public void appendInt(int n) {
        this.buf[this.pos++] = (byte)(n >>> 8 & 0xFF);
        this.buf[this.pos++] = (byte)(n & 0xFF);
    }

    public void appendByte(int n) {
        this.buf[this.pos++] = (byte)n;
    }

    public void appendBytes(MessageBytes messageBytes) {
        if (messageBytes == null) {
            log.error((Object)sm.getString("ajpmessage.null"), (Throwable)new NullPointerException());
            this.appendInt(0);
            this.appendByte(0);
            return;
        }
        if (messageBytes.getType() != 2) {
            messageBytes.toBytes();
            ByteChunk byteChunk = messageBytes.getByteChunk();
            byte[] byArray = byteChunk.getBuffer();
            for (int i = byteChunk.getOffset(); i < byteChunk.getLength(); ++i) {
                if ((byArray[i] <= -1 || byArray[i] > 31 || byArray[i] == 9) && byArray[i] != 127) continue;
                byArray[i] = 32;
            }
        }
        this.appendByteChunk(messageBytes.getByteChunk());
    }

    public void appendByteChunk(ByteChunk byteChunk) {
        if (byteChunk == null) {
            log.error((Object)sm.getString("ajpmessage.null"), (Throwable)new NullPointerException());
            this.appendInt(0);
            this.appendByte(0);
            return;
        }
        this.appendBytes(byteChunk.getBytes(), byteChunk.getStart(), byteChunk.getLength());
    }

    public void appendBytes(byte[] byArray, int n, int n2) {
        if (this.checkOverflow(n2)) {
            return;
        }
        this.appendInt(n2);
        System.arraycopy(byArray, n, this.buf, this.pos, n2);
        this.pos += n2;
        this.appendByte(0);
    }

    public void appendBytes(ByteBuffer byteBuffer) {
        int n = byteBuffer.remaining();
        if (this.checkOverflow(n)) {
            return;
        }
        this.appendInt(n);
        byteBuffer.get(this.buf, this.pos, n);
        this.pos += n;
        this.appendByte(0);
    }

    private boolean checkOverflow(int n) {
        if (this.pos + n + 3 > this.buf.length) {
            log.error((Object)sm.getString("ajpmessage.overflow", new Object[]{"" + n, "" + this.pos}), (Throwable)new ArrayIndexOutOfBoundsException());
            if (log.isDebugEnabled()) {
                this.dump("Overflow/coBytes");
            }
            return true;
        }
        return false;
    }

    public int getInt() {
        int n = this.buf[this.pos++] & 0xFF;
        int n2 = this.buf[this.pos++] & 0xFF;
        this.validatePos(this.pos);
        return (n << 8) + n2;
    }

    public int peekInt() {
        this.validatePos(this.pos + 2);
        int n = this.buf[this.pos] & 0xFF;
        int n2 = this.buf[this.pos + 1] & 0xFF;
        return (n << 8) + n2;
    }

    public byte getByte() {
        byte by = this.buf[this.pos++];
        this.validatePos(this.pos);
        return by;
    }

    public void getBytes(MessageBytes messageBytes) {
        this.doGetBytes(messageBytes, true);
    }

    public void getBodyBytes(MessageBytes messageBytes) {
        this.doGetBytes(messageBytes, false);
    }

    private void doGetBytes(MessageBytes messageBytes, boolean bl) {
        int n = this.getInt();
        if (n == 65535 || n == -1) {
            messageBytes.recycle();
            return;
        }
        if (bl) {
            this.validatePos(this.pos + n + 1);
        } else {
            this.validatePos(this.pos + n);
        }
        messageBytes.setBytes(this.buf, this.pos, n);
        messageBytes.getCharChunk().recycle();
        this.pos += n;
        if (bl) {
            ++this.pos;
        }
    }

    public int getLongInt() {
        int n = this.buf[this.pos++] & 0xFF;
        n <<= 8;
        n |= this.buf[this.pos++] & 0xFF;
        n <<= 8;
        n |= this.buf[this.pos++] & 0xFF;
        n <<= 8;
        this.validatePos(this.pos);
        return n |= this.buf[this.pos++] & 0xFF;
    }

    public int processHeader(boolean bl) {
        this.pos = 0;
        int n = this.getInt();
        this.len = this.getInt();
        if (bl && n != 4660 || !bl && n != 16706) {
            log.error((Object)sm.getString("ajpmessage.invalid", new Object[]{"" + n}));
            if (log.isDebugEnabled()) {
                this.dump("In");
            }
            return -1;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Received " + this.len + " " + this.buf[0]));
        }
        return this.len;
    }

    private void dump(String string) {
        if (log.isDebugEnabled()) {
            log.debug((Object)(string + ": " + HexUtils.toHexString((byte[])this.buf) + " " + this.pos + "/" + (this.len + 4)));
        }
        int n = this.pos;
        if (this.len + 4 > this.pos) {
            n = this.len + 4;
        }
        if (n > 1000) {
            n = 1000;
        }
        if (log.isDebugEnabled()) {
            for (int i = 0; i < n; i += 16) {
                log.debug((Object)AjpMessage.hexLine(this.buf, i, this.len));
            }
        }
    }

    private void validatePos(int n) {
        if (n > this.len + 4) {
            throw new ArrayIndexOutOfBoundsException(sm.getString("ajpMessage.invalidPos", new Object[]{n}));
        }
    }

    protected static String hexLine(byte[] byArray, int n, int n2) {
        int n3;
        StringBuilder stringBuilder = new StringBuilder();
        for (n3 = n; n3 < n + 16; ++n3) {
            if (n3 < n2 + 4) {
                stringBuilder.append(AjpMessage.hex(byArray[n3]) + " ");
                continue;
            }
            stringBuilder.append("   ");
        }
        stringBuilder.append(" | ");
        for (n3 = n; n3 < n + 16 && n3 < n2 + 4; ++n3) {
            if (!Character.isISOControl((char)byArray[n3])) {
                stringBuilder.append(Character.valueOf((char)byArray[n3]));
                continue;
            }
            stringBuilder.append('.');
        }
        return stringBuilder.toString();
    }

    protected static String hex(int n) {
        String string = Integer.toHexString(n);
        if (string.length() == 1) {
            string = "0" + string;
        }
        return string.substring(string.length() - 2);
    }
}

