/* KeyboardManager.c generated by valac 0.56.3, the Vala compiler
 * generated from KeyboardManager.vala, do not modify */

/**/
/*  Copyright (C) 2016 Santiago León*/
/**/
/*  This program is free software: you can redistribute it and/or modify*/
/*  it under the terms of the GNU General Public License as published by*/
/*  the Free Software Foundation, either version 3 of the License, or*/
/*  (at your option) any later version.*/
/**/
/*  This program is distributed in the hope that it will be useful,*/
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of*/
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the*/
/*  GNU General Public License for more details.*/
/**/
/*  You should have received a copy of the GNU General Public License*/
/*  along with this program.  If not, see <http://www.gnu.org/licenses/>.*/
/**/

#include <glib-object.h>
#include <gio/gio.h>
#include <glib.h>
#include <meta/display.h>
#include <stdlib.h>
#include <string.h>
#include <meta/meta-backend.h>

#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define GALA_TYPE_KEYBOARD_MANAGER (gala_keyboard_manager_get_type ())
#define GALA_KEYBOARD_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_KEYBOARD_MANAGER, GalaKeyboardManager))
#define GALA_KEYBOARD_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_KEYBOARD_MANAGER, GalaKeyboardManagerClass))
#define GALA_IS_KEYBOARD_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_KEYBOARD_MANAGER))
#define GALA_IS_KEYBOARD_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_KEYBOARD_MANAGER))
#define GALA_KEYBOARD_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_KEYBOARD_MANAGER, GalaKeyboardManagerClass))

typedef struct _GalaKeyboardManager GalaKeyboardManager;
typedef struct _GalaKeyboardManagerClass GalaKeyboardManagerClass;
typedef struct _GalaKeyboardManagerPrivate GalaKeyboardManagerPrivate;
enum  {
	GALA_KEYBOARD_MANAGER_0_PROPERTY,
	GALA_KEYBOARD_MANAGER_NUM_PROPERTIES
};
static GParamSpec* gala_keyboard_manager_properties[GALA_KEYBOARD_MANAGER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_settings_schema_unref0(var) ((var == NULL) ? NULL : (var = (g_settings_schema_unref (var), NULL)))
#define _g_variant_type_free0(var) ((var == NULL) ? NULL : (var = (g_variant_type_free (var), NULL)))

struct _GalaKeyboardManager {
	GObject parent_instance;
	GalaKeyboardManagerPrivate * priv;
};

struct _GalaKeyboardManagerClass {
	GObjectClass parent_class;
};

struct _GalaKeyboardManagerPrivate {
	GSettings* settings;
};

static gint GalaKeyboardManager_private_offset;
static gpointer gala_keyboard_manager_parent_class = NULL;
static GalaKeyboardManager* gala_keyboard_manager_instance;
static GalaKeyboardManager* gala_keyboard_manager_instance = NULL;
static GVariantType* gala_keyboard_manager_sources_variant_type;
static GVariantType* gala_keyboard_manager_sources_variant_type = NULL;

VALA_EXTERN GType gala_keyboard_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaKeyboardManager, g_object_unref)
VALA_EXTERN void gala_keyboard_manager_init (MetaDisplay* display);
static GalaKeyboardManager* gala_keyboard_manager_new (void);
static GalaKeyboardManager* gala_keyboard_manager_construct (GType object_type);
static gboolean gala_keyboard_manager_handle_modifiers_accelerator_activated (MetaDisplay* display,
                                                                       GalaKeyboardManager* self);
static gboolean _gala_keyboard_manager_handle_modifiers_accelerator_activated_meta_display_modifiers_accelerator_activated (MetaDisplay* _sender,
                                                                                                                     gpointer self);
static void gala_keyboard_manager_set_keyboard_layout (GSettings* settings,
                                                const gchar* key,
                                                GalaKeyboardManager* self);
static GObject * gala_keyboard_manager_constructor (GType type,
                                             guint n_construct_properties,
                                             GObjectConstructParam * construct_properties);
static void gala_keyboard_manager_finalize (GObject * obj);
static GType gala_keyboard_manager_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static inline gpointer
gala_keyboard_manager_get_instance_private (GalaKeyboardManager* self)
{
	return G_STRUCT_MEMBER_P (self, GalaKeyboardManager_private_offset);
}

static gboolean
_gala_keyboard_manager_handle_modifiers_accelerator_activated_meta_display_modifiers_accelerator_activated (MetaDisplay* _sender,
                                                                                                            gpointer self)
{
	gboolean result;
	result = gala_keyboard_manager_handle_modifiers_accelerator_activated (_sender, (GalaKeyboardManager*) self);
	return result;
}

void
gala_keyboard_manager_init (MetaDisplay* display)
{
	GalaKeyboardManager* _tmp0_;
	GalaKeyboardManager* _tmp1_;
	GalaKeyboardManager* _tmp2_;
	g_return_if_fail (display != NULL);
	_tmp0_ = gala_keyboard_manager_instance;
	if (_tmp0_ != NULL) {
		return;
	}
	_tmp1_ = gala_keyboard_manager_new ();
	_g_object_unref0 (gala_keyboard_manager_instance);
	gala_keyboard_manager_instance = _tmp1_;
	_tmp2_ = gala_keyboard_manager_instance;
	g_signal_connect_object (display, "modifiers-accelerator-activated", (GCallback) _gala_keyboard_manager_handle_modifiers_accelerator_activated_meta_display_modifiers_accelerator_activated, _tmp2_, 0);
}

static GalaKeyboardManager*
gala_keyboard_manager_construct (GType object_type)
{
	GalaKeyboardManager * self = NULL;
	self = (GalaKeyboardManager*) g_object_new (object_type, NULL);
	return self;
}

static GalaKeyboardManager*
gala_keyboard_manager_new (void)
{
	return gala_keyboard_manager_construct (GALA_TYPE_KEYBOARD_MANAGER);
}

static gboolean
gala_keyboard_manager_handle_modifiers_accelerator_activated (MetaDisplay* display,
                                                              GalaKeyboardManager* self)
{
	GVariant* sources = NULL;
	GSettings* _tmp0_;
	GVariant* _tmp1_;
	GVariant* _tmp2_;
	const GVariantType* _tmp3_;
	guint n_sources = 0U;
	GVariant* _tmp4_;
	guint current = 0U;
	GSettings* _tmp5_;
	GSettings* _tmp6_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (display != NULL, FALSE);
	meta_display_ungrab_keyboard (display, meta_display_get_current_time (display));
	_tmp0_ = self->priv->settings;
	_tmp1_ = g_settings_get_value (_tmp0_, "sources");
	sources = _tmp1_;
	_tmp2_ = sources;
	_tmp3_ = gala_keyboard_manager_sources_variant_type;
	if (!g_variant_is_of_type (_tmp2_, _tmp3_)) {
		result = TRUE;
		_g_variant_unref0 (sources);
		return result;
	}
	_tmp4_ = sources;
	n_sources = (guint) g_variant_n_children (_tmp4_);
	if (n_sources < ((guint) 2)) {
		result = TRUE;
		_g_variant_unref0 (sources);
		return result;
	}
	_tmp5_ = self->priv->settings;
	current = g_settings_get_uint (_tmp5_, "current");
	_tmp6_ = self->priv->settings;
	g_settings_set_uint (_tmp6_, "current", (current + 1) % n_sources);
	result = TRUE;
	_g_variant_unref0 (sources);
	return result;
}

static gchar*
_vala_g_strjoinv (const gchar* separator,
                  gchar** str_array,
                  gint str_array_length1)
{
	gboolean _tmp0_ = FALSE;
	gchar* result;
	if (separator == NULL) {
		separator = "";
	}
	if (str_array != NULL) {
		gboolean _tmp1_ = FALSE;
		if (str_array_length1 > 0) {
			_tmp1_ = TRUE;
		} else {
			gboolean _tmp2_ = FALSE;
			if (str_array_length1 == -1) {
				const gchar* _tmp3_;
				_tmp3_ = str_array[0];
				_tmp2_ = _tmp3_ != NULL;
			} else {
				_tmp2_ = FALSE;
			}
			_tmp1_ = _tmp2_;
		}
		_tmp0_ = _tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint i = 0;
		gsize len = 0UL;
		gint _tmp16_;
		gint _tmp17_;
		const gchar* res = NULL;
		void* _tmp18_;
		const gchar* _tmp19_ = NULL;
		const gchar* _tmp20_;
		void* ptr = NULL;
		const gchar* _tmp22_;
		void* _tmp23_;
		const gchar* _tmp33_;
		len = (gsize) 1;
		{
			gboolean _tmp4_ = FALSE;
			i = 0;
			_tmp4_ = TRUE;
			while (TRUE) {
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_ = FALSE;
				gint _tmp10_ = 0;
				const gchar* _tmp11_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				if (str_array_length1 != -1) {
					_tmp7_ = i < str_array_length1;
				} else {
					_tmp7_ = FALSE;
				}
				if (_tmp7_) {
					_tmp6_ = TRUE;
				} else {
					gboolean _tmp8_ = FALSE;
					if (str_array_length1 == -1) {
						const gchar* _tmp9_;
						_tmp9_ = str_array[i];
						_tmp8_ = _tmp9_ != NULL;
					} else {
						_tmp8_ = FALSE;
					}
					_tmp6_ = _tmp8_;
				}
				if (!_tmp6_) {
					break;
				}
				_tmp11_ = str_array[i];
				if (_tmp11_ != NULL) {
					const gchar* _tmp12_;
					gint _tmp13_;
					gint _tmp14_;
					_tmp12_ = str_array[i];
					_tmp13_ = strlen ((const gchar*) _tmp12_);
					_tmp14_ = _tmp13_;
					_tmp10_ = _tmp14_;
				} else {
					_tmp10_ = 0;
				}
				len += (gsize) _tmp10_;
			}
		}
		if (i == 0) {
			gchar* _tmp15_;
			_tmp15_ = g_strdup ("");
			result = _tmp15_;
			return result;
		}
		str_array_length1 = i;
		_tmp16_ = strlen ((const gchar*) separator);
		_tmp17_ = _tmp16_;
		len += (gsize) (_tmp17_ * (i - 1));
		_tmp18_ = g_malloc (len);
		res = _tmp18_;
		_tmp20_ = str_array[0];
		if (_tmp20_ != NULL) {
			const gchar* _tmp21_;
			_tmp21_ = str_array[0];
			_tmp19_ = (const gchar*) _tmp21_;
		} else {
			_tmp19_ = "";
		}
		_tmp22_ = res;
		_tmp23_ = g_stpcpy ((void*) _tmp22_, _tmp19_);
		ptr = _tmp23_;
		{
			gboolean _tmp24_ = FALSE;
			i = 1;
			_tmp24_ = TRUE;
			while (TRUE) {
				void* _tmp26_;
				void* _tmp27_;
				const gchar* _tmp28_ = NULL;
				const gchar* _tmp29_;
				void* _tmp31_;
				void* _tmp32_;
				if (!_tmp24_) {
					gint _tmp25_;
					_tmp25_ = i;
					i = _tmp25_ + 1;
				}
				_tmp24_ = FALSE;
				if (!(i < str_array_length1)) {
					break;
				}
				_tmp26_ = ptr;
				_tmp27_ = g_stpcpy (_tmp26_, (const gchar*) separator);
				ptr = _tmp27_;
				_tmp29_ = str_array[i];
				if (_tmp29_ != NULL) {
					const gchar* _tmp30_;
					_tmp30_ = str_array[i];
					_tmp28_ = (const gchar*) _tmp30_;
				} else {
					_tmp28_ = "";
				}
				_tmp31_ = ptr;
				_tmp32_ = g_stpcpy (_tmp31_, _tmp28_);
				ptr = _tmp32_;
			}
		}
		_tmp33_ = res;
		res = NULL;
		result = (gchar*) _tmp33_;
		return result;
	} else {
		gchar* _tmp34_;
		_tmp34_ = g_strdup ("");
		result = _tmp34_;
		return result;
	}
}

static void
gala_keyboard_manager_set_keyboard_layout (GSettings* settings,
                                           const gchar* key,
                                           GalaKeyboardManager* self)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gchar* layout = NULL;
	gchar* _tmp2_;
	gchar* variant = NULL;
	gchar* _tmp3_;
	gchar* options = NULL;
	gchar* _tmp4_;
	GVariant* sources = NULL;
	GVariant* _tmp5_;
	GVariant* _tmp6_;
	const GVariantType* _tmp7_;
	guint current = 0U;
	const gchar* type = NULL;
	const gchar* name = NULL;
	GVariant* _tmp8_;
	const gchar* _tmp12_;
	gchar** xkb_options = NULL;
	gchar** _tmp23_;
	gchar** _tmp24_;
	gint xkb_options_length1;
	gint _xkb_options_size_;
	gchar** _tmp25_;
	gint _tmp25__length1;
	gboolean _tmp28_ = FALSE;
	const gchar* _tmp29_;
	MetaBackend* _tmp35_;
	const gchar* _tmp36_;
	const gchar* _tmp37_;
	const gchar* _tmp38_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (settings != NULL);
	g_return_if_fail (key != NULL);
	if (g_strcmp0 (key, "current") == 0) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = g_strcmp0 (key, "sources") == 0;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (key, "xkb-options") == 0;
	}
	if (!_tmp0_) {
		return;
	}
	_tmp2_ = g_strdup ("us");
	layout = _tmp2_;
	_tmp3_ = g_strdup ("");
	variant = _tmp3_;
	_tmp4_ = g_strdup ("");
	options = _tmp4_;
	_tmp5_ = g_settings_get_value (settings, "sources");
	sources = _tmp5_;
	_tmp6_ = sources;
	_tmp7_ = gala_keyboard_manager_sources_variant_type;
	if (!g_variant_is_of_type (_tmp6_, _tmp7_)) {
		_g_variant_unref0 (sources);
		_g_free0 (options);
		_g_free0 (variant);
		_g_free0 (layout);
		return;
	}
	current = g_settings_get_uint (settings, "current");
	type = NULL;
	name = NULL;
	_tmp8_ = sources;
	if (g_variant_n_children (_tmp8_) > ((gsize) current)) {
		GVariant* _tmp9_;
		const gchar* _tmp10_ = NULL;
		const gchar* _tmp11_ = NULL;
		_tmp9_ = sources;
		g_variant_get_child (_tmp9_, (gsize) current, "(&s&s)", &_tmp10_, &_tmp11_, NULL);
		type = _tmp10_;
		name = _tmp11_;
	}
	_tmp12_ = type;
	if (g_strcmp0 (_tmp12_, "xkb") == 0) {
		gchar** arr = NULL;
		const gchar* _tmp13_;
		gchar** _tmp14_;
		gchar** _tmp15_;
		gint arr_length1;
		gint _arr_size_;
		gchar** _tmp16_;
		gint _tmp16__length1;
		const gchar* _tmp17_;
		gchar* _tmp18_;
		const gchar* _tmp19_ = NULL;
		gchar** _tmp20_;
		gint _tmp20__length1;
		const gchar* _tmp21_;
		gchar* _tmp22_;
		_tmp13_ = name;
		_tmp15_ = _tmp14_ = g_strsplit (_tmp13_, "+", 2);
		arr = _tmp15_;
		arr_length1 = _vala_array_length (_tmp14_);
		_arr_size_ = arr_length1;
		_tmp16_ = arr;
		_tmp16__length1 = arr_length1;
		_tmp17_ = _tmp16_[0];
		_tmp18_ = g_strdup (_tmp17_);
		_g_free0 (layout);
		layout = _tmp18_;
		_tmp20_ = arr;
		_tmp20__length1 = arr_length1;
		_tmp21_ = _tmp20_[1];
		_tmp19_ = _tmp21_;
		if (_tmp19_ == NULL) {
			_tmp19_ = "";
		}
		_tmp22_ = g_strdup (_tmp19_);
		_g_free0 (variant);
		variant = _tmp22_;
		arr = (_vala_array_free (arr, arr_length1, (GDestroyNotify) g_free), NULL);
	} else {
		_g_variant_unref0 (sources);
		_g_free0 (options);
		_g_free0 (variant);
		_g_free0 (layout);
		return;
	}
	_tmp24_ = _tmp23_ = g_settings_get_strv (settings, "xkb-options");
	xkb_options = _tmp24_;
	xkb_options_length1 = _vala_array_length (_tmp23_);
	_xkb_options_size_ = xkb_options_length1;
	_tmp25_ = xkb_options;
	_tmp25__length1 = xkb_options_length1;
	if (_tmp25__length1 > 0) {
		gchar** _tmp26_;
		gint _tmp26__length1;
		gchar* _tmp27_;
		_tmp26_ = xkb_options;
		_tmp26__length1 = xkb_options_length1;
		_tmp27_ = _vala_g_strjoinv (",", _tmp26_, (gint) _tmp26__length1);
		_g_free0 (options);
		options = _tmp27_;
	}
	_tmp29_ = layout;
	if (g_strcmp0 (_tmp29_, "us") != 0) {
		_tmp28_ = TRUE;
	} else {
		const gchar* _tmp30_;
		_tmp30_ = variant;
		_tmp28_ = g_strcmp0 (_tmp30_, "") != 0;
	}
	if (_tmp28_) {
		const gchar* _tmp31_;
		gchar* _tmp32_;
		const gchar* _tmp33_;
		gchar* _tmp34_;
		_tmp31_ = layout;
		_tmp32_ = g_strconcat (_tmp31_, ",us", NULL);
		_g_free0 (layout);
		layout = _tmp32_;
		_tmp33_ = variant;
		_tmp34_ = g_strconcat (_tmp33_, ",", NULL);
		_g_free0 (variant);
		variant = _tmp34_;
	}
	_tmp35_ = meta_get_backend ();
	_tmp36_ = layout;
	_tmp37_ = variant;
	_tmp38_ = options;
	meta_backend_set_keymap (_tmp35_, _tmp36_, _tmp37_, _tmp38_);
	xkb_options = (_vala_array_free (xkb_options, xkb_options_length1, (GDestroyNotify) g_free), NULL);
	_g_variant_unref0 (sources);
	_g_free0 (options);
	_g_free0 (variant);
	_g_free0 (layout);
}

static GObject *
gala_keyboard_manager_constructor (GType type,
                                   guint n_construct_properties,
                                   GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	GalaKeyboardManager * self;
	GSettingsSchema* schema = NULL;
	GSettingsSchemaSource* _tmp0_;
	GSettingsSchema* _tmp1_;
	GSettingsSchema* _tmp2_;
	GSettingsSchema* _tmp3_;
	GSettings* _tmp4_;
	GSettings* _tmp5_;
	GSettings* _tmp6_;
	parent_class = G_OBJECT_CLASS (gala_keyboard_manager_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GALA_TYPE_KEYBOARD_MANAGER, GalaKeyboardManager);
	_tmp0_ = g_settings_schema_source_get_default ();
	_tmp1_ = g_settings_schema_source_lookup (_tmp0_, "org.gnome.desktop.input-sources", TRUE);
	schema = _tmp1_;
	_tmp2_ = schema;
	if (_tmp2_ == NULL) {
		_g_settings_schema_unref0 (schema);
		return obj;
	}
	_tmp3_ = schema;
	_tmp4_ = g_settings_new_full (_tmp3_, NULL, NULL);
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp4_;
	_tmp5_ = self->priv->settings;
	g_signal_connect (_tmp5_, "changed", (GCallback) gala_keyboard_manager_set_keyboard_layout, self);
	_tmp6_ = self->priv->settings;
	gala_keyboard_manager_set_keyboard_layout (_tmp6_, "current", self);
	_g_settings_schema_unref0 (schema);
	return obj;
}

static void
gala_keyboard_manager_class_init (GalaKeyboardManagerClass * klass,
                                  gpointer klass_data)
{
	GVariantType* _tmp0_;
	gala_keyboard_manager_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GalaKeyboardManager_private_offset);
	G_OBJECT_CLASS (klass)->constructor = gala_keyboard_manager_constructor;
	G_OBJECT_CLASS (klass)->finalize = gala_keyboard_manager_finalize;
	_tmp0_ = g_variant_type_new ("a(ss)");
	_g_variant_type_free0 (gala_keyboard_manager_sources_variant_type);
	gala_keyboard_manager_sources_variant_type = _tmp0_;
}

static void
gala_keyboard_manager_instance_init (GalaKeyboardManager * self,
                                     gpointer klass)
{
	self->priv = gala_keyboard_manager_get_instance_private (self);
}

static void
gala_keyboard_manager_finalize (GObject * obj)
{
	GalaKeyboardManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GALA_TYPE_KEYBOARD_MANAGER, GalaKeyboardManager);
	_g_object_unref0 (self->priv->settings);
	G_OBJECT_CLASS (gala_keyboard_manager_parent_class)->finalize (obj);
}

static GType
gala_keyboard_manager_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GalaKeyboardManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gala_keyboard_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GalaKeyboardManager), 0, (GInstanceInitFunc) gala_keyboard_manager_instance_init, NULL };
	GType gala_keyboard_manager_type_id;
	gala_keyboard_manager_type_id = g_type_register_static (G_TYPE_OBJECT, "GalaKeyboardManager", &g_define_type_info, 0);
	GalaKeyboardManager_private_offset = g_type_add_instance_private (gala_keyboard_manager_type_id, sizeof (GalaKeyboardManagerPrivate));
	return gala_keyboard_manager_type_id;
}

GType
gala_keyboard_manager_get_type (void)
{
	static volatile gsize gala_keyboard_manager_type_id__once = 0;
	if (g_once_init_enter (&gala_keyboard_manager_type_id__once)) {
		GType gala_keyboard_manager_type_id;
		gala_keyboard_manager_type_id = gala_keyboard_manager_get_type_once ();
		g_once_init_leave (&gala_keyboard_manager_type_id__once, gala_keyboard_manager_type_id);
	}
	return gala_keyboard_manager_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

