/* PointerLocator.c generated by valac 0.56.3, the Vala compiler
 * generated from PointerLocator.vala, do not modify */

/**/
/*  Copyright 2020 elementary, Inc. (https://elementary.io)*/
/**/
/*  This program is free software: you can redistribute it and/or modify*/
/*  it under the terms of the GNU General Public License as published by*/
/*  the Free Software Foundation, either version 3 of the License, or*/
/*  (at your option) any later version.*/
/**/
/*  This program is distributed in the hope that it will be useful,*/
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of*/
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the*/
/*  GNU General Public License for more details.*/
/**/
/*  You should have received a copy of the GNU General Public License*/
/*  along with this program.  If not, see <http://www.gnu.org/licenses/>.*/
/**/

#include <clutter/clutter.h>
#include <glib-object.h>
#include "gala.h"
#include <glib.h>
#include <gio/gio.h>
#include <cogl/cogl.h>
#include <cairo-gobject.h>
#include <float.h>
#include <math.h>
#include <gdk/gdk.h>
#include <meta/meta-cursor-tracker.h>
#include <meta/meta-plugin.h>
#include <meta/display.h>
#include <graphene-gobject.h>
#include <string.h>
#include <meta/meta-monitor-manager.h>

#define GALA_POINTER_LOCATOR_WIDTH_PX 300
#define GALA_POINTER_LOCATOR_HEIGHT_PX 300
#define GALA_POINTER_LOCATOR_ANIMATION_TIME_MS 300
#define GALA_POINTER_LOCATOR_BORDER_WIDTH_PX ((guint) 1)
#define GALA_POINTER_LOCATOR_BACKGROUND_OPACITY 0.7
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define GALA_TYPE_POINTER_LOCATOR (gala_pointer_locator_get_type ())
#define GALA_POINTER_LOCATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_POINTER_LOCATOR, GalaPointerLocator))
#define GALA_POINTER_LOCATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_POINTER_LOCATOR, GalaPointerLocatorClass))
#define GALA_IS_POINTER_LOCATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_POINTER_LOCATOR))
#define GALA_IS_POINTER_LOCATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_POINTER_LOCATOR))
#define GALA_POINTER_LOCATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_POINTER_LOCATOR, GalaPointerLocatorClass))

typedef struct _GalaPointerLocator GalaPointerLocator;
typedef struct _GalaPointerLocatorClass GalaPointerLocatorClass;
typedef struct _GalaPointerLocatorPrivate GalaPointerLocatorPrivate;
enum  {
	GALA_POINTER_LOCATOR_0_PROPERTY,
	GALA_POINTER_LOCATOR_WM_PROPERTY,
	GALA_POINTER_LOCATOR_NUM_PROPERTIES
};
static GParamSpec* gala_pointer_locator_properties[GALA_POINTER_LOCATOR_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _cogl_object_unref0(var) ((var == NULL) ? NULL : (var = (cogl_object_unref (var), NULL)))
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))
#define _cairo_pattern_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_pattern_destroy (var), NULL)))
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))

struct _GalaPointerLocator {
	ClutterActor parent_instance;
	GalaPointerLocatorPrivate * priv;
};

struct _GalaPointerLocatorClass {
	ClutterActorClass parent_class;
};

struct _GalaPointerLocatorPrivate {
	GalaWindowManager* _wm;
	gint scaling_factor;
	gint surface_width;
	gint surface_height;
	GSettings* settings;
	CoglPipeline* pipeline;
	cairo_surface_t* surface;
	cairo_pattern_t* stroke_color;
	cairo_pattern_t* fill_color;
};

static gint GalaPointerLocator_private_offset;
static gpointer gala_pointer_locator_parent_class = NULL;
static ClutterAnimatableInterface * gala_pointer_locator_clutter_animatable_parent_iface = NULL;

VALA_EXTERN GType gala_pointer_locator_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaPointerLocator, g_object_unref)
VALA_EXTERN GalaPointerLocator* gala_pointer_locator_new (GalaWindowManager* wm);
VALA_EXTERN GalaPointerLocator* gala_pointer_locator_construct (GType object_type,
                                                    GalaWindowManager* wm);
static void gala_pointer_locator_update_surface (GalaPointerLocator* self);
VALA_EXTERN gint gala_internal_utils_get_ui_scaling_factor (void);
static void gala_pointer_locator_real_paint (ClutterActor* base,
                                      ClutterPaintContext* context);
VALA_EXTERN void gala_pointer_locator_show_ripple (GalaPointerLocator* self);
static void __lambda13_ (GalaPointerLocator* self);
static void ___lambda13__clutter_timeline_stopped (ClutterTimeline* _sender,
                                            gboolean is_finished,
                                            gpointer self);
static void __lambda14_ (GalaPointerLocator* self);
static void ___lambda14__clutter_timeline_started (ClutterTimeline* _sender,
                                            gpointer self);
VALA_EXTERN void gala_internal_utils_get_theme_accent_color (GdkRGBA* result);
VALA_EXTERN GalaWindowManager* gala_pointer_locator_get_wm (GalaPointerLocator* self);
static void gala_pointer_locator_set_wm (GalaPointerLocator* self,
                                  GalaWindowManager* value);
static GObject * gala_pointer_locator_constructor (GType type,
                                            guint n_construct_properties,
                                            GObjectConstructParam * construct_properties);
static void _gala_pointer_locator_update_surface_meta_monitor_manager_monitors_changed (MetaMonitorManager* _sender,
                                                                                 gpointer self);
static void gala_pointer_locator_finalize (GObject * obj);
static GType gala_pointer_locator_get_type_once (void);
static void _vala_gala_pointer_locator_get_property (GObject * object,
                                              guint property_id,
                                              GValue * value,
                                              GParamSpec * pspec);
static void _vala_gala_pointer_locator_set_property (GObject * object,
                                              guint property_id,
                                              const GValue * value,
                                              GParamSpec * pspec);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
gala_pointer_locator_get_instance_private (GalaPointerLocator* self)
{
	return G_STRUCT_MEMBER_P (self, GalaPointerLocator_private_offset);
}

GalaPointerLocator*
gala_pointer_locator_construct (GType object_type,
                                GalaWindowManager* wm)
{
	GalaPointerLocator * self = NULL;
	g_return_val_if_fail (wm != NULL, NULL);
	self = (GalaPointerLocator*) g_object_new (object_type, "wm", wm, NULL);
	return self;
}

GalaPointerLocator*
gala_pointer_locator_new (GalaWindowManager* wm)
{
	return gala_pointer_locator_construct (GALA_TYPE_POINTER_LOCATOR, wm);
}

static void
gala_pointer_locator_update_surface (GalaPointerLocator* self)
{
	gint cur_scale = 0;
	gboolean _tmp0_ = FALSE;
	cairo_surface_t* _tmp1_;
	g_return_if_fail (self != NULL);
	cur_scale = gala_internal_utils_get_ui_scaling_factor ();
	_tmp1_ = self->priv->surface;
	if (_tmp1_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = cur_scale != self->priv->scaling_factor;
	}
	if (_tmp0_) {
		cairo_surface_t* _tmp2_;
		self->priv->scaling_factor = cur_scale;
		self->priv->surface_width = GALA_POINTER_LOCATOR_WIDTH_PX * self->priv->scaling_factor;
		self->priv->surface_height = GALA_POINTER_LOCATOR_HEIGHT_PX * self->priv->scaling_factor;
		_tmp2_ = cairo_image_surface_create (CAIRO_FORMAT_ARGB32, self->priv->surface_width, self->priv->surface_height);
		_cairo_surface_destroy0 (self->priv->surface);
		self->priv->surface = _tmp2_;
	}
}

static gpointer
_cogl_object_ref0 (gpointer self)
{
	return self ? cogl_object_ref (self) : NULL;
}

static void
gala_pointer_locator_real_paint (ClutterActor* base,
                                 ClutterPaintContext* context)
{
	GalaPointerLocator * self;
	gint radius = 0;
	cairo_t* cr = NULL;
	cairo_surface_t* _tmp0_;
	cairo_t* _tmp1_;
	cairo_pattern_t* _tmp2_;
	cairo_pattern_t* _tmp3_;
	CoglContext* cogl_context = NULL;
	CoglFramebuffer* _tmp4_;
	CoglContext* _tmp5_;
	CoglContext* _tmp6_;
	GError* _inner_error0_ = NULL;
	self = (GalaPointerLocator*) base;
	g_return_if_fail (context != NULL);
	radius = MIN (self->priv->surface_width / 2, self->priv->surface_height / 2);
	_tmp0_ = self->priv->surface;
	_tmp1_ = cairo_create (_tmp0_);
	cr = _tmp1_;
	cairo_save (cr);
	cairo_set_source_rgba (cr, (gdouble) 0, (gdouble) 0, (gdouble) 0, (gdouble) 0);
	cairo_set_operator (cr, CAIRO_OPERATOR_SOURCE);
	cairo_paint (cr);
	cairo_restore (cr);
	cairo_set_line_cap (cr, CAIRO_LINE_CAP_ROUND);
	cairo_set_line_join (cr, CAIRO_LINE_JOIN_ROUND);
	cairo_translate (cr, (gdouble) (self->priv->surface_width / 2), (gdouble) (self->priv->surface_height / 2));
	cairo_move_to (cr, (gdouble) (radius - GALA_POINTER_LOCATOR_BORDER_WIDTH_PX), (gdouble) 0);
	cairo_arc (cr, (gdouble) 0, (gdouble) 0, (gdouble) (radius - (GALA_POINTER_LOCATOR_BORDER_WIDTH_PX * self->priv->scaling_factor)), (gdouble) 0, 2 * G_PI);
	cairo_close_path (cr);
	cairo_set_line_width (cr, (gdouble) 0);
	_tmp2_ = self->priv->fill_color;
	cairo_set_source (cr, _tmp2_);
	cairo_fill_preserve (cr);
	cairo_set_line_width (cr, (gdouble) (GALA_POINTER_LOCATOR_BORDER_WIDTH_PX * self->priv->scaling_factor));
	_tmp3_ = self->priv->stroke_color;
	cairo_set_source (cr, _tmp3_);
	cairo_stroke (cr);
	_tmp4_ = clutter_paint_context_get_framebuffer (context);
	_tmp5_ = cogl_framebuffer_get_context (_tmp4_);
	_tmp6_ = _cogl_object_ref0 (_tmp5_);
	cogl_context = _tmp6_;
	{
		CoglTexture2D* texture = NULL;
		cairo_surface_t* _tmp7_;
		cairo_surface_t* _tmp8_;
		guchar* _tmp9_;
		CoglTexture2D* _tmp10_;
		CoglPipeline* _tmp11_;
		CoglFramebuffer* _tmp12_;
		CoglPipeline* _tmp13_;
		_tmp7_ = self->priv->surface;
		_tmp8_ = self->priv->surface;
		_tmp9_ = cairo_image_surface_get_data (_tmp8_);
		_tmp10_ = cogl_texture_2d_new_from_data (cogl_context, self->priv->surface_width, self->priv->surface_height, COGL_PIXEL_FORMAT_BGRA_8888_PRE, cairo_image_surface_get_stride (_tmp7_), (const uint8_t*) _tmp9_, &_inner_error0_);
		texture = _tmp10_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp11_ = self->priv->pipeline;
		cogl_pipeline_set_layer_texture (_tmp11_, 0, (CoglTexture*) texture);
		_tmp12_ = clutter_paint_context_get_framebuffer (context);
		_tmp13_ = self->priv->pipeline;
		cogl_framebuffer_draw_rectangle (_tmp12_, _tmp13_, (gfloat) 0, (gfloat) 0, (gfloat) self->priv->surface_width, (gfloat) self->priv->surface_height);
		_cogl_object_unref0 (texture);
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_cogl_object_unref0 (cogl_context);
		_cairo_destroy0 (cr);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	CLUTTER_ACTOR_CLASS (gala_pointer_locator_parent_class)->paint (G_TYPE_CHECK_INSTANCE_CAST (self, clutter_actor_get_type (), ClutterActor), context);
	_cogl_object_unref0 (cogl_context);
	_cairo_destroy0 (cr);
}

static void
__lambda13_ (GalaPointerLocator* self)
{
	g_object_set ((ClutterActor*) self, "visible", FALSE, NULL);
}

static void
___lambda13__clutter_timeline_stopped (ClutterTimeline* _sender,
                                       gboolean is_finished,
                                       gpointer self)
{
	__lambda13_ ((GalaPointerLocator*) self);
}

static void
__lambda14_ (GalaPointerLocator* self)
{
	g_object_set ((ClutterActor*) self, "visible", TRUE, NULL);
}

static void
___lambda14__clutter_timeline_started (ClutterTimeline* _sender,
                                       gpointer self)
{
	__lambda14_ ((GalaPointerLocator*) self);
}

void
gala_pointer_locator_show_ripple (GalaPointerLocator* self)
{
	GSettings* _tmp0_;
	ClutterTransition* old_transition = NULL;
	ClutterTransition* _tmp1_;
	ClutterTransition* _tmp2_;
	ClutterTransitionGroup* transition = NULL;
	ClutterTransitionGroup* _tmp4_;
	ClutterTransitionGroup* _tmp5_;
	ClutterPropertyTransition* transition_x = NULL;
	ClutterPropertyTransition* _tmp6_;
	ClutterPropertyTransition* transition_y = NULL;
	ClutterPropertyTransition* _tmp7_;
	GValue start_val = {0};
	GValue _tmp8_ = {0};
	GValue stop_val = {0};
	GValue _tmp9_ = {0};
	ClutterPropertyTransition* _tmp10_;
	GValue _tmp11_;
	ClutterPropertyTransition* _tmp12_;
	GValue _tmp13_;
	ClutterPropertyTransition* _tmp14_;
	GValue _tmp15_;
	ClutterPropertyTransition* _tmp16_;
	GValue _tmp17_;
	ClutterTransitionGroup* _tmp18_;
	ClutterTransitionGroup* _tmp19_;
	ClutterTransitionGroup* _tmp20_;
	ClutterPropertyTransition* _tmp21_;
	ClutterTransitionGroup* _tmp22_;
	ClutterPropertyTransition* _tmp23_;
	ClutterTransitionGroup* _tmp24_;
	ClutterTransitionGroup* _tmp25_;
	ClutterTransitionGroup* _tmp26_;
	GdkRGBA rgba = {0};
	GdkRGBA _tmp27_ = {0};
	GdkRGBA _tmp28_;
	GdkRGBA _tmp29_;
	GdkRGBA _tmp30_;
	cairo_pattern_t* _tmp31_;
	GdkRGBA _tmp32_;
	GdkRGBA _tmp33_;
	GdkRGBA _tmp34_;
	cairo_pattern_t* _tmp35_;
	MetaCursorTracker* tracker = NULL;
	GalaWindowManager* _tmp36_;
	MetaDisplay* _tmp37_;
	MetaCursorTracker* _tmp38_;
	graphene_point_t coords = {0};
	graphene_point_t _tmp39_ = {0};
	MetaCursorTracker* _tmp40_;
	graphene_point_t _tmp41_ = {0};
	graphene_point_t _tmp42_;
	gfloat _tmp43_;
	gfloat _tmp44_;
	graphene_point_t _tmp45_;
	gfloat _tmp46_;
	gfloat _tmp47_;
	ClutterTransitionGroup* _tmp48_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->settings;
	if (!g_settings_get_boolean (_tmp0_, "locate-pointer")) {
		return;
	}
	_tmp1_ = clutter_actor_get_transition ((ClutterActor*) self, "circle");
	old_transition = _tmp1_;
	_tmp2_ = old_transition;
	if (_tmp2_ != NULL) {
		ClutterTransition* _tmp3_;
		_tmp3_ = old_transition;
		clutter_timeline_stop ((ClutterTimeline*) _tmp3_);
	}
	_tmp4_ = (ClutterTransitionGroup*) clutter_transition_group_new ();
	transition = _tmp4_;
	_tmp5_ = transition;
	clutter_transition_set_remove_on_complete ((ClutterTransition*) _tmp5_, TRUE);
	_tmp6_ = (ClutterPropertyTransition*) clutter_property_transition_new ("scale-x");
	transition_x = _tmp6_;
	_tmp7_ = (ClutterPropertyTransition*) clutter_property_transition_new ("scale-y");
	transition_y = _tmp7_;
	g_value_init (&_tmp8_, G_TYPE_DOUBLE);
	start_val = _tmp8_;
	g_value_set_double (&start_val, (gdouble) 1);
	g_value_init (&_tmp9_, G_TYPE_DOUBLE);
	stop_val = _tmp9_;
	g_value_set_double (&stop_val, (gdouble) 0);
	_tmp10_ = transition_x;
	_tmp11_ = start_val;
	clutter_transition_set_from_value ((ClutterTransition*) _tmp10_, &_tmp11_);
	_tmp12_ = transition_y;
	_tmp13_ = start_val;
	clutter_transition_set_from_value ((ClutterTransition*) _tmp12_, &_tmp13_);
	_tmp14_ = transition_x;
	_tmp15_ = stop_val;
	clutter_transition_set_to_value ((ClutterTransition*) _tmp14_, &_tmp15_);
	_tmp16_ = transition_y;
	_tmp17_ = stop_val;
	clutter_transition_set_to_value ((ClutterTransition*) _tmp16_, &_tmp17_);
	_tmp18_ = transition;
	clutter_timeline_set_progress_mode ((ClutterTimeline*) _tmp18_, CLUTTER_EASE_OUT_QUAD);
	_tmp19_ = transition;
	clutter_timeline_set_duration ((ClutterTimeline*) _tmp19_, (guint) GALA_POINTER_LOCATOR_ANIMATION_TIME_MS);
	_tmp20_ = transition;
	_tmp21_ = transition_x;
	clutter_transition_group_add_transition (_tmp20_, (ClutterTransition*) _tmp21_);
	_tmp22_ = transition;
	_tmp23_ = transition_y;
	clutter_transition_group_add_transition (_tmp22_, (ClutterTransition*) _tmp23_);
	_tmp24_ = transition;
	g_signal_connect_object ((ClutterTimeline*) _tmp24_, "stopped", (GCallback) ___lambda13__clutter_timeline_stopped, self, 0);
	_tmp25_ = transition;
	g_signal_connect_object ((ClutterTimeline*) _tmp25_, "started", (GCallback) ___lambda14__clutter_timeline_started, self, 0);
	_tmp26_ = transition;
	clutter_actor_add_transition ((ClutterActor*) self, "circle", (ClutterTransition*) _tmp26_);
	gala_internal_utils_get_theme_accent_color (&_tmp27_);
	rgba = _tmp27_;
	_tmp28_ = rgba;
	_tmp29_ = rgba;
	_tmp30_ = rgba;
	_tmp31_ = cairo_pattern_create_rgb (_tmp28_.red, _tmp29_.green, _tmp30_.blue);
	_cairo_pattern_destroy0 (self->priv->stroke_color);
	self->priv->stroke_color = _tmp31_;
	_tmp32_ = rgba;
	_tmp33_ = rgba;
	_tmp34_ = rgba;
	_tmp35_ = cairo_pattern_create_rgba (_tmp32_.red, _tmp33_.green, _tmp34_.blue, GALA_POINTER_LOCATOR_BACKGROUND_OPACITY);
	_cairo_pattern_destroy0 (self->priv->fill_color);
	self->priv->fill_color = _tmp35_;
	_tmp36_ = self->priv->_wm;
	_tmp37_ = meta_plugin_get_display ((MetaPlugin*) _tmp36_);
	_tmp38_ = meta_cursor_tracker_get_for_display (_tmp37_);
	tracker = _tmp38_;
	coords = _tmp39_;
	_tmp40_ = tracker;
	meta_cursor_tracker_get_pointer (_tmp40_, &_tmp41_, NULL);
	coords = _tmp41_;
	_tmp42_ = coords;
	_tmp43_ = clutter_actor_get_width ((ClutterActor*) self);
	_tmp44_ = _tmp43_;
	clutter_actor_set_x ((ClutterActor*) self, _tmp42_.x - (_tmp44_ / 2));
	_tmp45_ = coords;
	_tmp46_ = clutter_actor_get_width ((ClutterActor*) self);
	_tmp47_ = _tmp46_;
	clutter_actor_set_y ((ClutterActor*) self, _tmp45_.y - (_tmp47_ / 2));
	_tmp48_ = transition;
	clutter_timeline_start ((ClutterTimeline*) _tmp48_);
	G_IS_VALUE (&stop_val) ? (g_value_unset (&stop_val), NULL) : NULL;
	G_IS_VALUE (&start_val) ? (g_value_unset (&start_val), NULL) : NULL;
	_g_object_unref0 (transition_y);
	_g_object_unref0 (transition_x);
	_g_object_unref0 (transition);
}

GalaWindowManager*
gala_pointer_locator_get_wm (GalaPointerLocator* self)
{
	GalaWindowManager* result;
	GalaWindowManager* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_wm;
	result = _tmp0_;
	return result;
}

static void
gala_pointer_locator_set_wm (GalaPointerLocator* self,
                             GalaWindowManager* value)
{
	GalaWindowManager* old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_pointer_locator_get_wm (self);
	if (old_value != value) {
		self->priv->_wm = value;
		g_object_notify_by_pspec ((GObject *) self, gala_pointer_locator_properties[GALA_POINTER_LOCATOR_WM_PROPERTY]);
	}
}

static void
_gala_pointer_locator_update_surface_meta_monitor_manager_monitors_changed (MetaMonitorManager* _sender,
                                                                            gpointer self)
{
	gala_pointer_locator_update_surface ((GalaPointerLocator*) self);
}

static GObject *
gala_pointer_locator_constructor (GType type,
                                  guint n_construct_properties,
                                  GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	GalaPointerLocator * self;
	GSettings* _tmp0_;
	ClutterBackend* _tmp1_;
	CoglContext* _tmp2_;
	CoglPipeline* _tmp3_;
	graphene_point_t pivot = {0};
	graphene_point_t _tmp4_;
	MetaMonitorManager* _tmp5_;
	parent_class = G_OBJECT_CLASS (gala_pointer_locator_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GALA_TYPE_POINTER_LOCATOR, GalaPointerLocator);
	g_object_set ((ClutterActor*) self, "visible", FALSE, NULL);
	clutter_actor_set_reactive ((ClutterActor*) self, FALSE);
	_tmp0_ = g_settings_new ("org.gnome.desktop.interface");
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp0_;
	_tmp1_ = clutter_get_default_backend ();
	_tmp2_ = clutter_backend_get_cogl_context (_tmp1_);
	_tmp3_ = cogl_pipeline_new (_tmp2_);
	_cogl_object_unref0 (self->priv->pipeline);
	self->priv->pipeline = _tmp3_;
	gala_pointer_locator_update_surface (self);
	clutter_actor_set_size ((ClutterActor*) self, (gfloat) (GALA_POINTER_LOCATOR_WIDTH_PX * self->priv->scaling_factor), (gfloat) (GALA_POINTER_LOCATOR_HEIGHT_PX * self->priv->scaling_factor));
	memset (&pivot, 0, sizeof (graphene_point_t));
	graphene_point_init (&pivot, 0.5f, 0.5f);
	_tmp4_ = pivot;
	g_object_set ((ClutterActor*) self, "pivot-point", &_tmp4_, NULL);
	_tmp5_ = meta_monitor_manager_get ();
	g_signal_connect_object (_tmp5_, "monitors-changed", (GCallback) _gala_pointer_locator_update_surface_meta_monitor_manager_monitors_changed, self, 0);
	return obj;
}

static void
gala_pointer_locator_class_init (GalaPointerLocatorClass * klass,
                                 gpointer klass_data)
{
	gala_pointer_locator_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GalaPointerLocator_private_offset);
	((ClutterActorClass *) klass)->paint = (void (*) (ClutterActor*, ClutterPaintContext*)) gala_pointer_locator_real_paint;
	G_OBJECT_CLASS (klass)->get_property = _vala_gala_pointer_locator_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gala_pointer_locator_set_property;
	G_OBJECT_CLASS (klass)->constructor = gala_pointer_locator_constructor;
	G_OBJECT_CLASS (klass)->finalize = gala_pointer_locator_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_POINTER_LOCATOR_WM_PROPERTY, gala_pointer_locator_properties[GALA_POINTER_LOCATOR_WM_PROPERTY] = g_param_spec_object ("wm", "wm", "wm", GALA_TYPE_WINDOW_MANAGER, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}

static void
gala_pointer_locator_clutter_animatable_interface_init (ClutterAnimatableInterface * iface,
                                                        gpointer iface_data)
{
	gala_pointer_locator_clutter_animatable_parent_iface = g_type_interface_peek_parent (iface);
}

static void
gala_pointer_locator_instance_init (GalaPointerLocator * self,
                                    gpointer klass)
{
	self->priv = gala_pointer_locator_get_instance_private (self);
	self->priv->scaling_factor = 1;
	self->priv->surface_width = GALA_POINTER_LOCATOR_WIDTH_PX;
	self->priv->surface_height = GALA_POINTER_LOCATOR_HEIGHT_PX;
}

static void
gala_pointer_locator_finalize (GObject * obj)
{
	GalaPointerLocator * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GALA_TYPE_POINTER_LOCATOR, GalaPointerLocator);
	_g_object_unref0 (self->priv->settings);
	_cogl_object_unref0 (self->priv->pipeline);
	_cairo_surface_destroy0 (self->priv->surface);
	_cairo_pattern_destroy0 (self->priv->stroke_color);
	_cairo_pattern_destroy0 (self->priv->fill_color);
	G_OBJECT_CLASS (gala_pointer_locator_parent_class)->finalize (obj);
}

static GType
gala_pointer_locator_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GalaPointerLocatorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gala_pointer_locator_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GalaPointerLocator), 0, (GInstanceInitFunc) gala_pointer_locator_instance_init, NULL };
	static const GInterfaceInfo clutter_animatable_info = { (GInterfaceInitFunc) gala_pointer_locator_clutter_animatable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType gala_pointer_locator_type_id;
	gala_pointer_locator_type_id = g_type_register_static (clutter_actor_get_type (), "GalaPointerLocator", &g_define_type_info, 0);
	g_type_add_interface_static (gala_pointer_locator_type_id, clutter_animatable_get_type (), &clutter_animatable_info);
	GalaPointerLocator_private_offset = g_type_add_instance_private (gala_pointer_locator_type_id, sizeof (GalaPointerLocatorPrivate));
	return gala_pointer_locator_type_id;
}

GType
gala_pointer_locator_get_type (void)
{
	static volatile gsize gala_pointer_locator_type_id__once = 0;
	if (g_once_init_enter (&gala_pointer_locator_type_id__once)) {
		GType gala_pointer_locator_type_id;
		gala_pointer_locator_type_id = gala_pointer_locator_get_type_once ();
		g_once_init_leave (&gala_pointer_locator_type_id__once, gala_pointer_locator_type_id);
	}
	return gala_pointer_locator_type_id__once;
}

static void
_vala_gala_pointer_locator_get_property (GObject * object,
                                         guint property_id,
                                         GValue * value,
                                         GParamSpec * pspec)
{
	GalaPointerLocator * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GALA_TYPE_POINTER_LOCATOR, GalaPointerLocator);
	switch (property_id) {
		case GALA_POINTER_LOCATOR_WM_PROPERTY:
		g_value_set_object (value, gala_pointer_locator_get_wm (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_gala_pointer_locator_set_property (GObject * object,
                                         guint property_id,
                                         const GValue * value,
                                         GParamSpec * pspec)
{
	GalaPointerLocator * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GALA_TYPE_POINTER_LOCATOR, GalaPointerLocator);
	switch (property_id) {
		case GALA_POINTER_LOCATOR_WM_PROPERTY:
		gala_pointer_locator_set_wm (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

