// Generated by gmmproc 2.64.2 -- DO NOT MODIFY!
#ifndef _GSTREAMERMM_OBJECT_H
#define _GSTREAMERMM_OBJECT_H


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/* gstreamermm - a C++ wrapper for gstreamer
 *
 * Copyright 2008-2016 The gstreamermm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gst/gst.h>
#include <glibmm/object.h>
#include <glibmm/listhandle.h>
#include <glibmm/threads.h>
#include <gstreamermm/clockutils.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
using GstObject = struct _GstObject;
using GstObjectClass = struct _GstObjectClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Gst
{ class  Object_Class; } // namespace Gst
#endif //DOXYGEN_SHOULD_SKIP_THIS

namespace Gst
{

/** @addtogroup gstreamermmEnums gstreamermm Enums and Flags */

/** 
 *  @var ObjectFlags OBJECT_FLAG_LAST
 * Subclasses can add additional flags starting from this flag.
 * 
 *  @enum ObjectFlags
 * 
 * The standard flags that an gstobject may have.
 *
 * @ingroup gstreamermmEnums
 * @par Bitwise operators:
 * <tt>%ObjectFlags operator|(ObjectFlags, ObjectFlags)</tt><br>
 * <tt>%ObjectFlags operator&(ObjectFlags, ObjectFlags)</tt><br>
 * <tt>%ObjectFlags operator^(ObjectFlags, ObjectFlags)</tt><br>
 * <tt>%ObjectFlags operator~(ObjectFlags)</tt><br>
 * <tt>%ObjectFlags& operator|=(ObjectFlags&, ObjectFlags)</tt><br>
 * <tt>%ObjectFlags& operator&=(ObjectFlags&, ObjectFlags)</tt><br>
 * <tt>%ObjectFlags& operator^=(ObjectFlags&, ObjectFlags)</tt><br>
 */
enum ObjectFlags
{
  OBJECT_FLAG_LAST = (1<<4)
};

/** @ingroup gstreamermmEnums */
inline ObjectFlags operator|(ObjectFlags lhs, ObjectFlags rhs)
  { return static_cast<ObjectFlags>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs)); }

/** @ingroup gstreamermmEnums */
inline ObjectFlags operator&(ObjectFlags lhs, ObjectFlags rhs)
  { return static_cast<ObjectFlags>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs)); }

/** @ingroup gstreamermmEnums */
inline ObjectFlags operator^(ObjectFlags lhs, ObjectFlags rhs)
  { return static_cast<ObjectFlags>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs)); }

/** @ingroup gstreamermmEnums */
inline ObjectFlags operator~(ObjectFlags flags)
  { return static_cast<ObjectFlags>(~static_cast<unsigned>(flags)); }

/** @ingroup gstreamermmEnums */
inline ObjectFlags& operator|=(ObjectFlags& lhs, ObjectFlags rhs)
  { return (lhs = static_cast<ObjectFlags>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs))); }

/** @ingroup gstreamermmEnums */
inline ObjectFlags& operator&=(ObjectFlags& lhs, ObjectFlags rhs)
  { return (lhs = static_cast<ObjectFlags>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs))); }

/** @ingroup gstreamermmEnums */
inline ObjectFlags& operator^=(ObjectFlags& lhs, ObjectFlags rhs)
  { return (lhs = static_cast<ObjectFlags>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs))); }

} // namespace Gst

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gst::ObjectFlags> : public Glib::Value_Flags<Gst::ObjectFlags>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

namespace Gst
{


/** @defgroup GstBaseClasses gstreamermm Base Classes
 *  Wrapped GStreamer base classes (plug-ins and other classes derrive from
 *  these).
 */

/** A base class for the GStreamer object hierarchy.
 * Gst::Object provides a root for the object hierarchy tree filed in by the
 * GStreamer library. It is currently a thin wrapper on top of Glib::Object.
 * It is an abstract class that is not very usable on its own.
 *
 * Gst::Object gives us basic refcounting, parenting functionality and
 * locking. Most of the function are just extended for special GStreamer needs
 * and can be found under the same name in the base class of Gst::Object which
 * is Glib::Object (e.g. Glib::Object::reference() becomes
 * Gst:Object::reference().
 *
 * In contrast to Glib::Object instances, Gst::Object adds a name property.
 * The functions set_name() and get_name() are used to set/get the name of the
 * object.
 *
 * Last reviewed on 2016-06-06 (1.8.0)
 * @ingroup GstBaseClasses
 */

class Object : public Glib::Object 
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  using CppObjectType = Object;
  using CppClassType = Object_Class;
  using BaseObjectType = GstObject;
  using BaseClassType = GstObjectClass;

  // noncopyable
  Object(const Object&) = delete;
  Object& operator=(const Object&) = delete;

private:  friend class Object_Class;
  static CppClassType object_class_;

protected:
  explicit Object(const Glib::ConstructParams& construct_params);
  explicit Object(GstObject* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:

  Object(Object&& src) noexcept;
  Object& operator=(Object&& src) noexcept;

  ~Object() noexcept override;

  /** Get the GType for this class, for use with the underlying GObject type system.
   */
  static GType get_type()      G_GNUC_CONST;

#ifndef DOXYGEN_SHOULD_SKIP_THIS


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GstObject*       gobj()       { return reinterpret_cast<GstObject*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GstObject* gobj() const { return reinterpret_cast<GstObject*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GstObject* gobj_copy();

private:

  
public:
  bool is_element() const;
  bool is_element_factory() const;
  bool is_pad() const;
  bool is_pad_template() const;
  bool is_bin() const;

  /** Returns the entire set of flags for the object.
   */
  guint32 get_flags() const;

//TODO: These conversions should probably be in the glibmm conversion files.
 

  /** Sets the name of @a object, or gives @a object a guaranteed unique
   * name (if @a name is <tt>nullptr</tt>).
   * This function makes a copy of the provided name, so the caller
   * retains ownership of the name it sent.
   * 
   * @param name New name of object.
   * @return <tt>true</tt> if the name could be set. Since Objects that have
   * a parent cannot be renamed, this function returns <tt>false</tt> in those
   * cases.
   * 
   * MT safe.  This function grabs and releases @a object's LOCK.
   */
  bool set_name(const Glib::ustring& name);
  
  /** Returns a copy of the name of @a object.
   * For a nameless object, this returns <tt>nullptr</tt>, which you can safely Glib::free()
   * as well.
   * 
   * Free-function: g_free
   * 
   * @return The name of @a object.
   * 
   * MT safe. This function grabs and releases @a object's LOCK.
   */
  Glib::ustring get_name() const;
  
  /** Sets the parent of @a object to @a parent. The object's reference count will
   * be incremented, and any floating reference will be removed (see ref_sink()).
   * 
   * @param parent New parent of object.
   * @return <tt>true</tt> if @a parent could be set or <tt>false</tt> when @a object
   * already had a parent or @a object and @a parent are the same.
   * 
   * MT safe. Grabs and releases @a object's LOCK.
   */
  bool set_parent(const Glib::RefPtr<Gst::Object>& parent);
  
  /** Returns the parent of @a object. This function increases the refcount
   * of the parent object so you should unref() it after usage.
   * 
   * @return Parent of @a object, this can be
   * <tt>nullptr</tt> if @a object has no parent. unref after usage.
   * 
   * MT safe. Grabs and releases @a object's LOCK.
   */
  Glib::RefPtr<Gst::Object> get_parent();
  
  /** Returns the parent of @a object. This function increases the refcount
   * of the parent object so you should unref() it after usage.
   * 
   * @return Parent of @a object, this can be
   * <tt>nullptr</tt> if @a object has no parent. unref after usage.
   * 
   * MT safe. Grabs and releases @a object's LOCK.
   */
  Glib::RefPtr<const Gst::Object> get_parent() const;
  
  /** Clear the parent of @a object, removing the associated reference.
   * This function decreases the refcount of @a object.
   * 
   * MT safe. Grabs and releases @a object's lock.
   */
  void unparent();

  
  /** Change the control-rate for this @a object. Audio processing Gst::Element
   * objects will use this rate to sub-divide their processing loop and call
   * sync_values() inbetween. The length of the processing segment
   * should be up to @a control-rate nanoseconds.
   * 
   * The control-rate should not change if the element is in Gst::STATE_PAUSED or
   * Gst::STATE_PLAYING.
   * 
   * @param control_rate The new control-rate in nanoseconds.
   */
  void set_control_rate(Gst::ClockTime control_rate);
  
  /** Obtain the control-rate for this @a object. Audio processing Gst::Element
   * objects will use this rate to sub-divide their processing loop and call
   * sync_values() inbetween. The length of the processing segment
   * should be up to @a control-rate nanoseconds.
   * 
   * If the @a object is not under property control, this will return
   * Gst::CLOCK_TIME_NONE. This allows the element to avoid the sub-dividing.
   * 
   * The control-rate is not expected to change if the element is in
   * Gst::STATE_PAUSED or Gst::STATE_PLAYING.
   * 
   * @return The control rate in nanoseconds.
   */
  Gst::ClockTime get_control_rate() const;
  
  /** Returns a suggestion for timestamps where buffers should be split
   * to get best controller results.
   * 
   * @return Returns the suggested timestamp or Gst::CLOCK_TIME_NONE
   * if no control-rate was set.
   */
  Gst::ClockTime suggest_next_sync() const;
  
  /** Sets the properties of the object, according to the Gst::ControlSources that
   * (maybe) handle them and for the given timestamp.
   * 
   * If this function fails, it is most likely the application developers fault.
   * Most probably the control sources are not setup correctly.
   * 
   * @param timestamp The time that should be processed.
   * @return <tt>true</tt> if the controller values could be applied to the object
   * properties, <tt>false</tt> otherwise.
   */
  bool sync_values(Gst::ClockTime timestamp);

  
  /** This function is used to disable all controlled properties of the @a object for
   * some time, i.e.\ sync_values() will do nothing.
   * 
   * @param disabled Boolean that specifies whether to disable the controller
   * or not.
   */
  void set_control_bindings_disabled(bool disabled);
  
  /** Check if the @a object has an active controlled properties.
   * 
   * @return <tt>true</tt> if the object has active controlled properties.
   */
  bool has_asctive_control_bindings() const;

  // Ignore default signal and error callback.
  

  /** Checks to see if there is any object named @a name in @a list. This function
   * does not do any locking of any kind. You might want to protect the
   * provided list with the lock of the owner of the list. This function
   * will lock each Gst::Object in the list to compare the name, so be
   * careful when passing a list with a locked object.
   * 
   * @param list A list of Gst::Object to
   * check through.
   * @param name The name to search for.
   * @return <tt>true</tt> if a Gst::Object named @a name does not appear in @a list,
   * <tt>false</tt> if it does.
   * 
   * MT safe. Grabs and releases the LOCK of each object in the list.
   */
  static bool check_uniqueness(const Glib::ListHandle<const Gst::Object>& list, const Glib::ustring& name);

  
  /** Check if @a object has an ancestor @a ancestor somewhere up in
   * the hierarchy. One can e.g. check if a Gst::Element is inside a Gst::Pipeline.
   * 
   * Deprecated: Use has_as_ancestor() instead.
   * 
   * MT safe. Grabs and releases @a object's locks.
   * 
   * @param ancestor A Gst::Object to check as ancestor.
   * @return <tt>true</tt> if @a ancestor is an ancestor of @a object.
   */
  bool has_ancestor(const Glib::RefPtr<const Gst::Object>& ancestor) const;
  
  /** Check if @a object has an ancestor @a ancestor somewhere up in
   * the hierarchy. One can e.g. check if a Gst::Element is inside a Gst::Pipeline.
   * 
   * @param ancestor A Gst::Object to check as ancestor.
   * @return <tt>true</tt> if @a ancestor is an ancestor of @a object.
   * 
   * MT safe. Grabs and releases @a object's locks.
   */
  bool has_as_ancestor(const Glib::RefPtr<Gst::Object>& ancestor) const;
  
  /** Check if @a parent is the parent of @a object.
   * E.g. a Gst::Element can check if it owns a given Gst::Pad.
   * 
   * @param parent A Gst::Object to check as parent.
   * @return <tt>false</tt> if either @a object or @a parent is <tt>nullptr</tt>. <tt>true</tt> if @a parent is
   * the parent of @a object. Otherwise <tt>false</tt>.
   * 
   * MT safe. Grabs and releases @a object's locks.
   */
  bool has_as_parent(const Glib::RefPtr<Gst::Object>& parent) const;

  
  /** Generates a string describing the path of @a object in
   * the object hierarchy. Only useful (or used) for debugging.
   * 
   * @return A string describing the path of @a object.
   * 
   * MT safe. Grabs and releases the Gst::Object's LOCK for all objects
   * in the hierarchy.
   */
  Glib::ustring get_path_string();

  /** The name of the object.
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Glib::ustring > property_name() ;

/** The name of the object.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::ustring > property_name() const;

  /** The parent of the object.
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Glib::RefPtr<Gst::Object> > property_parent() ;

/** The parent of the object.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::RefPtr<Gst::Object> > property_parent() const;


  //TODO: Maybe GParamSpec should be wrapped in glibmm?
  
  /**
   * @par Slot Prototype:
   * <tt>void on_my_%deep_notify(const Glib::RefPtr<Gst::Object>& prop_object, GParamSpec* prop)</tt>
   *
   * Flags: Run First
   *
   * The deep notify signal is used to be notified of property changes. It is
   * typically attached to the toplevel bin to receive notifications from all
   * the elements contained in that bin.
   * 
   * @param prop_object The object that originated the signal.
   * @param prop The property that changed.
   */

  Glib::SignalProxy< void,const Glib::RefPtr<Gst::Object>&,GParamSpec* > signal_deep_notify();


  int get_refcount() const;


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::
  /// This is a default handler for the signal signal_deep_notify().
  virtual void on_deep_notify(const Glib::RefPtr<Gst::Object>& prop_object, GParamSpec* prop);


};

} // namespace Gst


namespace Glib
{
  /** A Glib::wrap() method for this object.
   *
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gst::Object
   */
  
  Glib::RefPtr<Gst::Object> wrap(GstObject* object, bool take_copy = false);
}


#endif /* _GSTREAMERMM_OBJECT_H */

