/*
 * Decompiled with CFR 0.152.
 */
package jspecview.source;

import java.io.BufferedReader;
import java.io.IOException;
import javajs.util.SB;
import org.jmol.util.Logger;

public class JDXSourceStreamTokenizer {
    private BufferedReader br;
    String rawLabel;
    private String value;
    int labelLineNo = 0;
    String line;
    private int lineNo;

    JDXSourceStreamTokenizer(BufferedReader br) {
        this.br = br;
    }

    String peakLabel() {
        return this.nextLabel(false);
    }

    String getLabel() {
        return this.nextLabel(true);
    }

    private String nextLabel(boolean isGet) {
        int pt;
        this.rawLabel = null;
        this.value = null;
        while (this.line == null || this.line.length() == 0) {
            try {
                this.readLine();
                if (this.line == null) {
                    this.line = "";
                    return null;
                }
                this.line = this.line.trim();
            }
            catch (IOException e) {
                this.line = "";
                return null;
            }
            if (this.line.startsWith("##")) break;
            this.line = null;
        }
        if ((pt = this.line.indexOf("=")) < 0) {
            if (isGet) {
                Logger.info("BAD JDX LINE -- no '=' (line " + this.lineNo + "): " + this.line);
            }
            this.rawLabel = this.line;
            if (!isGet) {
                this.line = "";
            }
        } else {
            this.rawLabel = this.line.substring(0, pt).trim();
            if (isGet) {
                this.line = this.line.substring(pt + 1);
            }
        }
        this.labelLineNo = this.lineNo;
        if (Logger.debugging) {
            Logger.info(this.rawLabel);
        }
        return JDXSourceStreamTokenizer.cleanLabel(this.rawLabel);
    }

    public static String cleanLabel(String label) {
        if (label == null) {
            return null;
        }
        SB str = new SB();
        block3: for (int i = 0; i < label.length(); ++i) {
            switch (label.charAt(i)) {
                case ' ': 
                case '-': 
                case '/': 
                case '\\': 
                case '_': {
                    continue block3;
                }
                default: {
                    str.appendC(label.charAt(i));
                }
            }
        }
        return str.toString().toUpperCase();
    }

    public String getValue() {
        if (this.value != null) {
            return this.value;
        }
        SB sb = new SB().append(this.line);
        if (sb.length() > 0) {
            sb.appendC('\n');
        }
        try {
            while (!(this.readLine() == null || this.line.indexOf("##") >= 0 && this.line.trim().startsWith("##"))) {
                sb.append(this.line).appendC('\n');
            }
        }
        catch (IOException e) {
            Logger.info(e.toString());
        }
        String string = this.value = this.rawLabel.startsWith("##$") ? sb.toString().trim() : JDXSourceStreamTokenizer.trimLines(sb);
        if (Logger.debugging) {
            Logger.info(this.value);
        }
        return this.value;
    }

    public String readLineTrimmed() throws IOException {
        this.readLine();
        if (this.line == null) {
            return null;
        }
        if (this.line.indexOf("$$") < 0) {
            return this.line.trim();
        }
        SB sb = new SB().append(this.line);
        return JDXSourceStreamTokenizer.trimLines(sb);
    }

    String flushLine() {
        SB sb = new SB().append(this.line);
        this.line = null;
        return JDXSourceStreamTokenizer.trimLines(sb);
    }

    private String readLine() throws IOException {
        this.line = this.br.readLine();
        ++this.lineNo;
        return this.line;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static String trimLines(SB v) {
        int n = v.length();
        int ilast = n - 1;
        int vpt = JDXSourceStreamTokenizer.ptNonWhite(v, 0, n);
        if (vpt >= n) {
            return "";
        }
        char[] buffer = new char[n - vpt];
        int pt = 0;
        while (vpt < n) {
            block12: {
                int ch = v.charAt(vpt);
                switch (ch) {
                    case 13: {
                        if (vpt >= ilast || v.charAt(vpt + 1) != '\n') {
                            ch = 10;
                            break;
                        }
                        break block12;
                    }
                    case 10: {
                        if (pt > 0 && buffer[pt - 1] != '\n') {
                            pt -= vpt - JDXSourceStreamTokenizer.ptNonSpaceRev(v, vpt) - 1;
                        }
                        ++vpt;
                        vpt = JDXSourceStreamTokenizer.ptNonSpace(v, vpt, n) - 1;
                        break;
                    }
                    case 36: {
                        if (vpt >= ilast || v.charAt(vpt + 1) != '$') break;
                        ++vpt;
                        while (++vpt < n && "\n\r".indexOf(v.charAt(vpt)) < 0) {
                        }
                        break block12;
                    }
                }
                if (ch != 10 || pt <= 0 || buffer[pt - 1] != '\n') {
                    buffer[pt++] = ch;
                }
            }
            ++vpt;
        }
        if (pt > 0 && buffer[pt - 1] == '\n') {
            --pt;
        }
        return new String(buffer).substring(0, pt).trim();
    }

    private static int ptNonWhite(SB v, int pt, int n) {
        while (pt < n && Character.isWhitespace(v.charAt(pt))) {
            ++pt;
        }
        return pt;
    }

    private static int ptNonSpace(SB v, int pt, int n) {
        while (pt < n && (v.charAt(pt) == ' ' || v.charAt(pt) == '\t')) {
            ++pt;
        }
        return pt;
    }

    private static int ptNonSpaceRev(SB v, int pt) {
        while (--pt >= 0 && (v.charAt(pt) == ' ' || v.charAt(pt) == '\t')) {
        }
        return pt;
    }
}

