/*
 * Decompiled with CFR 0.152.
 */
package javajs.util;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.zip.CRC32;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javajs.J2SIgnoreImport;
import javajs.api.GenericZipInputStream;
import javajs.api.GenericZipTools;
import javajs.api.Interface;
import javajs.api.ZInputStream;
import javajs.util.BArray;
import javajs.util.Lst;
import javajs.util.Rdr;
import javajs.util.SB;
import org.apache.tools.bzip2.CBZip2InputStreamFactory;

@J2SIgnoreImport(value={ZipOutputStream.class})
public class ZipTools
implements GenericZipTools {
    private static byte[] b512;

    @Override
    public ZInputStream newZipInputStream(InputStream inputStream) {
        return (ZInputStream)((Object)ZipTools.newZIS(inputStream));
    }

    private static ZipInputStream newZIS(InputStream inputStream) {
        return inputStream instanceof ZipInputStream ? (ZipInputStream)inputStream : (inputStream instanceof BufferedInputStream ? new GenericZipInputStream(inputStream) : new GenericZipInputStream(new BufferedInputStream(inputStream)));
    }

    @Override
    @Deprecated
    public void getAllZipData(InputStream inputStream, String[] stringArray, String string, String string2, String string3, Map<String, String> map) {
    }

    @Override
    public Object getZipFileDirectory(BufferedInputStream bufferedInputStream, String[] stringArray, int n, boolean bl) {
        byte[] byArray;
        boolean bl2;
        block14: {
            ZipEntry zipEntry;
            String string;
            boolean bl3 = stringArray == null || n >= stringArray.length;
            String string2 = string = bl3 ? "." : stringArray[n];
            if (Rdr.isTar(bufferedInputStream)) {
                return ZipTools.getTarFileDirectory(bufferedInputStream, string, bl);
            }
            if (bl3) {
                return this.getZipDirectoryAsStringAndClose(bufferedInputStream);
            }
            bufferedInputStream = Rdr.getPngZipStream(bufferedInputStream, true);
            ZipInputStream zipInputStream = ZipTools.newZIS(bufferedInputStream);
            boolean bl4 = string.equals(".");
            if (bl4 || string.lastIndexOf("/") == string.length() - 1) {
                String string3;
                ZipEntry zipEntry2;
                SB sB = new SB();
                while ((zipEntry2 = zipInputStream.getNextEntry()) != null) {
                    string3 = zipEntry2.getName();
                    if (!bl4 && !string3.startsWith(string)) continue;
                    sB.append(string3).appendC('\n');
                }
                string3 = sB.toString();
                return bl ? Rdr.getBIS(string3.getBytes()) : string3;
            }
            int n2 = string.indexOf(":asBinaryString");
            boolean bl5 = bl2 = n2 > 0;
            if (bl2) {
                string = string.substring(0, n2);
            }
            string = string.replace('\\', '/');
            while ((zipEntry = zipInputStream.getNextEntry()) != null && !string.equals(zipEntry.getName())) {
            }
            byArray = zipEntry == null ? null : Rdr.getLimitedStreamBytes(zipInputStream, zipEntry.getSize());
            zipEntry = null;
            zipInputStream.close();
            if (byArray != null) break block14;
            return "";
        }
        try {
            if (Rdr.isZipB(byArray) || Rdr.isPngZipB(byArray)) {
                return this.getZipFileDirectory(Rdr.getBIS(byArray), stringArray, ++n, bl);
            }
            if (bl) {
                return Rdr.getBIS(byArray);
            }
            if (bl2) {
                SB sB = new SB();
                int n3 = 0;
                while (n3 < byArray.length) {
                    sB.append(Integer.toHexString(byArray[n3] & 0xFF)).appendC(' ');
                    ++n3;
                }
                return sB.toString();
            }
            if (Rdr.isGzipB(byArray)) {
                byArray = Rdr.getLimitedStreamBytes(this.getUnGzippedInputStream(byArray), -1L);
            }
            return Rdr.fixUTF(byArray);
        }
        catch (Exception exception) {
            return "";
        }
    }

    private static Object getTarFileDirectory(BufferedInputStream bufferedInputStream, String string, boolean bl) {
        try {
            boolean bl2 = string.equals(".");
            if (bl2 || string.lastIndexOf("/") == string.length() - 1) {
                SB sB = new SB();
                ZipTools.getTarContents(bufferedInputStream, string, sB);
                String string2 = sB.toString();
                return bl ? Rdr.getBIS(string2.getBytes()) : string2;
            }
            string = string.replace('\\', '/');
            byte[] byArray = ZipTools.getTarContents(bufferedInputStream, string, null);
            bufferedInputStream.close();
            return byArray == null ? "" : (bl ? Rdr.getBIS(byArray) : Rdr.fixUTF(byArray));
        }
        catch (Exception exception) {
            return "";
        }
    }

    public byte[] getZipFileContentsAsBytes(BufferedInputStream bufferedInputStream, String[] stringArray, int n) {
        byte[] byArray = new byte[]{};
        String string = stringArray[n];
        if (string.lastIndexOf("/") == string.length() - 1) {
            return byArray;
        }
        try {
            ZipEntry zipEntry;
            if (Rdr.isTar(bufferedInputStream)) {
                return ZipTools.getTarContents(bufferedInputStream, string, null);
            }
            bufferedInputStream = Rdr.getPngZipStream(bufferedInputStream, true);
            ZipInputStream zipInputStream = ZipTools.newZIS(bufferedInputStream);
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                if (!string.equals(zipEntry.getName())) continue;
                byte[] byArray2 = Rdr.getLimitedStreamBytes(zipInputStream, zipEntry.getSize());
                return (Rdr.isZipB(byArray2) || Rdr.isPngZipB(byArray2)) && ++n < stringArray.length ? this.getZipFileContentsAsBytes(Rdr.getBIS(byArray2), stringArray, n) : byArray2;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return byArray;
    }

    private static byte[] getTarContents(BufferedInputStream bufferedInputStream, String string, SB sB) throws IOException {
        if (b512 == null) {
            b512 = new byte[512];
        }
        int n = string.length();
        while (bufferedInputStream.read(b512, 0, 512) > 0) {
            byte[] byArray = ZipTools.getTarFile(bufferedInputStream, string, n, sB, null, false);
            if (byArray == null) continue;
            return byArray;
        }
        return null;
    }

    private static byte[] getTarFile(BufferedInputStream bufferedInputStream, String string, int n, SB sB, Map<String, Object> map, boolean bl) throws IOException {
        int n2 = 124;
        while (b512[n2] == 48) {
            ++n2;
        }
        boolean bl2 = sB != null && string.equals(".");
        int n3 = 0;
        while (n2 < 135) {
            n3 = (n3 << 3) + (b512[n2++] - 48);
        }
        if (n3 == 0) {
            return null;
        }
        String string2 = new String(b512, 0, 100).trim();
        String string3 = new String(b512, 345, 155).trim();
        String string4 = String.valueOf(string3) + string2;
        boolean bl3 = false;
        if (sB != null) {
            if (string4.length() == 0) {
                return null;
            }
            if (bl2 || (bl ? string4.equalsIgnoreCase(string) : string4.startsWith(string))) {
                bl3 = map != null;
                sB.append(string4).appendC('\n');
            }
            n = -1;
        }
        int n4 = (512 - n3 % 512) % 512;
        if (!(bl3 || n == string4.length() && string.equals(string4))) {
            int n5;
            int n6 = n5 = n3 + n4 >> 9;
            while (--n6 >= 0) {
                bufferedInputStream.read(b512, 0, 512);
            }
            return null;
        }
        byte[] byArray = Rdr.getLimitedStreamBytes(bufferedInputStream, n3);
        if (map != null) {
            map.put(string4, new BArray(byArray));
            bufferedInputStream.read(b512, 0, n4);
        }
        return byArray;
    }

    @Override
    public String getZipDirectoryAsStringAndClose(BufferedInputStream bufferedInputStream) {
        SB sB = new SB();
        String[] stringArray = new String[]{};
        try {
            stringArray = this.getZipDirectoryOrErrorAndClose(bufferedInputStream, null);
            bufferedInputStream.close();
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
        }
        int n = 0;
        while (n < stringArray.length) {
            sB.append(stringArray[n]).appendC('\n');
            ++n;
        }
        return sB.toString();
    }

    @Override
    public String[] getZipDirectoryAndClose(BufferedInputStream bufferedInputStream, String string) {
        String[] stringArray = new String[]{};
        try {
            stringArray = this.getZipDirectoryOrErrorAndClose(bufferedInputStream, string);
            bufferedInputStream.close();
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
        }
        return stringArray;
    }

    private String[] getZipDirectoryOrErrorAndClose(BufferedInputStream bufferedInputStream, String string) throws IOException {
        ZipEntry zipEntry;
        bufferedInputStream = Rdr.getPngZipStream(bufferedInputStream, true);
        Lst<String> lst = new Lst<String>();
        ZipInputStream zipInputStream = ZipTools.newZIS(bufferedInputStream);
        String string2 = null;
        while ((zipEntry = zipInputStream.getNextEntry()) != null) {
            String string3 = zipEntry.getName();
            if (string != null && string3.startsWith(string)) {
                string2 = ZipTools.getStreamAsString(zipInputStream);
                continue;
            }
            if (string3.startsWith("__MACOS")) continue;
            lst.addLast(string3);
        }
        zipInputStream.close();
        if (string != null) {
            lst.add(0, string2 == null ? "" : String.valueOf(string2) + "\n############\n");
        }
        return lst.toArray(new String[lst.size()]);
    }

    public static String getStreamAsString(InputStream inputStream) throws IOException {
        return Rdr.fixUTF(Rdr.getLimitedStreamBytes(inputStream, -1L));
    }

    @Override
    public InputStream newGZIPInputStream(InputStream inputStream) throws IOException {
        return new BufferedInputStream(new GZIPInputStream(inputStream, 512));
    }

    @Override
    public InputStream newBZip2InputStream(InputStream inputStream) throws IOException {
        return new BufferedInputStream((InputStream)((CBZip2InputStreamFactory)Interface.getInterface("org.apache.tools.bzip2.CBZip2InputStreamFactory")).getStream(inputStream));
    }

    @Override
    public BufferedInputStream getUnGzippedInputStream(byte[] byArray) {
        try {
            return Rdr.getUnzippedInputStream(this, Rdr.getBIS(byArray));
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public void addZipEntry(Object object, String string) throws IOException {
        ((ZipOutputStream)object).putNextEntry(new ZipEntry(string));
    }

    @Override
    public void closeZipEntry(Object object) throws IOException {
        ((ZipOutputStream)object).closeEntry();
    }

    @Override
    public Object getZipOutputStream(Object object) {
        return new ZipOutputStream((OutputStream)object);
    }

    @Override
    public int getCrcValue(byte[] byArray) {
        CRC32 cRC32 = new CRC32();
        cRC32.update(byArray, 0, byArray.length);
        return (int)cRC32.getValue();
    }

    @Override
    public void readFileAsMap(BufferedInputStream bufferedInputStream, Map<String, Object> map, String string) {
        ZipTools.readFileAsMapStatic(bufferedInputStream, map, string);
    }

    private static void readFileAsMapStatic(BufferedInputStream bufferedInputStream, Map<String, Object> map, String string) {
        int n = string == null ? -1 : string.indexOf("|");
        string = n >= 0 ? string.substring(n + 1) : null;
        try {
            boolean bl = false;
            if (Rdr.isPngZipStream(bufferedInputStream)) {
                boolean bl2 = "_IMAGE_".equals(string);
                if (string == null || bl2) {
                    map.put(bl2 ? "_DATA_" : "_IMAGE_", new BArray(ZipTools.getPngImageBytes(bufferedInputStream)));
                }
                bl = !bl2;
            } else if (Rdr.isZipS(bufferedInputStream)) {
                bl = true;
            } else if (Rdr.isTar(bufferedInputStream)) {
                ZipTools.cacheTarContentsStatic(bufferedInputStream, string, map);
            } else if (string == null) {
                map.put("_DATA_", new BArray(Rdr.getLimitedStreamBytes(bufferedInputStream, -1L)));
            } else {
                throw new IOException("ZIP file " + string + " not found");
            }
            if (bl) {
                ZipTools.cacheZipContentsStatic(bufferedInputStream, string, map, true);
            }
            map.put("$_BINARY_$", Boolean.TRUE);
        }
        catch (IOException iOException) {
            map.clear();
            map.put("_ERROR_", iOException.getMessage());
        }
    }

    private static String cacheTarContentsStatic(BufferedInputStream bufferedInputStream, String string, Map<String, Object> map) {
        SB sB = new SB();
        long l = 0L;
        if (string != null && string.endsWith("/.")) {
            string = string.substring(0, string.length() - 1);
        }
        boolean bl = string != null && string.endsWith("/");
        boolean bl2 = string != null && !bl;
        try {
            if (b512 == null) {
                b512 = new byte[512];
            }
            while (bufferedInputStream.read(b512, 0, 512) > 0) {
                byte[] byArray = ZipTools.getTarFile(bufferedInputStream, string == null ? "." : string, -1, sB, map, bl2);
                if (byArray == null) continue;
                l += (long)byArray.length;
                if (bl2) break;
            }
            bufferedInputStream.close();
        }
        catch (Exception exception) {
            try {
                bufferedInputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return null;
        }
        if (l == 0L || string == null) {
            return null;
        }
        System.out.println("ZipTools cached " + l + " bytes from " + string);
        return sB.toString();
    }

    @Override
    public String cacheZipContents(BufferedInputStream bufferedInputStream, String string, Map<String, Object> map, boolean bl) {
        return ZipTools.cacheZipContentsStatic(bufferedInputStream, string, map, bl);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String cacheZipContentsStatic(BufferedInputStream bufferedInputStream, String string, Map<String, Object> map, boolean bl) {
        String string2;
        ZipInputStream zipInputStream = ZipTools.newZIS(bufferedInputStream);
        SB sB = new SB();
        long l = 0L;
        if (string != null && string.endsWith("/.")) {
            string = string.substring(0, string.length() - 1);
        }
        boolean bl2 = string != null && string.endsWith("/");
        boolean bl3 = string != null && !bl2 && bl;
        int n = bl3 ? string.indexOf("|") : -1;
        String string3 = string2 = n >= 0 ? string : null;
        if (n >= 0) {
            string = string.substring(0, n);
        }
        String string4 = string == null || bl2 ? "" : String.valueOf(string) + "|";
        try {
            ZipEntry zipEntry;
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                Object object;
                if (zipEntry.isDirectory()) continue;
                String string5 = zipEntry.getName();
                if (string != null) {
                    if (bl3) {
                        if (!string5.equalsIgnoreCase(string)) {
                            continue;
                        }
                    } else {
                        if (bl2 && !string5.startsWith(string)) continue;
                        sB.append(string5).appendC('\n');
                    }
                }
                long l2 = zipEntry.getSize();
                byte[] byArray = Rdr.getLimitedStreamBytes(zipInputStream, l2);
                if (string2 != null) {
                    ZipTools.readFileAsMapStatic(Rdr.getBIS(byArray), map, string2);
                    return null;
                }
                l += (long)byArray.length;
                if (bl) {
                    BArray bArray;
                    object = bArray;
                    bArray = new BArray(byArray);
                } else {
                    object = byArray;
                }
                Object object2 = object;
                map.put(bl3 ? "_DATA_" : String.valueOf(string4) + string5, object2);
                if (!bl3) continue;
            }
            zipInputStream.close();
        }
        catch (Exception exception) {
            try {
                zipInputStream.close();
                return null;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return null;
        }
        if (l == 0L) return null;
        if (string == null) {
            return null;
        }
        System.out.println("ZipTools cached " + l + " bytes from " + string);
        return sB.toString();
    }

    private static byte[] getPngImageBytes(BufferedInputStream bufferedInputStream) {
        try {
            if (Rdr.isPngZipStream(bufferedInputStream)) {
                int[] nArray = new int[2];
                Rdr.getPngZipPointAndCount(bufferedInputStream, nArray);
                if (nArray[1] != 0) {
                    return ZipTools.deActivatePngZipB(Rdr.getLimitedStreamBytes(bufferedInputStream, nArray[0]));
                }
            }
            return Rdr.getLimitedStreamBytes(bufferedInputStream, -1L);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private static byte[] deActivatePngZipB(byte[] byArray) {
        if (Rdr.isPngZipB(byArray)) {
            byArray[51] = 32;
        }
        return byArray;
    }
}

