/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.xml;

import javajs.util.BS;
import javajs.util.PT;
import org.jmol.adapter.readers.xml.XmlReader;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.Bond;
import org.jmol.api.JmolAdapter;

public class XmlChemDrawReader
extends XmlReader {
    private float minX = Float.MAX_VALUE;
    private float minY = Float.MAX_VALUE;
    private float minZ = Float.MAX_VALUE;
    private float maxZ = -3.4028235E38f;
    private float maxY = -3.4028235E38f;
    private float maxX = -3.4028235E38f;
    private boolean no3D;

    @Override
    protected void processXml(XmlReader parent, Object saxReader) throws Exception {
        this.is2D = true;
        this.no3D = parent.checkFilterKey("NO3D");
        this.noHydrogens = parent.noHydrogens;
        this.processXml2(parent, saxReader);
        this.filter = parent.filter;
    }

    @Override
    public void processStartElement(String localName, String nodeName) {
        if ("fragment".equals(localName)) {
            return;
        }
        if ("n".equals(localName)) {
            String isotope;
            if (this.asc.bsAtoms == null) {
                this.asc.bsAtoms = new BS();
            }
            String id = (String)this.atts.get("id");
            String nodeType = (String)this.atts.get("nodetype");
            this.atom = new CDAtom(id, nodeType);
            String warning = (String)this.atts.get("warning");
            if (warning != null) {
                ((CDAtom)this.atom).warning = PT.rep(warning, "&apos;", "'");
                ((CDAtom)this.atom).isValid = warning.indexOf("ChemDraw can't interpret") < 0;
            }
            String element = (String)this.atts.get("element");
            this.atom.elementNumber = (short)(warning != null && warning.indexOf("valence") < 0 && warning.indexOf("very close") < 0 ? 0 : (element == null ? 6 : this.parseIntStr(element)));
            element = JmolAdapter.getElementSymbol(this.atom.elementNumber);
            if (this.atom.elementNumber == 0) {
                System.err.println("XmlChemDrawReader: Could not read elementSymbol for " + element);
            }
            if ((isotope = (String)this.atts.get("isotope")) != null) {
                element = isotope + element;
            }
            this.setElementAndIsotope(this.atom, element);
            String s = (String)this.atts.get("charge");
            if (s != null) {
                this.atom.formalCharge = this.parseIntStr(s);
            }
            boolean hasXYZ = this.atts.containsKey("xyz");
            boolean hasXY = this.atts.containsKey("p");
            if (!(!hasXYZ || this.no3D && hasXY)) {
                this.is2D = false;
                this.setAtom("xyz");
            } else if (this.atts.containsKey("p")) {
                this.setAtom("p");
            }
            this.asc.addAtomWithMappedSerialNumber(this.atom);
            this.asc.bsAtoms.set(this.atom.index);
            return;
        }
        if ("s".equals(localName) && ((CDAtom)this.atom).warning != null) {
            this.setKeepChars(true);
        }
        if ("b".equals(localName)) {
            String atom1 = (String)this.atts.get("b");
            String atom2 = (String)this.atts.get("e");
            boolean invertEnds = false;
            int order = this.atts.containsKey("order") ? this.parseIntStr((String)this.atts.get("order")) : 1;
            String buf = (String)this.atts.get("display");
            if (buf != null) {
                if (buf.equals("WedgeEnd")) {
                    invertEnds = true;
                    order = 1025;
                } else if (buf.equals("WedgeBegin")) {
                    order = 1025;
                } else if (buf.equals("Hash") || buf.equals("WedgedHashBegin")) {
                    order = 1041;
                } else if (buf.equals("WedgedHashEnd")) {
                    invertEnds = true;
                    order = 1041;
                }
            }
            this.asc.addBondNoCheck(new CDBond(invertEnds ? atom2 : atom1, invertEnds ? atom1 : atom2, order));
            return;
        }
    }

    private void setAtom(String key) {
        float z;
        String xyz = (String)this.atts.get(key);
        String[] tokens = PT.getTokens(xyz);
        float x = this.parseFloatStr(tokens[0]);
        float y = -this.parseFloatStr(tokens[1]);
        float f = z = key == "xyz" ? this.parseFloatStr(tokens[2]) : 0.0f;
        if (x < this.minX) {
            this.minX = x;
        }
        if (x > this.maxX) {
            this.maxX = x;
        }
        if (y < this.minY) {
            this.minY = y;
        }
        if (y > this.maxY) {
            this.maxY = y;
        }
        if (z < this.minZ) {
            this.minZ = z;
        }
        if (z > this.maxZ) {
            this.maxZ = z;
        }
        this.atom.set(x, y, z);
    }

    @Override
    void processEndElement(String localName) {
        String w;
        if ("s".equals(localName) && (w = ((CDAtom)this.atom).warning) != null) {
            String group = this.chars.toString();
            this.parent.appendLoadNote("Warning: " + group + " " + w);
        }
        this.setKeepChars(false);
    }

    @Override
    protected void finalizeSubclassReader() throws Exception {
        this.fixConnections();
        this.fixInvalidAtoms();
        this.center();
        this.asc.setInfo("minimize3D", !this.is2D && !this.noHydrogens);
        this.set2D();
        this.asc.setInfo("is2D", this.is2D);
        if (this.is2D) {
            this.asc.setModelInfoForSet("dimension", "2D", this.asc.iSet);
        }
        this.parent.appendLoadNote("ChemDraw CDXML: " + (this.is2D ? "2D" : "3D"));
    }

    private void fixConnections() {
        int n = this.asc.bondCount;
        for (int i = 0; i < n; ++i) {
            CDAtom pt;
            Bond b = this.asc.bonds[i];
            if (b == null) continue;
            CDAtom a1 = (CDAtom)this.asc.getAtomFromName(((CDBond)b).id1);
            CDAtom a2 = (CDAtom)this.asc.getAtomFromName(((CDBond)b).id2);
            a1.isConnected = true;
            a2.isConnected = true;
            CDAtom cDAtom = a1.isFragment || a1.isNickname || a1.isConnectionPt ? a1 : (pt = a2.isFragment || a2.isNickname || a2.isConnectionPt ? a2 : null);
            if (pt != null) {
                int j = this.asc.bsAtoms.nextSetBit(0);
                while (j >= 0) {
                    CDAtom a = (CDAtom)this.asc.atoms[j];
                    if (!a.isFragment && !a.isNickname && (double)Math.abs(a.x - pt.x) < 0.1 && (double)Math.abs(a.y - pt.y) < 0.1) {
                        if (pt == a1) {
                            a1 = a;
                            break;
                        }
                        a2 = a;
                        break;
                    }
                    j = this.asc.bsAtoms.nextSetBit(j + 1);
                }
            }
            b.atomIndex1 = a1.index;
            b.atomIndex2 = a2.index;
        }
    }

    private void center() {
        float f;
        if (this.minX > this.maxX) {
            return;
        }
        float sum = 0.0f;
        int n = 0;
        float lenH = 1.0f;
        int i = this.asc.bondCount;
        while (--i >= 0) {
            Atom a1 = this.asc.atoms[this.asc.bonds[i].atomIndex1];
            Atom a2 = this.asc.atoms[this.asc.bonds[i].atomIndex2];
            float d = a1.distance(a2);
            if (a1.elementNumber > 1 && a2.elementNumber > 1) {
                sum += d;
                ++n;
                continue;
            }
            lenH = d;
        }
        float f2 = sum > 0.0f ? 1.45f * (float)n / sum : (f = lenH > 0.0f ? 1.0f / lenH : 1.0f);
        if ((double)f > 0.5) {
            f = 1.0f;
        }
        float cx = (this.maxX + this.minX) / 2.0f;
        float cy = (this.maxY + this.minY) / 2.0f;
        float cz = (this.maxZ + this.minZ) / 2.0f;
        int i2 = this.asc.ac;
        while (--i2 >= 0) {
            Atom a = this.asc.atoms[i2];
            a.x = (a.x - cx) * f;
            a.y = (a.y - cy) * f;
            a.z = (a.z - cz) * f;
        }
    }

    private void fixInvalidAtoms() {
        int i = this.asc.ac;
        while (--i >= 0) {
            CDAtom a = (CDAtom)this.asc.atoms[i];
            a.atomSerial = Integer.MIN_VALUE;
            if (!a.isFragment && !a.isNickname && !a.isConnectionPt && (a.isValid || a.isConnected)) continue;
            System.out.println("removing atom " + a.id + " " + a.nodeType);
            this.asc.bsAtoms.clear(a.index);
        }
    }

    static class CDBond
    extends Bond {
        String id1;
        String id2;

        CDBond(String id1, String id2, int order) {
            this.id1 = id1;
            this.id2 = id2;
            this.order = order;
        }
    }

    static class CDAtom
    extends Atom {
        String warning;
        String id;
        boolean isValid = true;
        boolean isConnected;
        boolean isFragment;
        boolean isNickname;
        boolean isConnectionPt;
        String nodeType;

        CDAtom(String id, String nodeType) {
            this.id = id;
            this.atomSerial = Integer.parseInt(id);
            this.nodeType = nodeType;
            this.isFragment = "Fragment".equals(nodeType);
            this.isNickname = "Nickname".equals(nodeType);
            this.isConnectionPt = "ExternalConnectionPoint".equals(nodeType);
        }
    }
}

