/*
 * Decompiled with CFR 0.152.
 */
package mediathek.javafx.downloadtab;

import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.layout.HBox;
import mediathek.config.Daten;
import mediathek.daten.DownloadStartInfo;
import mediathek.daten.ListeDownloads;
import mediathek.gui.messages.TimerEvent;
import mediathek.gui.messages.UpdateStatusBarLeftDisplayEvent;
import mediathek.javafx.CenteredBorderPane;
import mediathek.javafx.InfoLabel.AboLabel;
import mediathek.javafx.InfoLabel.ActiveDownloadsLabel;
import mediathek.javafx.InfoLabel.ErrorLabel;
import mediathek.javafx.InfoLabel.FinishedLabel;
import mediathek.javafx.InfoLabel.GesamtdownloadsLabel;
import mediathek.javafx.InfoLabel.NumDownloadsLabel;
import mediathek.javafx.InfoLabel.WaitingLabel;
import mediathek.javafx.VerticalSeparator;
import mediathek.tool.MessageBus;
import net.engio.mbassy.listener.Handler;

public class DownloadTabInformationLabel
extends HBox {
    private final Daten daten;
    private final GesamtdownloadsLabel overallDownloadLabel = new GesamtdownloadsLabel();
    private final AboLabel aboLabel = new AboLabel();
    private final NumDownloadsLabel numDownloadsLabel = new NumDownloadsLabel();
    private final ActiveDownloadsLabel activeDownloadLabel = new ActiveDownloadsLabel();
    private final WaitingLabel waitingLabel = new WaitingLabel();
    private final FinishedLabel finishedLabel = new FinishedLabel();
    private final ErrorLabel errorLabel = new ErrorLabel();
    private final HBox finishedBox = new HBox();
    private final HBox waitingBox = new HBox();
    private final HBox activeBox = new HBox();

    public DownloadTabInformationLabel(Daten daten) {
        this.daten = daten;
        this.setupListeners();
        this.initLayout();
    }

    private void setupListeners() {
        if (this.isVisible()) {
            MessageBus.getMessageBus().subscribe(this);
        }
        this.visibleProperty().addListener(new ChangeListener<Boolean>(){

            @Override
            public void changed(ObservableValue<? extends Boolean> observable2, Boolean oldValue, Boolean newValue) {
                if (newValue.booleanValue()) {
                    MessageBus.getMessageBus().subscribe(this);
                } else {
                    MessageBus.getMessageBus().unsubscribe(this);
                }
            }
        });
    }

    private void initLayout() {
        this.finishedBox.getChildren().addAll((Node[])new Node[]{new CenteredBorderPane((Node)this.finishedLabel), new VerticalSeparator()});
        this.waitingBox.getChildren().addAll((Node[])new Node[]{new CenteredBorderPane((Node)this.waitingLabel), new VerticalSeparator()});
        this.activeBox.getChildren().addAll((Node[])new Node[]{new CenteredBorderPane((Node)this.activeDownloadLabel), new VerticalSeparator()});
        this.getChildren().addAll((Node[])new Node[]{new CenteredBorderPane((Node)this.overallDownloadLabel), new VerticalSeparator(), new CenteredBorderPane((Node)this.aboLabel), new VerticalSeparator(), new CenteredBorderPane((Node)this.numDownloadsLabel), new VerticalSeparator(), this.activeBox, this.waitingBox, this.finishedBox, new CenteredBorderPane((Node)this.errorLabel)});
    }

    @Handler
    private void handleLeftDisplayUpdate(UpdateStatusBarLeftDisplayEvent e) {
        Platform.runLater(this::getInfoTextDownloads);
    }

    @Handler
    private void handleTimerEvent(TimerEvent e) {
        Platform.runLater(this::getInfoTextDownloads);
    }

    private void getInfoTextDownloads() {
        ListeDownloads listeDownloads = this.daten.getListeDownloads();
        DownloadStartInfo info = listeDownloads.getStarts();
        ObservableList<Node> children = this.getChildren();
        this.overallDownloadLabel.updateLabel(listeDownloads, info);
        this.aboLabel.updateLabel(info);
        this.numDownloadsLabel.updateLabel(info);
        if (info.running > 0) {
            if (!children.contains(this.activeBox)) {
                children.add(this.activeBox);
            }
            this.activeDownloadLabel.updateLabel(this.daten, info);
        } else {
            children.remove(this.activeBox);
        }
        if (info.initialized > 0) {
            if (!children.contains(this.waitingBox)) {
                children.add(this.waitingBox);
            }
            this.waitingLabel.updateLabel(info);
        } else {
            children.remove(this.waitingBox);
        }
        if (info.finished > 0) {
            if (!children.contains(this.finishedBox)) {
                children.add(this.finishedBox);
            }
            this.finishedLabel.updateLabel(info);
        } else {
            children.remove(this.finishedBox);
        }
        if (info.error > 0) {
            if (!children.contains(this.errorLabel)) {
                children.add(new CenteredBorderPane((Node)this.errorLabel));
            }
            this.errorLabel.updateLabel(info);
        } else {
            children.remove(this.errorLabel);
        }
    }
}

