/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.openapidiff.core.compare.schemadiffresult;

import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.media.Schema;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.openapitools.openapidiff.core.compare.ListDiff;
import org.openapitools.openapidiff.core.compare.MapKeyDiff;
import org.openapitools.openapidiff.core.compare.OpenApiDiff;
import org.openapitools.openapidiff.core.model.Change;
import org.openapitools.openapidiff.core.model.Changed;
import org.openapitools.openapidiff.core.model.ChangedSchema;
import org.openapitools.openapidiff.core.model.DiffContext;
import org.openapitools.openapidiff.core.model.deferred.DeferredBuilder;
import org.openapitools.openapidiff.core.model.deferred.DeferredChanged;
import org.openapitools.openapidiff.core.model.deferred.RecursiveSchemaSet;
import org.openapitools.openapidiff.core.model.schema.ChangedEnum;
import org.openapitools.openapidiff.core.model.schema.ChangedMaxLength;
import org.openapitools.openapidiff.core.model.schema.ChangedReadOnly;
import org.openapitools.openapidiff.core.model.schema.ChangedRequired;
import org.openapitools.openapidiff.core.model.schema.ChangedWriteOnly;
import org.openapitools.openapidiff.core.utils.ChangedUtils;

public class SchemaDiffResult {
    protected ChangedSchema changedSchema;
    protected OpenApiDiff openApiDiff;

    public SchemaDiffResult(OpenApiDiff openApiDiff) {
        this.openApiDiff = openApiDiff;
        this.changedSchema = new ChangedSchema();
    }

    public SchemaDiffResult(String type, OpenApiDiff openApiDiff) {
        this(openApiDiff);
        this.changedSchema.setType(type);
    }

    public <V extends Schema<X>, X> DeferredChanged<ChangedSchema> diff(RecursiveSchemaSet refSet, Components leftComponents, Components rightComponents, V left, V right, DiffContext context) {
        DeferredBuilder<Changed> builder = new DeferredBuilder<Changed>();
        ChangedEnum<X> changedEnum = ListDiff.diff(new ChangedEnum<X>(left.getEnum(), right.getEnum(), context));
        this.changedSchema.setContext(context).setOldSchema(left).setNewSchema(right).setChangeDeprecated(!Boolean.TRUE.equals(left.getDeprecated()) && Boolean.TRUE.equals(right.getDeprecated())).setChangeTitle(!Objects.equals(left.getTitle(), right.getTitle())).setRequired(ListDiff.diff(new ChangedRequired(left.getRequired(), right.getRequired(), context))).setChangeDefault(!Objects.equals(left.getDefault(), right.getDefault())).setEnumeration(changedEnum).setChangeFormat(!Objects.equals(left.getFormat(), right.getFormat())).setReadOnly(new ChangedReadOnly(left.getReadOnly(), right.getReadOnly(), context)).setWriteOnly(new ChangedWriteOnly(left.getWriteOnly(), right.getWriteOnly(), context)).setMaxLength(new ChangedMaxLength(left.getMaxLength(), right.getMaxLength(), context));
        builder.with(this.openApiDiff.getExtensionsDiff().diff(left.getExtensions(), right.getExtensions(), context)).ifPresent(this.changedSchema::setExtensions);
        builder.with(this.openApiDiff.getMetadataDiff().diff(left.getDescription(), right.getDescription(), context)).ifPresent(this.changedSchema::setDescription);
        Map<String, Schema> leftProperties = left.getProperties();
        Map<String, Schema> rightProperties = right.getProperties();
        MapKeyDiff<String, Schema> propertyDiff = MapKeyDiff.diff(leftProperties, rightProperties);
        for (String key : propertyDiff.getSharedKey()) {
            builder.with(this.openApiDiff.getSchemaDiff().diff(refSet, leftProperties.get(key), rightProperties.get(key), this.required(context, key, right.getRequired()))).ifPresent(changedSchema1 -> this.changedSchema.getChangedProperties().put(key, (ChangedSchema)changedSchema1));
        }
        this.compareAdditionalProperties(refSet, left, right, context, builder);
        this.changedSchema.getIncreasedProperties().putAll(this.filterProperties(Change.Type.ADDED, propertyDiff.getIncreased(), context));
        this.changedSchema.getMissingProperties().putAll(this.filterProperties(Change.Type.REMOVED, propertyDiff.getMissing(), context));
        return builder.build().mapOptional(values -> this.isApplicable(context));
    }

    protected Optional<ChangedSchema> isApplicable(DiffContext context) {
        if (this.changedSchema.getReadOnly().isUnchanged() && this.changedSchema.getWriteOnly().isUnchanged() && !this.isPropertyApplicable(this.changedSchema.getNewSchema(), context)) {
            return Optional.empty();
        }
        return ChangedUtils.isChanged(this.changedSchema);
    }

    private Map<String, Schema<?>> filterProperties(Change.Type type, Map<String, Schema> properties, DiffContext context) {
        LinkedHashMap result = new LinkedHashMap();
        for (Map.Entry<String, Schema> entry : properties.entrySet()) {
            if (this.isPropertyApplicable(entry.getValue(), context) && this.openApiDiff.getExtensionsDiff().isParentApplicable(type, entry.getValue(), Optional.ofNullable(entry.getValue().getExtensions()).orElse(new LinkedHashMap()), context)) {
                result.put(entry.getKey(), entry.getValue());
                continue;
            }
            this.changedSchema.getRequired().getIncreased().remove(entry.getKey());
        }
        return result;
    }

    private boolean isPropertyApplicable(Schema<?> schema, DiffContext context) {
        return !(context.isResponse() && Boolean.TRUE.equals(schema.getWriteOnly()) || context.isRequest() && Boolean.TRUE.equals(schema.getReadOnly()));
    }

    private DiffContext required(DiffContext context, String key, List<String> required) {
        return context.copyWithRequired(required != null && required.contains(key));
    }

    private void compareAdditionalProperties(RecursiveSchemaSet refSet, Schema<?> leftSchema, Schema<?> rightSchema, DiffContext context, DeferredBuilder<Changed> builder) {
        Object left = leftSchema.getAdditionalProperties();
        Object right = rightSchema.getAdditionalProperties();
        if (left instanceof Schema || right instanceof Schema) {
            Schema leftAdditionalSchema = left instanceof Schema ? (Schema)left : null;
            Schema rightAdditionalSchema = right instanceof Schema ? (Schema)right : null;
            ChangedSchema apChangedSchema = new ChangedSchema().setContext(context).setOldSchema(leftAdditionalSchema).setNewSchema(rightAdditionalSchema);
            if (left != null && right != null) {
                DeferredChanged<ChangedSchema> addPropChangedSchemaOP = this.openApiDiff.getSchemaDiff().diff(refSet, leftAdditionalSchema, rightAdditionalSchema, context.copyWithRequired(false));
                builder.with(addPropChangedSchemaOP).whenSet(optional -> {
                    ChangedSchema apc = optional.orElse(apChangedSchema);
                    ChangedUtils.isChanged(apc).ifPresent(this.changedSchema::setAddProp);
                });
            } else {
                ChangedUtils.isChanged(apChangedSchema).ifPresent(this.changedSchema::setAddProp);
            }
        }
    }

    public ChangedSchema getChangedSchema() {
        return this.changedSchema;
    }

    public OpenApiDiff getOpenApiDiff() {
        return this.openApiDiff;
    }
}

