/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.owlapi.concurrent;

import java.util.concurrent.locks.ReadWriteLock;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyBuilder;
import org.semanticweb.owlapi.model.OWLOntologyID;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import uk.ac.manchester.cs.owl.owlapi.concurrent.ConcurrentOWLOntologyImpl;
import uk.ac.manchester.cs.owl.owlapi.concurrent.NonConcurrentDelegate;

public class ConcurrentOWLOntologyBuilder
implements OWLOntologyBuilder {
    private final OWLOntologyBuilder builder;
    private ReadWriteLock readWriteLock;

    @Inject
    public ConcurrentOWLOntologyBuilder(@NonConcurrentDelegate OWLOntologyBuilder builder, ReadWriteLock readWriteLock) {
        this.builder = OWLAPIPreconditions.verifyNotNull(builder);
        this.readWriteLock = OWLAPIPreconditions.verifyNotNull(readWriteLock);
    }

    @Override
    @Nonnull
    public OWLOntology createOWLOntology(@Nonnull OWLOntologyManager manager, @Nonnull OWLOntologyID ontologyID) {
        OWLOntology owlOntology = this.builder.createOWLOntology(manager, ontologyID);
        return new ConcurrentOWLOntologyImpl(owlOntology, this.readWriteLock);
    }

    @Override
    public void setLock(ReadWriteLock lock) {
        this.readWriteLock = lock;
    }
}

