/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.deprecation;

import com.google.common.base.Preconditions;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.ui.AbstractOWLWizardPanel;
import org.protege.editor.owl.ui.deprecation.DeprecateEntityWizardState;
import org.protege.editor.owl.ui.find.EntityFinderField;
import org.protege.editor.owl.ui.renderer.OWLCellRenderer;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLObject;

public class AlternateEntitiesPage
extends AbstractOWLWizardPanel {
    public static final String ID = "AlternateEntitiesPage";
    private final JButton addButton = new JButton("Add");
    private final JList<OWLEntity> entityList = new JList();
    private final List<OWLEntity> listData = new ArrayList<OWLEntity>();
    private final JButton removeButton = new JButton("Remove");
    private OWLEntity lastFoundEntity = null;
    private final EntityFinderField finderField;
    private final DeprecateEntityWizardState state;

    public AlternateEntitiesPage(@Nonnull OWLEditorKit editorKit, @Nonnull DeprecateEntityWizardState state) {
        super(ID, "Alternate entities", editorKit);
        this.state = (DeprecateEntityWizardState)Preconditions.checkNotNull((Object)state);
        this.setInstructions("You have chosen <emph>not</emph> to replace the deprecated entity with a different entity.  Please enter a list of alternate entities that should be considered by consumers of this ontology.");
        JPanel content = new JPanel(new GridBagLayout());
        this.finderField = new EntityFinderField(content, this.getOWLEditorKit());
        this.finderField.setEntityFoundHandler(entity -> {
            this.finderField.setText(this.getOWLModelManager().getRendering((OWLObject)entity));
            this.lastFoundEntity = entity;
            this.addButton.setEnabled(true);
        });
        this.addButton.setEnabled(false);
        this.finderField.setSearchStartedHandler(() -> {
            this.lastFoundEntity = null;
            this.addButton.setEnabled(false);
        });
        Insets insets = new Insets(1, 1, 1, 1);
        content.add((Component)((Object)this.finderField), new GridBagConstraints(0, 0, 1, 1, 100.0, 0.0, 512, 2, insets, 0, 0));
        content.add((Component)this.addButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 512, 2, insets, 0, 0));
        this.addButton.addActionListener(e -> {
            this.listData.add(this.lastFoundEntity);
            this.updateEntityList();
            this.addButton.setEnabled(false);
            this.finderField.setText("");
            this.finderField.requestFocus();
        });
        content.add((Component)new JScrollPane(this.entityList), new GridBagConstraints(0, 1, 1, 1, 100.0, 100.0, 10, 1, insets, 0, 0));
        this.entityList.addListSelectionListener(e -> this.removeButton.setEnabled(this.entityList.getSelectedValue() != null));
        this.removeButton.setEnabled(false);
        this.removeButton.addActionListener(e -> {
            OWLEntity sel = this.entityList.getSelectedValue();
            if (sel != null) {
                int selIndex = this.entityList.getSelectedIndex();
                this.listData.remove(sel);
                this.updateEntityList();
                if (this.entityList.getModel().getSize() > selIndex) {
                    this.entityList.setSelectedIndex(selIndex);
                } else if (this.entityList.getModel().getSize() > selIndex - 1) {
                    this.entityList.setSelectedIndex(selIndex - 1);
                }
            }
        });
        this.entityList.setCellRenderer(new OWLCellRenderer(this.getOWLEditorKit()));
        content.add((Component)this.removeButton, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 512, 2, insets, 0, 0));
        content.setPreferredSize(new Dimension(450, 300));
        this.setContent(content);
    }

    private void updateEntityList() {
        this.entityList.setListData((OWLEntity[])this.listData.toArray(new OWLEntity[this.listData.size()]));
    }

    @Nullable
    public Object getBackPanelDescriptor() {
        return "DeprecationReplacementEntityPage";
    }

    @Nullable
    public Object getNextPanelDescriptor() {
        return "DeprecationSummaryPage";
    }

    public void displayingPanel() {
        this.finderField.requestFocus();
    }

    public void aboutToHidePanel() {
        this.state.setAlternateEntities(this.listData);
    }
}

