/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.frame.cls;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.model.inference.ReasonerPreferences;
import org.protege.editor.owl.ui.editor.OWLIndividualEditor;
import org.protege.editor.owl.ui.editor.OWLObjectEditor;
import org.protege.editor.owl.ui.frame.OWLFrame;
import org.protege.editor.owl.ui.frame.OWLFrameSectionRow;
import org.protege.editor.owl.ui.frame.cls.AbstractOWLClassAxiomFrameSection;
import org.protege.editor.owl.ui.frame.cls.OWLClassAssertionAxiomMembersSectionRow;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.reasoner.NodeSet;

public class OWLClassAssertionAxiomMembersSection
extends AbstractOWLClassAxiomFrameSection<OWLClassAssertionAxiom, OWLNamedIndividual> {
    public static final String LABEL = "Instances";
    public static final boolean SHOW_DIRECT_INSTANCES = true;
    private Set<OWLNamedIndividual> added = new HashSet<OWLNamedIndividual>();

    public OWLClassAssertionAxiomMembersSection(OWLEditorKit editorKit, OWLFrame<? extends OWLClass> frame) {
        super(editorKit, LABEL, "Type assertion", (OWLFrame<? extends OWLClassExpression>)frame);
    }

    @Override
    protected void clear() {
        this.added.clear();
    }

    @Override
    protected void addAxiom(OWLClassAssertionAxiom ax, OWLOntology ont) {
        this.addRow(new OWLClassAssertionAxiomMembersSectionRow(this.getOWLEditorKit(), this, ont, this.getRootObject(), ax));
        if (!ax.getIndividual().isAnonymous()) {
            this.added.add(ax.getIndividual().asOWLNamedIndividual());
        }
    }

    @Override
    protected Set<OWLClassAssertionAxiom> getClassAxioms(OWLClassExpression descr, OWLOntology ont) {
        if (!descr.isAnonymous()) {
            return ont.getClassAssertionAxioms((OWLClassExpression)descr.asOWLClass());
        }
        HashSet<OWLClassAssertionAxiom> axioms = new HashSet<OWLClassAssertionAxiom>();
        for (OWLClassAssertionAxiom ax : ont.getAxioms(AxiomType.CLASS_ASSERTION)) {
            if (!ax.getClassExpression().equals(descr)) continue;
            axioms.add(ax);
        }
        return axioms;
    }

    @Override
    protected void refillInferred() {
        this.getOWLModelManager().getReasonerPreferences().executeTask(ReasonerPreferences.OptionalInferenceTask.SHOW_INFERED_CLASS_MEMBERS, () -> {
            if (!this.getOWLModelManager().getReasoner().isConsistent()) {
                return;
            }
            OWLDataFactory df = this.getOWLModelManager().getOWLDataFactory();
            NodeSet instances = this.getOWLModelManager().getReasoner().getInstances(this.getRootObject(), true);
            if (instances != null) {
                for (OWLIndividual ind : instances.getFlattened()) {
                    if (ind.isAnonymous() || this.added.contains(ind.asOWLNamedIndividual())) continue;
                    this.addRow(new OWLClassAssertionAxiomMembersSectionRow(this.getOWLEditorKit(), this, null, this.getRootObject(), df.getOWLClassAssertionAxiom(this.getRootObject(), ind)));
                    this.added.add(ind.asOWLNamedIndividual());
                }
            }
        });
    }

    @Override
    protected OWLClassAssertionAxiom createAxiom(OWLNamedIndividual individual) {
        return this.getOWLDataFactory().getOWLClassAssertionAxiom(this.getRootObject(), (OWLIndividual)individual);
    }

    @Override
    public OWLObjectEditor<OWLNamedIndividual> getObjectEditor() {
        return new OWLIndividualEditor(this.getOWLEditorKit(), 2);
    }

    @Override
    public boolean canAcceptDrop(List<OWLObject> objects) {
        for (OWLObject obj : objects) {
            if (obj instanceof OWLIndividual) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean dropObjects(List<OWLObject> objects) {
        ArrayList<AddAxiom> changes = new ArrayList<AddAxiom>();
        for (OWLObject obj : objects) {
            if (!(obj instanceof OWLIndividual)) continue;
            OWLIndividual ind = (OWLIndividual)obj;
            OWLClassAssertionAxiom ax = this.getOWLDataFactory().getOWLClassAssertionAxiom(this.getRootObject(), ind);
            changes.add(new AddAxiom(this.getOWLModelManager().getActiveOntology(), (OWLAxiom)ax));
        }
        this.getOWLModelManager().applyChanges(changes);
        return true;
    }

    @Override
    public Comparator<OWLFrameSectionRow<OWLClassExpression, OWLClassAssertionAxiom, OWLNamedIndividual>> getRowComparator() {
        return (o1, o2) -> {
            String s1 = this.getOWLModelManager().getRendering((OWLObject)((OWLClassAssertionAxiom)o1.getAxiom()).getIndividual());
            String s2 = this.getOWLModelManager().getRendering((OWLObject)((OWLClassAssertionAxiom)o2.getAxiom()).getIndividual());
            return s1.compareToIgnoreCase(s2);
        };
    }

    @Override
    protected boolean isResettingChange(OWLOntologyChange change) {
        return change.isAxiomChange() && change.getAxiom() instanceof OWLClassAssertionAxiom && ((OWLClassAssertionAxiom)change.getAxiom()).getClassExpression().equals(this.getRootObject());
    }
}

