from __future__ import (absolute_import, division, print_function)

"""
extra colormaps:

* Generic Mapping Tools colormaps: GMT_drywet,GMT_gebco,GMT_globe,GMT_haxby
GMT_no_green,GMT_ocean,GMT_polar,GMT_red2green,GMT_relief,GMT_split,
GMT_wysiwyg
* Stepped-sequential scheme: StepSeq
* A nonlinear precipitation colormap:  s3pcpn
* A linear version of the precip colormap: s3pcpn_l

run examples/show_colormaps.py to see what these colormaps look like.
"""

from six import iteritems

from matplotlib import rcParams, colors
_LUTSIZE = rcParams['image.lut']

_StepSeq_data =  {'blue': [(0.0, 1.0, 1.0), (0.041666666666666664, 0.49411764740943909, 0.49411764740943909), (0.083333333333333329, 0.31764706969261169, 0.31764706969261169), (0.125, 0.17254902422428131, 0.17254902422428131), (0.16666666666666666, 0.058823529630899429, 0.058823529630899429), (0.20833333333333334, 0.69803923368453979, 0.69803923368453979), (0.25, 0.49411764740943909, 0.49411764740943909), (0.29166666666666669, 0.31764706969261169, 0.31764706969261169), (0.33333333333333331, 0.17254902422428131, 0.17254902422428131), (0.375, 0.058823529630899429, 0.058823529630899429), (0.41666666666666669, 0.69803923368453979, 0.69803923368453979), (0.45833333333333331, 0.49411764740943909, 0.49411764740943909), (0.5, 0.31764706969261169, 0.31764706969261169), (0.54166666666666663, 0.17254902422428131, 0.17254902422428131), (0.58333333333333337, 0.058823529630899429, 0.058823529630899429), (0.625, 1.0, 1.0), (0.66666666666666663, 0.89803922176361084, 0.89803922176361084), (0.70833333333333337, 0.80000001192092896, 0.80000001192092896), (0.75, 0.69803923368453979, 0.69803923368453979), (0.79166666666666663, 0.60000002384185791, 0.60000002384185791), (0.83333333333333337, 1.0, 1.0), (0.875, 0.89803922176361084, 0.89803922176361084), (0.91666666666666663, 0.80000001192092896, 0.80000001192092896), (0.95833333333333337, 0.69803923368453979, 0.69803923368453979), (1.0, 0.60000002384185791, 0.60000002384185791)], 'green': [(0.0, 1.0, 1.0), (0.041666666666666664, 0.49411764740943909, 0.49411764740943909), (0.083333333333333329, 0.31764706969261169, 0.31764706969261169), (0.125, 0.17254902422428131, 0.17254902422428131), (0.16666666666666666, 0.058823529630899429, 0.058823529630899429), (0.20833333333333334, 0.84705883264541626, 0.84705883264541626), (0.25, 0.69411766529083252, 0.69411766529083252), (0.29166666666666669, 0.55686277151107788, 0.55686277151107788), (0.33333333333333331, 0.43529412150382996, 0.43529412150382996), (0.375, 0.32941177487373352, 0.32941177487373352), (0.41666666666666669, 1.0, 1.0), (0.45833333333333331, 0.89803922176361084, 0.89803922176361084), (0.5, 0.80000001192092896, 0.80000001192092896), (0.54166666666666663, 0.69803923368453979, 0.69803923368453979), (0.58333333333333337, 0.60000002384185791, 0.60000002384185791), (0.625, 0.89803922176361084, 0.89803922176361084), (0.66666666666666663, 0.76470589637756348, 0.76470589637756348), (0.70833333333333337, 0.63921570777893066, 0.63921570777893066), (0.75, 0.5215686559677124, 0.5215686559677124), (0.79166666666666663, 0.41960784792900085, 0.41960784792900085), (0.83333333333333337, 0.69803923368453979, 0.69803923368453979), (0.875, 0.49411764740943909, 0.49411764740943909), (0.91666666666666663, 0.31764706969261169, 0.31764706969261169), (0.95833333333333337, 0.17254902422428131, 0.17254902422428131), (1.0, 0.058823529630899429, 0.058823529630899429)], 'red': [(0.0, 1.0, 1.0), (0.041666666666666664, 0.89803922176361084, 0.89803922176361084), (0.083333333333333329, 0.80000001192092896, 0.80000001192092896), (0.125, 0.69803923368453979, 0.69803923368453979), (0.16666666666666666, 0.60000002384185791, 0.60000002384185791), (0.20833333333333334, 1.0, 1.0), (0.25, 0.89803922176361084, 0.89803922176361084), (0.29166666666666669, 0.80000001192092896, 0.80000001192092896), (0.33333333333333331, 0.69803923368453979, 0.69803923368453979), (0.375, 0.60000002384185791, 0.60000002384185791), (0.41666666666666669, 0.89803922176361084, 0.89803922176361084), (0.45833333333333331, 0.76470589637756348, 0.76470589637756348), (0.5, 0.63921570777893066, 0.63921570777893066), (0.54166666666666663, 0.5215686559677124, 0.5215686559677124), (0.58333333333333337, 0.41960784792900085, 0.41960784792900085), (0.625, 0.69803923368453979, 0.69803923368453979), (0.66666666666666663, 0.49411764740943909, 0.49411764740943909), (0.70833333333333337, 0.31764706969261169, 0.31764706969261169), (0.75, 0.17254902422428131, 0.17254902422428131), (0.79166666666666663, 0.058823529630899429, 0.058823529630899429), (0.83333333333333337, 0.74901962280273438, 0.74901962280273438), (0.875, 0.56078433990478516, 0.56078433990478516), (0.91666666666666663, 0.3960784375667572, 0.3960784375667572), (0.95833333333333337, 0.25882354378700256, 0.25882354378700256), (1.0, 0.14901961386203766, 0.14901961386203766)]}
_s3pcpn_l_data =  {'blue': [(0.0, 1.0, 1.0), (0.050000000000000003, 0.81568628549575806, 0.81568628549575806), (0.10000000000000001, 1.0, 1.0), (0.14999999999999999, 0.50196081399917603, 0.50196081399917603), (0.20000000000000001, 0.0, 0.0), (0.25, 0.0, 0.0), (0.29999999999999999, 0.0, 0.0), (0.34999999999999998, 0.0, 0.0), (0.40000000000000002, 0.0, 0.0), (0.45000000000000001, 0.50196081399917603, 0.50196081399917603), (0.5, 1.0, 1.0), (0.55000000000000004, 1.0, 1.0), (0.59999999999999998, 1.0, 1.0), (0.65000000000000002, 0.50196081399917603, 0.50196081399917603), (0.69999999999999996, 0.12549020349979401, 0.12549020349979401), (0.75, 0.50196081399917603, 0.50196081399917603), (0.80000000000000004, 0.87843137979507446, 0.87843137979507446), (0.84999999999999998, 0.73725491762161255, 0.73725491762161255), (0.90000000000000002, 0.47058823704719543, 0.47058823704719543), (0.94999999999999996, 0.23529411852359772, 0.23529411852359772), (1.0, 0.0, 0.0)], 'green': [(0.0, 1.0, 1.0), (0.050000000000000003, 0.81568628549575806, 0.81568628549575806), (0.10000000000000001, 1.0, 1.0), (0.14999999999999999, 0.87843137979507446, 0.87843137979507446), (0.20000000000000001, 0.75294119119644165, 0.75294119119644165), (0.25, 0.87843137979507446, 0.87843137979507446), (0.29999999999999999, 1.0, 1.0), (0.34999999999999998, 0.62745100259780884, 0.62745100259780884), (0.40000000000000002, 0.0, 0.0), (0.45000000000000001, 0.12549020349979401, 0.12549020349979401), (0.5, 0.25098040699958801, 0.25098040699958801), (0.55000000000000004, 0.12549020349979401, 0.12549020349979401), (0.59999999999999998, 0.25098040699958801, 0.25098040699958801), (0.65000000000000002, 0.12549020349979401, 0.12549020349979401), (0.69999999999999996, 0.12549020349979401, 0.12549020349979401), (0.75, 0.50196081399917603, 0.50196081399917603), (0.80000000000000004, 0.87843137979507446, 0.87843137979507446), (0.84999999999999998, 0.83137255907058716, 0.83137255907058716), (0.90000000000000002, 0.65098041296005249, 0.65098041296005249), (0.94999999999999996, 0.42352941632270813, 0.42352941632270813), (1.0, 0.20000000298023224, 0.20000000298023224)], 'red': [(0.0, 1.0, 1.0), (0.050000000000000003, 0.31372550129890442, 0.31372550129890442), (0.10000000000000001, 0.0, 0.0), (0.14999999999999999, 0.0, 0.0), (0.20000000000000001, 0.0, 0.0), (0.25, 0.50196081399917603, 0.50196081399917603), (0.29999999999999999, 1.0, 1.0), (0.34999999999999998, 1.0, 1.0), (0.40000000000000002, 1.0, 1.0), (0.45000000000000001, 1.0, 1.0), (0.5, 0.94117647409439087, 0.94117647409439087), (0.55000000000000004, 0.50196081399917603, 0.50196081399917603), (0.59999999999999998, 0.25098040699958801, 0.25098040699958801), (0.65000000000000002, 0.12549020349979401, 0.12549020349979401), (0.69999999999999996, 0.12549020349979401, 0.12549020349979401), (0.75, 0.50196081399917603, 0.50196081399917603), (0.80000000000000004, 0.87843137979507446, 0.87843137979507446), (0.84999999999999998, 0.93333333730697632, 0.93333333730697632), (0.90000000000000002, 0.85490196943283081, 0.85490196943283081), (0.94999999999999996, 0.62745100259780884, 0.62745100259780884), (1.0, 0.40000000596046448, 0.40000000596046448)]}
_s3pcpn_data =  {'blue': [(0.0, 1.0, 1.0), (0.0013333333333333333, 0.81568628549575806, 0.81568628549575806), (0.0033333333333333335, 1.0, 1.0), (0.0066666666666666671, 0.50196081399917603, 0.50196081399917603), (0.01, 0.0, 0.0), (0.013333333333333334, 0.0, 0.0), (0.02, 0.0, 0.0), (0.026666666666666668, 0.0, 0.0), (0.040000000000000001, 0.0, 0.0), (0.053333333333333337, 0.50196081399917603, 0.50196081399917603), (0.066666666666666666, 1.0, 1.0), (0.093333333333333338, 1.0, 1.0), (0.13333333333333333, 1.0, 1.0), (0.20000000000000001, 0.50196081399917603, 0.50196081399917603), (0.26666666666666666, 0.12549020349979401, 0.12549020349979401), (0.33333333333333331, 0.50196081399917603, 0.50196081399917603), (0.40000000000000002, 0.87843137979507446, 0.87843137979507446), (0.53333333333333333, 0.73725491762161255, 0.73725491762161255), (0.66666666666666663, 0.47058823704719543, 0.47058823704719543), (0.80000000000000004, 0.23529411852359772, 0.23529411852359772), (1.0, 0.0, 0.0)], 'green': [(0.0, 1.0, 1.0), (0.0013333333333333333, 0.81568628549575806, 0.81568628549575806), (0.0033333333333333335, 1.0, 1.0), (0.0066666666666666671, 0.87843137979507446, 0.87843137979507446), (0.01, 0.75294119119644165, 0.75294119119644165), (0.013333333333333334, 0.87843137979507446, 0.87843137979507446), (0.02, 1.0, 1.0), (0.026666666666666668, 0.62745100259780884, 0.62745100259780884), (0.040000000000000001, 0.0, 0.0), (0.053333333333333337, 0.12549020349979401, 0.12549020349979401), (0.066666666666666666, 0.25098040699958801, 0.25098040699958801), (0.093333333333333338, 0.12549020349979401, 0.12549020349979401), (0.13333333333333333, 0.25098040699958801, 0.25098040699958801), (0.20000000000000001, 0.12549020349979401, 0.12549020349979401), (0.26666666666666666, 0.12549020349979401, 0.12549020349979401), (0.33333333333333331, 0.50196081399917603, 0.50196081399917603), (0.40000000000000002, 0.87843137979507446, 0.87843137979507446), (0.53333333333333333, 0.83137255907058716, 0.83137255907058716), (0.66666666666666663, 0.65098041296005249, 0.65098041296005249), (0.80000000000000004, 0.42352941632270813, 0.42352941632270813), (1.0, 0.20000000298023224, 0.20000000298023224)], 'red': [(0.0, 1.0, 1.0), (0.0013333333333333333, 0.31372550129890442, 0.31372550129890442), (0.0033333333333333335, 0.0, 0.0), (0.0066666666666666671, 0.0, 0.0), (0.01, 0.0, 0.0), (0.013333333333333334, 0.50196081399917603, 0.50196081399917603), (0.02, 1.0, 1.0), (0.026666666666666668, 1.0, 1.0), (0.040000000000000001, 1.0, 1.0), (0.053333333333333337, 1.0, 1.0), (0.066666666666666666, 0.94117647409439087, 0.94117647409439087), (0.093333333333333338, 0.50196081399917603, 0.50196081399917603), (0.13333333333333333, 0.25098040699958801, 0.25098040699958801), (0.20000000000000001, 0.12549020349979401, 0.12549020349979401), (0.26666666666666666, 0.12549020349979401, 0.12549020349979401), (0.33333333333333331, 0.50196081399917603, 0.50196081399917603), (0.40000000000000002, 0.87843137979507446, 0.87843137979507446), (0.53333333333333333, 0.93333333730697632, 0.93333333730697632), (0.66666666666666663, 0.85490196943283081, 0.85490196943283081), (0.80000000000000004, 0.62745100259780884, 0.62745100259780884), (1.0, 0.40000000596046448, 0.40000000596046448)]}

_GMT_drywet_data =  {'blue': [(0.0, 0.164705887437, 0.164705887437), (0.20000000298, 0.392156869173, 0.392156869173), (0.40000000596, 0.529411792755, 0.529411792755), (0.600000023842, 0.921568632126, 0.921568632126), (0.800000011921, 0.933333337307, 0.933333337307), (1.0, 0.717647075653, 0.717647075653)], 'green': [(0.0, 0.380392163992, 0.380392163992), (0.20000000298, 0.780392169952, 0.780392169952), (0.40000000596, 0.933333337307, 0.933333337307), (0.600000023842, 0.933333337307, 0.933333337307), (0.800000011921, 0.470588237047, 0.470588237047), (1.0, 0.00392156885937, 0.00392156885937)], 'red': [(0.0, 0.525490224361, 0.525490224361), (0.20000000298, 0.933333337307, 0.933333337307), (0.40000000596, 0.705882370472, 0.705882370472), (0.600000023842, 0.196078434587, 0.196078434587), (0.800000011921, 0.0470588244498, 0.0470588244498), (1.0, 0.149019613862, 0.149019613862)]}
_GMT_gebco_data =  {'blue': [(0.0, 1.0, 1.0), (0.147058829665, 1.0, 1.0), (0.29411765933, 1.0, 1.0), (0.441176474094, 0.901960790157, 0.901960790157), (0.588235318661, 0.843137264252, 0.843137264252), (0.735294103622, 0.843137264252, 0.843137264252), (0.882352948189, 0.843137264252, 0.843137264252), (0.955882370472, 0.941176474094, 0.941176474094), (1.0, 1.0, 1.0)], 'green': [(0.0, 0.941176474094, 0.941176474094), (0.147058829665, 1.0, 1.0), (0.29411765933, 1.0, 1.0), (0.441176474094, 1.0, 1.0), (0.588235318661, 1.0, 1.0), (0.735294103622, 1.0, 1.0), (0.882352948189, 1.0, 1.0), (0.955882370472, 1.0, 1.0), (1.0, 1.0, 1.0)], 'red': [(0.0, 0.0, 0.0), (0.147058829665, 0.137254908681, 0.137254908681), (0.29411765933, 0.352941185236, 0.352941185236), (0.441176474094, 0.549019634724, 0.549019634724), (0.588235318661, 0.647058844566, 0.647058844566), (0.735294103622, 0.764705896378, 0.764705896378), (0.882352948189, 0.823529422283, 0.823529422283), (0.955882370472, 0.901960790157, 0.901960790157), (1.0, 0.921568632126, 0.921568632126)]}
_GMT_globe_data =  {'blue': [(0.0, 1.0, 1.0), (0.0256410259753, 1.0, 1.0), (0.0512820519507, 1.0, 1.0), (0.0769230797887, 1.0, 1.0), (0.102564103901, 1.0, 1.0), (0.128205135465, 1.0, 1.0), (0.153846159577, 1.0, 1.0), (0.17948718369, 1.0, 1.0), (0.205128207803, 1.0, 1.0), (0.230769231915, 1.0, 1.0), (0.256410270929, 1.0, 1.0), (0.282051295042, 1.0, 1.0), (0.307692319155, 1.0, 1.0), (0.333333343267, 1.0, 1.0), (0.35897436738, 1.0, 1.0), (0.384615391493, 1.0, 1.0), (0.410256415606, 1.0, 1.0), (0.435897439718, 1.0, 1.0), (0.461538463831, 1.0, 1.0), (0.487179487944, 1.0, 1.0), (0.502564132214, 1.0, 1.0), (0.512820541859, 0.0, 0.0), (0.517948746681, 0.40000000596, 0.40000000596), (0.523076951504, 0.572549045086, 0.572549045086), (0.538461565971, 0.72549021244, 0.72549021244), (0.564102590084, 0.537254929543, 0.537254929543), (0.589743614197, 0.345098048449, 0.345098048449), (0.615384638309, 0.152941182256, 0.152941182256), (0.641025662422, 0.121568627656, 0.121568627656), (0.666666686535, 0.0980392172933, 0.0980392172933), (0.692307710648, 0.074509806931, 0.074509806931), (0.71794873476, 0.0509803928435, 0.0509803928435), (0.743589758873, 0.0274509806186, 0.0274509806186), (0.769230782986, 0.0, 0.0), (0.794871807098, 0.349019616842, 0.349019616842), (0.820512831211, 0.46274510026, 0.46274510026), (0.846153855324, 0.57647061348, 0.57647061348), (0.871794879436, 0.690196096897, 0.690196096897), (0.897435903549, 0.800000011921, 0.800000011921), (0.923076927662, 0.898039221764, 0.898039221764), (0.948717951775, 0.949019610882, 0.949019610882), (0.974358975887, 1.0, 1.0), (1.0, 1.0, 1.0)], 'green': [(0.0, 0.0, 0.0), (0.0256410259753, 0.0, 0.0), (0.0512820519507, 0.0, 0.0), (0.0769230797887, 0.0666666701436, 0.0666666701436), (0.102564103901, 0.133333340287, 0.133333340287), (0.128205135465, 0.20000000298, 0.20000000298), (0.153846159577, 0.266666680574, 0.266666680574), (0.17948718369, 0.333333343267, 0.333333343267), (0.205128207803, 0.40000000596, 0.40000000596), (0.230769231915, 0.466666668653, 0.466666668653), (0.256410270929, 0.533333361149, 0.533333361149), (0.282051295042, 0.600000023842, 0.600000023842), (0.307692319155, 0.643137276173, 0.643137276173), (0.333333343267, 0.686274528503, 0.686274528503), (0.35897436738, 0.729411780834, 0.729411780834), (0.384615391493, 0.772549033165, 0.772549033165), (0.410256415606, 0.815686285496, 0.815686285496), (0.435897439718, 0.858823537827, 0.858823537827), (0.461538463831, 0.901960790157, 0.901960790157), (0.487179487944, 0.945098042488, 0.945098042488), (0.502564132214, 0.988235294819, 0.988235294819), (0.512820541859, 0.40000000596, 0.40000000596), (0.517948746681, 0.800000011921, 0.800000011921), (0.523076951504, 0.89411765337, 0.89411765337), (0.538461565971, 0.86274510622, 0.86274510622), (0.564102590084, 0.792156875134, 0.792156875134), (0.589743614197, 0.721568644047, 0.721568644047), (0.615384638309, 0.65098041296, 0.65098041296), (0.641025662422, 0.603921592236, 0.603921592236), (0.666666686535, 0.564705908298, 0.564705908298), (0.692307710648, 0.525490224361, 0.525490224361), (0.71794873476, 0.482352942228, 0.482352942228), (0.743589758873, 0.443137258291, 0.443137258291), (0.769230782986, 0.40000000596, 0.40000000596), (0.794871807098, 0.349019616842, 0.349019616842), (0.820512831211, 0.46274510026, 0.46274510026), (0.846153855324, 0.57647061348, 0.57647061348), (0.871794879436, 0.690196096897, 0.690196096897), (0.897435903549, 0.800000011921, 0.800000011921), (0.923076927662, 0.898039221764, 0.898039221764), (0.948717951775, 0.949019610882, 0.949019610882), (0.974358975887, 1.0, 1.0), (1.0, 1.0, 1.0)], 'red': [(0.0, 0.600000023842, 0.600000023842), (0.0256410259753, 0.600000023842, 0.600000023842), (0.0512820519507, 0.600000023842, 0.600000023842), (0.0769230797887, 0.533333361149, 0.533333361149), (0.102564103901, 0.466666668653, 0.466666668653), (0.128205135465, 0.40000000596, 0.40000000596), (0.153846159577, 0.333333343267, 0.333333343267), (0.17948718369, 0.266666680574, 0.266666680574), (0.205128207803, 0.20000000298, 0.20000000298), (0.230769231915, 0.133333340287, 0.133333340287), (0.256410270929, 0.0666666701436, 0.0666666701436), (0.282051295042, 0.0, 0.0), (0.307692319155, 0.105882354081, 0.105882354081), (0.333333343267, 0.211764708161, 0.211764708161), (0.35897436738, 0.317647069693, 0.317647069693), (0.384615391493, 0.423529416323, 0.423529416323), (0.410256415606, 0.525490224361, 0.525490224361), (0.435897439718, 0.631372570992, 0.631372570992), (0.461538463831, 0.737254917622, 0.737254917622), (0.487179487944, 0.843137264252, 0.843137264252), (0.502564132214, 0.945098042488, 0.945098042488), (0.512820541859, 0.20000000298, 0.20000000298), (0.517948746681, 0.20000000298, 0.20000000298), (0.523076951504, 0.733333349228, 0.733333349228), (0.538461565971, 1.0, 1.0), (0.564102590084, 0.952941179276, 0.952941179276), (0.589743614197, 0.901960790157, 0.901960790157), (0.615384638309, 0.850980401039, 0.850980401039), (0.641025662422, 0.658823549747, 0.658823549747), (0.666666686535, 0.643137276173, 0.643137276173), (0.692307710648, 0.635294139385, 0.635294139385), (0.71794873476, 0.623529434204, 0.623529434204), (0.743589758873, 0.611764729023, 0.611764729023), (0.769230782986, 0.600000023842, 0.600000023842), (0.794871807098, 0.635294139385, 0.635294139385), (0.820512831211, 0.698039233685, 0.698039233685), (0.846153855324, 0.717647075653, 0.717647075653), (0.871794879436, 0.760784327984, 0.760784327984), (0.897435903549, 0.800000011921, 0.800000011921), (0.923076927662, 0.898039221764, 0.898039221764), (0.948717951775, 0.949019610882, 0.949019610882), (0.974358975887, 1.0, 1.0), (1.0, 1.0, 1.0)]}
_GMT_haxby_data =  {'blue': [(0.0, 0.474509805441, 0.474509805441), (0.0322580635548, 0.588235318661, 0.588235318661), (0.0645161271095, 0.686274528503, 0.686274528503), (0.0967741906643, 0.784313738346, 0.784313738346), (0.129032254219, 0.831372559071, 0.831372559071), (0.161290317774, 0.878431379795, 0.878431379795), (0.193548381329, 0.941176474094, 0.941176474094), (0.225806444883, 0.972549021244, 0.972549021244), (0.258064508438, 1.0, 1.0), (0.290322571993, 1.0, 1.0), (0.322580635548, 1.0, 1.0), (0.354838699102, 0.941176474094, 0.941176474094), (0.387096762657, 0.882352948189, 0.882352948189), (0.419354826212, 0.784313738346, 0.784313738346), (0.451612889767, 0.68235296011, 0.68235296011), (0.483870953321, 0.658823549747, 0.658823549747), (0.516129016876, 0.635294139385, 0.635294139385), (0.548387110233, 0.552941203117, 0.552941203117), (0.580645143986, 0.474509805441, 0.474509805441), (0.612903237343, 0.407843142748, 0.407843142748), (0.645161271095, 0.341176480055, 0.341176480055), (0.677419364452, 0.270588248968, 0.270588248968), (0.709677398205, 0.29411765933, 0.29411765933), (0.741935491562, 0.305882364511, 0.305882364511), (0.774193525314, 0.352941185236, 0.352941185236), (0.806451618671, 0.486274510622, 0.486274510622), (0.838709652424, 0.61960786581, 0.61960786581), (0.870967745781, 0.68235296011, 0.68235296011), (0.903225779533, 0.768627464771, 0.768627464771), (0.93548387289, 0.843137264252, 0.843137264252), (0.967741906643, 0.921568632126, 0.921568632126), (1.0, 1.0, 1.0)], 'green': [(0.0, 0.0, 0.0), (0.0322580635548, 0.0, 0.0), (0.0645161271095, 0.0196078438312, 0.0196078438312), (0.0967741906643, 0.0392156876624, 0.0392156876624), (0.129032254219, 0.0980392172933, 0.0980392172933), (0.161290317774, 0.156862750649, 0.156862750649), (0.193548381329, 0.40000000596, 0.40000000596), (0.225806444883, 0.505882382393, 0.505882382393), (0.258064508438, 0.686274528503, 0.686274528503), (0.290322571993, 0.745098054409, 0.745098054409), (0.322580635548, 0.792156875134, 0.792156875134), (0.354838699102, 0.882352948189, 0.882352948189), (0.387096762657, 0.921568632126, 0.921568632126), (0.419354826212, 0.921568632126, 0.921568632126), (0.451612889767, 0.92549020052, 0.92549020052), (0.483870953321, 0.960784316063, 0.960784316063), (0.516129016876, 1.0, 1.0), (0.548387110233, 0.960784316063, 0.960784316063), (0.580645143986, 0.92549020052, 0.92549020052), (0.612903237343, 0.843137264252, 0.843137264252), (0.645161271095, 0.741176486015, 0.741176486015), (0.677419364452, 0.627451002598, 0.627451002598), (0.709677398205, 0.458823531866, 0.458823531866), (0.741935491562, 0.313725501299, 0.313725501299), (0.774193525314, 0.352941185236, 0.352941185236), (0.806451618671, 0.486274510622, 0.486274510622), (0.838709652424, 0.61960786581, 0.61960786581), (0.870967745781, 0.701960802078, 0.701960802078), (0.903225779533, 0.768627464771, 0.768627464771), (0.93548387289, 0.843137264252, 0.843137264252), (0.967741906643, 0.921568632126, 0.921568632126), (1.0, 1.0, 1.0)], 'red': [(0.0, 0.0392156876624, 0.0392156876624), (0.0322580635548, 0.156862750649, 0.156862750649), (0.0645161271095, 0.0784313753247, 0.0784313753247), (0.0967741906643, 0.0, 0.0), (0.129032254219, 0.0, 0.0), (0.161290317774, 0.0, 0.0), (0.193548381329, 0.101960785687, 0.101960785687), (0.225806444883, 0.0509803928435, 0.0509803928435), (0.258064508438, 0.0980392172933, 0.0980392172933), (0.290322571993, 0.196078434587, 0.196078434587), (0.322580635548, 0.266666680574, 0.266666680574), (0.354838699102, 0.380392163992, 0.380392163992), (0.387096762657, 0.415686279535, 0.415686279535), (0.419354826212, 0.486274510622, 0.486274510622), (0.451612889767, 0.541176497936, 0.541176497936), (0.483870953321, 0.674509823322, 0.674509823322), (0.516129016876, 0.803921580315, 0.803921580315), (0.548387110233, 0.874509811401, 0.874509811401), (0.580645143986, 0.941176474094, 0.941176474094), (0.612903237343, 0.96862745285, 0.96862745285), (0.645161271095, 1.0, 1.0), (0.677419364452, 1.0, 1.0), (0.709677398205, 0.956862747669, 0.956862747669), (0.741935491562, 0.933333337307, 0.933333337307), (0.774193525314, 1.0, 1.0), (0.806451618671, 1.0, 1.0), (0.838709652424, 1.0, 1.0), (0.870967745781, 0.960784316063, 0.960784316063), (0.903225779533, 1.0, 1.0), (0.93548387289, 1.0, 1.0), (0.967741906643, 1.0, 1.0), (1.0, 1.0, 1.0)]}
_GMT_no_green_data =  {'blue': [(0.0, 1.0, 1.0), (0.0666666701436, 1.0, 1.0), (0.133333340287, 1.0, 1.0), (0.20000000298, 1.0, 1.0), (0.266666680574, 1.0, 1.0), (0.333333343267, 1.0, 1.0), (0.40000000596, 1.0, 1.0), (0.466666668653, 1.0, 1.0), (0.533333361149, 0.329411774874, 0.329411774874), (0.600000023842, 0.0, 0.0), (0.666666686535, 0.0, 0.0), (0.733333349228, 0.0, 0.0), (0.800000011921, 0.0, 0.0), (0.866666674614, 0.0, 0.0), (0.933333337307, 0.0, 0.0), (1.0, 0.0, 0.0)], 'green': [(0.0, 0.376470595598, 0.376470595598), (0.0666666701436, 0.623529434204, 0.623529434204), (0.133333340287, 0.749019622803, 0.749019622803), (0.20000000298, 0.811764717102, 0.811764717102), (0.266666680574, 1.0, 1.0), (0.333333343267, 1.0, 1.0), (0.40000000596, 1.0, 1.0), (0.466666668653, 1.0, 1.0), (0.533333361149, 1.0, 1.0), (0.600000023842, 0.941176474094, 0.941176474094), (0.666666686535, 0.749019622803, 0.749019622803), (0.733333349228, 0.658823549747, 0.658823549747), (0.800000011921, 0.541176497936, 0.541176497936), (0.866666674614, 0.439215689898, 0.439215689898), (0.933333337307, 0.301960796118, 0.301960796118), (1.0, 0.0, 0.0)], 'red': [(0.0, 0.1254902035, 0.1254902035), (0.0666666701436, 0.1254902035, 0.1254902035), (0.133333340287, 0.1254902035, 0.1254902035), (0.20000000298, 0.0, 0.0), (0.266666680574, 0.164705887437, 0.164705887437), (0.333333343267, 0.333333343267, 0.333333343267), (0.40000000596, 0.498039215803, 0.498039215803), (0.466666668653, 0.666666686535, 0.666666686535), (0.533333361149, 1.0, 1.0), (0.600000023842, 1.0, 1.0), (0.666666686535, 1.0, 1.0), (0.733333349228, 1.0, 1.0), (0.800000011921, 1.0, 1.0), (0.866666674614, 1.0, 1.0), (0.933333337307, 1.0, 1.0), (1.0, 1.0, 1.0)]}
_GMT_ocean_data =  {'blue': [(0.0, 0.0, 0.0), (0.142857149243, 0.0980392172933, 0.0980392172933), (0.285714298487, 0.196078434587, 0.196078434587), (0.428571432829, 0.490196079016, 0.490196079016), (0.571428596973, 0.784313738346, 0.784313738346), (0.714285731316, 0.721568644047, 0.721568644047), (0.857142865658, 0.658823549747, 0.658823549747), (1.0, 0.827450990677, 0.827450990677)], 'green': [(0.0, 0.0, 0.0), (0.142857149243, 0.0196078438312, 0.0196078438312), (0.285714298487, 0.0392156876624, 0.0392156876624), (0.428571432829, 0.313725501299, 0.313725501299), (0.571428596973, 0.588235318661, 0.588235318661), (0.714285731316, 0.772549033165, 0.772549033165), (0.857142865658, 0.960784316063, 0.960784316063), (1.0, 0.980392158031, 0.980392158031)], 'red': [(0.0, 0.0, 0.0), (0.142857149243, 0.0, 0.0), (0.285714298487, 0.0, 0.0), (0.428571432829, 0.0, 0.0), (0.571428596973, 0.0, 0.0), (0.714285731316, 0.337254911661, 0.337254911661), (0.857142865658, 0.674509823322, 0.674509823322), (1.0, 0.827450990677, 0.827450990677)]}
_GMT_polar_data =  {'blue': [(0.0, 1.0, 1.0), (0.5, 1.0, 1.0), (1.0, 0.0, 0.0)], 'green': [(0.0, 0.0, 0.0), (0.5, 1.0, 1.0), (1.0, 0.0, 0.0)], 'red': [(0.0, 0.0, 0.0), (0.5, 1.0, 1.0), (1.0, 1.0, 1.0)]}
_GMT_red2green_data =  {'blue': [(0.0, 0.0, 0.0), (0.5, 1.0, 1.0), (1.0, 0.0, 0.0)], 'green': [(0.0, 0.0, 0.0), (0.5, 1.0, 1.0), (1.0, 1.0, 1.0)], 'red': [(0.0, 1.0, 1.0), (0.5, 1.0, 1.0), (1.0, 0.0, 0.0)]}
_GMT_relief_data =  {'blue': [(0.0, 0.0, 0.0), (0.0666666701436, 0.0980392172933, 0.0980392172933), (0.133333340287, 0.196078434587, 0.196078434587), (0.20000000298, 0.490196079016, 0.490196079016), (0.266666680574, 0.784313738346, 0.784313738346), (0.333333343267, 0.721568644047, 0.721568644047), (0.40000000596, 0.658823549747, 0.658823549747), (0.466666668653, 0.827450990677, 0.827450990677), (0.533333361149, 0.196078434587, 0.196078434587), (0.566666662693, 0.196078434587, 0.196078434587), (0.600000023842, 0.235294118524, 0.235294118524), (0.666666686535, 0.313725501299, 0.313725501299), (0.733333349228, 0.392156869173, 0.392156869173), (0.800000011921, 0.494117647409, 0.494117647409), (0.866666674614, 0.596078455448, 0.596078455448), (0.933333337307, 0.694117665291, 0.694117665291), (1.0, 0.847058832645, 0.847058832645)], 'green': [(0.0, 0.0, 0.0), (0.0666666701436, 0.0196078438312, 0.0196078438312), (0.133333340287, 0.0392156876624, 0.0392156876624), (0.20000000298, 0.313725501299, 0.313725501299), (0.266666680574, 0.588235318661, 0.588235318661), (0.333333343267, 0.772549033165, 0.772549033165), (0.40000000596, 0.960784316063, 0.960784316063), (0.466666668653, 0.980392158031, 0.980392158031), (0.533333361149, 0.470588237047, 0.470588237047), (0.566666662693, 0.392156869173, 0.392156869173), (0.600000023842, 0.494117647409, 0.494117647409), (0.666666686535, 0.698039233685, 0.698039233685), (0.733333349228, 0.901960790157, 0.901960790157), (0.800000011921, 0.917647063732, 0.917647063732), (0.866666674614, 0.933333337307, 0.933333337307), (0.933333337307, 0.952941179276, 0.952941179276), (1.0, 0.976470589638, 0.976470589638)], 'red': [(0.0, 0.0, 0.0), (0.0666666701436, 0.0, 0.0), (0.133333340287, 0.0, 0.0), (0.20000000298, 0.0, 0.0), (0.266666680574, 0.0, 0.0), (0.333333343267, 0.337254911661, 0.337254911661), (0.40000000596, 0.674509823322, 0.674509823322), (0.466666668653, 0.827450990677, 0.827450990677), (0.533333361149, 0.274509817362, 0.274509817362), (0.566666662693, 0.470588237047, 0.470588237047), (0.600000023842, 0.572549045086, 0.572549045086), (0.666666686535, 0.776470601559, 0.776470601559), (0.733333349228, 0.980392158031, 0.980392158031), (0.800000011921, 0.980392158031, 0.980392158031), (0.866666674614, 0.988235294819, 0.988235294819), (0.933333337307, 0.988235294819, 0.988235294819), (1.0, 0.992156863213, 0.992156863213)]}
_GMT_seis_data =  {'blue': [(0.0, 0.0, 0.0), (0.12549239397, 0.0, 0.0), (0.25042206049, 0.0, 0.0), (0.375351727009, 0.0, 0.0), (0.500281393528, 0.0, 0.0), (0.625211060047, 0.0, 0.0), (0.750140666962, 0.117647059262, 0.117647059262), (0.875070393085, 0.43137255311, 0.43137255311), (1.0, 1.0, 1.0)], 'green': [(0.0, 0.0, 0.0), (0.12549239397, 0.0, 0.0), (0.25042206049, 0.333333343267, 0.333333343267), (0.375351727009, 0.666666686535, 0.666666686535), (0.500281393528, 1.0, 1.0), (0.625211060047, 1.0, 1.0), (0.750140666962, 1.0, 1.0), (0.875070393085, 0.941176474094, 0.941176474094), (1.0, 0.313725501299, 0.313725501299)], 'red': [(0.0, 0.666666686535, 0.666666686535), (0.12549239397, 1.0, 1.0), (0.25042206049, 1.0, 1.0), (0.375351727009, 1.0, 1.0), (0.500281393528, 1.0, 1.0), (0.625211060047, 1.0, 1.0), (0.750140666962, 0.352941185236, 0.352941185236), (0.875070393085, 0.0, 0.0), (1.0, 0.0, 0.0)]}
_GMT_split_data =  {'blue': [(0.0, 1.0, 1.0), (0.333333343267, 0.501960813999, 0.501960813999), (0.666666686535, 0.0, 0.0), (1.0, 0.0, 0.0)], 'green': [(0.0, 0.501960813999, 0.501960813999), (0.333333343267, 0.0, 0.0), (0.666666686535, 0.0, 0.0), (1.0, 0.0, 0.0)], 'red': [(0.0, 0.501960813999, 0.501960813999), (0.333333343267, 0.0, 0.0), (0.666666686535, 0.0, 0.0), (1.0, 0.501960813999, 0.501960813999)]}
_GMT_wysiwyg_data =  {'blue': [(0.0, 0.250980407, 0.250980407), (0.0526315793395, 0.752941191196, 0.752941191196), (0.105263158679, 1.0, 1.0), (0.157894730568, 1.0, 1.0), (0.210526317358, 1.0, 1.0), (0.263157904148, 1.0, 1.0), (0.315789461136, 1.0, 1.0), (0.368421047926, 1.0, 1.0), (0.421052634716, 0.752941191196, 0.752941191196), (0.473684221506, 0.250980407, 0.250980407), (0.526315808296, 0.250980407, 0.250980407), (0.578947365284, 0.250980407, 0.250980407), (0.631578922272, 0.250980407, 0.250980407), (0.684210538864, 0.250980407, 0.250980407), (0.736842095852, 0.250980407, 0.250980407), (0.789473712444, 0.250980407, 0.250980407), (0.842105269432, 0.250980407, 0.250980407), (0.89473682642, 0.752941191196, 0.752941191196), (0.947368443012, 1.0, 1.0), (1.0, 1.0, 1.0)], 'green': [(0.0, 0.0, 0.0), (0.0526315793395, 0.0, 0.0), (0.105263158679, 0.250980407, 0.250980407), (0.157894730568, 0.501960813999, 0.501960813999), (0.210526317358, 0.627451002598, 0.627451002598), (0.263157904148, 0.752941191196, 0.752941191196), (0.315789461136, 0.878431379795, 0.878431379795), (0.368421047926, 1.0, 1.0), (0.421052634716, 1.0, 1.0), (0.473684221506, 1.0, 1.0), (0.526315808296, 1.0, 1.0), (0.578947365284, 1.0, 1.0), (0.631578922272, 1.0, 1.0), (0.684210538864, 0.878431379795, 0.878431379795), (0.736842095852, 0.627451002598, 0.627451002598), (0.789473712444, 0.376470595598, 0.376470595598), (0.842105269432, 0.1254902035, 0.1254902035), (0.89473682642, 0.376470595598, 0.376470595598), (0.947368443012, 0.627451002598, 0.627451002598), (1.0, 0.878431379795, 0.878431379795)], 'red': [(0.0, 0.250980407, 0.250980407), (0.0526315793395, 0.250980407, 0.250980407), (0.105263158679, 0.0, 0.0), (0.157894730568, 0.0, 0.0), (0.210526317358, 0.0, 0.0), (0.263157904148, 0.250980407, 0.250980407), (0.315789461136, 0.250980407, 0.250980407), (0.368421047926, 0.250980407, 0.250980407), (0.421052634716, 0.250980407, 0.250980407), (0.473684221506, 0.250980407, 0.250980407), (0.526315808296, 0.501960813999, 0.501960813999), (0.578947365284, 0.752941191196, 0.752941191196), (0.631578922272, 1.0, 1.0), (0.684210538864, 1.0, 1.0), (0.736842095852, 1.0, 1.0), (0.789473712444, 1.0, 1.0), (0.842105269432, 1.0, 1.0), (0.89473682642, 1.0, 1.0), (0.947368443012, 1.0, 1.0), (1.0, 1.0, 1.0)]}
GMT_drywet = colors.LinearSegmentedColormap('GMT_drywet', _GMT_drywet_data, _LUTSIZE)
GMT_gebco = colors.LinearSegmentedColormap('GMT_gebco', _GMT_gebco_data, _LUTSIZE)
GMT_globe = colors.LinearSegmentedColormap('GMT_globe', _GMT_globe_data, _LUTSIZE)
GMT_haxby = colors.LinearSegmentedColormap('GMT_haxby', _GMT_haxby_data, _LUTSIZE)
GMT_no_green = colors.LinearSegmentedColormap('GMT_no_green', _GMT_no_green_data, _LUTSIZE)
GMT_ocean = colors.LinearSegmentedColormap('GMT_ocean', _GMT_ocean_data, _LUTSIZE)
GMT_polar = colors.LinearSegmentedColormap('GMT_polar', _GMT_polar_data, _LUTSIZE)
GMT_red2green = colors.LinearSegmentedColormap('GMT_red2green', _GMT_red2green_data, _LUTSIZE)
GMT_relief = colors.LinearSegmentedColormap('GMT_relief', _GMT_relief_data, _LUTSIZE)
GMT_seis = colors.LinearSegmentedColormap('GMT_seis', _GMT_seis_data, _LUTSIZE)
GMT_split = colors.LinearSegmentedColormap('GMT_split', _GMT_split_data, _LUTSIZE)
GMT_wysiwyg = colors.LinearSegmentedColormap('GMT_wysiwyg', _GMT_wysiwyg_data, _LUTSIZE)
s3pcpn = colors.LinearSegmentedColormap('s3pcpn', _s3pcpn_data, _LUTSIZE)
s3pcpn_l = colors.LinearSegmentedColormap('s3pcpn_l', _s3pcpn_l_data, _LUTSIZE)
StepSeq = colors.LinearSegmentedColormap('StepSeq', _StepSeq_data, _LUTSIZE)
_sstanom_data =  {'blue': [(0.0, 0.858823537827, 0.858823537827), (0.0243902429938, 0.835294127464, 0.835294127464), (0.0487804859877, 0.815686285496, 0.815686285496), (0.0731707289815, 0.78823530674, 0.78823530674), (0.0975609719753, 0.819607853889, 0.819607853889), (0.12195122242, 0.882352948189, 0.882352948189), (0.146341457963, 0.945098042488, 0.945098042488), (0.170731708407, 1.0, 1.0), (0.195121943951, 1.0, 1.0), (0.219512194395, 1.0, 1.0), (0.243902444839, 1.0, 1.0), (0.268292695284, 0.886274516582, 0.886274516582), (0.292682915926, 0.745098054409, 0.745098054409), (0.31707316637, 0.603921592236, 0.603921592236), (0.341463416815, 0.51372551918, 0.51372551918), (0.365853667259, 0.552941203117, 0.552941203117), (0.390243887901, 0.588235318661, 0.588235318661), (0.414634138346, 0.623529434204, 0.623529434204), (0.43902438879, 0.658823549747, 0.658823549747), (0.463414639235, 0.694117665291, 0.694117665291), (0.487804889679, 0.729411780834, 0.729411780834), (0.512195110321, 0.717647075653, 0.717647075653), (0.536585390568, 0.658823549747, 0.658823549747), (0.56097561121, 0.603921592236, 0.603921592236), (0.585365831852, 0.537254929543, 0.537254929543), (0.609756112099, 0.380392163992, 0.380392163992), (0.634146332741, 0.227450981736, 0.227450981736), (0.658536612988, 0.0431372560561, 0.0431372560561), (0.68292683363, 0.0, 0.0), (0.707317054272, 0.0, 0.0), (0.731707334518, 0.0, 0.0), (0.756097555161, 0.0, 0.0), (0.780487775803, 0.0, 0.0), (0.804878056049, 0.0, 0.0), (0.829268276691, 0.0, 0.0), (0.853658556938, 0.145098045468, 0.145098045468), (0.87804877758, 0.309803932905, 0.309803932905), (0.902438998222, 0.478431373835, 0.478431373835), (0.926829278469, 0.529411792755, 0.529411792755), (0.951219499111, 0.333333343267, 0.333333343267), (0.975609779358, 0.168627455831, 0.168627455831), (1.0, 0.0, 0.0)], 'green': [(0.0, 0.0, 0.0), (0.0243902429938, 0.0, 0.0), (0.0487804859877, 0.0, 0.0), (0.0731707289815, 0.0, 0.0), (0.0975609719753, 0.0941176488996, 0.0941176488996), (0.12195122242, 0.235294118524, 0.235294118524), (0.146341457963, 0.380392163992, 0.380392163992), (0.170731708407, 0.521568655968, 0.521568655968), (0.195121943951, 0.662745118141, 0.662745118141), (0.219512194395, 0.827450990677, 0.827450990677), (0.243902444839, 0.96862745285, 0.96862745285), (0.268292695284, 1.0, 1.0), (0.292682915926, 1.0, 1.0), (0.31707316637, 1.0, 1.0), (0.341463416815, 1.0, 1.0), (0.365853667259, 1.0, 1.0), (0.390243887901, 1.0, 1.0), (0.414634138346, 1.0, 1.0), (0.43902438879, 0.933333337307, 0.933333337307), (0.463414639235, 0.86274510622, 0.86274510622), (0.487804889679, 0.792156875134, 0.792156875134), (0.512195110321, 0.792156875134, 0.792156875134), (0.536585390568, 0.86274510622, 0.86274510622), (0.56097561121, 0.933333337307, 0.933333337307), (0.585365831852, 0.996078431606, 0.996078431606), (0.609756112099, 0.92549020052, 0.92549020052), (0.634146332741, 0.854901969433, 0.854901969433), (0.658536612988, 0.772549033165, 0.772549033165), (0.68292683363, 0.701960802078, 0.701960802078), (0.707317054272, 0.631372570992, 0.631372570992), (0.731707334518, 0.556862771511, 0.556862771511), (0.756097555161, 0.470588237047, 0.470588237047), (0.780487775803, 0.329411774874, 0.329411774874), (0.804878056049, 0.160784319043, 0.160784319043), (0.829268276691, 0.0196078438312, 0.0196078438312), (0.853658556938, 0.0, 0.0), (0.87804877758, 0.0, 0.0), (0.902438998222, 0.0, 0.0), (0.926829278469, 0.0, 0.0), (0.951219499111, 0.0, 0.0), (0.975609779358, 0.0, 0.0), (1.0, 0.0, 0.0)], 'red': [(0.0, 0.419607847929, 0.419607847929), (0.0243902429938, 0.478431373835, 0.478431373835), (0.0487804859877, 0.541176497936, 0.541176497936), (0.0731707289815, 0.611764729023, 0.611764729023), (0.0975609719753, 0.51372551918, 0.51372551918), (0.12195122242, 0.333333343267, 0.333333343267), (0.146341457963, 0.152941182256, 0.152941182256), (0.170731708407, 0.0, 0.0), (0.195121943951, 0.0, 0.0), (0.219512194395, 0.0, 0.0), (0.243902444839, 0.0, 0.0), (0.268292695284, 0.113725490868, 0.113725490868), (0.292682915926, 0.254901975393, 0.254901975393), (0.31707316637, 0.40000000596, 0.40000000596), (0.341463416815, 0.521568655968, 0.521568655968), (0.365853667259, 0.603921592236, 0.603921592236), (0.390243887901, 0.678431391716, 0.678431391716), (0.414634138346, 0.749019622803, 0.749019622803), (0.43902438879, 0.752941191196, 0.752941191196), (0.463414639235, 0.749019622803, 0.749019622803), (0.487804889679, 0.749019622803, 0.749019622803), (0.512195110321, 0.792156875134, 0.792156875134), (0.536585390568, 0.86274510622, 0.86274510622), (0.56097561121, 0.933333337307, 0.933333337307), (0.585365831852, 1.0, 1.0), (0.609756112099, 1.0, 1.0), (0.634146332741, 1.0, 1.0), (0.658536612988, 1.0, 1.0), (0.68292683363, 1.0, 1.0), (0.707317054272, 1.0, 1.0), (0.731707334518, 1.0, 1.0), (0.756097555161, 1.0, 1.0), (0.780487775803, 1.0, 1.0), (0.804878056049, 1.0, 1.0), (0.829268276691, 1.0, 1.0), (0.853658556938, 0.964705884457, 0.964705884457), (0.87804877758, 0.92549020052, 0.92549020052), (0.902438998222, 0.890196084976, 0.890196084976), (0.926829278469, 0.827450990677, 0.827450990677), (0.951219499111, 0.705882370472, 0.705882370472), (0.975609779358, 0.603921592236, 0.603921592236), (1.0, 0.501960813999, 0.501960813999)]}
sstanom = colors.LinearSegmentedColormap('sstanom', _sstanom_data, _LUTSIZE)
datad={}
datad['GMT_drywet']=_GMT_drywet_data
datad['GMT_gebco']=_GMT_gebco_data
datad['GMT_globe']=_GMT_globe_data
datad['GMT_haxby']=_GMT_haxby_data
datad['GMT_no_green']=_GMT_no_green_data
datad['GMT_ocean']=_GMT_ocean_data
datad['GMT_polar']=_GMT_polar_data
datad['GMT_red2green']=_GMT_red2green_data
datad['GMT_relief']=_GMT_relief_data
datad['GMT_seis']=_GMT_seis_data
datad['GMT_split']=_GMT_split_data
datad['GMT_wysiwyg']=_GMT_wysiwyg_data
datad['s3pcpn']=_s3pcpn_data
datad['s3pcpn_l']=_s3pcpn_l_data
datad['StepSeq']=_StepSeq_data
datad['sstanom']=_sstanom_data

# reverse all the colormaps.
# reversed colormaps have '_r' appended to the name.

def _revcmap(data):
    data_r = {}
    for key,val in iteritems(data):
        val = list(val)
        valrev = val[::-1]
        valnew = []
        for a,b,c in valrev:
            valnew.append((1.-a,b,c))
        data_r[key]=valnew
    return data_r

_cmapnames = list(datad.keys())
for _cmapname in _cmapnames:
    _cmapname_r = _cmapname+'_r'
    _cmapdat_r = _revcmap(datad[_cmapname])
    datad[_cmapname_r] = _cmapdat_r
    locals()[_cmapname_r] = colors.LinearSegmentedColormap(_cmapname_r, _cmapdat_r, _LUTSIZE)
