/**
 * **IMPORTANT** this module should not depend on `vscode-languageserver` only protocol and types
 */
import lsp from 'vscode-languageserver-protocol';
import tslib from 'typescript/lib/tsserverlibrary.js';
import type { TraceValue } from './tsServer/tracer.js';
import tsp = tslib.server.protocol;
export { tslib, tsp };
export declare namespace TypeScriptRenameRequest {
    const type: lsp.RequestType<lsp.TextDocumentPositionParams, void, void>;
}
declare module 'typescript/lib/tsserverlibrary.js' {
    namespace server.protocol {
        enum CommandTypes {
            EncodedSemanticClassificationsFull = "encodedSemanticClassifications-full"
        }
    }
}
export declare const enum EventTypes {
    ConfigFileDiag = "configFileDiag",
    SyntaxDiag = "syntaxDiag",
    SementicDiag = "semanticDiag",
    SuggestionDiag = "suggestionDiag",
    ProjectLoadingStart = "projectLoadingStart",
    ProjectLoadingFinish = "projectLoadingFinish"
}
export declare class KindModifiers {
    static readonly optional = "optional";
    static readonly deprecated = "deprecated";
    static readonly dtsFile = ".d.ts";
    static readonly tsFile = ".ts";
    static readonly tsxFile = ".tsx";
    static readonly jsFile = ".js";
    static readonly jsxFile = ".jsx";
    static readonly jsonFile = ".json";
    static readonly fileExtensionKindModifiers: string[];
}
export declare function toSymbolDisplayPartKind(kind: string): tslib.SymbolDisplayPartKind;
export interface SupportedFeatures {
    codeActionDisabledSupport?: boolean;
    completionInsertReplaceSupport?: boolean;
    completionLabelDetails?: boolean;
    completionSnippets?: boolean;
    definitionLinkSupport?: boolean;
    diagnosticsTagSupport?: boolean;
}
export interface TypeScriptPlugin {
    name: string;
    location: string;
}
export interface TypeScriptInitializationOptions {
    disableAutomaticTypingAcquisition?: boolean;
    hostInfo?: string;
    locale?: string;
    maxTsServerMemory?: number;
    npmLocation?: string;
    plugins: TypeScriptPlugin[];
    preferences?: tsp.UserPreferences;
    tsserver?: TsserverOptions;
}
interface TsserverOptions {
    /**
     * The path to the directory where the `tsserver` log files will be created.
     * If not provided, the log files will be created within the workspace, inside the `.log` directory.
     * If no workspace root is provided when initializating the server and no custom path is specified then
     * the logs will not be created.
     * @default undefined
     */
    logDirectory?: string;
    /**
     * Verbosity of the information logged into the `tsserver` log files.
     *
     * Log levels from least to most amount of details: `'terse'`, `'normal'`, `'requestTime`', `'verbose'`.
     * Enabling particular level also enables all lower levels.
     *
     * @default 'off'
     */
    logVerbosity?: 'off' | 'terse' | 'normal' | 'requestTime' | 'verbose';
    /**
     * The path to the `tsserver.js` file or the typescript lib directory. For example: `/Users/me/typescript/lib/tsserver.js`.
     */
    path?: string;
    /**
     * The verbosity of logging the tsserver communication through the LSP messages.
     * This doesn't affect the file logging.
     * @default 'off'
     */
    trace?: TraceValue;
}
export type TypeScriptInitializeParams = lsp.InitializeParams & {
    initializationOptions?: Partial<TypeScriptInitializationOptions>;
};
//# sourceMappingURL=ts-protocol.d.ts.map