/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.admin.cluster.shards.routing.weighted.get;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opensearch.OpenSearchParseException;
import org.opensearch.action.ActionResponse;
import org.opensearch.cluster.routing.WeightedRouting;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.common.xcontent.ToXContent;
import org.opensearch.common.xcontent.ToXContentObject;
import org.opensearch.common.xcontent.XContentBuilder;
import org.opensearch.common.xcontent.XContentParser;
import org.opensearch.common.xcontent.XContentParserUtils;

public class ClusterGetWeightedRoutingResponse
extends ActionResponse
implements ToXContentObject {
    private WeightedRouting weightedRouting;
    private String localNodeWeight;
    private static final String NODE_WEIGHT = "node_weight";

    public String getLocalNodeWeight() {
        return this.localNodeWeight;
    }

    ClusterGetWeightedRoutingResponse() {
        this.weightedRouting = null;
    }

    public ClusterGetWeightedRoutingResponse(String localNodeWeight, WeightedRouting weightedRouting) {
        this.localNodeWeight = localNodeWeight;
        this.weightedRouting = weightedRouting;
    }

    ClusterGetWeightedRoutingResponse(StreamInput in) throws IOException {
        if (in.available() != 0) {
            this.weightedRouting = new WeightedRouting(in);
        }
    }

    public WeightedRouting weights() {
        return this.weightedRouting;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        if (this.weightedRouting != null) {
            this.weightedRouting.writeTo(out);
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.weightedRouting != null) {
            for (Map.Entry<String, Double> entry : this.weightedRouting.weights().entrySet()) {
                builder.field(entry.getKey(), entry.getValue().toString());
            }
            if (this.localNodeWeight != null) {
                builder.field(NODE_WEIGHT, this.localNodeWeight);
            }
        }
        builder.endObject();
        return builder;
    }

    public static ClusterGetWeightedRoutingResponse fromXContent(XContentParser parser) throws IOException {
        XContentParser.Token token;
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_OBJECT, parser.nextToken(), parser);
        String attrKey = null;
        String attrValue = null;
        String localNodeWeight = null;
        HashMap<String, Double> weights = new HashMap<String, Double>();
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                attrKey = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.VALUE_STRING) {
                attrValue = parser.text();
                if (attrKey != null && attrKey.equals(NODE_WEIGHT)) {
                    localNodeWeight = attrValue;
                    continue;
                }
                if (attrKey == null) continue;
                weights.put(attrKey, Double.parseDouble(attrValue));
                continue;
            }
            throw new OpenSearchParseException("failed to parse weighted routing response", new Object[0]);
        }
        WeightedRouting weightedRouting = new WeightedRouting("", weights);
        return new ClusterGetWeightedRoutingResponse(localNodeWeight, weightedRouting);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClusterGetWeightedRoutingResponse that = (ClusterGetWeightedRoutingResponse)o;
        return this.weightedRouting.equals(that.weightedRouting) && this.localNodeWeight.equals(that.localNodeWeight);
    }

    public int hashCode() {
        return Objects.hash(this.weightedRouting, this.localNodeWeight);
    }
}

