/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.admin.indices.template.get;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.opensearch.action.ActionRequestValidationException;
import org.opensearch.action.ActionResponse;
import org.opensearch.action.ActionType;
import org.opensearch.action.support.clustermanager.ClusterManagerNodeReadRequest;
import org.opensearch.cluster.metadata.ComponentTemplate;
import org.opensearch.common.Nullable;
import org.opensearch.common.ParseField;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.common.xcontent.ToXContent;
import org.opensearch.common.xcontent.ToXContentObject;
import org.opensearch.common.xcontent.XContentBuilder;

public class GetComponentTemplateAction
extends ActionType<Response> {
    public static final GetComponentTemplateAction INSTANCE = new GetComponentTemplateAction();
    public static final String NAME = "cluster:admin/component_template/get";

    private GetComponentTemplateAction() {
        super(NAME, Response::new);
    }

    public static class Response
    extends ActionResponse
    implements ToXContentObject {
        public static final ParseField NAME = new ParseField("name", new String[0]);
        public static final ParseField COMPONENT_TEMPLATES = new ParseField("component_templates", new String[0]);
        public static final ParseField COMPONENT_TEMPLATE = new ParseField("component_template", new String[0]);
        private final Map<String, ComponentTemplate> componentTemplates;

        public Response(StreamInput in) throws IOException {
            super(in);
            this.componentTemplates = in.readMap(StreamInput::readString, ComponentTemplate::new);
        }

        public Response(Map<String, ComponentTemplate> componentTemplates) {
            this.componentTemplates = componentTemplates;
        }

        public Map<String, ComponentTemplate> getComponentTemplates() {
            return this.componentTemplates;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeMap(this.componentTemplates, StreamOutput::writeString, (o, v) -> v.writeTo(o));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Response that = (Response)o;
            return Objects.equals(this.componentTemplates, that.componentTemplates);
        }

        public int hashCode() {
            return Objects.hash(this.componentTemplates);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.startArray(COMPONENT_TEMPLATES.getPreferredName());
            for (Map.Entry<String, ComponentTemplate> componentTemplate : this.componentTemplates.entrySet()) {
                builder.startObject();
                builder.field(NAME.getPreferredName(), componentTemplate.getKey());
                builder.field(COMPONENT_TEMPLATE.getPreferredName(), (ToXContent)componentTemplate.getValue());
                builder.endObject();
            }
            builder.endArray();
            builder.endObject();
            return builder;
        }
    }

    public static class Request
    extends ClusterManagerNodeReadRequest<Request> {
        @Nullable
        private String name;

        public Request() {
        }

        public Request(String name) {
            this.name = name;
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.name = in.readOptionalString();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeOptionalString(this.name);
        }

        @Override
        public ActionRequestValidationException validate() {
            return null;
        }

        public Request name(String name) {
            this.name = name;
            return this;
        }

        public String name() {
            return this.name;
        }
    }
}

