/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.cluster.routing;

import org.opensearch.cluster.metadata.IndexMetadata;
import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.cluster.routing.RoutingNode;
import org.opensearch.cluster.routing.ShardRouting;
import org.opensearch.cluster.routing.allocation.RoutingAllocation;
import org.opensearch.common.settings.Settings;
import org.opensearch.index.IndexModule;

public enum RoutingPool {
    LOCAL_ONLY,
    REMOTE_CAPABLE;


    public static RoutingPool getNodePool(RoutingNode node) {
        return RoutingPool.getNodePool(node.node());
    }

    public static RoutingPool getNodePool(DiscoveryNode node) {
        if (node.isSearchNode()) {
            return REMOTE_CAPABLE;
        }
        return LOCAL_ONLY;
    }

    public static RoutingPool getShardPool(ShardRouting shard, RoutingAllocation allocation) {
        IndexMetadata indexMetadata = allocation.metadata().getIndexSafe(shard.index());
        return RoutingPool.getIndexPool(indexMetadata);
    }

    public static RoutingPool getIndexPool(IndexMetadata indexMetadata) {
        Settings indexSettings = indexMetadata.getSettings();
        if (IndexModule.Type.REMOTE_SNAPSHOT.getSettingsKey().equals(indexSettings.get(IndexModule.INDEX_STORE_TYPE_SETTING.getKey()))) {
            return REMOTE_CAPABLE;
        }
        return LOCAL_ONLY;
    }
}

