/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.cluster.routing;

import java.util.List;
import java.util.Locale;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.opensearch.action.ActionListener;
import org.opensearch.action.ActionRequestValidationException;
import org.opensearch.action.ValidateActions;
import org.opensearch.action.admin.cluster.shards.routing.weighted.delete.ClusterDeleteWeightedRoutingRequest;
import org.opensearch.action.admin.cluster.shards.routing.weighted.delete.ClusterDeleteWeightedRoutingResponse;
import org.opensearch.action.admin.cluster.shards.routing.weighted.put.ClusterPutWeightedRoutingRequest;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.ClusterStateUpdateTask;
import org.opensearch.cluster.ack.ClusterStateUpdateResponse;
import org.opensearch.cluster.decommission.DecommissionAttributeMetadata;
import org.opensearch.cluster.decommission.DecommissionStatus;
import org.opensearch.cluster.metadata.Metadata;
import org.opensearch.cluster.metadata.WeightedRoutingMetadata;
import org.opensearch.cluster.routing.allocation.decider.AwarenessAllocationDecider;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.Priority;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.settings.ClusterSettings;
import org.opensearch.common.settings.Settings;
import org.opensearch.threadpool.ThreadPool;

public class WeightedRoutingService {
    private static final Logger logger = LogManager.getLogger(WeightedRoutingService.class);
    private final ClusterService clusterService;
    private final ThreadPool threadPool;
    private volatile List<String> awarenessAttributes;

    @Inject
    public WeightedRoutingService(ClusterService clusterService, ThreadPool threadPool, Settings settings, ClusterSettings clusterSettings) {
        this.clusterService = clusterService;
        this.threadPool = threadPool;
        this.awarenessAttributes = AwarenessAllocationDecider.CLUSTER_ROUTING_ALLOCATION_AWARENESS_ATTRIBUTE_SETTING.get(settings);
        clusterSettings.addSettingsUpdateConsumer(AwarenessAllocationDecider.CLUSTER_ROUTING_ALLOCATION_AWARENESS_ATTRIBUTE_SETTING, this::setAwarenessAttributes);
    }

    public void registerWeightedRoutingMetadata(final ClusterPutWeightedRoutingRequest request, final ActionListener<ClusterStateUpdateResponse> listener) {
        final WeightedRoutingMetadata newWeightedRoutingMetadata = new WeightedRoutingMetadata(request.getWeightedRouting());
        this.clusterService.submitStateUpdateTask("update_weighted_routing", new ClusterStateUpdateTask(Priority.URGENT){

            @Override
            public ClusterState execute(ClusterState currentState) {
                WeightedRoutingService.this.ensureNoOngoingDecommissionAction(currentState);
                Metadata metadata = currentState.metadata();
                Metadata.Builder mdBuilder = Metadata.builder(currentState.metadata());
                WeightedRoutingMetadata weightedRoutingMetadata = (WeightedRoutingMetadata)metadata.custom("weighted_shard_routing");
                if (weightedRoutingMetadata == null) {
                    logger.info("put weighted routing weights in metadata [{}]", (Object)request.getWeightedRouting());
                    weightedRoutingMetadata = new WeightedRoutingMetadata(request.getWeightedRouting());
                } else if (!WeightedRoutingService.this.checkIfSameWeightsInMetadata(newWeightedRoutingMetadata, weightedRoutingMetadata)) {
                    logger.info("updated weighted routing weights [{}] in metadata", (Object)request.getWeightedRouting());
                    weightedRoutingMetadata = new WeightedRoutingMetadata(newWeightedRoutingMetadata.getWeightedRouting());
                } else {
                    return currentState;
                }
                mdBuilder.putCustom("weighted_shard_routing", weightedRoutingMetadata);
                logger.info("building cluster state with weighted routing weights [{}]", (Object)request.getWeightedRouting());
                return ClusterState.builder(currentState).metadata(mdBuilder).build();
            }

            @Override
            public void onFailure(String source, Exception e) {
                logger.warn(() -> new ParameterizedMessage("failed to update cluster state for weighted routing weights [{}]", (Object)e));
                listener.onFailure(e);
            }

            @Override
            public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                logger.debug("cluster weighted routing weights metadata change is processed by all the nodes");
                listener.onResponse(new ClusterStateUpdateResponse(true));
            }
        });
    }

    private boolean checkIfSameWeightsInMetadata(WeightedRoutingMetadata newWeightedRoutingMetadata, WeightedRoutingMetadata oldWeightedRoutingMetadata) {
        return newWeightedRoutingMetadata.getWeightedRouting().equals(oldWeightedRoutingMetadata.getWeightedRouting());
    }

    public void deleteWeightedRoutingMetadata(ClusterDeleteWeightedRoutingRequest request, final ActionListener<ClusterDeleteWeightedRoutingResponse> listener) {
        this.clusterService.submitStateUpdateTask("delete_weighted_routing", new ClusterStateUpdateTask(Priority.URGENT){

            @Override
            public ClusterState execute(ClusterState currentState) {
                logger.info("Deleting weighted routing metadata from the cluster state");
                Metadata.Builder mdBuilder = Metadata.builder(currentState.metadata());
                mdBuilder.removeCustom("weighted_shard_routing");
                return ClusterState.builder(currentState).metadata(mdBuilder).build();
            }

            @Override
            public void onFailure(String source, Exception e) {
                logger.error("failed to remove weighted routing metadata from cluster state", (Throwable)e);
                listener.onFailure(e);
            }

            @Override
            public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                logger.debug("cluster weighted routing metadata change is processed by all the nodes");
                assert (newState.metadata().weightedRoutingMetadata() == null);
                listener.onResponse(new ClusterDeleteWeightedRoutingResponse(true));
            }
        });
    }

    List<String> getAwarenessAttributes() {
        return this.awarenessAttributes;
    }

    private void setAwarenessAttributes(List<String> awarenessAttributes) {
        this.awarenessAttributes = awarenessAttributes;
    }

    public void verifyAwarenessAttribute(String attributeName) {
        if (!this.getAwarenessAttributes().contains(attributeName)) {
            ActionRequestValidationException validationException = null;
            validationException = ValidateActions.addValidationError(String.format(Locale.ROOT, "invalid awareness attribute %s requested for updating weighted routing", attributeName), validationException);
            throw validationException;
        }
    }

    public void ensureNoOngoingDecommissionAction(ClusterState state) {
        DecommissionAttributeMetadata decommissionAttributeMetadata = state.metadata().decommissionAttributeMetadata();
        if (decommissionAttributeMetadata != null && !decommissionAttributeMetadata.status().equals((Object)DecommissionStatus.FAILED)) {
            throw new IllegalStateException("a decommission action is ongoing with status [" + decommissionAttributeMetadata.status().status() + "], cannot update weight during this state");
        }
    }
}

