/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.common.metrics;

import java.util.concurrent.atomic.LongAdder;
import org.opensearch.common.metrics.Metric;

public class MeanMetric
implements Metric {
    private final LongAdder counter = new LongAdder();
    private final LongAdder sum = new LongAdder();

    public void inc(long n) {
        this.counter.increment();
        this.sum.add(n);
    }

    public void dec(long n) {
        this.counter.decrement();
        this.sum.add(-n);
    }

    public long count() {
        return this.counter.sum();
    }

    public long sum() {
        return this.sum.sum();
    }

    public double mean() {
        long count = this.count();
        if (count > 0L) {
            return (double)this.sum.sum() / (double)count;
        }
        return 0.0;
    }

    public void clear() {
        this.counter.reset();
        this.sum.reset();
    }
}

