/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.store.remote.utils;

import java.nio.file.Path;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;

public class BlobFetchRequest {
    private final long position;
    private final long length;
    private final String blobName;
    private final Path filePath;
    private final Directory directory;
    private final String fileName;

    private BlobFetchRequest(Builder builder) {
        this.position = builder.position;
        this.length = builder.length;
        this.blobName = builder.blobName;
        this.fileName = builder.fileName;
        this.filePath = builder.directory.getDirectory().resolve(this.fileName);
        this.directory = builder.directory;
    }

    public long getPosition() {
        return this.position;
    }

    public long getLength() {
        return this.length;
    }

    public String getBlobName() {
        return this.blobName;
    }

    public Path getFilePath() {
        return this.filePath;
    }

    public Directory getDirectory() {
        return this.directory;
    }

    public String getFileName() {
        return this.fileName;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        return "BlobFetchRequest{position=" + this.position + ", length=" + this.length + ", blobName='" + this.blobName + "', filePath=" + this.filePath + ", directory=" + this.directory + ", fileName='" + this.fileName + "'}";
    }

    public static final class Builder {
        private long position;
        private long length;
        private String blobName;
        private FSDirectory directory;
        private String fileName;

        private Builder() {
        }

        public Builder position(long position) {
            this.position = position;
            return this;
        }

        public Builder length(long length) {
            if (length <= 0L) {
                throw new IllegalArgumentException("Length for blob fetch request needs to be non-negative");
            }
            this.length = length;
            return this;
        }

        public Builder blobName(String blobName) {
            this.blobName = blobName;
            return this;
        }

        public Builder directory(FSDirectory directory) {
            this.directory = directory;
            return this;
        }

        public Builder fileName(String fileName) {
            this.fileName = fileName;
            return this;
        }

        public BlobFetchRequest build() {
            return new BlobFetchRequest(this);
        }
    }
}

