/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.backpressure.trackers;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.xcontent.ToXContent;
import org.opensearch.common.xcontent.XContentBuilder;
import org.opensearch.search.backpressure.settings.SearchBackpressureSettings;
import org.opensearch.search.backpressure.trackers.TaskResourceUsageTracker;
import org.opensearch.search.backpressure.trackers.TaskResourceUsageTrackerType;
import org.opensearch.tasks.Task;
import org.opensearch.tasks.TaskCancellation;

public class CpuUsageTracker
extends TaskResourceUsageTracker {
    private volatile long cpuTimeMillisThreshold;
    public static final Setting<Long> SETTING_CPU_TIME_MILLIS_THRESHOLD = Setting.longSetting("search_backpressure.search_shard_task.cpu_time_millis_threshold", 15000L, 0L, Setting.Property.Dynamic, Setting.Property.NodeScope);

    public CpuUsageTracker(SearchBackpressureSettings settings) {
        this.cpuTimeMillisThreshold = SETTING_CPU_TIME_MILLIS_THRESHOLD.get(settings.getSettings());
        settings.getClusterSettings().addSettingsUpdateConsumer(SETTING_CPU_TIME_MILLIS_THRESHOLD, this::setCpuTimeMillisThreshold);
    }

    @Override
    public String name() {
        return TaskResourceUsageTrackerType.CPU_USAGE_TRACKER.getName();
    }

    @Override
    public Optional<TaskCancellation.Reason> checkAndMaybeGetCancellationReason(Task task) {
        long threshold;
        long usage = task.getTotalResourceStats().getCpuTimeInNanos();
        if (usage < (threshold = this.getCpuTimeNanosThreshold())) {
            return Optional.empty();
        }
        return Optional.of(new TaskCancellation.Reason("cpu usage exceeded [" + new TimeValue(usage, TimeUnit.NANOSECONDS) + " >= " + new TimeValue(threshold, TimeUnit.NANOSECONDS) + "]", 1));
    }

    public long getCpuTimeNanosThreshold() {
        return TimeUnit.MILLISECONDS.toNanos(this.cpuTimeMillisThreshold);
    }

    public void setCpuTimeMillisThreshold(long cpuTimeMillisThreshold) {
        this.cpuTimeMillisThreshold = cpuTimeMillisThreshold;
    }

    @Override
    public TaskResourceUsageTracker.Stats stats(List<? extends Task> activeTasks) {
        long currentMax = activeTasks.stream().mapToLong(t -> t.getTotalResourceStats().getCpuTimeInNanos()).max().orElse(0L);
        long currentAvg = (long)activeTasks.stream().mapToLong(t -> t.getTotalResourceStats().getCpuTimeInNanos()).average().orElse(0.0);
        return new Stats(this.getCancellations(), currentMax, currentAvg);
    }

    public static class Stats
    implements TaskResourceUsageTracker.Stats {
        private final long cancellationCount;
        private final long currentMax;
        private final long currentAvg;

        public Stats(long cancellationCount, long currentMax, long currentAvg) {
            this.cancellationCount = cancellationCount;
            this.currentMax = currentMax;
            this.currentAvg = currentAvg;
        }

        public Stats(StreamInput in) throws IOException {
            this(in.readVLong(), in.readVLong(), in.readVLong());
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            return builder.startObject().field("cancellation_count", this.cancellationCount).humanReadableField("current_max_millis", "current_max", (Object)new TimeValue(this.currentMax, TimeUnit.NANOSECONDS)).humanReadableField("current_avg_millis", "current_avg", (Object)new TimeValue(this.currentAvg, TimeUnit.NANOSECONDS)).endObject();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeVLong(this.cancellationCount);
            out.writeVLong(this.currentMax);
            out.writeVLong(this.currentAvg);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Stats stats = (Stats)o;
            return this.cancellationCount == stats.cancellationCount && this.currentMax == stats.currentMax && this.currentAvg == stats.currentAvg;
        }

        public int hashCode() {
            return Objects.hash(this.cancellationCount, this.currentMax, this.currentAvg);
        }
    }

    private static class Defaults {
        private static final long CPU_TIME_MILLIS_THRESHOLD = 15000L;

        private Defaults() {
        }
    }
}

