/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.lookup;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.StoredFieldVisitor;
import org.opensearch.OpenSearchParseException;
import org.opensearch.index.fieldvisitor.SingleFieldsVisitor;
import org.opensearch.index.mapper.MappedFieldType;
import org.opensearch.index.mapper.MapperService;
import org.opensearch.search.lookup.FieldLookup;

public class LeafFieldsLookup
implements Map {
    private final MapperService mapperService;
    private final LeafReader reader;
    private int docId = -1;
    private final Map<String, FieldLookup> cachedFieldData = new HashMap<String, FieldLookup>();

    LeafFieldsLookup(MapperService mapperService, LeafReader reader) {
        this.mapperService = mapperService;
        this.reader = reader;
    }

    public void setDocument(int docId) {
        if (this.docId == docId) {
            return;
        }
        this.docId = docId;
        this.clearCache();
    }

    public Object get(Object key) {
        return this.loadFieldData(key.toString());
    }

    @Override
    public boolean containsKey(Object key) {
        try {
            this.loadFieldData(key.toString());
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public int size() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isEmpty() {
        throw new UnsupportedOperationException();
    }

    public Set keySet() {
        throw new UnsupportedOperationException();
    }

    public Collection values() {
        throw new UnsupportedOperationException();
    }

    public Set entrySet() {
        throw new UnsupportedOperationException();
    }

    public Object put(Object key, Object value) {
        throw new UnsupportedOperationException();
    }

    public Object remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    public void putAll(Map m) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsValue(Object value) {
        throw new UnsupportedOperationException();
    }

    private FieldLookup loadFieldData(String name) {
        FieldLookup data = this.cachedFieldData.get(name);
        if (data == null) {
            MappedFieldType fieldType = this.mapperService.fieldType(name);
            if (fieldType == null) {
                throw new IllegalArgumentException("No field found for [" + name + "] in mapping");
            }
            data = new FieldLookup(fieldType);
            this.cachedFieldData.put(name, data);
        }
        if (data.fields() == null) {
            ArrayList<Object> values = new ArrayList<Object>(2);
            SingleFieldsVisitor visitor = new SingleFieldsVisitor(data.fieldType(), values);
            try {
                this.reader.document(this.docId, (StoredFieldVisitor)visitor);
            }
            catch (IOException e) {
                throw new OpenSearchParseException("failed to load field [{}]", (Throwable)e, name);
            }
            data.fields(Collections.singletonMap(data.fieldType().name(), values));
        }
        return data;
    }

    private void clearCache() {
        for (Map.Entry<String, FieldLookup> entry : this.cachedFieldData.entrySet()) {
            entry.getValue().clear();
        }
    }
}

