/*
 * Decompiled with CFR 0.152.
 */
package javajs.util;

import javajs.api.EigenInterface;
import javajs.api.Interface;
import javajs.util.Lst;
import javajs.util.M3;
import javajs.util.M4;
import javajs.util.P3;
import javajs.util.P4;
import javajs.util.Quat;
import javajs.util.T3;
import javajs.util.V3;

public final class Measure {
    public static final float radiansPerDegree = (float)Math.PI / 180;
    public static final V3 axisY = V3.new3(0.0f, 1.0f, 0.0f);

    public static float computeAngle(T3 pointA, T3 pointB, T3 pointC, V3 vectorBA, V3 vectorBC, boolean asDegrees) {
        vectorBA.sub2(pointA, pointB);
        vectorBC.sub2(pointC, pointB);
        float angle = vectorBA.angle(vectorBC);
        return asDegrees ? angle / ((float)Math.PI / 180) : angle;
    }

    public static float computeAngleABC(T3 pointA, T3 pointB, T3 pointC, boolean asDegrees) {
        V3 vectorBA = new V3();
        V3 vectorBC = new V3();
        return Measure.computeAngle(pointA, pointB, pointC, vectorBA, vectorBC, asDegrees);
    }

    public static float computeTorsion(T3 p1, T3 p2, T3 p3, T3 p4, boolean asDegrees) {
        float ci;
        float ijx = p1.x - p2.x;
        float ijy = p1.y - p2.y;
        float ijz = p1.z - p2.z;
        float kjx = p3.x - p2.x;
        float kjy = p3.y - p2.y;
        float kjz = p3.z - p2.z;
        float klx = p3.x - p4.x;
        float kly = p3.y - p4.y;
        float klz = p3.z - p4.z;
        float ax = ijy * kjz - ijz * kjy;
        float ay = ijz * kjx - ijx * kjz;
        float az = ijx * kjy - ijy * kjx;
        float cx = kjy * klz - kjz * kly;
        float cy = kjz * klx - kjx * klz;
        float cz = kjx * kly - kjy * klx;
        float ai2 = 1.0f / (ax * ax + ay * ay + az * az);
        float ci2 = 1.0f / (cx * cx + cy * cy + cz * cz);
        float cross = ax * cx + ay * cy + az * cz;
        float ai = (float)Math.sqrt(ai2);
        float denom = ai * (ci = (float)Math.sqrt(ci2));
        float cosang = cross * denom;
        if (cosang > 1.0f) {
            cosang = 1.0f;
        }
        if (cosang < -1.0f) {
            cosang = -1.0f;
        }
        float torsion = (float)Math.acos(cosang);
        float dot = ijx * cx + ijy * cy + ijz * cz;
        float absDot = Math.abs(dot);
        torsion = dot / absDot > 0.0f ? torsion : -torsion;
        return asDegrees ? torsion / ((float)Math.PI / 180) : torsion;
    }

    public static T3[] computeHelicalAxis(P3 a, P3 b, Quat dq) {
        V3 vab = new V3();
        vab.sub2(b, a);
        float theta = dq.getTheta();
        V3 n = dq.getNormal();
        float v_dot_n = vab.dot(n);
        if (Math.abs(v_dot_n) < 1.0E-4f) {
            v_dot_n = 0.0f;
        }
        V3 va_prime_d = new V3();
        va_prime_d.cross(vab, n);
        if (va_prime_d.dot(va_prime_d) != 0.0f) {
            va_prime_d.normalize();
        }
        V3 vda = new V3();
        V3 vcb = V3.newV(n);
        if (v_dot_n == 0.0f) {
            v_dot_n = Float.MIN_VALUE;
        }
        vcb.scale(v_dot_n);
        vda.sub2(vcb, vab);
        vda.scale(0.5f);
        va_prime_d.scale(theta == 0.0f ? 0.0f : (float)((double)vda.length() / Math.tan((double)(theta / 2.0f / 180.0f) * Math.PI)));
        V3 r = V3.newV(va_prime_d);
        if (theta != 0.0f) {
            r.add(vda);
        }
        P3 pt_a_prime = P3.newP(a);
        pt_a_prime.sub(r);
        if (v_dot_n != Float.MIN_VALUE) {
            n.scale(v_dot_n);
        }
        P3 pt_b_prime = P3.newP(pt_a_prime);
        pt_b_prime.add(n);
        theta = Measure.computeTorsion(a, pt_a_prime, pt_b_prime, b, true);
        if (Float.isNaN(theta) || r.length() < 1.0E-4f) {
            theta = dq.getThetaDirectedV(n);
        }
        float residuesPerTurn = Math.abs(theta == 0.0f ? 0.0f : 360.0f / theta);
        float pitch = Math.abs(v_dot_n == Float.MIN_VALUE ? 0.0f : n.length() * (theta == 0.0f ? 1.0f : 360.0f / theta));
        return new T3[]{pt_a_prime, n, r, P3.new3(theta, pitch, residuesPerTurn), pt_b_prime};
    }

    public static P4 getPlaneThroughPoints(T3 pointA, T3 pointB, T3 pointC, V3 vNorm, V3 vAB, P4 plane) {
        if (vNorm == null) {
            vNorm = new V3();
        }
        if (vAB == null) {
            vAB = new V3();
        }
        float w = Measure.getNormalThroughPoints(pointA, pointB, pointC, vNorm, vAB);
        plane.set4(vNorm.x, vNorm.y, vNorm.z, w);
        return plane;
    }

    public static void getPlaneThroughPoint(T3 pt, V3 normal, P4 plane) {
        plane.set4(normal.x, normal.y, normal.z, -normal.dot(pt));
    }

    public static float distanceToPlane(P4 plane, T3 pt) {
        return plane == null ? Float.NaN : (plane.dot(pt) + plane.w) / (float)Math.sqrt(plane.dot(plane));
    }

    public static float directedDistanceToPlane(P3 pt, P4 plane, P3 ptref) {
        float f = plane.dot(pt) + plane.w;
        float f1 = plane.dot(ptref) + plane.w;
        return Math.signum(f1) * f / (float)Math.sqrt(plane.dot(plane));
    }

    public static float distanceToPlaneD(P4 plane, float d, P3 pt) {
        return plane == null ? Float.NaN : (plane.dot(pt) + plane.w) / d;
    }

    public static float distanceToPlaneV(V3 norm, float w, P3 pt) {
        return norm == null ? Float.NaN : (norm.dot(pt) + w) / (float)Math.sqrt(norm.dot(norm));
    }

    public static void calcNormalizedNormal(T3 pointA, T3 pointB, T3 pointC, T3 vNormNorm, T3 vAB) {
        vAB.sub2(pointB, pointA);
        vNormNorm.sub2(pointC, pointA);
        vNormNorm.cross(vAB, vNormNorm);
        vNormNorm.normalize();
    }

    public static float getDirectedNormalThroughPoints(T3 pointA, T3 pointB, T3 pointC, T3 ptRef, V3 vNorm, V3 vAB) {
        float nd = Measure.getNormalThroughPoints(pointA, pointB, pointC, vNorm, vAB);
        if (ptRef != null) {
            P3 pt0 = P3.newP(pointA);
            pt0.add(vNorm);
            float d = pt0.distance(ptRef);
            pt0.sub2(pointA, vNorm);
            if (d > pt0.distance(ptRef)) {
                vNorm.scale(-1.0f);
                nd = -nd;
            }
        }
        return nd;
    }

    public static float getNormalThroughPoints(T3 pointA, T3 pointB, T3 pointC, T3 vNorm, T3 vTemp) {
        Measure.calcNormalizedNormal(pointA, pointB, pointC, vNorm, vTemp);
        vTemp.setT(pointA);
        return -vTemp.dot(vNorm);
    }

    public static float getPlaneProjection(T3 pt, P4 plane, T3 retPtProj, V3 retNorm) {
        float dist = Measure.distanceToPlane(plane, pt);
        retNorm.set(plane.x, plane.y, plane.z);
        retNorm.normalize();
        if (dist > 0.0f) {
            retNorm.scale(-1.0f);
        }
        retPtProj.scaleAdd2(-dist, retNorm, pt);
        return dist;
    }

    public static boolean getNormalFromCenter(P3 ptCenter, P3 ptA, P3 ptB, P3 ptC, boolean isOutward, V3 normal, V3 vTemp) {
        boolean isReversed;
        float d = Measure.getNormalThroughPoints(ptA, ptB, ptC, normal, vTemp);
        boolean bl = isReversed = Measure.distanceToPlaneV(normal, d, ptCenter) > 0.0f;
        if (isReversed == isOutward) {
            normal.scale(-1.0f);
        }
        return !isReversed;
    }

    public static void getNormalToLine(P3 pointA, P3 pointB, V3 vNormNorm) {
        vNormNorm.sub2(pointA, pointB);
        vNormNorm.cross(vNormNorm, axisY);
        vNormNorm.normalize();
        if (Float.isNaN(vNormNorm.x)) {
            vNormNorm.set(1.0f, 0.0f, 0.0f);
        }
    }

    public static void getBisectingPlane(P3 pointA, V3 vAB, T3 ptTemp, V3 vTemp, P4 plane) {
        ptTemp.scaleAdd2(0.5f, vAB, pointA);
        vTemp.setT(vAB);
        vTemp.normalize();
        Measure.getPlaneThroughPoint(ptTemp, vTemp, plane);
    }

    public static float projectOntoAxis(P3 pt, P3 ptA, V3 axisUnitVector, V3 vectorProjection) {
        vectorProjection.sub2(pt, ptA);
        float projectedLength = vectorProjection.dot(axisUnitVector);
        pt.scaleAdd2(projectedLength, axisUnitVector, ptA);
        vectorProjection.sub2(pt, ptA);
        return projectedLength;
    }

    public static void calcBestAxisThroughPoints(P3[] points, int nPoints, P3 axisA, V3 axisUnitVector, V3 vectorProjection, int nTriesMax) {
        axisA.setT(points[0]);
        axisUnitVector.sub2(points[nPoints - 1], axisA);
        axisUnitVector.normalize();
        Measure.calcAveragePointN(points, nPoints, axisA);
        int nTries = 0;
        while (nTries++ < nTriesMax && (double)Measure.findAxis(points, nPoints, axisA, axisUnitVector, vectorProjection) > 0.001) {
        }
        P3 tempA = P3.newP(points[0]);
        Measure.projectOntoAxis(tempA, axisA, axisUnitVector, vectorProjection);
        axisA.setT(tempA);
    }

    public static float findAxis(P3[] points, int nPoints, P3 axisA, V3 axisUnitVector, V3 vectorProjection) {
        V3 sumXiYi = new V3();
        V3 vTemp = new V3();
        P3 pt = new P3();
        P3 ptProj = new P3();
        V3 a = V3.newV(axisUnitVector);
        float sum_Xi2 = 0.0f;
        int i = nPoints;
        while (--i >= 0) {
            pt.setT(points[i]);
            ptProj.setT(pt);
            Measure.projectOntoAxis(ptProj, axisA, axisUnitVector, vectorProjection);
            vTemp.sub2(pt, ptProj);
            vTemp.cross(vectorProjection, vTemp);
            sumXiYi.add(vTemp);
            sum_Xi2 += vectorProjection.lengthSquared();
        }
        V3 m = V3.newV(sumXiYi);
        m.scale(1.0f / sum_Xi2);
        vTemp.cross(m, axisUnitVector);
        axisUnitVector.add(vTemp);
        axisUnitVector.normalize();
        vTemp.sub2(axisUnitVector, a);
        return vTemp.length();
    }

    public static void calcAveragePoint(P3 pointA, P3 pointB, P3 pointC) {
        pointC.set((pointA.x + pointB.x) / 2.0f, (pointA.y + pointB.y) / 2.0f, (pointA.z + pointB.z) / 2.0f);
    }

    public static void calcAveragePointN(P3[] points, int nPoints, P3 averagePoint) {
        averagePoint.setT(points[0]);
        for (int i = 1; i < nPoints; ++i) {
            averagePoint.add(points[i]);
        }
        averagePoint.scale(1.0f / (float)nPoints);
    }

    public static Lst<P3> transformPoints(Lst<P3> vPts, M4 m4, P3 center) {
        Lst<P3> v = new Lst<P3>();
        for (int i = 0; i < vPts.size(); ++i) {
            P3 pt = P3.newP((T3)vPts.get(i));
            pt.sub(center);
            m4.rotTrans(pt);
            pt.add(center);
            v.addLast(pt);
        }
        return v;
    }

    public static boolean isInTetrahedron(P3 pt, P3 ptA, P3 ptB, P3 ptC, P3 ptD, P4 plane, V3 vTemp, V3 vTemp2, boolean fullyEnclosed) {
        boolean b = Measure.distanceToPlane(Measure.getPlaneThroughPoints(ptC, ptD, ptA, vTemp, vTemp2, plane), pt) >= 0.0f;
        if (b != Measure.distanceToPlane(Measure.getPlaneThroughPoints(ptA, ptD, ptB, vTemp, vTemp2, plane), pt) >= 0.0f) {
            return false;
        }
        if (b != Measure.distanceToPlane(Measure.getPlaneThroughPoints(ptB, ptD, ptC, vTemp, vTemp2, plane), pt) >= 0.0f) {
            return false;
        }
        float d = Measure.distanceToPlane(Measure.getPlaneThroughPoints(ptA, ptB, ptC, vTemp, vTemp2, plane), pt);
        if (fullyEnclosed) {
            return b == d >= 0.0f;
        }
        float d1 = Measure.distanceToPlane(plane, ptD);
        return d1 * d <= 0.0f || Math.abs(d1) > Math.abs(d);
    }

    public static Lst<Object> getIntersectionPP(P4 plane1, P4 plane2) {
        float z;
        float y;
        float x;
        float a1 = plane1.x;
        float b1 = plane1.y;
        float c1 = plane1.z;
        float d1 = plane1.w;
        float a2 = plane2.x;
        float b2 = plane2.y;
        float c2 = plane2.z;
        float d2 = plane2.w;
        V3 norm1 = V3.new3(a1, b1, c1);
        V3 norm2 = V3.new3(a2, b2, c2);
        V3 nxn = new V3();
        nxn.cross(norm1, norm2);
        float ax = Math.abs(nxn.x);
        float ay = Math.abs(nxn.y);
        float az = Math.abs(nxn.z);
        int type = ax > ay ? (ax > az ? 1 : 3) : (ay > az ? 2 : 3);
        switch (type) {
            case 1: {
                x = 0.0f;
                float diff = b1 * c2 - b2 * c1;
                if ((double)Math.abs(diff) < 0.01) {
                    return null;
                }
                y = (c1 * d2 - c2 * d1) / diff;
                z = (b2 * d1 - d2 * b1) / diff;
                break;
            }
            case 2: {
                float diff = a1 * c2 - a2 * c1;
                if ((double)Math.abs(diff) < 0.01) {
                    return null;
                }
                x = (c1 * d2 - c2 * d1) / diff;
                y = 0.0f;
                z = (a2 * d1 - d2 * a1) / diff;
                break;
            }
            default: {
                float diff = a1 * b2 - a2 * b1;
                if ((double)Math.abs(diff) < 0.01) {
                    return null;
                }
                x = (b1 * d2 - b2 * d1) / diff;
                y = (a2 * d1 - d2 * a1) / diff;
                z = 0.0f;
            }
        }
        Lst<Object> list = new Lst<Object>();
        list.addLast(P3.new3(x, y, z));
        nxn.normalize();
        list.addLast(nxn);
        return list;
    }

    public static P3 getIntersection(P3 pt1, V3 v, P4 plane, P3 ptRet, V3 tempNorm, V3 vTemp) {
        float l_dot_n;
        Measure.getPlaneProjection(pt1, plane, ptRet, tempNorm);
        tempNorm.set(plane.x, plane.y, plane.z);
        tempNorm.normalize();
        if (v == null) {
            v = V3.newV(tempNorm);
        }
        if ((double)Math.abs(l_dot_n = v.dot(tempNorm)) < 0.01) {
            return null;
        }
        vTemp.sub2(ptRet, pt1);
        ptRet.scaleAdd2(vTemp.dot(tempNorm) / l_dot_n, v, pt1);
        return ptRet;
    }

    public static Quat calculateQuaternionRotation(P3[][] centerAndPoints, float[] retStddev) {
        retStddev[1] = Float.NaN;
        Quat q = new Quat();
        P3[] ptsA = centerAndPoints[0];
        P3[] ptsB = centerAndPoints[1];
        int nPts = ptsA.length - 1;
        if (nPts < 2 || ptsA.length != ptsB.length) {
            return q;
        }
        double Sxx = 0.0;
        double Sxy = 0.0;
        double Sxz = 0.0;
        double Syx = 0.0;
        double Syy = 0.0;
        double Syz = 0.0;
        double Szx = 0.0;
        double Szy = 0.0;
        double Szz = 0.0;
        P3 ptA = new P3();
        P3 ptB = new P3();
        P3 ptA0 = ptsA[0];
        P3 ptB0 = ptsB[0];
        int i = nPts + 1;
        while (--i >= 1) {
            ptA.sub2(ptsA[i], ptA0);
            ptB.sub2(ptsB[i], ptB0);
            Sxx += (double)ptA.x * (double)ptB.x;
            Sxy += (double)ptA.x * (double)ptB.y;
            Sxz += (double)ptA.x * (double)ptB.z;
            Syx += (double)ptA.y * (double)ptB.x;
            Syy += (double)ptA.y * (double)ptB.y;
            Syz += (double)ptA.y * (double)ptB.z;
            Szx += (double)ptA.z * (double)ptB.x;
            Szy += (double)ptA.z * (double)ptB.y;
            Szz += (double)ptA.z * (double)ptB.z;
        }
        retStddev[0] = Measure.getRmsd(centerAndPoints, q);
        double[][] N = new double[4][4];
        N[0][0] = Sxx + Syy + Szz;
        double d = Syz - Szy;
        N[1][0] = d;
        N[0][1] = d;
        double d2 = Szx - Sxz;
        N[2][0] = d2;
        N[0][2] = d2;
        double d3 = Sxy - Syx;
        N[3][0] = d3;
        N[0][3] = d3;
        N[1][1] = Sxx - Syy - Szz;
        double d4 = Sxy + Syx;
        N[2][1] = d4;
        N[1][2] = d4;
        double d5 = Szx + Sxz;
        N[3][1] = d5;
        N[1][3] = d5;
        N[2][2] = -Sxx + Syy - Szz;
        double d6 = Syz + Szy;
        N[3][2] = d6;
        N[2][3] = d6;
        N[3][3] = -Sxx - Syy + Szz;
        float[] v = ((EigenInterface)Interface.getInterface("javajs.util.Eigen")).setM(N).getEigenvectorsFloatTransposed()[3];
        q = Quat.newP4(P4.new4(v[1], v[2], v[3], v[0]));
        retStddev[1] = Measure.getRmsd(centerAndPoints, q);
        return q;
    }

    public static float getTransformMatrix4(Lst<P3> ptsA, Lst<P3> ptsB, M4 m, P3 centerA) {
        P3[] cptsA = Measure.getCenterAndPoints(ptsA);
        P3[] cptsB = Measure.getCenterAndPoints(ptsB);
        float[] retStddev = new float[2];
        Quat q = Measure.calculateQuaternionRotation(new P3[][]{cptsA, cptsB}, retStddev);
        M3 r = q.getMatrix();
        if (centerA == null) {
            r.rotate(cptsA[0]);
        } else {
            centerA.setT(cptsA[0]);
        }
        V3 t = V3.newVsub(cptsB[0], cptsA[0]);
        m.setMV(r, t);
        return retStddev[1];
    }

    public static P3[] getCenterAndPoints(Lst<P3> vPts) {
        int n = vPts.size();
        P3[] pts = new P3[n + 1];
        pts[0] = new P3();
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                P3 p3 = (P3)vPts.get(i);
                pts[i + 1] = p3;
                pts[0].add(p3);
            }
            pts[0].scale(1.0f / (float)n);
        }
        return pts;
    }

    public static float getRmsd(P3[][] centerAndPoints, Quat q) {
        double sum2 = 0.0;
        P3[] ptsA = centerAndPoints[0];
        P3[] ptsB = centerAndPoints[1];
        P3 cA = ptsA[0];
        P3 cB = ptsB[0];
        int n = ptsA.length - 1;
        P3 ptAnew = new P3();
        int i = n + 1;
        while (--i >= 1) {
            ptAnew.sub2(ptsA[i], cA);
            q.transform2(ptAnew, ptAnew).add(cB);
            sum2 += (double)ptAnew.distanceSquared(ptsB[i]);
        }
        return (float)Math.sqrt(sum2 / (double)n);
    }

    public static P3[] getBestLineThroughPoints(P3[] points, int nPoints) {
        if (nPoints <= 0) {
            nPoints = points.length;
        }
        if (nPoints <= 2) {
            return points;
        }
        P3 ptA = new P3();
        V3 unitVector = new V3();
        V3 vTemp = new V3();
        Measure.calcBestAxisThroughPoints(points, nPoints, ptA, unitVector, vTemp, 8);
        return Measure.getProjectedLineSegment(points, nPoints, ptA, unitVector, vTemp);
    }

    public static P3[] getProjectedLineSegment(P3[] points, int nPoints, P3 ptA, V3 unitVector, V3 vTemp) {
        if (nPoints < 0) {
            nPoints = points.length;
        }
        if (vTemp == null) {
            vTemp = new V3();
        }
        P3 pmin = null;
        P3 pmax = null;
        float dmin = Float.MAX_VALUE;
        float dmax = -3.4028235E38f;
        for (int i = 0; i < points.length; ++i) {
            P3 p = P3.newP(points[i]);
            Measure.projectOntoAxis(p, ptA, unitVector, vTemp);
            float d = unitVector.dot(vTemp);
            if (d < dmin) {
                dmin = d;
                pmin = p;
            }
            if (!(d > dmax)) continue;
            dmax = d;
            pmax = p;
        }
        return new P3[]{pmin, pmax};
    }

    public static boolean isInTriangle(P3 p, P3 a, P3 b, P3 c, V3 v0, V3 v1, V3 v2) {
        v0.sub2(c, a);
        v1.sub2(b, a);
        v2.sub2(p, a);
        float dot00 = v0.dot(v0);
        float dot01 = v0.dot(v1);
        float dot02 = v0.dot(v2);
        float dot11 = v1.dot(v1);
        float dot12 = v1.dot(v2);
        float invDenom = 1.0f / (dot00 * dot11 - dot01 * dot01);
        float u = (dot11 * dot02 - dot01 * dot12) * invDenom;
        float v = (dot00 * dot12 - dot01 * dot02) * invDenom;
        return u >= 0.0f && v >= 0.0f && u + v <= 1.0f;
    }

    public static float calcBestPlaneThroughPoints(P3[] points, int nPoints, P4 plane) {
        P4 plane3;
        if (nPoints <= 0) {
            nPoints = points.length;
        }
        if (nPoints == 3) {
            Measure.getPlaneThroughPoints(points[0], points[1], points[2], null, null, plane);
            return 0.0f;
        }
        P4 pmin = plane;
        P4 plane2 = new P4();
        float rmsd = Measure.calcPlaneForMode(points, nPoints, plane, 'z');
        if ((double)rmsd < 1.0E-6) {
            return rmsd;
        }
        float f2 = Measure.calcPlaneForMode(points, nPoints, plane2, 'y');
        if (f2 < rmsd) {
            rmsd = f2;
            pmin = plane2;
            plane3 = plane;
        } else {
            plane3 = plane2;
        }
        if ((double)rmsd >= 1.0E-6 && (f2 = Measure.calcPlaneForMode(points, nPoints, plane3, 'x')) < rmsd) {
            rmsd = f2;
            pmin = plane3;
        }
        if (pmin != plane) {
            plane.setT(pmin);
            plane.w = pmin.w;
        }
        return rmsd;
    }

    public static float calcPlaneForMode(P3[] points, int nPoints, P4 plane, char mode) {
        int k;
        double d;
        int j;
        double[][] A = new double[nPoints][3];
        double[][] AT = new double[3][nPoints];
        double[][] ATAT = new double[3][nPoints];
        double[][] ATA1 = new double[3][3];
        double[] B = new double[nPoints];
        int i = nPoints;
        while (--i >= 0) {
            P3 p = points[i];
            double d2 = mode == 'x' ? p.z : p.x;
            AT[0][i] = d2;
            A[i][0] = d2;
            double d3 = mode == 'y' ? p.z : p.y;
            AT[1][i] = d3;
            A[i][1] = d3;
            AT[2][i] = 1.0;
            A[i][2] = 1.0;
            B[i] = -(mode == 'y' ? p.y : (mode == 'x' ? p.x : p.z));
        }
        M3 m = new M3();
        int i2 = 3;
        while (--i2 >= 0) {
            j = 3;
            while (--j >= 0) {
                d = 0.0;
                k = nPoints;
                while (--k >= 0) {
                    d += AT[i2][k] * A[k][j];
                }
                m.set33(i2, j, (float)d);
            }
        }
        m.invert();
        i2 = 3;
        while (--i2 >= 0) {
            j = 3;
            while (--j >= 0) {
                ATA1[i2][j] = m.get33(i2, j);
            }
        }
        i2 = 3;
        while (--i2 >= 0) {
            int k2 = nPoints;
            while (--k2 >= 0) {
                d = 0.0;
                int j2 = 3;
                while (--j2 >= 0) {
                    d += ATA1[i2][j2] * AT[j2][k2];
                }
                ATAT[i2][k2] = d;
            }
        }
        switch (mode) {
            case 'x': {
                plane.x = 1.0f;
                break;
            }
            case 'y': {
                plane.y = 1.0f;
                break;
            }
            case 'z': {
                plane.z = 1.0f;
            }
        }
        float len2 = 1.0f;
        j = 3;
        while (--j >= 0) {
            double v = 0.0;
            k = nPoints;
            while (--k >= 0) {
                v += ATAT[j][k] * B[k];
            }
            switch (j) {
                case 0: {
                    len2 = (float)((double)len2 + v * v);
                    if (mode == 'x') {
                        plane.z = (float)v;
                        break;
                    }
                    plane.x = (float)v;
                    break;
                }
                case 1: {
                    len2 = (float)((double)len2 + v * v);
                    if (mode == 'y') {
                        plane.z = (float)v;
                        break;
                    }
                    plane.y = (float)v;
                    break;
                }
                case 2: {
                    plane.w = (float)v;
                }
            }
        }
        float f = (float)Math.sqrt(len2);
        plane.scale4((float)(1.0f / plane.w > 0.0f ? 1 : -1) / f);
        float sum2 = 0.0f;
        for (int i3 = 0; i3 < nPoints; ++i3) {
            float d4 = Measure.distanceToPlane(plane, points[i3]);
            sum2 += d4 * d4;
        }
        float ret = (float)Math.sqrt(sum2 / (float)nPoints);
        return ret;
    }

    static P3 rndPt() {
        return P3.new3((float)Math.random() * 20.0f, (float)(Math.random() * 20.0), (float)(Math.random() * 20.0));
    }

    static void testRnd() {
        P4 plane = P4.new4((float)Math.random() * 20.0f, (float)Math.random() * 20.0f, (float)Math.random() * 20.0f, (float)Math.random() * 20.0f);
        plane.scale4(1.0f / plane.length());
        System.out.println("\n==========\n ");
        System.out.println("plane is " + plane);
        P3 ptProj = new P3();
        V3 vNorm = new V3();
        P3[] pts = new P3[4];
        for (int i = 0; i < pts.length; ++i) {
            pts[i] = new P3();
            P3 p = Measure.rndPt();
            Measure.getPlaneProjection(p, plane, ptProj, vNorm);
            pts[i].setT(ptProj);
            float d = (float)Math.random() * 0.1f;
            pts[i].scaleAdd2(d, vNorm, ptProj);
            System.out.println(pts[i] + " d=" + d);
        }
        P4 p2 = new P4();
        float f = Measure.calcBestPlaneThroughPoints(pts, -1, p2);
        System.out.println("found " + p2 + " rmsd = " + f);
    }

    public static void test() {
        for (int i = 0; i < 10; ++i) {
            Measure.testRnd();
        }
        System.exit(0);
    }

    public static Lst<P3> getPointsOnPlane(P3[] pts, P4 plane) {
        Lst<P3> ret = new Lst<P3>();
        int i = pts.length;
        while (--i >= 0) {
            float d = Math.abs(Measure.distanceToPlane(plane, pts[i]));
            if (!(d < 0.001f)) continue;
            ret.addLast(pts[i]);
        }
        return ret;
    }

    public static Lst<P3> getLatticePoints(Lst<P3> cpts, int h, int k, int l) {
        cpts.addLast(new P3());
        h = h == 0 ? 1 : Math.abs(h);
        k = k == 0 ? 1 : Math.abs(k);
        l = l == 0 ? 1 : Math.abs(l);
        int n = cpts.size();
        for (int ih = -h; ih <= h; ++ih) {
            for (int ik = -k; ik <= k; ++ik) {
                for (int il = -l; il <= l; ++il) {
                    for (int i = 0; i < n; ++i) {
                        P3 pt = P3.new3(ih, ik, il);
                        pt.add((T3)cpts.get(i));
                        cpts.addLast(pt);
                    }
                }
            }
        }
        int i = n;
        while (--i >= 0) {
            cpts.removeItemAt(0);
        }
        return cpts;
    }
}

