/* WindowManager.c generated by valac 0.56.3, the Vala compiler
 * generated from WindowManager.vala, do not modify */

/**/
/*  Copyright (C) 2014 Tom Beckmann*/
/**/
/*  This program is free software: you can redistribute it and/or modify*/
/*  it under the terms of the GNU General Public License as published by*/
/*  the Free Software Foundation, either version 3 of the License, or*/
/*  (at your option) any later version.*/
/**/
/*  This program is distributed in the hope that it will be useful,*/
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of*/
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the*/
/*  GNU General Public License for more details.*/
/**/
/*  You should have received a copy of the GNU General Public License*/
/*  along with this program.  If not, see <http://www.gnu.org/licenses/>.*/
/**/

#include "gala.h"
#include <clutter/clutter.h>
#include <glib.h>
#include <meta/keybindings.h>
#include <glib-object.h>
#include <meta/window.h>
#include <meta/common.h>
#include <string.h>

enum  {
	GALA_MODAL_PROXY_0_PROPERTY,
	GALA_MODAL_PROXY_GRAB_PROPERTY,
	GALA_MODAL_PROXY_NUM_PROPERTIES
};
static GParamSpec* gala_modal_proxy_properties[GALA_MODAL_PROXY_NUM_PROPERTIES];
#define _clutter_grab_unref0(var) ((var == NULL) ? NULL : (var = (clutter_grab_unref (var), NULL)))

struct _GalaModalProxyPrivate {
	ClutterGrab* _grab;
	GalaKeybindingFilter _keybinding_filter;
	gpointer _keybinding_filter_target;
	GDestroyNotify _keybinding_filter_target_destroy_notify;
};

static gint GalaModalProxy_private_offset;
static gpointer gala_modal_proxy_parent_class = NULL;

static gboolean _gala_modal_proxy__keybinding_filter_lambda12_ (void);
static gboolean __gala_modal_proxy__keybinding_filter_lambda12__gala_keybinding_filter (MetaKeyBinding* binding,
                                                                                 gpointer self);
static void gala_modal_proxy_finalize (GObject * obj);
static GType gala_modal_proxy_get_type_once (void);
static void _vala_gala_modal_proxy_get_property (GObject * object,
                                          guint property_id,
                                          GValue * value,
                                          GParamSpec * pspec);
static void _vala_gala_modal_proxy_set_property (GObject * object,
                                          guint property_id,
                                          const GValue * value,
                                          GParamSpec * pspec);
static GType gala_window_manager_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static GType
gala_action_type_get_type_once (void)
{
	static const GEnumValue values[] = {{GALA_ACTION_TYPE_NONE, "GALA_ACTION_TYPE_NONE", "none"}, {GALA_ACTION_TYPE_SHOW_WORKSPACE_VIEW, "GALA_ACTION_TYPE_SHOW_WORKSPACE_VIEW", "show-workspace-view"}, {GALA_ACTION_TYPE_MAXIMIZE_CURRENT, "GALA_ACTION_TYPE_MAXIMIZE_CURRENT", "maximize-current"}, {GALA_ACTION_TYPE_HIDE_CURRENT, "GALA_ACTION_TYPE_HIDE_CURRENT", "hide-current"}, {GALA_ACTION_TYPE_OPEN_LAUNCHER, "GALA_ACTION_TYPE_OPEN_LAUNCHER", "open-launcher"}, {GALA_ACTION_TYPE_CUSTOM_COMMAND, "GALA_ACTION_TYPE_CUSTOM_COMMAND", "custom-command"}, {GALA_ACTION_TYPE_WINDOW_OVERVIEW, "GALA_ACTION_TYPE_WINDOW_OVERVIEW", "window-overview"}, {GALA_ACTION_TYPE_WINDOW_OVERVIEW_ALL, "GALA_ACTION_TYPE_WINDOW_OVERVIEW_ALL", "window-overview-all"}, {GALA_ACTION_TYPE_SWITCH_TO_WORKSPACE_LAST, "GALA_ACTION_TYPE_SWITCH_TO_WORKSPACE_LAST", "switch-to-workspace-last"}, {GALA_ACTION_TYPE_START_MOVE_CURRENT, "GALA_ACTION_TYPE_START_MOVE_CURRENT", "start-move-current"}, {GALA_ACTION_TYPE_START_RESIZE_CURRENT, "GALA_ACTION_TYPE_START_RESIZE_CURRENT", "start-resize-current"}, {GALA_ACTION_TYPE_TOGGLE_ALWAYS_ON_TOP_CURRENT, "GALA_ACTION_TYPE_TOGGLE_ALWAYS_ON_TOP_CURRENT", "toggle-always-on-top-current"}, {GALA_ACTION_TYPE_TOGGLE_ALWAYS_ON_VISIBLE_WORKSPACE_CURRENT, "GALA_ACTION_TYPE_TOGGLE_ALWAYS_ON_VISIBLE_WORKSPACE_CURRENT", "toggle-always-on-visible-workspace-current"}, {GALA_ACTION_TYPE_MOVE_CURRENT_WORKSPACE_LEFT, "GALA_ACTION_TYPE_MOVE_CURRENT_WORKSPACE_LEFT", "move-current-workspace-left"}, {GALA_ACTION_TYPE_MOVE_CURRENT_WORKSPACE_RIGHT, "GALA_ACTION_TYPE_MOVE_CURRENT_WORKSPACE_RIGHT", "move-current-workspace-right"}, {GALA_ACTION_TYPE_CLOSE_CURRENT, "GALA_ACTION_TYPE_CLOSE_CURRENT", "close-current"}, {GALA_ACTION_TYPE_SCREENSHOT_CURRENT, "GALA_ACTION_TYPE_SCREENSHOT_CURRENT", "screenshot-current"}, {0, NULL, NULL}};
	GType gala_action_type_type_id;
	gala_action_type_type_id = g_enum_register_static ("GalaActionType", values);
	return gala_action_type_type_id;
}

GType
gala_action_type_get_type (void)
{
	static volatile gsize gala_action_type_type_id__once = 0;
	if (g_once_init_enter (&gala_action_type_type_id__once)) {
		GType gala_action_type_type_id;
		gala_action_type_type_id = gala_action_type_get_type_once ();
		g_once_init_leave (&gala_action_type_type_id__once, gala_action_type_type_id);
	}
	return gala_action_type_type_id__once;
}

static GType
gala_window_flags_get_type_once (void)
{
	static const GFlagsValue values[] = {{GALA_WINDOW_FLAGS_NONE, "GALA_WINDOW_FLAGS_NONE", "none"}, {GALA_WINDOW_FLAGS_CAN_HIDE, "GALA_WINDOW_FLAGS_CAN_HIDE", "can-hide"}, {GALA_WINDOW_FLAGS_CAN_MAXIMIZE, "GALA_WINDOW_FLAGS_CAN_MAXIMIZE", "can-maximize"}, {GALA_WINDOW_FLAGS_IS_MAXIMIZED, "GALA_WINDOW_FLAGS_IS_MAXIMIZED", "is-maximized"}, {GALA_WINDOW_FLAGS_ALLOWS_MOVE, "GALA_WINDOW_FLAGS_ALLOWS_MOVE", "allows-move"}, {GALA_WINDOW_FLAGS_ALLOWS_RESIZE, "GALA_WINDOW_FLAGS_ALLOWS_RESIZE", "allows-resize"}, {GALA_WINDOW_FLAGS_ALWAYS_ON_TOP, "GALA_WINDOW_FLAGS_ALWAYS_ON_TOP", "always-on-top"}, {GALA_WINDOW_FLAGS_ON_ALL_WORKSPACES, "GALA_WINDOW_FLAGS_ON_ALL_WORKSPACES", "on-all-workspaces"}, {GALA_WINDOW_FLAGS_CAN_CLOSE, "GALA_WINDOW_FLAGS_CAN_CLOSE", "can-close"}, {GALA_WINDOW_FLAGS_IS_TILED, "GALA_WINDOW_FLAGS_IS_TILED", "is-tiled"}, {0, NULL, NULL}};
	GType gala_window_flags_type_id;
	gala_window_flags_type_id = g_flags_register_static ("GalaWindowFlags", values);
	return gala_window_flags_type_id;
}

GType
gala_window_flags_get_type (void)
{
	static volatile gsize gala_window_flags_type_id__once = 0;
	if (g_once_init_enter (&gala_window_flags_type_id__once)) {
		GType gala_window_flags_type_id;
		gala_window_flags_type_id = gala_window_flags_get_type_once ();
		g_once_init_leave (&gala_window_flags_type_id__once, gala_window_flags_type_id);
	}
	return gala_window_flags_type_id__once;
}

static inline gpointer
gala_modal_proxy_get_instance_private (GalaModalProxy* self)
{
	return G_STRUCT_MEMBER_P (self, GalaModalProxy_private_offset);
}

static gboolean
_gala_modal_proxy__keybinding_filter_lambda12_ (void)
{
	gboolean result;
	result = TRUE;
	return result;
}

static gboolean
__gala_modal_proxy__keybinding_filter_lambda12__gala_keybinding_filter (MetaKeyBinding* binding,
                                                                        gpointer self)
{
	gboolean result;
	result = _gala_modal_proxy__keybinding_filter_lambda12_ ();
	return result;
}

GalaKeybindingFilter
gala_modal_proxy_get_keybinding_filter (GalaModalProxy* self,
                                        gpointer* result_target)
{
	GalaKeybindingFilter _tmp0_;
	gpointer _tmp0__target;
	GalaKeybindingFilter _tmp1_;
	gpointer _tmp1__target;
	GalaKeybindingFilter result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_keybinding_filter;
	_tmp0__target = self->priv->_keybinding_filter_target;
	_tmp1_ = _tmp0_;
	_tmp1__target = _tmp0__target;
	*result_target = _tmp1__target;
	result = _tmp1_;
	return result;
}

void
gala_modal_proxy_set_keybinding_filter (GalaModalProxy* self,
                                        GalaKeybindingFilter filter,
                                        gpointer filter_target)
{
	g_return_if_fail (self != NULL);
	(self->priv->_keybinding_filter_target_destroy_notify == NULL) ? NULL : (self->priv->_keybinding_filter_target_destroy_notify (self->priv->_keybinding_filter_target), NULL);
	self->priv->_keybinding_filter = NULL;
	self->priv->_keybinding_filter_target = NULL;
	self->priv->_keybinding_filter_target_destroy_notify = NULL;
	self->priv->_keybinding_filter = filter;
	self->priv->_keybinding_filter_target = filter_target;
	self->priv->_keybinding_filter_target_destroy_notify = NULL;
}

GalaModalProxy*
gala_modal_proxy_construct (GType object_type)
{
	GalaModalProxy * self = NULL;
	self = (GalaModalProxy*) g_object_new (object_type, NULL);
	return self;
}

GalaModalProxy*
gala_modal_proxy_new (void)
{
	return gala_modal_proxy_construct (GALA_TYPE_MODAL_PROXY);
}

/**
         * Small utility to allow all keybindings
         */
void
gala_modal_proxy_allow_all_keybindings (GalaModalProxy* self)
{
	g_return_if_fail (self != NULL);
	(self->priv->_keybinding_filter_target_destroy_notify == NULL) ? NULL : (self->priv->_keybinding_filter_target_destroy_notify (self->priv->_keybinding_filter_target), NULL);
	self->priv->_keybinding_filter = NULL;
	self->priv->_keybinding_filter_target = NULL;
	self->priv->_keybinding_filter_target_destroy_notify = NULL;
	self->priv->_keybinding_filter = NULL;
	self->priv->_keybinding_filter_target = NULL;
	self->priv->_keybinding_filter_target_destroy_notify = NULL;
}

ClutterGrab*
gala_modal_proxy_get_grab (GalaModalProxy* self)
{
	ClutterGrab* result;
	ClutterGrab* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_grab;
	result = _tmp0_;
	return result;
}

static gpointer
_clutter_grab_ref0 (gpointer self)
{
	return self ? clutter_grab_ref (self) : NULL;
}

void
gala_modal_proxy_set_grab (GalaModalProxy* self,
                           ClutterGrab* value)
{
	ClutterGrab* old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_modal_proxy_get_grab (self);
	if (old_value != value) {
		ClutterGrab* _tmp0_;
		_tmp0_ = _clutter_grab_ref0 (value);
		_clutter_grab_unref0 (self->priv->_grab);
		self->priv->_grab = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, gala_modal_proxy_properties[GALA_MODAL_PROXY_GRAB_PROPERTY]);
	}
}

static void
gala_modal_proxy_class_init (GalaModalProxyClass * klass,
                             gpointer klass_data)
{
	gala_modal_proxy_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GalaModalProxy_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_gala_modal_proxy_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gala_modal_proxy_set_property;
	G_OBJECT_CLASS (klass)->finalize = gala_modal_proxy_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_MODAL_PROXY_GRAB_PROPERTY, gala_modal_proxy_properties[GALA_MODAL_PROXY_GRAB_PROPERTY] = g_param_spec_boxed ("grab", "grab", "grab", clutter_grab_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
gala_modal_proxy_instance_init (GalaModalProxy * self,
                                gpointer klass)
{
	self->priv = gala_modal_proxy_get_instance_private (self);
	self->priv->_keybinding_filter = __gala_modal_proxy__keybinding_filter_lambda12__gala_keybinding_filter;
	self->priv->_keybinding_filter_target = NULL;
	self->priv->_keybinding_filter_target_destroy_notify = NULL;
}

static void
gala_modal_proxy_finalize (GObject * obj)
{
	GalaModalProxy * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GALA_TYPE_MODAL_PROXY, GalaModalProxy);
	_clutter_grab_unref0 (self->priv->_grab);
	(self->priv->_keybinding_filter_target_destroy_notify == NULL) ? NULL : (self->priv->_keybinding_filter_target_destroy_notify (self->priv->_keybinding_filter_target), NULL);
	self->priv->_keybinding_filter = NULL;
	self->priv->_keybinding_filter_target = NULL;
	self->priv->_keybinding_filter_target_destroy_notify = NULL;
	G_OBJECT_CLASS (gala_modal_proxy_parent_class)->finalize (obj);
}

/**
     * A minimal class mostly used to identify your call to {@link WindowManager.push_modal} and used
     * to end your modal mode again with {@link WindowManager.pop_modal}
     */
static GType
gala_modal_proxy_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GalaModalProxyClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gala_modal_proxy_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GalaModalProxy), 0, (GInstanceInitFunc) gala_modal_proxy_instance_init, NULL };
	GType gala_modal_proxy_type_id;
	gala_modal_proxy_type_id = g_type_register_static (G_TYPE_OBJECT, "GalaModalProxy", &g_define_type_info, 0);
	GalaModalProxy_private_offset = g_type_add_instance_private (gala_modal_proxy_type_id, sizeof (GalaModalProxyPrivate));
	return gala_modal_proxy_type_id;
}

GType
gala_modal_proxy_get_type (void)
{
	static volatile gsize gala_modal_proxy_type_id__once = 0;
	if (g_once_init_enter (&gala_modal_proxy_type_id__once)) {
		GType gala_modal_proxy_type_id;
		gala_modal_proxy_type_id = gala_modal_proxy_get_type_once ();
		g_once_init_leave (&gala_modal_proxy_type_id__once, gala_modal_proxy_type_id);
	}
	return gala_modal_proxy_type_id__once;
}

static void
_vala_gala_modal_proxy_get_property (GObject * object,
                                     guint property_id,
                                     GValue * value,
                                     GParamSpec * pspec)
{
	GalaModalProxy * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GALA_TYPE_MODAL_PROXY, GalaModalProxy);
	switch (property_id) {
		case GALA_MODAL_PROXY_GRAB_PROPERTY:
		g_value_set_boxed (value, gala_modal_proxy_get_grab (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_gala_modal_proxy_set_property (GObject * object,
                                     guint property_id,
                                     const GValue * value,
                                     GParamSpec * pspec)
{
	GalaModalProxy * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GALA_TYPE_MODAL_PROXY, GalaModalProxy);
	switch (property_id) {
		case GALA_MODAL_PROXY_GRAB_PROPERTY:
		gala_modal_proxy_set_grab (self, g_value_get_boxed (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

/**
         * Enters the modal mode, which means that all events are directed to the stage instead
         * of the windows. This is the only way to receive keyboard events besides shortcut listeners.
         *
         * @return a {@link ModalProxy} which is needed to end the modal mode again and provides some
         *         some basic control on the behavior of the window manager while it is in modal mode.
         */
GalaModalProxy*
gala_window_manager_push_modal (GalaWindowManager* self,
                                ClutterActor* actor)
{
	GalaWindowManagerIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = GALA_WINDOW_MANAGER_GET_INTERFACE (self);
	if (_iface_->push_modal) {
		return _iface_->push_modal (self, actor);
	}
	return NULL;
}

/**
         * May exit the modal mode again, unless another component has called {@link push_modal}
         *
         * @param proxy The {@link ModalProxy} received from {@link push_modal}
         */
void
gala_window_manager_pop_modal (GalaWindowManager* self,
                               GalaModalProxy* proxy)
{
	GalaWindowManagerIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = GALA_WINDOW_MANAGER_GET_INTERFACE (self);
	if (_iface_->pop_modal) {
		_iface_->pop_modal (self, proxy);
	}
}

/**
         * Returns whether the window manager is currently in modal mode.
         * @see push_modal
         */
gboolean
gala_window_manager_is_modal (GalaWindowManager* self)
{
	GalaWindowManagerIface* _iface_;
	g_return_val_if_fail (self != NULL, FALSE);
	_iface_ = GALA_WINDOW_MANAGER_GET_INTERFACE (self);
	if (_iface_->is_modal) {
		return _iface_->is_modal (self);
	}
	return FALSE;
}

/**
         * Tests if a given {@link ModalProxy} is valid and may be popped. Should not be necessary
         * to use this function in most cases, but it may be helpful for debugging. Gala catches
         * invalid proxies as well and emits a warning in that case.
         *
         * @param proxy The {@link ModalProxy} to check
         * @return      Returns true if the prox is valid
         */
gboolean
gala_window_manager_modal_proxy_valid (GalaWindowManager* self,
                                       GalaModalProxy* proxy)
{
	GalaWindowManagerIface* _iface_;
	g_return_val_if_fail (self != NULL, FALSE);
	_iface_ = GALA_WINDOW_MANAGER_GET_INTERFACE (self);
	if (_iface_->modal_proxy_valid) {
		return _iface_->modal_proxy_valid (self, proxy);
	}
	return FALSE;
}

/**
         * Tells the window manager to perform the given action.
         *
         * @param type The type of action to perform
         */
void
gala_window_manager_perform_action (GalaWindowManager* self,
                                    GalaActionType type)
{
	GalaWindowManagerIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = GALA_WINDOW_MANAGER_GET_INTERFACE (self);
	if (_iface_->perform_action) {
		_iface_->perform_action (self, type);
	}
}

/**
         * Moves the window to the workspace next to its current workspace in the given direction.
         * Gala currently only supports LEFT and RIGHT.
         *
         * @param window    The window to be moved
         * @param direction The direction in which to move the window
         */
void
gala_window_manager_move_window (GalaWindowManager* self,
                                 MetaWindow* window,
                                 MetaMotionDirection direction)
{
	GalaWindowManagerIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = GALA_WINDOW_MANAGER_GET_INTERFACE (self);
	if (_iface_->move_window) {
		_iface_->move_window (self, window, direction);
	}
}

/**
         * Switches to the next workspace in the given direction.
         *
         * @param direction The direction in which to switch
         */
void
gala_window_manager_switch_to_next_workspace (GalaWindowManager* self,
                                              MetaMotionDirection direction)
{
	GalaWindowManagerIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = GALA_WINDOW_MANAGER_GET_INTERFACE (self);
	if (_iface_->switch_to_next_workspace) {
		_iface_->switch_to_next_workspace (self, direction);
	}
}

ClutterActor*
gala_window_manager_get_ui_group (GalaWindowManager* self)
{
	GalaWindowManagerIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = GALA_WINDOW_MANAGER_GET_INTERFACE (self);
	if (_iface_->get_ui_group) {
		return _iface_->get_ui_group (self);
	}
	return NULL;
}

void
gala_window_manager_set_ui_group (GalaWindowManager* self,
                                  ClutterActor* value)
{
	GalaWindowManagerIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = GALA_WINDOW_MANAGER_GET_INTERFACE (self);
	if (_iface_->set_ui_group) {
		_iface_->set_ui_group (self, value);
	}
}

ClutterStage*
gala_window_manager_get_stage (GalaWindowManager* self)
{
	GalaWindowManagerIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = GALA_WINDOW_MANAGER_GET_INTERFACE (self);
	if (_iface_->get_stage) {
		return _iface_->get_stage (self);
	}
	return NULL;
}

void
gala_window_manager_set_stage (GalaWindowManager* self,
                               ClutterStage* value)
{
	GalaWindowManagerIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = GALA_WINDOW_MANAGER_GET_INTERFACE (self);
	if (_iface_->set_stage) {
		_iface_->set_stage (self, value);
	}
}

ClutterActor*
gala_window_manager_get_window_group (GalaWindowManager* self)
{
	GalaWindowManagerIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = GALA_WINDOW_MANAGER_GET_INTERFACE (self);
	if (_iface_->get_window_group) {
		return _iface_->get_window_group (self);
	}
	return NULL;
}

void
gala_window_manager_set_window_group (GalaWindowManager* self,
                                      ClutterActor* value)
{
	GalaWindowManagerIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = GALA_WINDOW_MANAGER_GET_INTERFACE (self);
	if (_iface_->set_window_group) {
		_iface_->set_window_group (self, value);
	}
}

ClutterActor*
gala_window_manager_get_top_window_group (GalaWindowManager* self)
{
	GalaWindowManagerIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = GALA_WINDOW_MANAGER_GET_INTERFACE (self);
	if (_iface_->get_top_window_group) {
		return _iface_->get_top_window_group (self);
	}
	return NULL;
}

void
gala_window_manager_set_top_window_group (GalaWindowManager* self,
                                          ClutterActor* value)
{
	GalaWindowManagerIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = GALA_WINDOW_MANAGER_GET_INTERFACE (self);
	if (_iface_->set_top_window_group) {
		_iface_->set_top_window_group (self, value);
	}
}

MetaBackgroundGroup*
gala_window_manager_get_background_group (GalaWindowManager* self)
{
	GalaWindowManagerIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = GALA_WINDOW_MANAGER_GET_INTERFACE (self);
	if (_iface_->get_background_group) {
		return _iface_->get_background_group (self);
	}
	return NULL;
}

void
gala_window_manager_set_background_group (GalaWindowManager* self,
                                          MetaBackgroundGroup* value)
{
	GalaWindowManagerIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = GALA_WINDOW_MANAGER_GET_INTERFACE (self);
	if (_iface_->set_background_group) {
		_iface_->set_background_group (self, value);
	}
}

GalaActivatableComponent*
gala_window_manager_get_workspace_view (GalaWindowManager* self)
{
	GalaWindowManagerIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = GALA_WINDOW_MANAGER_GET_INTERFACE (self);
	if (_iface_->get_workspace_view) {
		return _iface_->get_workspace_view (self);
	}
	return NULL;
}

void
gala_window_manager_set_workspace_view (GalaWindowManager* self,
                                        GalaActivatableComponent* value)
{
	GalaWindowManagerIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = GALA_WINDOW_MANAGER_GET_INTERFACE (self);
	if (_iface_->set_workspace_view) {
		_iface_->set_workspace_view (self, value);
	}
}

gboolean
gala_window_manager_get_enable_animations (GalaWindowManager* self)
{
	GalaWindowManagerIface* _iface_;
	g_return_val_if_fail (self != NULL, FALSE);
	_iface_ = GALA_WINDOW_MANAGER_GET_INTERFACE (self);
	if (_iface_->get_enable_animations) {
		return _iface_->get_enable_animations (self);
	}
	return FALSE;
}

void
gala_window_manager_set_enable_animations (GalaWindowManager* self,
                                           gboolean value)
{
	GalaWindowManagerIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = GALA_WINDOW_MANAGER_GET_INTERFACE (self);
	if (_iface_->set_enable_animations) {
		_iface_->set_enable_animations (self, value);
	}
}

static void
gala_window_manager_default_init (GalaWindowManagerIface * iface,
                                  gpointer iface_data)
{
	/**
	         * This is the container you'll most likely want to add your component to. It wraps
	         * every other container listed in this interface and is a direct child of the stage.
	         */
	g_object_interface_install_property (iface, g_param_spec_object ("ui-group", "ui-group", "ui-group", clutter_actor_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	         * The stage of the window manager
	         */
	g_object_interface_install_property (iface, g_param_spec_object ("stage", "stage", "stage", clutter_stage_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	         * A group containing all 'usual' windows
	         * @see top_window_group
	         */
	g_object_interface_install_property (iface, g_param_spec_object ("window-group", "window-group", "window-group", clutter_actor_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	         * The top window group contains special windows that are always placed on top
	         * like fullscreen windows.
	         */
	g_object_interface_install_property (iface, g_param_spec_object ("top-window-group", "top-window-group", "top-window-group", clutter_actor_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	         * The background group is a container for the background actors forming the wallpaper
	         */
	g_object_interface_install_property (iface, g_param_spec_object ("background-group", "background-group", "background-group", meta_background_group_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	         * View that allows to see and manage all your windows and desktops.
	         */
	g_object_interface_install_property (iface, g_param_spec_object ("workspace-view", "workspace-view", "workspace-view", GALA_TYPE_ACTIVATABLE_COMPONENT, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	         * Whether animations should be displayed.
	         */
	g_object_interface_install_property (iface, g_param_spec_boolean ("enable-animations", "enable-animations", "enable-animations", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static GType
gala_window_manager_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GalaWindowManagerIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gala_window_manager_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType gala_window_manager_type_id;
	gala_window_manager_type_id = g_type_register_static (G_TYPE_INTERFACE, "GalaWindowManager", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (gala_window_manager_type_id, meta_plugin_get_type ());
	return gala_window_manager_type_id;
}

GType
gala_window_manager_get_type (void)
{
	static volatile gsize gala_window_manager_type_id__once = 0;
	if (g_once_init_enter (&gala_window_manager_type_id__once)) {
		GType gala_window_manager_type_id;
		gala_window_manager_type_id = gala_window_manager_get_type_once ();
		g_once_init_leave (&gala_window_manager_type_id__once, gala_window_manager_type_id);
	}
	return gala_window_manager_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

