/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.rca.scheduler;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.sql.SQLException;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.performanceanalyzer.AppContext;
import org.opensearch.performanceanalyzer.metrics.AllMetrics;
import org.opensearch.performanceanalyzer.rca.framework.core.ConnectedComponent;
import org.opensearch.performanceanalyzer.rca.framework.core.Queryable;
import org.opensearch.performanceanalyzer.rca.framework.core.RcaConf;
import org.opensearch.performanceanalyzer.rca.framework.core.ThresholdMain;
import org.opensearch.performanceanalyzer.rca.net.WireHopper;
import org.opensearch.performanceanalyzer.rca.persistence.Persistable;
import org.opensearch.performanceanalyzer.rca.scheduler.RCASchedulerTask;
import org.opensearch.performanceanalyzer.rca.scheduler.RcaSchedulerState;

public class RCAScheduler {
    private WireHopper net;
    private boolean shutdownRequested;
    private volatile RcaSchedulerState schedulerState = RcaSchedulerState.STATE_NOT_STARTED;
    private final AllMetrics.NodeRole role;
    private final AppContext appContext;
    private RCASchedulerTask schedulerTask = null;
    final ThreadFactory schedThreadFactory;
    final ThreadFactory taskThreadFactory;
    ExecutorService rcaSchedulerPeriodicExecutor;
    ScheduledExecutorService scheduledPool;
    List<ConnectedComponent> connectedComponents;
    volatile Queryable db;
    RcaConf rcaConf;
    ThresholdMain thresholdMain;
    Persistable persistable;
    static final int PERIODICITY_SECONDS = 1;
    static final int PERIODICITY_IN_MS = 1000;
    private static final Logger LOG = LogManager.getLogger(RCAScheduler.class);
    private CountDownLatch schedulerTrackingLatch;

    public RCAScheduler(List<ConnectedComponent> connectedComponents, Queryable db, RcaConf rcaConf, ThresholdMain thresholdMain, Persistable persistable, WireHopper net, AppContext appContext) {
        String instanceId = appContext.getMyInstanceDetails().getInstanceId().toString();
        this.schedThreadFactory = new ThreadFactoryBuilder().setNameFormat(instanceId + "-sched-%d").setDaemon(true).build();
        this.taskThreadFactory = new ThreadFactoryBuilder().setNameFormat(instanceId + "-task-%d-").setDaemon(true).build();
        this.connectedComponents = connectedComponents;
        this.db = db;
        this.rcaConf = rcaConf;
        this.thresholdMain = thresholdMain;
        this.persistable = persistable;
        this.net = net;
        this.shutdownRequested = false;
        this.appContext = appContext;
        this.role = this.appContext.getMyInstanceDetails().getRole();
    }

    public void start() {
        LOG.info("RCA: Starting RCA scheduler ...........");
        this.createExecutorPools();
        if (this.scheduledPool == null) {
            LOG.error("Couldn't start RCA scheduler. Executor pool is not set.");
            if (this.schedulerTrackingLatch != null) {
                this.schedulerTrackingLatch.countDown();
            }
            return;
        }
        if (this.role == AllMetrics.NodeRole.UNKNOWN) {
            LOG.error("Couldn't start RCA scheduler as the node role is UNKNOWN.");
            if (this.schedulerTrackingLatch != null) {
                this.schedulerTrackingLatch.countDown();
            }
            return;
        }
        this.schedulerTask = new RCASchedulerTask(10000, this.rcaSchedulerPeriodicExecutor, this.connectedComponents, this.db, this.persistable, this.rcaConf, this.net, this.appContext);
        this.schedulerState = RcaSchedulerState.STATE_STARTED;
        LOG.info("RCA scheduler thread started successfully on node: {}", (Object)this.appContext.getMyInstanceDetails().getInstanceId());
        if (this.schedulerTrackingLatch != null) {
            this.schedulerTrackingLatch.countDown();
        }
        while (this.schedulerState == RcaSchedulerState.STATE_STARTED) {
            try {
                long startTime = System.currentTimeMillis();
                this.schedulerTask.run();
                long duration = System.currentTimeMillis() - startTime;
                if (duration >= 1000L) continue;
                Thread.sleep(1000L - duration);
            }
            catch (InterruptedException ie) {
                LOG.error("**ERR: Rca scheduler thread sleep interrupted.", (Throwable)ie);
                this.shutdown();
                this.schedulerState = RcaSchedulerState.STATE_STOPPED_DUE_TO_EXCEPTION;
            }
            catch (Exception ex) {
                LOG.error("**ERR Scheduler failed: ", (Throwable)ex);
            }
        }
    }

    public void shutdown() {
        LOG.info("Shutting down the scheduler..");
        this.shutdownRequested = true;
        this.scheduledPool.shutdown();
        this.waitForShutdown(this.scheduledPool);
        this.rcaSchedulerPeriodicExecutor.shutdown();
        this.waitForShutdown(this.rcaSchedulerPeriodicExecutor);
        try {
            this.persistable.close();
        }
        catch (SQLException e) {
            LOG.error("RCA: Error while closing the DB connection: {}::{}", (Object)e.getErrorCode(), (Object)e.getCause());
        }
        this.schedulerState = RcaSchedulerState.STATE_STOPPED;
        if (this.schedulerTrackingLatch != null) {
            this.schedulerTrackingLatch.countDown();
        }
    }

    private void waitForShutdown(ExecutorService execPool) {
        try {
            if (!execPool.awaitTermination(2L, TimeUnit.SECONDS)) {
                execPool.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            LOG.error("RCA: Error in call to shutdownNow. {}", (Object)e.getMessage());
            execPool.shutdownNow();
        }
    }

    public RcaSchedulerState getState() {
        return this.schedulerState;
    }

    private void createExecutorPools() {
        this.scheduledPool = Executors.newScheduledThreadPool(1, this.schedThreadFactory);
        this.rcaSchedulerPeriodicExecutor = Executors.newFixedThreadPool(2, this.taskThreadFactory);
    }

    public void updateAppContextWithMutedActions(Set<String> mutedActions) {
        if (this.appContext != null) {
            this.appContext.updateMutedActions(mutedActions);
        }
    }

    public AllMetrics.NodeRole getRole() {
        return this.role;
    }

    public void setSchedulerTrackingLatch(CountDownLatch schedulerTrackingLatch) {
        this.schedulerTrackingLatch = schedulerTrackingLatch;
    }

    @VisibleForTesting
    public void setQueryable(Queryable queryable) throws InterruptedException {
        this.db = queryable;
        if (this.schedulerTask != null) {
            this.schedulerTask.setNewDb(queryable);
            Thread.sleep(2000L);
        }
    }

    @VisibleForTesting
    public AppContext getAppContext() {
        return this.appContext;
    }
}

