/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.catalog.model.auth;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public enum AuthenticationType {
    BASICAUTH("basicauth"),
    AWSSIGV4AUTH("awssigv4");

    private String name;
    private static final Map<String, AuthenticationType> ENUM_MAP;

    private AuthenticationType(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public static AuthenticationType get(String name) {
        return ENUM_MAP.get(name.toLowerCase());
    }

    static {
        HashMap<String, AuthenticationType> map = new HashMap<String, AuthenticationType>();
        for (AuthenticationType instance : AuthenticationType.values()) {
            map.put(instance.getName().toLowerCase(), instance);
        }
        ENUM_MAP = Collections.unmodifiableMap(map);
    }
}

