/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.opensearch.planner.logical.rule;

import com.facebook.presto.matching.Capture;
import com.facebook.presto.matching.Captures;
import com.facebook.presto.matching.Pattern;
import lombok.Generated;
import org.opensearch.sql.opensearch.planner.logical.OpenSearchLogicalIndexScan;
import org.opensearch.sql.planner.logical.LogicalLimit;
import org.opensearch.sql.planner.logical.LogicalPlan;
import org.opensearch.sql.planner.logical.LogicalRelation;
import org.opensearch.sql.planner.optimizer.Rule;
import org.opensearch.sql.planner.optimizer.pattern.Patterns;

public class MergeLimitAndRelation
implements Rule<LogicalLimit> {
    private final Capture<LogicalRelation> relationCapture = Capture.newCapture();
    private final Pattern<LogicalLimit> pattern = Pattern.typeOf(LogicalLimit.class).with(Patterns.source().matching(Pattern.typeOf(LogicalRelation.class).capturedAs(this.relationCapture)));

    public LogicalPlan apply(LogicalLimit plan, Captures captures) {
        LogicalRelation relation = (LogicalRelation)captures.get(this.relationCapture);
        return OpenSearchLogicalIndexScan.builder().relationName(relation.getRelationName()).offset(plan.getOffset()).limit(plan.getLimit()).build();
    }

    @Generated
    public Capture<LogicalRelation> getRelationCapture() {
        return this.relationCapture;
    }

    @Generated
    public Pattern<LogicalLimit> pattern() {
        return this.pattern;
    }
}

