/*
 * Copyright (C) 2022 TypeFox and others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at http://www.apache.org/licenses/LICENSE-2.0
 */
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
import API from '../utils/api.js';
import { Position } from '../utils/typeConverters.js';
import { toLocation, uriToPath } from '../protocol-translation.js';
import { tsp } from '../ts-protocol.js';
export class SourceDefinitionCommand {
    static async execute(uri, position, documents, tspClient, lspClient, reporter) {
        if (tspClient.apiVersion.lt(SourceDefinitionCommand.minVersion)) {
            lspClient.showErrorMessage('Go to Source Definition failed. Requires TypeScript 4.7+.');
            return;
        }
        if (!position || typeof position.character !== 'number' || typeof position.line !== 'number') {
            lspClient.showErrorMessage('Go to Source Definition failed. Invalid position.');
            return;
        }
        let file;
        if (!uri || typeof uri !== 'string' || !(file = uriToPath(uri))) {
            lspClient.showErrorMessage('Go to Source Definition failed. No resource provided.');
            return;
        }
        const document = documents.get(file);
        if (!document) {
            lspClient.showErrorMessage('Go to Source Definition failed. File not opened in the editor.');
            return;
        }
        const args = Position.toFileLocationRequestArgs(file, position);
        return await lspClient.withProgress({
            message: 'Finding source definitions…',
            reporter,
        }, async () => {
            const response = await tspClient.request(tsp.CommandTypes.FindSourceDefinition, args);
            if (response.type !== 'response' || !response.body) {
                lspClient.showErrorMessage('No source definitions found.');
                return;
            }
            return response.body.map(reference => toLocation(reference, documents));
        });
    }
}
SourceDefinitionCommand.id = '_typescript.goToSourceDefinition';
SourceDefinitionCommand.minVersion = API.v470;
//# sourceMappingURL=source-definition.js.map