/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.uisupport;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.Box;

public final class HorizontalLayout
implements LayoutManager {
    private final boolean proportionalHeight;
    private final int hGap;

    public HorizontalLayout(boolean proportionalHeight) {
        this(proportionalHeight, 0);
    }

    public HorizontalLayout(boolean proportionalHeight, int hGap) {
        this.proportionalHeight = proportionalHeight;
        this.hGap = hGap;
    }

    @Override
    public void layoutContainer(Container parent) {
        Insets insets = parent.getInsets();
        int posX = insets.left;
        int posY = insets.top;
        int height = parent.getHeight() - insets.top - insets.bottom;
        for (Component comp : parent.getComponents()) {
            if (!comp.isVisible()) continue;
            Dimension pref = comp.getPreferredSize();
            if (this.proportionalHeight) {
                int h = Math.min(pref.height, height);
                int o = (height - h) / 2;
                comp.setBounds(posX, posY + o, pref.width, h);
            } else {
                comp.setBounds(posX, posY, pref.width, height);
            }
            posX += this.hGap;
            posX += pref.width;
        }
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        Insets insets = parent.getInsets();
        Dimension d = new Dimension(insets.left + insets.right, insets.top + insets.bottom);
        int maxHeight = 0;
        int visibleCount = 0;
        for (Component comp : parent.getComponents()) {
            if (!comp.isVisible() || comp instanceof Box.Filler) continue;
            Dimension size = comp.getPreferredSize();
            maxHeight = Math.max(maxHeight, size.height);
            d.width += size.width;
            ++visibleCount;
        }
        d.width += (visibleCount - 1) * this.hGap;
        d.height += maxHeight;
        return d;
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        Insets insets = parent.getInsets();
        Dimension d = new Dimension(insets.left + insets.right, insets.top + insets.bottom);
        int maxHeight = 0;
        int visibleCount = 0;
        for (Component comp : parent.getComponents()) {
            if (!comp.isVisible()) continue;
            Dimension size = comp.getPreferredSize();
            maxHeight = Math.max(maxHeight, size.height);
            d.width += size.width;
            ++visibleCount;
        }
        d.width += (visibleCount - 1) * this.hGap;
        d.height += maxHeight;
        return d;
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
    }

    @Override
    public void removeLayoutComponent(Component comp) {
    }
}

