/* sudoku-board.c generated by valac 0.56.3, the Vala compiler
 * generated from sudoku-board.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*
 * Copyright © 2014 Parin Porecha
 * Copyright © 2014 Michael Catanzaro
 *
 * This file is part of GNOME Sudoku.
 *
 * GNOME Sudoku is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME Sudoku is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME Sudoku. If not, see <http://www.gnu.org/licenses/>.
 */

#include "libsudoku.h"
#include <glib.h>
#include <float.h>
#include <math.h>
#include <glib-object.h>
#include <gee.h>
#include <qqwing-wrapper.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>

enum  {
	SUDOKU_BOARD_0_PROPERTY,
	SUDOKU_BOARD_PREVIOUS_PLAYED_TIME_PROPERTY,
	SUDOKU_BOARD_DIFFICULTY_CATEGORY_PROPERTY,
	SUDOKU_BOARD_BLOCK_ROWS_PROPERTY,
	SUDOKU_BOARD_BLOCK_COLS_PROPERTY,
	SUDOKU_BOARD_ROWS_PROPERTY,
	SUDOKU_BOARD_COLS_PROPERTY,
	SUDOKU_BOARD_MAX_VAL_PROPERTY,
	SUDOKU_BOARD_BROKEN_PROPERTY,
	SUDOKU_BOARD_FILLED_PROPERTY,
	SUDOKU_BOARD_FIXED_PROPERTY,
	SUDOKU_BOARD_SIZE_PROPERTY,
	SUDOKU_BOARD_COMPLETE_PROPERTY,
	SUDOKU_BOARD_NUM_PROPERTIES
};
static GParamSpec* sudoku_board_properties[SUDOKU_BOARD_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _coord_free0(var) ((var == NULL) ? NULL : (var = (coord_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
enum  {
	SUDOKU_BOARD_COMPLETED_SIGNAL,
	SUDOKU_BOARD_NUM_SIGNALS
};
static guint sudoku_board_signals[SUDOKU_BOARD_NUM_SIGNALS] = {0};
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _SudokuBoardPrivate {
	gboolean* possible_in_row;
	gint possible_in_row_length1;
	gint possible_in_row_length2;
	gboolean* possible_in_col;
	gint possible_in_col_length1;
	gint possible_in_col_length2;
	gboolean* possible_in_block;
	gint possible_in_block_length1;
	gint possible_in_block_length2;
	gint possible_in_block_length3;
	gboolean* earmarks;
	gint earmarks_length1;
	gint earmarks_length2;
	gint earmarks_length3;
	gint n_earmarks;
	gdouble _previous_played_time;
	DifficultyCategory _difficulty_category;
	gint _block_rows;
	gint _block_cols;
	gint _rows;
	gint _cols;
	gint _filled;
	gint _fixed;
};

static gint SudokuBoard_private_offset;
static gpointer sudoku_board_parent_class = NULL;

static void sudoku_board_set_cols (SudokuBoard* self,
                            gint value);
static void sudoku_board_set_rows (SudokuBoard* self,
                            gint value);
static void sudoku_board_set_block_rows (SudokuBoard* self,
                                  gint value);
static void sudoku_board_set_block_cols (SudokuBoard* self,
                                  gint value);
static gint* _vala_array_dup1 (gint* self,
                        gssize length);
static gint* _vala_array_dup2 (gint* self,
                        gssize length);
static gboolean* _vala_array_dup3 (gboolean* self,
                            gssize length);
static gboolean* _vala_array_dup4 (gboolean* self,
                            gssize length);
static gboolean* _vala_array_dup5 (gboolean* self,
                            gssize length);
static gboolean* _vala_array_dup6 (gboolean* self,
                            gssize length);
static void sudoku_board_set_filled (SudokuBoard* self,
                              gint value);
static void sudoku_board_set_fixed (SudokuBoard* self,
                             gint value);
static gboolean* _vala_array_dup7 (gboolean* self,
                            gssize length);
static gint* _vala_array_dup8 (gint* self,
                        gssize length);
static void sudoku_board_mark_breakages_for (SudokuBoard* self,
                                      GeeList* coords,
                                      gint val);
static void sudoku_board_remove_breakages_for (SudokuBoard* self,
                                        GeeList* coords,
                                        gint val);
static gint* sudoku_board_convert_2d_to_1d (SudokuBoard* self,
                                     gint* ints_2d,
                                     gint ints_2d_length1,
                                     gint ints_2d_length2,
                                     gint* result_length1);
static gint* sudoku_board_convert_1d_to_2d (SudokuBoard* self,
                                     gint* ints_1d,
                                     gint ints_1d_length1,
                                     gint* result_length1,
                                     gint* result_length2);
static gint* _vala_array_dup9 (gint* self,
                        gssize length);
static void sudoku_board_finalize (GObject * obj);
static GType sudoku_board_get_type_once (void);
static void _vala_sudoku_board_get_property (GObject * object,
                                      guint property_id,
                                      GValue * value,
                                      GParamSpec * pspec);
static void _vala_sudoku_board_set_property (GObject * object,
                                      guint property_id,
                                      const GValue * value,
                                      GParamSpec * pspec);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
sudoku_board_get_instance_private (SudokuBoard* self)
{
	return G_STRUCT_MEMBER_P (self, SudokuBoard_private_offset);
}

gboolean
sudoku_board_is_empty (SudokuBoard* self)
{
	gboolean _tmp0_ = FALSE;
	gint _tmp1_;
	gint _tmp2_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = self->priv->_filled;
	_tmp2_ = self->priv->_fixed;
	if (_tmp1_ == _tmp2_) {
		_tmp0_ = self->priv->n_earmarks == 0;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

gboolean
sudoku_board_is_fully_filled (SudokuBoard* self)
{
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_filled;
	_tmp1_ = self->priv->_cols;
	_tmp2_ = self->priv->_rows;
	result = _tmp0_ == (_tmp1_ * _tmp2_);
	return result;
}

SudokuBoard*
sudoku_board_construct (GType object_type,
                        gint block_rows,
                        gint block_cols)
{
	SudokuBoard * self = NULL;
	gint _tmp0_;
	gint _tmp1_;
	gint* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gboolean* _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	gboolean* _tmp8_;
	gint _tmp9_;
	gint _tmp10_;
	gboolean* _tmp11_;
	gboolean* _tmp12_;
	gint _tmp13_;
	gint _tmp14_;
	gint _tmp15_;
	gint _tmp16_;
	gboolean* _tmp17_;
	GeeHashSet* _tmp37_;
	GeeArrayList* _tmp38_;
	GeeList* _tmp59_;
	GeeList* _tmp60_;
	GeeList* _tmp61_;
	GeeArrayList* _tmp62_;
	GeeList* _tmp83_;
	GeeList* _tmp84_;
	GeeList* _tmp85_;
	GeeHashMap* _tmp86_;
	GeeMap* _tmp119_;
	GeeMap* _tmp120_;
	GeeMap* _tmp121_;
	self = (SudokuBoard*) g_object_new (object_type, NULL);
	sudoku_board_set_cols (self, block_rows * block_cols);
	sudoku_board_set_rows (self, block_rows * block_cols);
	sudoku_board_set_block_rows (self, block_rows);
	sudoku_board_set_block_cols (self, block_cols);
	_tmp0_ = self->priv->_rows;
	_tmp1_ = self->priv->_cols;
	_tmp2_ = g_new0 (gint, _tmp0_ * _tmp1_);
	self->cells = (g_free (self->cells), NULL);
	self->cells = _tmp2_;
	self->cells_length1 = _tmp0_;
	self->cells_length2 = _tmp1_;
	_tmp3_ = self->priv->_rows;
	_tmp4_ = self->priv->_cols;
	_tmp5_ = g_new0 (gboolean, _tmp3_ * _tmp4_);
	self->is_fixed = (g_free (self->is_fixed), NULL);
	self->is_fixed = _tmp5_;
	self->is_fixed_length1 = _tmp3_;
	self->is_fixed_length2 = _tmp4_;
	_tmp6_ = self->priv->_rows;
	_tmp7_ = self->priv->_cols;
	_tmp8_ = g_new0 (gboolean, _tmp6_ * _tmp7_);
	self->priv->possible_in_row = (g_free (self->priv->possible_in_row), NULL);
	self->priv->possible_in_row = _tmp8_;
	self->priv->possible_in_row_length1 = _tmp6_;
	self->priv->possible_in_row_length2 = _tmp7_;
	_tmp9_ = self->priv->_cols;
	_tmp10_ = self->priv->_rows;
	_tmp11_ = g_new0 (gboolean, _tmp9_ * _tmp10_);
	self->priv->possible_in_col = (g_free (self->priv->possible_in_col), NULL);
	self->priv->possible_in_col = _tmp11_;
	self->priv->possible_in_col_length1 = _tmp9_;
	self->priv->possible_in_col_length2 = _tmp10_;
	_tmp12_ = g_new0 (gboolean, (block_rows * block_cols) * (block_rows * block_cols));
	self->priv->possible_in_block = (g_free (self->priv->possible_in_block), NULL);
	self->priv->possible_in_block = _tmp12_;
	self->priv->possible_in_block_length1 = block_rows;
	self->priv->possible_in_block_length2 = block_cols;
	self->priv->possible_in_block_length3 = block_rows * block_cols;
	_tmp13_ = self->priv->_rows;
	_tmp14_ = self->priv->_cols;
	_tmp15_ = sudoku_board_get_max_val (self);
	_tmp16_ = _tmp15_;
	_tmp17_ = g_new0 (gboolean, (_tmp13_ * _tmp14_) * _tmp16_);
	self->priv->earmarks = (g_free (self->priv->earmarks), NULL);
	self->priv->earmarks = _tmp17_;
	self->priv->earmarks_length1 = _tmp13_;
	self->priv->earmarks_length2 = _tmp14_;
	self->priv->earmarks_length3 = _tmp16_;
	{
		gint l1 = 0;
		l1 = 0;
		{
			gboolean _tmp18_ = FALSE;
			_tmp18_ = TRUE;
			while (TRUE) {
				gint _tmp20_;
				if (!_tmp18_) {
					gint _tmp19_;
					_tmp19_ = l1;
					l1 = _tmp19_ + 1;
				}
				_tmp18_ = FALSE;
				_tmp20_ = self->priv->_rows;
				if (!(l1 < _tmp20_)) {
					break;
				}
				{
					gint l2 = 0;
					l2 = 0;
					{
						gboolean _tmp21_ = FALSE;
						_tmp21_ = TRUE;
						while (TRUE) {
							gint _tmp23_;
							gint* _tmp24_;
							gint _tmp24__length1;
							gint _tmp24__length2;
							gboolean* _tmp25_;
							gint _tmp25__length1;
							gint _tmp25__length2;
							gboolean* _tmp26_;
							gint _tmp26__length1;
							gint _tmp26__length2;
							gboolean* _tmp27_;
							gint _tmp27__length1;
							gint _tmp27__length2;
							if (!_tmp21_) {
								gint _tmp22_;
								_tmp22_ = l2;
								l2 = _tmp22_ + 1;
							}
							_tmp21_ = FALSE;
							_tmp23_ = self->priv->_cols;
							if (!(l2 < _tmp23_)) {
								break;
							}
							_tmp24_ = self->cells;
							_tmp24__length1 = self->cells_length1;
							_tmp24__length2 = self->cells_length2;
							_tmp24_[(l1 * _tmp24__length2) + l2] = 0;
							_tmp25_ = self->is_fixed;
							_tmp25__length1 = self->is_fixed_length1;
							_tmp25__length2 = self->is_fixed_length2;
							_tmp25_[(l1 * _tmp25__length2) + l2] = FALSE;
							_tmp26_ = self->priv->possible_in_row;
							_tmp26__length1 = self->priv->possible_in_row_length1;
							_tmp26__length2 = self->priv->possible_in_row_length2;
							_tmp26_[(l1 * _tmp26__length2) + l2] = TRUE;
							_tmp27_ = self->priv->possible_in_col;
							_tmp27__length1 = self->priv->possible_in_col_length1;
							_tmp27__length2 = self->priv->possible_in_col_length2;
							_tmp27_[(l2 * _tmp27__length2) + l1] = TRUE;
						}
					}
				}
			}
		}
	}
	{
		gint l1 = 0;
		l1 = 0;
		{
			gboolean _tmp28_ = FALSE;
			_tmp28_ = TRUE;
			while (TRUE) {
				if (!_tmp28_) {
					gint _tmp29_;
					_tmp29_ = l1;
					l1 = _tmp29_ + 1;
				}
				_tmp28_ = FALSE;
				if (!(l1 < block_rows)) {
					break;
				}
				{
					gint l2 = 0;
					l2 = 0;
					{
						gboolean _tmp30_ = FALSE;
						_tmp30_ = TRUE;
						while (TRUE) {
							if (!_tmp30_) {
								gint _tmp31_;
								_tmp31_ = l2;
								l2 = _tmp31_ + 1;
							}
							_tmp30_ = FALSE;
							if (!(l2 < block_cols)) {
								break;
							}
							{
								gint l3 = 0;
								l3 = 0;
								{
									gboolean _tmp32_ = FALSE;
									_tmp32_ = TRUE;
									while (TRUE) {
										gint _tmp34_;
										gint _tmp35_;
										gboolean* _tmp36_;
										gint _tmp36__length1;
										gint _tmp36__length2;
										gint _tmp36__length3;
										if (!_tmp32_) {
											gint _tmp33_;
											_tmp33_ = l3;
											l3 = _tmp33_ + 1;
										}
										_tmp32_ = FALSE;
										_tmp34_ = sudoku_board_get_max_val (self);
										_tmp35_ = _tmp34_;
										if (!(l3 < _tmp35_)) {
											break;
										}
										_tmp36_ = self->priv->possible_in_block;
										_tmp36__length1 = self->priv->possible_in_block_length1;
										_tmp36__length2 = self->priv->possible_in_block_length2;
										_tmp36__length3 = self->priv->possible_in_block_length3;
										_tmp36_[(((l1 * _tmp36__length2) + l2) * _tmp36__length3) + l3] = TRUE;
									}
								}
							}
						}
					}
				}
			}
		}
	}
	_tmp37_ = gee_hash_set_new (TYPE_COORD, (GBoxedCopyFunc) coord_dup, (GDestroyNotify) coord_free, (GeeHashDataFunc) coord_hash, NULL, NULL, (GeeEqualDataFunc) coord_equal, NULL, NULL);
	_g_object_unref0 (self->broken_coords);
	self->broken_coords = (GeeSet*) _tmp37_;
	_tmp38_ = gee_array_list_new (GEE_TYPE_ARRAY_LIST, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->coords_for_col);
	self->coords_for_col = (GeeList*) _tmp38_;
	{
		gint col = 0;
		col = 0;
		{
			gboolean _tmp39_ = FALSE;
			_tmp39_ = TRUE;
			while (TRUE) {
				gint _tmp41_;
				GeeList* _tmp42_;
				GeeArrayList* _tmp43_;
				GeeArrayList* _tmp44_;
				GeeList* _tmp52_;
				GeeList* _tmp53_;
				gpointer _tmp54_;
				GeeList* _tmp55_;
				GeeList* _tmp56_;
				GeeList* _tmp57_;
				GeeList* _tmp58_;
				if (!_tmp39_) {
					gint _tmp40_;
					_tmp40_ = col;
					col = _tmp40_ + 1;
				}
				_tmp39_ = FALSE;
				_tmp41_ = self->priv->_cols;
				if (!(col < _tmp41_)) {
					break;
				}
				_tmp42_ = self->coords_for_col;
				_tmp43_ = gee_array_list_new (TYPE_COORD, (GBoxedCopyFunc) coord_dup, (GDestroyNotify) coord_free, (GeeEqualDataFunc) coord_equal, NULL, NULL);
				_tmp44_ = _tmp43_;
				gee_collection_add ((GeeCollection*) _tmp42_, (GeeList*) _tmp44_);
				_g_object_unref0 (_tmp44_);
				{
					gint row = 0;
					row = 0;
					{
						gboolean _tmp45_ = FALSE;
						_tmp45_ = TRUE;
						while (TRUE) {
							gint _tmp47_;
							GeeList* _tmp48_;
							gpointer _tmp49_;
							GeeList* _tmp50_;
							Coord _tmp51_ = {0};
							if (!_tmp45_) {
								gint _tmp46_;
								_tmp46_ = row;
								row = _tmp46_ + 1;
							}
							_tmp45_ = FALSE;
							_tmp47_ = self->priv->_rows;
							if (!(row < _tmp47_)) {
								break;
							}
							_tmp48_ = self->coords_for_col;
							_tmp49_ = gee_list_get (_tmp48_, col);
							_tmp50_ = (GeeList*) _tmp49_;
							coord_init (&_tmp51_, row, col);
							gee_collection_add ((GeeCollection*) _tmp50_, &_tmp51_);
							_g_object_unref0 (_tmp50_);
						}
					}
				}
				_tmp52_ = self->coords_for_col;
				_tmp53_ = self->coords_for_col;
				_tmp54_ = gee_list_get (_tmp53_, col);
				_tmp55_ = (GeeList*) _tmp54_;
				_tmp56_ = gee_list_get_read_only_view (_tmp55_);
				_tmp57_ = _tmp56_;
				_tmp58_ = _tmp57_;
				gee_list_set (_tmp52_, col, _tmp58_);
				_g_object_unref0 (_tmp58_);
				_g_object_unref0 (_tmp55_);
			}
		}
	}
	_tmp59_ = self->coords_for_col;
	_tmp60_ = gee_list_get_read_only_view (_tmp59_);
	_tmp61_ = _tmp60_;
	_g_object_unref0 (self->coords_for_col);
	self->coords_for_col = _tmp61_;
	_tmp62_ = gee_array_list_new (GEE_TYPE_ARRAY_LIST, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->coords_for_row);
	self->coords_for_row = (GeeList*) _tmp62_;
	{
		gint row = 0;
		row = 0;
		{
			gboolean _tmp63_ = FALSE;
			_tmp63_ = TRUE;
			while (TRUE) {
				gint _tmp65_;
				GeeList* _tmp66_;
				GeeArrayList* _tmp67_;
				GeeArrayList* _tmp68_;
				GeeList* _tmp76_;
				GeeList* _tmp77_;
				gpointer _tmp78_;
				GeeList* _tmp79_;
				GeeList* _tmp80_;
				GeeList* _tmp81_;
				GeeList* _tmp82_;
				if (!_tmp63_) {
					gint _tmp64_;
					_tmp64_ = row;
					row = _tmp64_ + 1;
				}
				_tmp63_ = FALSE;
				_tmp65_ = self->priv->_rows;
				if (!(row < _tmp65_)) {
					break;
				}
				_tmp66_ = self->coords_for_row;
				_tmp67_ = gee_array_list_new (TYPE_COORD, (GBoxedCopyFunc) coord_dup, (GDestroyNotify) coord_free, (GeeEqualDataFunc) coord_equal, NULL, NULL);
				_tmp68_ = _tmp67_;
				gee_collection_add ((GeeCollection*) _tmp66_, (GeeList*) _tmp68_);
				_g_object_unref0 (_tmp68_);
				{
					gint col = 0;
					col = 0;
					{
						gboolean _tmp69_ = FALSE;
						_tmp69_ = TRUE;
						while (TRUE) {
							gint _tmp71_;
							GeeList* _tmp72_;
							gpointer _tmp73_;
							GeeList* _tmp74_;
							Coord _tmp75_ = {0};
							if (!_tmp69_) {
								gint _tmp70_;
								_tmp70_ = col;
								col = _tmp70_ + 1;
							}
							_tmp69_ = FALSE;
							_tmp71_ = self->priv->_cols;
							if (!(col < _tmp71_)) {
								break;
							}
							_tmp72_ = self->coords_for_row;
							_tmp73_ = gee_list_get (_tmp72_, row);
							_tmp74_ = (GeeList*) _tmp73_;
							coord_init (&_tmp75_, row, col);
							gee_collection_add ((GeeCollection*) _tmp74_, &_tmp75_);
							_g_object_unref0 (_tmp74_);
						}
					}
				}
				_tmp76_ = self->coords_for_row;
				_tmp77_ = self->coords_for_row;
				_tmp78_ = gee_list_get (_tmp77_, row);
				_tmp79_ = (GeeList*) _tmp78_;
				_tmp80_ = gee_list_get_read_only_view (_tmp79_);
				_tmp81_ = _tmp80_;
				_tmp82_ = _tmp81_;
				gee_list_set (_tmp76_, row, _tmp82_);
				_g_object_unref0 (_tmp82_);
				_g_object_unref0 (_tmp79_);
			}
		}
	}
	_tmp83_ = self->coords_for_row;
	_tmp84_ = gee_list_get_read_only_view (_tmp83_);
	_tmp85_ = _tmp84_;
	_g_object_unref0 (self->coords_for_row);
	self->coords_for_row = _tmp85_;
	_tmp86_ = gee_hash_map_new (TYPE_COORD, (GBoxedCopyFunc) coord_dup, (GDestroyNotify) coord_free, GEE_TYPE_LIST, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, (GeeHashDataFunc) coord_hash, NULL, NULL, (GeeEqualDataFunc) coord_equal, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->coords_for_block);
	self->coords_for_block = (GeeMap*) _tmp86_;
	{
		gint col = 0;
		col = 0;
		{
			gboolean _tmp87_ = FALSE;
			_tmp87_ = TRUE;
			while (TRUE) {
				if (!_tmp87_) {
					gint _tmp88_;
					_tmp88_ = col;
					col = _tmp88_ + 1;
				}
				_tmp87_ = FALSE;
				if (!(col < block_cols)) {
					break;
				}
				{
					gint row = 0;
					row = 0;
					{
						gboolean _tmp89_ = FALSE;
						_tmp89_ = TRUE;
						while (TRUE) {
							GeeMap* _tmp91_;
							Coord _tmp92_ = {0};
							GeeArrayList* _tmp93_;
							GeeArrayList* _tmp94_;
							if (!_tmp89_) {
								gint _tmp90_;
								_tmp90_ = row;
								row = _tmp90_ + 1;
							}
							_tmp89_ = FALSE;
							if (!(row < block_rows)) {
								break;
							}
							_tmp91_ = self->coords_for_block;
							coord_init (&_tmp92_, row, col);
							_tmp93_ = gee_array_list_new (TYPE_COORD, (GBoxedCopyFunc) coord_dup, (GDestroyNotify) coord_free, (GeeEqualDataFunc) coord_equal, NULL, NULL);
							_tmp94_ = _tmp93_;
							gee_map_set (_tmp91_, &_tmp92_, (GeeList*) _tmp94_);
							_g_object_unref0 (_tmp94_);
						}
					}
				}
			}
		}
	}
	{
		gint col = 0;
		col = 0;
		{
			gboolean _tmp95_ = FALSE;
			_tmp95_ = TRUE;
			while (TRUE) {
				gint _tmp97_;
				if (!_tmp95_) {
					gint _tmp96_;
					_tmp96_ = col;
					col = _tmp96_ + 1;
				}
				_tmp95_ = FALSE;
				_tmp97_ = self->priv->_cols;
				if (!(col < _tmp97_)) {
					break;
				}
				{
					gint row = 0;
					row = 0;
					{
						gboolean _tmp98_ = FALSE;
						_tmp98_ = TRUE;
						while (TRUE) {
							gint _tmp100_;
							GeeMap* _tmp101_;
							Coord _tmp102_ = {0};
							gpointer _tmp103_;
							GeeList* _tmp104_;
							Coord _tmp105_ = {0};
							if (!_tmp98_) {
								gint _tmp99_;
								_tmp99_ = row;
								row = _tmp99_ + 1;
							}
							_tmp98_ = FALSE;
							_tmp100_ = self->priv->_rows;
							if (!(row < _tmp100_)) {
								break;
							}
							_tmp101_ = self->coords_for_block;
							coord_init (&_tmp102_, row / block_rows, col / block_cols);
							_tmp103_ = gee_map_get (_tmp101_, &_tmp102_);
							_tmp104_ = (GeeList*) _tmp103_;
							coord_init (&_tmp105_, row, col);
							gee_collection_add ((GeeCollection*) _tmp104_, &_tmp105_);
							_g_object_unref0 (_tmp104_);
						}
					}
				}
			}
		}
	}
	{
		gint col = 0;
		col = 0;
		{
			gboolean _tmp106_ = FALSE;
			_tmp106_ = TRUE;
			while (TRUE) {
				if (!_tmp106_) {
					gint _tmp107_;
					_tmp107_ = col;
					col = _tmp107_ + 1;
				}
				_tmp106_ = FALSE;
				if (!(col < block_cols)) {
					break;
				}
				{
					gint row = 0;
					row = 0;
					{
						gboolean _tmp108_ = FALSE;
						_tmp108_ = TRUE;
						while (TRUE) {
							GeeMap* _tmp110_;
							Coord _tmp111_ = {0};
							GeeMap* _tmp112_;
							Coord _tmp113_ = {0};
							gpointer _tmp114_;
							GeeList* _tmp115_;
							GeeList* _tmp116_;
							GeeList* _tmp117_;
							GeeList* _tmp118_;
							if (!_tmp108_) {
								gint _tmp109_;
								_tmp109_ = row;
								row = _tmp109_ + 1;
							}
							_tmp108_ = FALSE;
							if (!(row < block_rows)) {
								break;
							}
							_tmp110_ = self->coords_for_block;
							coord_init (&_tmp111_, row, col);
							_tmp112_ = self->coords_for_block;
							coord_init (&_tmp113_, row, col);
							_tmp114_ = gee_map_get (_tmp112_, &_tmp113_);
							_tmp115_ = (GeeList*) _tmp114_;
							_tmp116_ = gee_list_get_read_only_view (_tmp115_);
							_tmp117_ = _tmp116_;
							_tmp118_ = _tmp117_;
							gee_map_set (_tmp110_, &_tmp111_, _tmp118_);
							_g_object_unref0 (_tmp118_);
							_g_object_unref0 (_tmp115_);
						}
					}
				}
			}
		}
	}
	_tmp119_ = self->coords_for_block;
	_tmp120_ = gee_map_get_read_only_view (_tmp119_);
	_tmp121_ = _tmp120_;
	_g_object_unref0 (self->coords_for_block);
	self->coords_for_block = _tmp121_;
	return self;
}

SudokuBoard*
sudoku_board_new (gint block_rows,
                  gint block_cols)
{
	return sudoku_board_construct (TYPE_SUDOKU_BOARD, block_rows, block_cols);
}

static gint*
_vala_array_dup1 (gint* self,
                  gssize length)
{
	if (length > 0) {
		return _vala_memdup2 (self, length * sizeof (gint));
	}
	return NULL;
}

static gint*
_vala_array_dup2 (gint* self,
                  gssize length)
{
	if (length > 0) {
		return _vala_memdup2 (self, length * sizeof (gint));
	}
	return NULL;
}

static gboolean*
_vala_array_dup3 (gboolean* self,
                  gssize length)
{
	if (length > 0) {
		return _vala_memdup2 (self, length * sizeof (gboolean));
	}
	return NULL;
}

static gboolean*
_vala_array_dup4 (gboolean* self,
                  gssize length)
{
	if (length > 0) {
		return _vala_memdup2 (self, length * sizeof (gboolean));
	}
	return NULL;
}

static gboolean*
_vala_array_dup5 (gboolean* self,
                  gssize length)
{
	if (length > 0) {
		return _vala_memdup2 (self, length * sizeof (gboolean));
	}
	return NULL;
}

static gboolean*
_vala_array_dup6 (gboolean* self,
                  gssize length)
{
	if (length > 0) {
		return _vala_memdup2 (self, length * sizeof (gboolean));
	}
	return NULL;
}

static gboolean*
_vala_array_dup7 (gboolean* self,
                  gssize length)
{
	if (length > 0) {
		return _vala_memdup2 (self, length * sizeof (gboolean));
	}
	return NULL;
}

SudokuBoard*
sudoku_board_clone (SudokuBoard* self)
{
	SudokuBoard* board = NULL;
	gint _tmp0_;
	gint _tmp1_;
	SudokuBoard* _tmp2_;
	gint* _tmp3_;
	gint _tmp3__length1;
	gint _tmp3__length2;
	gint* _tmp4_;
	gint _tmp4__length1;
	gint _tmp4__length2;
	gint* _tmp5_;
	gint _tmp5__length1;
	gint _tmp5__length2;
	gint* _tmp6_;
	gint _tmp6__length1;
	gint _tmp6__length2;
	gboolean* _tmp7_;
	gint _tmp7__length1;
	gint _tmp7__length2;
	gboolean* _tmp8_;
	gint _tmp8__length1;
	gint _tmp8__length2;
	gboolean* _tmp9_;
	gint _tmp9__length1;
	gint _tmp9__length2;
	gboolean* _tmp10_;
	gint _tmp10__length1;
	gint _tmp10__length2;
	gboolean* _tmp11_;
	gint _tmp11__length1;
	gint _tmp11__length2;
	gboolean* _tmp12_;
	gint _tmp12__length1;
	gint _tmp12__length2;
	gboolean* _tmp13_;
	gint _tmp13__length1;
	gint _tmp13__length2;
	gint _tmp13__length3;
	gboolean* _tmp14_;
	gint _tmp14__length1;
	gint _tmp14__length2;
	gint _tmp14__length3;
	gint _tmp15_;
	gint _tmp16_;
	GeeSet* _tmp17_;
	GeeSet* _tmp18_;
	gboolean* _tmp19_;
	gint _tmp19__length1;
	gint _tmp19__length2;
	gint _tmp19__length3;
	gboolean* _tmp20_;
	gint _tmp20__length1;
	gint _tmp20__length2;
	gint _tmp20__length3;
	DifficultyCategory _tmp21_;
	SudokuBoard* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_block_rows;
	_tmp1_ = self->priv->_block_cols;
	_tmp2_ = sudoku_board_new (_tmp0_, _tmp1_);
	board = _tmp2_;
	_tmp3_ = self->cells;
	_tmp3__length1 = self->cells_length1;
	_tmp3__length2 = self->cells_length2;
	_tmp4_ = (_tmp3_ != NULL) ? _vala_array_dup1 (_tmp3_, _tmp3__length1 * _tmp3__length2) : _tmp3_;
	_tmp4__length1 = _tmp3__length1;
	_tmp4__length2 = _tmp3__length2;
	board->cells = (g_free (board->cells), NULL);
	board->cells = _tmp4_;
	board->cells_length1 = _tmp4__length1;
	board->cells_length2 = _tmp4__length2;
	_tmp5_ = self->solution;
	_tmp5__length1 = self->solution_length1;
	_tmp5__length2 = self->solution_length2;
	_tmp6_ = (_tmp5_ != NULL) ? _vala_array_dup2 (_tmp5_, _tmp5__length1 * _tmp5__length2) : _tmp5_;
	_tmp6__length1 = _tmp5__length1;
	_tmp6__length2 = _tmp5__length2;
	board->solution = (g_free (board->solution), NULL);
	board->solution = _tmp6_;
	board->solution_length1 = _tmp6__length1;
	board->solution_length2 = _tmp6__length2;
	_tmp7_ = self->is_fixed;
	_tmp7__length1 = self->is_fixed_length1;
	_tmp7__length2 = self->is_fixed_length2;
	_tmp8_ = (_tmp7_ != NULL) ? _vala_array_dup3 (_tmp7_, _tmp7__length1 * _tmp7__length2) : _tmp7_;
	_tmp8__length1 = _tmp7__length1;
	_tmp8__length2 = _tmp7__length2;
	board->is_fixed = (g_free (board->is_fixed), NULL);
	board->is_fixed = _tmp8_;
	board->is_fixed_length1 = _tmp8__length1;
	board->is_fixed_length2 = _tmp8__length2;
	_tmp9_ = self->priv->possible_in_row;
	_tmp9__length1 = self->priv->possible_in_row_length1;
	_tmp9__length2 = self->priv->possible_in_row_length2;
	_tmp10_ = (_tmp9_ != NULL) ? _vala_array_dup4 (_tmp9_, _tmp9__length1 * _tmp9__length2) : _tmp9_;
	_tmp10__length1 = _tmp9__length1;
	_tmp10__length2 = _tmp9__length2;
	board->priv->possible_in_row = (g_free (board->priv->possible_in_row), NULL);
	board->priv->possible_in_row = _tmp10_;
	board->priv->possible_in_row_length1 = _tmp10__length1;
	board->priv->possible_in_row_length2 = _tmp10__length2;
	_tmp11_ = self->priv->possible_in_col;
	_tmp11__length1 = self->priv->possible_in_col_length1;
	_tmp11__length2 = self->priv->possible_in_col_length2;
	_tmp12_ = (_tmp11_ != NULL) ? _vala_array_dup5 (_tmp11_, _tmp11__length1 * _tmp11__length2) : _tmp11_;
	_tmp12__length1 = _tmp11__length1;
	_tmp12__length2 = _tmp11__length2;
	board->priv->possible_in_col = (g_free (board->priv->possible_in_col), NULL);
	board->priv->possible_in_col = _tmp12_;
	board->priv->possible_in_col_length1 = _tmp12__length1;
	board->priv->possible_in_col_length2 = _tmp12__length2;
	_tmp13_ = self->priv->possible_in_block;
	_tmp13__length1 = self->priv->possible_in_block_length1;
	_tmp13__length2 = self->priv->possible_in_block_length2;
	_tmp13__length3 = self->priv->possible_in_block_length3;
	_tmp14_ = (_tmp13_ != NULL) ? _vala_array_dup6 (_tmp13_, (_tmp13__length1 * _tmp13__length2) * _tmp13__length3) : _tmp13_;
	_tmp14__length1 = _tmp13__length1;
	_tmp14__length2 = _tmp13__length2;
	_tmp14__length3 = _tmp13__length3;
	board->priv->possible_in_block = (g_free (board->priv->possible_in_block), NULL);
	board->priv->possible_in_block = _tmp14_;
	board->priv->possible_in_block_length1 = _tmp14__length1;
	board->priv->possible_in_block_length2 = _tmp14__length2;
	board->priv->possible_in_block_length3 = _tmp14__length3;
	_tmp15_ = self->priv->_filled;
	sudoku_board_set_filled (board, _tmp15_);
	_tmp16_ = self->priv->_fixed;
	sudoku_board_set_fixed (board, _tmp16_);
	board->priv->n_earmarks = self->priv->n_earmarks;
	_tmp17_ = board->broken_coords;
	_tmp18_ = self->broken_coords;
	gee_collection_add_all ((GeeCollection*) _tmp17_, (GeeCollection*) _tmp18_);
	_tmp19_ = self->priv->earmarks;
	_tmp19__length1 = self->priv->earmarks_length1;
	_tmp19__length2 = self->priv->earmarks_length2;
	_tmp19__length3 = self->priv->earmarks_length3;
	_tmp20_ = (_tmp19_ != NULL) ? _vala_array_dup7 (_tmp19_, (_tmp19__length1 * _tmp19__length2) * _tmp19__length3) : _tmp19_;
	_tmp20__length1 = _tmp19__length1;
	_tmp20__length2 = _tmp19__length2;
	_tmp20__length3 = _tmp19__length3;
	board->priv->earmarks = (g_free (board->priv->earmarks), NULL);
	board->priv->earmarks = _tmp20_;
	board->priv->earmarks_length1 = _tmp20__length1;
	board->priv->earmarks_length2 = _tmp20__length2;
	board->priv->earmarks_length3 = _tmp20__length3;
	_tmp21_ = self->priv->_difficulty_category;
	sudoku_board_set_difficulty_category (board, _tmp21_);
	result = board;
	return result;
}

void
sudoku_board_enable_earmark (SudokuBoard* self,
                             gint row,
                             gint column,
                             gint digit)
{
	gboolean* _tmp0_;
	gint _tmp0__length1;
	gint _tmp0__length2;
	gint _tmp0__length3;
	gboolean _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->earmarks;
	_tmp0__length1 = self->priv->earmarks_length1;
	_tmp0__length2 = self->priv->earmarks_length2;
	_tmp0__length3 = self->priv->earmarks_length3;
	_tmp1_ = _tmp0_[(((row * _tmp0__length2) + column) * _tmp0__length3) + (digit - 1)];
	if (!_tmp1_) {
		gboolean* _tmp2_;
		gint _tmp2__length1;
		gint _tmp2__length2;
		gint _tmp2__length3;
		gint _tmp3_;
		_tmp2_ = self->priv->earmarks;
		_tmp2__length1 = self->priv->earmarks_length1;
		_tmp2__length2 = self->priv->earmarks_length2;
		_tmp2__length3 = self->priv->earmarks_length3;
		_tmp2_[(((row * _tmp2__length2) + column) * _tmp2__length3) + (digit - 1)] = TRUE;
		_tmp3_ = self->priv->n_earmarks;
		self->priv->n_earmarks = _tmp3_ + 1;
	}
	_vala_warn_if_fail (self->priv->n_earmarks > 0, "n_earmarks > 0");
}

void
sudoku_board_disable_earmark (SudokuBoard* self,
                              gint row,
                              gint column,
                              gint digit)
{
	gboolean* _tmp0_;
	gint _tmp0__length1;
	gint _tmp0__length2;
	gint _tmp0__length3;
	gboolean _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->earmarks;
	_tmp0__length1 = self->priv->earmarks_length1;
	_tmp0__length2 = self->priv->earmarks_length2;
	_tmp0__length3 = self->priv->earmarks_length3;
	_tmp1_ = _tmp0_[(((row * _tmp0__length2) + column) * _tmp0__length3) + (digit - 1)];
	if (_tmp1_) {
		gboolean* _tmp2_;
		gint _tmp2__length1;
		gint _tmp2__length2;
		gint _tmp2__length3;
		gint _tmp3_;
		_tmp2_ = self->priv->earmarks;
		_tmp2__length1 = self->priv->earmarks_length1;
		_tmp2__length2 = self->priv->earmarks_length2;
		_tmp2__length3 = self->priv->earmarks_length3;
		_tmp2_[(((row * _tmp2__length2) + column) * _tmp2__length3) + (digit - 1)] = FALSE;
		_tmp3_ = self->priv->n_earmarks;
		self->priv->n_earmarks = _tmp3_ - 1;
	}
	_vala_warn_if_fail (self->priv->n_earmarks >= 0, "n_earmarks >= 0");
}

void
sudoku_board_disable_all_earmarks (SudokuBoard* self,
                                   gint row,
                                   gint column)
{
	g_return_if_fail (self != NULL);
	{
		gint i = 0;
		i = 1;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_;
				gint _tmp3_;
				gboolean* _tmp4_;
				gint _tmp4__length1;
				gint _tmp4__length2;
				gint _tmp4__length3;
				gboolean _tmp5_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = sudoku_board_get_max_val (self);
				_tmp3_ = _tmp2_;
				if (!(i <= _tmp3_)) {
					break;
				}
				_tmp4_ = self->priv->earmarks;
				_tmp4__length1 = self->priv->earmarks_length1;
				_tmp4__length2 = self->priv->earmarks_length2;
				_tmp4__length3 = self->priv->earmarks_length3;
				_tmp5_ = _tmp4_[(((row * _tmp4__length2) + column) * _tmp4__length3) + (i - 1)];
				if (_tmp5_) {
					sudoku_board_disable_earmark (self, row, column, i);
				}
			}
		}
	}
	_vala_warn_if_fail (self->priv->n_earmarks >= 0, "n_earmarks >= 0");
}

gboolean
sudoku_board_is_earmark_enabled (SudokuBoard* self,
                                 gint row,
                                 gint column,
                                 gint digit)
{
	gboolean* _tmp0_;
	gint _tmp0__length1;
	gint _tmp0__length2;
	gint _tmp0__length3;
	gboolean _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->earmarks;
	_tmp0__length1 = self->priv->earmarks_length1;
	_tmp0__length2 = self->priv->earmarks_length2;
	_tmp0__length3 = self->priv->earmarks_length3;
	_tmp1_ = _tmp0_[(((row * _tmp0__length2) + column) * _tmp0__length3) + (digit - 1)];
	result = _tmp1_;
	return result;
}

gboolean
sudoku_board_is_possible (SudokuBoard* self,
                          gint row,
                          gint col,
                          gint val)
{
	gint _tmp0_;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean* _tmp3_;
	gint _tmp3__length1;
	gint _tmp3__length2;
	gboolean _tmp4_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = val;
	val = _tmp0_ - 1;
	_tmp3_ = self->priv->possible_in_row;
	_tmp3__length1 = self->priv->possible_in_row_length1;
	_tmp3__length2 = self->priv->possible_in_row_length2;
	_tmp4_ = _tmp3_[(row * _tmp3__length2) + val];
	if (_tmp4_) {
		gboolean* _tmp5_;
		gint _tmp5__length1;
		gint _tmp5__length2;
		gboolean _tmp6_;
		_tmp5_ = self->priv->possible_in_col;
		_tmp5__length1 = self->priv->possible_in_col_length1;
		_tmp5__length2 = self->priv->possible_in_col_length2;
		_tmp6_ = _tmp5_[(col * _tmp5__length2) + val];
		_tmp2_ = _tmp6_;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		gboolean* _tmp7_;
		gint _tmp7__length1;
		gint _tmp7__length2;
		gint _tmp7__length3;
		gint _tmp8_;
		gint _tmp9_;
		gboolean _tmp10_;
		_tmp7_ = self->priv->possible_in_block;
		_tmp7__length1 = self->priv->possible_in_block_length1;
		_tmp7__length2 = self->priv->possible_in_block_length2;
		_tmp7__length3 = self->priv->possible_in_block_length3;
		_tmp8_ = self->priv->_block_cols;
		_tmp9_ = self->priv->_block_rows;
		_tmp10_ = _tmp7_[((((row / _tmp8_) * _tmp7__length2) + (col / _tmp9_)) * _tmp7__length3) + val];
		_tmp1_ = _tmp10_;
	} else {
		_tmp1_ = FALSE;
	}
	result = _tmp1_;
	return result;
}

gint
sudoku_board_count_possibilities (SudokuBoard* self,
                                  gint row,
                                  gint col)
{
	gint _tmp0_ = 0;
	gint* _tmp1_;
	gint* _tmp2_;
	gint _tmp2__length1;
	gint _tmp3_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp1_ = sudoku_board_get_possibilities (self, row, col, &_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp2__length1 = _tmp0_;
	_tmp3_ = _tmp0_;
	_tmp2_ = (g_free (_tmp2_), NULL);
	result = _tmp3_;
	return result;
}

static gint*
_vala_array_dup8 (gint* self,
                  gssize length)
{
	if (length > 0) {
		return _vala_memdup2 (self, length * sizeof (gint));
	}
	return NULL;
}

gint*
sudoku_board_get_possibilities (SudokuBoard* self,
                                gint row,
                                gint col,
                                gint* result_length1)
{
	gint* _tmp0_;
	gint _tmp0__length1;
	gint _tmp0__length2;
	gint _tmp1_;
	gint* possibilities = NULL;
	gint* _tmp4_;
	gint possibilities_length1;
	gint _possibilities_size_;
	gint count = 0;
	gint* _tmp11_;
	gint _tmp11__length1;
	gint* _tmp12_;
	gint _tmp12__length1;
	gint* _tmp13_;
	gint _tmp13__length1;
	gint* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->cells;
	_tmp0__length1 = self->cells_length1;
	_tmp0__length2 = self->cells_length2;
	_tmp1_ = _tmp0_[(row * _tmp0__length2) + col];
	if (_tmp1_ != 0) {
		gint* _tmp2_;
		gint* _tmp3_;
		gint _tmp3__length1;
		_tmp2_ = g_new0 (gint, 0);
		_tmp3_ = _tmp2_;
		_tmp3__length1 = 0;
		if (result_length1) {
			*result_length1 = _tmp3__length1;
		}
		result = _tmp3_;
		return result;
	}
	_tmp4_ = g_new0 (gint, 9);
	possibilities = _tmp4_;
	possibilities_length1 = 9;
	_possibilities_size_ = possibilities_length1;
	count = 0;
	{
		gint l = 0;
		l = 1;
		{
			gboolean _tmp5_ = FALSE;
			_tmp5_ = TRUE;
			while (TRUE) {
				gint _tmp7_;
				gint _tmp8_;
				if (!_tmp5_) {
					gint _tmp6_;
					_tmp6_ = l;
					l = _tmp6_ + 1;
				}
				_tmp5_ = FALSE;
				_tmp7_ = sudoku_board_get_max_val (self);
				_tmp8_ = _tmp7_;
				if (!(l <= _tmp8_)) {
					break;
				}
				if (sudoku_board_is_possible (self, row, col, l)) {
					gint* _tmp9_;
					gint _tmp9__length1;
					gint _tmp10_;
					_tmp9_ = possibilities;
					_tmp9__length1 = possibilities_length1;
					_tmp9_[count] = l;
					_tmp10_ = count;
					count = _tmp10_ + 1;
				}
			}
		}
	}
	_tmp11_ = possibilities;
	_tmp11__length1 = possibilities_length1;
	_tmp12_ = (_tmp11_ != NULL) ? _vala_array_dup8 (_tmp11_ + 0, count - 0) : _tmp11_;
	_tmp12__length1 = count - 0;
	_tmp13_ = _tmp12_;
	_tmp13__length1 = _tmp12__length1;
	if (result_length1) {
		*result_length1 = _tmp13__length1;
	}
	result = _tmp13_;
	possibilities = (g_free (possibilities), NULL);
	return result;
}

gboolean*
sudoku_board_get_possibilities_as_bool_array (SudokuBoard* self,
                                              gint row,
                                              gint col,
                                              gint* result_length1)
{
	gboolean* possibilities = NULL;
	gint _tmp0_;
	gint _tmp1_;
	gboolean* _tmp2_;
	gint possibilities_length1;
	gint _possibilities_size_;
	gboolean* _tmp8_;
	gint _tmp8__length1;
	gboolean* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = sudoku_board_get_max_val (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_new0 (gboolean, _tmp1_);
	possibilities = _tmp2_;
	possibilities_length1 = _tmp1_;
	_possibilities_size_ = possibilities_length1;
	{
		gint l = 0;
		l = 1;
		{
			gboolean _tmp3_ = FALSE;
			_tmp3_ = TRUE;
			while (TRUE) {
				gint _tmp5_;
				gint _tmp6_;
				gboolean* _tmp7_;
				gint _tmp7__length1;
				if (!_tmp3_) {
					gint _tmp4_;
					_tmp4_ = l;
					l = _tmp4_ + 1;
				}
				_tmp3_ = FALSE;
				_tmp5_ = sudoku_board_get_max_val (self);
				_tmp6_ = _tmp5_;
				if (!(l <= _tmp6_)) {
					break;
				}
				_tmp7_ = possibilities;
				_tmp7__length1 = possibilities_length1;
				_tmp7_[l - 1] = sudoku_board_is_possible (self, row, col, l);
			}
		}
	}
	_tmp8_ = possibilities;
	_tmp8__length1 = possibilities_length1;
	if (result_length1) {
		*result_length1 = _tmp8__length1;
	}
	result = _tmp8_;
	return result;
}

void
sudoku_board_get_block_for (SudokuBoard* self,
                            gint row,
                            gint col,
                            Coord* result)
{
	gint _tmp0_;
	gint _tmp1_;
	Coord _tmp2_ = {0};
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_block_rows;
	_tmp1_ = self->priv->_block_cols;
	coord_init (&_tmp2_, row / _tmp0_, col / _tmp1_);
	*result = _tmp2_;
	return;
}

void
sudoku_board_insert (SudokuBoard* self,
                     gint row,
                     gint col,
                     gint val,
                     gboolean is_fixed)
{
	gint _tmp0_;
	gint _tmp1_;
	gint* _tmp4_;
	gint _tmp4__length1;
	gint _tmp4__length2;
	gint _tmp5_;
	gint* _tmp6_;
	gint _tmp6__length1;
	gint _tmp6__length2;
	gboolean* _tmp7_;
	gint _tmp7__length1;
	gint _tmp7__length2;
	gint _tmp8_;
	gboolean* _tmp10_;
	gint _tmp10__length1;
	gint _tmp10__length2;
	gboolean _tmp11_;
	gboolean* _tmp15_;
	gint _tmp15__length1;
	gint _tmp15__length2;
	gboolean _tmp16_;
	gboolean* _tmp20_;
	gint _tmp20__length1;
	gint _tmp20__length2;
	gint _tmp20__length3;
	gint _tmp21_;
	gint _tmp22_;
	gboolean _tmp23_;
	gint _tmp30_;
	gboolean* _tmp31_;
	gint _tmp31__length1;
	gint _tmp31__length2;
	gboolean* _tmp32_;
	gint _tmp32__length1;
	gint _tmp32__length2;
	gboolean* _tmp33_;
	gint _tmp33__length1;
	gint _tmp33__length2;
	gint _tmp33__length3;
	gint _tmp34_;
	gint _tmp35_;
	gboolean _tmp36_;
	gboolean _tmp37_;
	g_return_if_fail (self != NULL);
	_vala_assert (val > 0, "val > 0");
	_tmp0_ = sudoku_board_get_max_val (self);
	_tmp1_ = _tmp0_;
	_vala_assert (val <= _tmp1_, "val <= max_val");
	if (!is_fixed) {
		gboolean* _tmp2_;
		gint _tmp2__length1;
		gint _tmp2__length2;
		gboolean _tmp3_;
		_tmp2_ = self->is_fixed;
		_tmp2__length1 = self->is_fixed_length1;
		_tmp2__length2 = self->is_fixed_length2;
		_tmp3_ = _tmp2_[(row * _tmp2__length2) + col];
		_vala_assert (!_tmp3_, "!this.is_fixed[row, col]");
	}
	_tmp4_ = self->cells;
	_tmp4__length1 = self->cells_length1;
	_tmp4__length2 = self->cells_length2;
	_tmp5_ = _tmp4_[(row * _tmp4__length2) + col];
	if (_tmp5_ != 0) {
		sudoku_board_remove (self, row, col, is_fixed);
	}
	_tmp6_ = self->cells;
	_tmp6__length1 = self->cells_length1;
	_tmp6__length2 = self->cells_length2;
	_tmp6_[(row * _tmp6__length2) + col] = val;
	_tmp7_ = self->is_fixed;
	_tmp7__length1 = self->is_fixed_length1;
	_tmp7__length2 = self->is_fixed_length2;
	_tmp7_[(row * _tmp7__length2) + col] = is_fixed;
	_tmp8_ = self->priv->_filled;
	sudoku_board_set_filled (self, _tmp8_ + 1);
	if (is_fixed) {
		gint _tmp9_;
		_tmp9_ = self->priv->_fixed;
		sudoku_board_set_fixed (self, _tmp9_ + 1);
	}
	_tmp10_ = self->priv->possible_in_row;
	_tmp10__length1 = self->priv->possible_in_row_length1;
	_tmp10__length2 = self->priv->possible_in_row_length2;
	_tmp11_ = _tmp10_[(row * _tmp10__length2) + (val - 1)];
	if (!_tmp11_) {
		GeeList* _tmp12_;
		gpointer _tmp13_;
		GeeList* _tmp14_;
		_tmp12_ = self->coords_for_row;
		_tmp13_ = gee_list_get (_tmp12_, row);
		_tmp14_ = (GeeList*) _tmp13_;
		sudoku_board_mark_breakages_for (self, _tmp14_, val);
		_g_object_unref0 (_tmp14_);
	}
	_tmp15_ = self->priv->possible_in_col;
	_tmp15__length1 = self->priv->possible_in_col_length1;
	_tmp15__length2 = self->priv->possible_in_col_length2;
	_tmp16_ = _tmp15_[(col * _tmp15__length2) + (val - 1)];
	if (!_tmp16_) {
		GeeList* _tmp17_;
		gpointer _tmp18_;
		GeeList* _tmp19_;
		_tmp17_ = self->coords_for_col;
		_tmp18_ = gee_list_get (_tmp17_, col);
		_tmp19_ = (GeeList*) _tmp18_;
		sudoku_board_mark_breakages_for (self, _tmp19_, val);
		_g_object_unref0 (_tmp19_);
	}
	_tmp20_ = self->priv->possible_in_block;
	_tmp20__length1 = self->priv->possible_in_block_length1;
	_tmp20__length2 = self->priv->possible_in_block_length2;
	_tmp20__length3 = self->priv->possible_in_block_length3;
	_tmp21_ = self->priv->_block_cols;
	_tmp22_ = self->priv->_block_rows;
	_tmp23_ = _tmp20_[((((row / _tmp21_) * _tmp20__length2) + (col / _tmp22_)) * _tmp20__length3) + (val - 1)];
	if (!_tmp23_) {
		GeeMap* _tmp24_;
		gint _tmp25_;
		gint _tmp26_;
		Coord _tmp27_ = {0};
		gpointer _tmp28_;
		GeeList* _tmp29_;
		_tmp24_ = self->coords_for_block;
		_tmp25_ = self->priv->_block_cols;
		_tmp26_ = self->priv->_block_rows;
		coord_init (&_tmp27_, row / _tmp25_, col / _tmp26_);
		_tmp28_ = gee_map_get (_tmp24_, &_tmp27_);
		_tmp29_ = (GeeList*) _tmp28_;
		sudoku_board_mark_breakages_for (self, _tmp29_, val);
		_g_object_unref0 (_tmp29_);
	}
	_tmp30_ = val;
	val = _tmp30_ - 1;
	_tmp31_ = self->priv->possible_in_row;
	_tmp31__length1 = self->priv->possible_in_row_length1;
	_tmp31__length2 = self->priv->possible_in_row_length2;
	_tmp31_[(row * _tmp31__length2) + val] = FALSE;
	_tmp32_ = self->priv->possible_in_col;
	_tmp32__length1 = self->priv->possible_in_col_length1;
	_tmp32__length2 = self->priv->possible_in_col_length2;
	_tmp32_[(col * _tmp32__length2) + val] = FALSE;
	_tmp33_ = self->priv->possible_in_block;
	_tmp33__length1 = self->priv->possible_in_block_length1;
	_tmp33__length2 = self->priv->possible_in_block_length2;
	_tmp33__length3 = self->priv->possible_in_block_length3;
	_tmp34_ = self->priv->_block_cols;
	_tmp35_ = self->priv->_block_rows;
	_tmp33_[((((row / _tmp34_) * _tmp33__length2) + (col / _tmp35_)) * _tmp33__length3) + val] = FALSE;
	_tmp36_ = sudoku_board_get_complete (self);
	_tmp37_ = _tmp36_;
	if (_tmp37_) {
		g_signal_emit (self, sudoku_board_signals[SUDOKU_BOARD_COMPLETED_SIGNAL], 0);
	}
}

void
sudoku_board_set (SudokuBoard* self,
                  gint row,
                  gint col,
                  gint val)
{
	g_return_if_fail (self != NULL);
	if (val == 0) {
		sudoku_board_remove (self, row, col, FALSE);
	} else {
		gboolean _tmp0_ = FALSE;
		if (val > 0) {
			gint _tmp1_;
			gint _tmp2_;
			_tmp1_ = sudoku_board_get_max_val (self);
			_tmp2_ = _tmp1_;
			_tmp0_ = val <= _tmp2_;
		} else {
			_tmp0_ = FALSE;
		}
		if (_tmp0_) {
			sudoku_board_insert (self, row, col, val, FALSE);
		} else {
			g_assert_not_reached ();
		}
	}
}

gint
sudoku_board_get (SudokuBoard* self,
                  gint row,
                  gint col)
{
	gint* _tmp0_;
	gint _tmp0__length1;
	gint _tmp0__length2;
	gint _tmp1_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->cells;
	_tmp0__length1 = self->cells_length1;
	_tmp0__length2 = self->cells_length2;
	_tmp1_ = _tmp0_[(row * _tmp0__length2) + col];
	result = _tmp1_;
	return result;
}

void
sudoku_board_remove (SudokuBoard* self,
                     gint row,
                     gint col,
                     gboolean is_fixed)
{
	gint* _tmp0_;
	gint _tmp0__length1;
	gint _tmp0__length2;
	gint _tmp1_;
	gint previous_val = 0;
	gint* _tmp4_;
	gint _tmp4__length1;
	gint _tmp4__length2;
	gint _tmp5_;
	gint* _tmp6_;
	gint _tmp6__length1;
	gint _tmp6__length2;
	GeeSet* _tmp7_;
	Coord _tmp8_ = {0};
	gint _tmp70_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->cells;
	_tmp0__length1 = self->cells_length1;
	_tmp0__length2 = self->cells_length2;
	_tmp1_ = _tmp0_[(row * _tmp0__length2) + col];
	if (_tmp1_ == 0) {
		return;
	}
	if (!is_fixed) {
		gboolean* _tmp2_;
		gint _tmp2__length1;
		gint _tmp2__length2;
		gboolean _tmp3_;
		_tmp2_ = self->is_fixed;
		_tmp2__length1 = self->is_fixed_length1;
		_tmp2__length2 = self->is_fixed_length2;
		_tmp3_ = _tmp2_[(row * _tmp2__length2) + col];
		_vala_assert (!_tmp3_, "!this.is_fixed[row, col]");
	}
	_tmp4_ = self->cells;
	_tmp4__length1 = self->cells_length1;
	_tmp4__length2 = self->cells_length2;
	_tmp5_ = _tmp4_[(row * _tmp4__length2) + col];
	previous_val = _tmp5_;
	_tmp6_ = self->cells;
	_tmp6__length1 = self->cells_length1;
	_tmp6__length2 = self->cells_length2;
	_tmp6_[(row * _tmp6__length2) + col] = 0;
	_tmp7_ = self->broken_coords;
	coord_init (&_tmp8_, row, col);
	if (gee_collection_contains ((GeeCollection*) _tmp7_, &_tmp8_)) {
		GeeList* _tmp9_;
		gpointer _tmp10_;
		GeeList* _tmp11_;
		GeeList* _tmp12_;
		gpointer _tmp13_;
		GeeList* _tmp14_;
		GeeMap* _tmp15_;
		gint _tmp16_;
		gint _tmp17_;
		Coord _tmp18_ = {0};
		gpointer _tmp19_;
		GeeList* _tmp20_;
		GeeSet* _tmp21_;
		Coord _tmp22_ = {0};
		GeeList* _tmp23_;
		gpointer _tmp24_;
		GeeList* _tmp25_;
		GeeList* _tmp26_;
		gpointer _tmp27_;
		GeeList* _tmp28_;
		GeeMap* _tmp29_;
		gint _tmp30_;
		gint _tmp31_;
		Coord _tmp32_ = {0};
		gpointer _tmp33_;
		GeeList* _tmp34_;
		gboolean* _tmp35_;
		gint _tmp35__length1;
		gint _tmp35__length2;
		GeeList* _tmp36_;
		gpointer _tmp37_;
		GeeList* _tmp38_;
		GeeSet* _tmp39_;
		GeeSet* _tmp40_;
		gint _tmp41_;
		gint _tmp42_;
		gboolean* _tmp43_;
		gint _tmp43__length1;
		gint _tmp43__length2;
		GeeList* _tmp44_;
		gpointer _tmp45_;
		GeeList* _tmp46_;
		GeeSet* _tmp47_;
		GeeSet* _tmp48_;
		gint _tmp49_;
		gint _tmp50_;
		gboolean* _tmp51_;
		gint _tmp51__length1;
		gint _tmp51__length2;
		gint _tmp51__length3;
		gint _tmp52_;
		gint _tmp53_;
		GeeMap* _tmp54_;
		gint _tmp55_;
		gint _tmp56_;
		Coord _tmp57_ = {0};
		gpointer _tmp58_;
		GeeList* _tmp59_;
		GeeSet* _tmp60_;
		GeeSet* _tmp61_;
		gint _tmp62_;
		gint _tmp63_;
		_tmp9_ = self->coords_for_row;
		_tmp10_ = gee_list_get (_tmp9_, row);
		_tmp11_ = (GeeList*) _tmp10_;
		sudoku_board_remove_breakages_for (self, _tmp11_, previous_val);
		_g_object_unref0 (_tmp11_);
		_tmp12_ = self->coords_for_col;
		_tmp13_ = gee_list_get (_tmp12_, col);
		_tmp14_ = (GeeList*) _tmp13_;
		sudoku_board_remove_breakages_for (self, _tmp14_, previous_val);
		_g_object_unref0 (_tmp14_);
		_tmp15_ = self->coords_for_block;
		_tmp16_ = self->priv->_block_rows;
		_tmp17_ = self->priv->_block_cols;
		coord_init (&_tmp18_, row / _tmp16_, col / _tmp17_);
		_tmp19_ = gee_map_get (_tmp15_, &_tmp18_);
		_tmp20_ = (GeeList*) _tmp19_;
		sudoku_board_remove_breakages_for (self, _tmp20_, previous_val);
		_g_object_unref0 (_tmp20_);
		_tmp21_ = self->broken_coords;
		coord_init (&_tmp22_, row, col);
		gee_collection_remove ((GeeCollection*) _tmp21_, &_tmp22_);
		_tmp23_ = self->coords_for_row;
		_tmp24_ = gee_list_get (_tmp23_, row);
		_tmp25_ = (GeeList*) _tmp24_;
		sudoku_board_mark_breakages_for (self, _tmp25_, previous_val);
		_g_object_unref0 (_tmp25_);
		_tmp26_ = self->coords_for_col;
		_tmp27_ = gee_list_get (_tmp26_, col);
		_tmp28_ = (GeeList*) _tmp27_;
		sudoku_board_mark_breakages_for (self, _tmp28_, previous_val);
		_g_object_unref0 (_tmp28_);
		_tmp29_ = self->coords_for_block;
		_tmp30_ = self->priv->_block_rows;
		_tmp31_ = self->priv->_block_cols;
		coord_init (&_tmp32_, row / _tmp30_, col / _tmp31_);
		_tmp33_ = gee_map_get (_tmp29_, &_tmp32_);
		_tmp34_ = (GeeList*) _tmp33_;
		sudoku_board_mark_breakages_for (self, _tmp34_, previous_val);
		_g_object_unref0 (_tmp34_);
		_tmp35_ = self->priv->possible_in_row;
		_tmp35__length1 = self->priv->possible_in_row_length1;
		_tmp35__length2 = self->priv->possible_in_row_length2;
		_tmp36_ = self->coords_for_row;
		_tmp37_ = gee_list_get (_tmp36_, row);
		_tmp38_ = (GeeList*) _tmp37_;
		_tmp39_ = sudoku_board_get_occurances (self, _tmp38_, previous_val);
		_tmp40_ = _tmp39_;
		_tmp41_ = gee_collection_get_size ((GeeCollection*) _tmp40_);
		_tmp42_ = _tmp41_;
		_tmp35_[(row * _tmp35__length2) + (previous_val - 1)] = _tmp42_ == 0;
		_g_object_unref0 (_tmp40_);
		_g_object_unref0 (_tmp38_);
		_tmp43_ = self->priv->possible_in_col;
		_tmp43__length1 = self->priv->possible_in_col_length1;
		_tmp43__length2 = self->priv->possible_in_col_length2;
		_tmp44_ = self->coords_for_col;
		_tmp45_ = gee_list_get (_tmp44_, col);
		_tmp46_ = (GeeList*) _tmp45_;
		_tmp47_ = sudoku_board_get_occurances (self, _tmp46_, previous_val);
		_tmp48_ = _tmp47_;
		_tmp49_ = gee_collection_get_size ((GeeCollection*) _tmp48_);
		_tmp50_ = _tmp49_;
		_tmp43_[(col * _tmp43__length2) + (previous_val - 1)] = _tmp50_ == 0;
		_g_object_unref0 (_tmp48_);
		_g_object_unref0 (_tmp46_);
		_tmp51_ = self->priv->possible_in_block;
		_tmp51__length1 = self->priv->possible_in_block_length1;
		_tmp51__length2 = self->priv->possible_in_block_length2;
		_tmp51__length3 = self->priv->possible_in_block_length3;
		_tmp52_ = self->priv->_block_cols;
		_tmp53_ = self->priv->_block_rows;
		_tmp54_ = self->coords_for_block;
		_tmp55_ = self->priv->_block_rows;
		_tmp56_ = self->priv->_block_cols;
		coord_init (&_tmp57_, row / _tmp55_, col / _tmp56_);
		_tmp58_ = gee_map_get (_tmp54_, &_tmp57_);
		_tmp59_ = (GeeList*) _tmp58_;
		_tmp60_ = sudoku_board_get_occurances (self, _tmp59_, previous_val);
		_tmp61_ = _tmp60_;
		_tmp62_ = gee_collection_get_size ((GeeCollection*) _tmp61_);
		_tmp63_ = _tmp62_;
		_tmp51_[((((row / _tmp52_) * _tmp51__length2) + (col / _tmp53_)) * _tmp51__length3) + (previous_val - 1)] = _tmp63_ == 0;
		_g_object_unref0 (_tmp61_);
		_g_object_unref0 (_tmp59_);
	} else {
		gint _tmp64_;
		gboolean* _tmp65_;
		gint _tmp65__length1;
		gint _tmp65__length2;
		gboolean* _tmp66_;
		gint _tmp66__length1;
		gint _tmp66__length2;
		gboolean* _tmp67_;
		gint _tmp67__length1;
		gint _tmp67__length2;
		gint _tmp67__length3;
		gint _tmp68_;
		gint _tmp69_;
		_tmp64_ = previous_val;
		previous_val = _tmp64_ - 1;
		_tmp65_ = self->priv->possible_in_row;
		_tmp65__length1 = self->priv->possible_in_row_length1;
		_tmp65__length2 = self->priv->possible_in_row_length2;
		_tmp65_[(row * _tmp65__length2) + previous_val] = TRUE;
		_tmp66_ = self->priv->possible_in_col;
		_tmp66__length1 = self->priv->possible_in_col_length1;
		_tmp66__length2 = self->priv->possible_in_col_length2;
		_tmp66_[(col * _tmp66__length2) + previous_val] = TRUE;
		_tmp67_ = self->priv->possible_in_block;
		_tmp67__length1 = self->priv->possible_in_block_length1;
		_tmp67__length2 = self->priv->possible_in_block_length2;
		_tmp67__length3 = self->priv->possible_in_block_length3;
		_tmp68_ = self->priv->_block_cols;
		_tmp69_ = self->priv->_block_rows;
		_tmp67_[((((row / _tmp68_) * _tmp67__length2) + (col / _tmp69_)) * _tmp67__length3) + previous_val] = TRUE;
	}
	_tmp70_ = self->priv->_filled;
	sudoku_board_set_filled (self, _tmp70_ - 1);
	if (is_fixed) {
		gint _tmp71_;
		_tmp71_ = self->priv->_fixed;
		sudoku_board_set_fixed (self, _tmp71_ - 1);
	}
}

void
sudoku_board_set_solution (SudokuBoard* self,
                           gint row,
                           gint col,
                           gint val)
{
	gint* _tmp0_;
	gint _tmp0__length1;
	gint _tmp0__length2;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->solution;
	_tmp0__length1 = self->solution_length1;
	_tmp0__length2 = self->solution_length2;
	_tmp0_[(row * _tmp0__length2) + col] = val;
}

gint
sudoku_board_get_solution (SudokuBoard* self,
                           gint row,
                           gint col)
{
	gint* _tmp0_;
	gint _tmp0__length1;
	gint _tmp0__length2;
	gint _tmp1_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->solution;
	_tmp0__length1 = self->solution_length1;
	_tmp0__length2 = self->solution_length2;
	_tmp1_ = _tmp0_[(row * _tmp0__length2) + col];
	result = _tmp1_;
	return result;
}

void
sudoku_board_solve (SudokuBoard* self)
{
	gint* solution_1d = NULL;
	gint* _tmp0_;
	gint _tmp0__length1;
	gint _tmp0__length2;
	gint _tmp1_ = 0;
	gint* _tmp2_;
	gint solution_1d_length1;
	gint _solution_1d_size_;
	gint* _tmp3_;
	gint _tmp3__length1;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->cells;
	_tmp0__length1 = self->cells_length1;
	_tmp0__length2 = self->cells_length2;
	_tmp2_ = sudoku_board_convert_2d_to_1d (self, _tmp0_, (gint) _tmp0__length1, (gint) _tmp0__length2, &_tmp1_);
	solution_1d = _tmp2_;
	solution_1d_length1 = _tmp1_;
	_solution_1d_size_ = solution_1d_length1;
	_tmp3_ = solution_1d;
	_tmp3__length1 = solution_1d_length1;
	if (qqwing_solve_puzzle (_tmp3_)) {
		gint* _tmp4_;
		gint _tmp4__length1;
		gint _tmp5_ = 0;
		gint _tmp6_ = 0;
		gint* _tmp7_;
		_tmp4_ = solution_1d;
		_tmp4__length1 = solution_1d_length1;
		_tmp7_ = sudoku_board_convert_1d_to_2d (self, _tmp4_, (gint) _tmp4__length1, &_tmp5_, &_tmp6_);
		self->solution = (g_free (self->solution), NULL);
		self->solution = _tmp7_;
		self->solution_length1 = _tmp5_;
		self->solution_length2 = _tmp6_;
	} else {
		self->solution = (g_free (self->solution), NULL);
		self->solution = NULL;
		self->solution_length1 = 0;
		self->solution_length2 = 0;
	}
	solution_1d = (g_free (solution_1d), NULL);
}

gboolean
sudoku_board_solved (SudokuBoard* self)
{
	gint* _tmp0_;
	gint _tmp0__length1;
	gint _tmp0__length2;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->solution;
	_tmp0__length1 = self->solution_length1;
	_tmp0__length2 = self->solution_length2;
	result = _tmp0_ != NULL;
	return result;
}

gint
sudoku_board_count_solutions_limited (SudokuBoard* self)
{
	gint* cells_1d = NULL;
	gint* _tmp0_;
	gint _tmp0__length1;
	gint _tmp0__length2;
	gint _tmp1_ = 0;
	gint* _tmp2_;
	gint cells_1d_length1;
	gint _cells_1d_size_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->cells;
	_tmp0__length1 = self->cells_length1;
	_tmp0__length2 = self->cells_length2;
	_tmp2_ = sudoku_board_convert_2d_to_1d (self, _tmp0_, (gint) _tmp0__length1, (gint) _tmp0__length2, &_tmp1_);
	cells_1d = _tmp2_;
	cells_1d_length1 = _tmp1_;
	_cells_1d_size_ = cells_1d_length1;
	result = qqwing_count_solutions_limited (cells_1d);
	cells_1d = (g_free (cells_1d), NULL);
	return result;
}

GeeSet*
sudoku_board_get_occurances (SudokuBoard* self,
                             GeeList* coords,
                             gint val)
{
	GeeSet* occurances = NULL;
	GeeHashSet* _tmp0_;
	GeeSet* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (coords != NULL, NULL);
	_tmp0_ = gee_hash_set_new (TYPE_COORD, (GBoxedCopyFunc) coord_dup, (GDestroyNotify) coord_free, (GeeHashDataFunc) coord_hash, NULL, NULL, (GeeEqualDataFunc) coord_equal, NULL, NULL);
	occurances = (GeeSet*) _tmp0_;
	{
		GeeList* _coord_list = NULL;
		gint _coord_size = 0;
		GeeList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _coord_index = 0;
		_coord_list = coords;
		_tmp1_ = _coord_list;
		_tmp2_ = gee_collection_get_size ((GeeCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_coord_size = _tmp3_;
		_coord_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			Coord coord = {0};
			GeeList* _tmp6_;
			gpointer _tmp7_;
			Coord* _tmp8_;
			Coord _tmp9_;
			gint* _tmp10_;
			gint _tmp10__length1;
			gint _tmp10__length2;
			Coord _tmp11_;
			Coord _tmp12_;
			gint _tmp13_;
			_coord_index = _coord_index + 1;
			_tmp4_ = _coord_index;
			_tmp5_ = _coord_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _coord_list;
			_tmp7_ = gee_list_get (_tmp6_, _coord_index);
			_tmp8_ = (Coord*) _tmp7_;
			_tmp9_ = *_tmp8_;
			_coord_free0 (_tmp8_);
			coord = _tmp9_;
			_tmp10_ = self->cells;
			_tmp10__length1 = self->cells_length1;
			_tmp10__length2 = self->cells_length2;
			_tmp11_ = coord;
			_tmp12_ = coord;
			_tmp13_ = _tmp10_[(_tmp11_.row * _tmp10__length2) + _tmp12_.col];
			if (_tmp13_ == val) {
				GeeSet* _tmp14_;
				Coord _tmp15_;
				_tmp14_ = occurances;
				_tmp15_ = coord;
				gee_collection_add ((GeeCollection*) _tmp14_, &_tmp15_);
			}
		}
	}
	result = occurances;
	return result;
}

gboolean
sudoku_board_row_contains (SudokuBoard* self,
                           gint row,
                           gint val)
{
	GeeList* _tmp0_;
	gpointer _tmp1_;
	GeeList* _tmp2_;
	GeeSet* _tmp3_;
	GeeSet* _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	gboolean _tmp7_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->coords_for_row;
	_tmp1_ = gee_list_get (_tmp0_, row);
	_tmp2_ = (GeeList*) _tmp1_;
	_tmp3_ = sudoku_board_get_occurances (self, _tmp2_, val);
	_tmp4_ = _tmp3_;
	_tmp5_ = gee_collection_get_size ((GeeCollection*) _tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = _tmp6_ != 0;
	_g_object_unref0 (_tmp4_);
	_g_object_unref0 (_tmp2_);
	result = _tmp7_;
	return result;
}

gboolean
sudoku_board_col_contains (SudokuBoard* self,
                           gint col,
                           gint val)
{
	GeeList* _tmp0_;
	gpointer _tmp1_;
	GeeList* _tmp2_;
	GeeSet* _tmp3_;
	GeeSet* _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	gboolean _tmp7_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->coords_for_col;
	_tmp1_ = gee_list_get (_tmp0_, col);
	_tmp2_ = (GeeList*) _tmp1_;
	_tmp3_ = sudoku_board_get_occurances (self, _tmp2_, val);
	_tmp4_ = _tmp3_;
	_tmp5_ = gee_collection_get_size ((GeeCollection*) _tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = _tmp6_ != 0;
	_g_object_unref0 (_tmp4_);
	_g_object_unref0 (_tmp2_);
	result = _tmp7_;
	return result;
}

gboolean
sudoku_board_block_contains (SudokuBoard* self,
                             Coord* block,
                             gint val)
{
	GeeMap* _tmp0_;
	Coord _tmp1_;
	gpointer _tmp2_;
	GeeList* _tmp3_;
	GeeSet* _tmp4_;
	GeeSet* _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	gboolean _tmp8_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (block != NULL, FALSE);
	_tmp0_ = self->coords_for_block;
	_tmp1_ = *block;
	_tmp2_ = gee_map_get (_tmp0_, &_tmp1_);
	_tmp3_ = (GeeList*) _tmp2_;
	_tmp4_ = sudoku_board_get_occurances (self, _tmp3_, val);
	_tmp5_ = _tmp4_;
	_tmp6_ = gee_collection_get_size ((GeeCollection*) _tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = _tmp7_ != 0;
	_g_object_unref0 (_tmp5_);
	_g_object_unref0 (_tmp3_);
	result = _tmp8_;
	return result;
}

static void
sudoku_board_remove_breakages_for (SudokuBoard* self,
                                   GeeList* coords,
                                   gint val)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (coords != NULL);
	{
		GeeList* _coord_list = NULL;
		gint _coord_size = 0;
		GeeList* _tmp0_;
		gint _tmp1_;
		gint _tmp2_;
		gint _coord_index = 0;
		_coord_list = coords;
		_tmp0_ = _coord_list;
		_tmp1_ = gee_collection_get_size ((GeeCollection*) _tmp0_);
		_tmp2_ = _tmp1_;
		_coord_size = _tmp2_;
		_coord_index = -1;
		while (TRUE) {
			gint _tmp3_;
			gint _tmp4_;
			Coord coord = {0};
			GeeList* _tmp5_;
			gpointer _tmp6_;
			Coord* _tmp7_;
			Coord _tmp8_;
			gboolean _tmp9_ = FALSE;
			gint* _tmp10_;
			gint _tmp10__length1;
			gint _tmp10__length2;
			Coord _tmp11_;
			Coord _tmp12_;
			gint _tmp13_;
			_coord_index = _coord_index + 1;
			_tmp3_ = _coord_index;
			_tmp4_ = _coord_size;
			if (!(_tmp3_ < _tmp4_)) {
				break;
			}
			_tmp5_ = _coord_list;
			_tmp6_ = gee_list_get (_tmp5_, _coord_index);
			_tmp7_ = (Coord*) _tmp6_;
			_tmp8_ = *_tmp7_;
			_coord_free0 (_tmp7_);
			coord = _tmp8_;
			_tmp10_ = self->cells;
			_tmp10__length1 = self->cells_length1;
			_tmp10__length2 = self->cells_length2;
			_tmp11_ = coord;
			_tmp12_ = coord;
			_tmp13_ = _tmp10_[(_tmp11_.row * _tmp10__length2) + _tmp12_.col];
			if (_tmp13_ == val) {
				GeeSet* _tmp14_;
				Coord _tmp15_;
				_tmp14_ = self->broken_coords;
				_tmp15_ = coord;
				_tmp9_ = gee_collection_contains ((GeeCollection*) _tmp14_, &_tmp15_);
			} else {
				_tmp9_ = FALSE;
			}
			if (_tmp9_) {
				GeeSet* _tmp16_;
				Coord _tmp17_;
				_tmp16_ = self->broken_coords;
				_tmp17_ = coord;
				gee_collection_remove ((GeeCollection*) _tmp16_, &_tmp17_);
			}
		}
	}
}

static void
sudoku_board_mark_breakages_for (SudokuBoard* self,
                                 GeeList* coords,
                                 gint val)
{
	GeeSet* occurances = NULL;
	GeeSet* _tmp0_;
	GeeSet* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (coords != NULL);
	_tmp0_ = sudoku_board_get_occurances (self, coords, val);
	occurances = _tmp0_;
	_tmp1_ = occurances;
	_tmp2_ = gee_collection_get_size ((GeeCollection*) _tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ != 1) {
		GeeSet* _tmp4_;
		GeeSet* _tmp5_;
		_tmp4_ = self->broken_coords;
		_tmp5_ = occurances;
		gee_collection_add_all ((GeeCollection*) _tmp4_, (GeeCollection*) _tmp5_);
	}
	_g_object_unref0 (occurances);
}

void
sudoku_board_to_initial_state (SudokuBoard* self)
{
	g_return_if_fail (self != NULL);
	{
		gint l1 = 0;
		l1 = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = l1;
					l1 = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = self->priv->_rows;
				if (!(l1 < _tmp2_)) {
					break;
				}
				{
					gint l2 = 0;
					l2 = 0;
					{
						gboolean _tmp3_ = FALSE;
						_tmp3_ = TRUE;
						while (TRUE) {
							gint _tmp5_;
							gboolean* _tmp6_;
							gint _tmp6__length1;
							gint _tmp6__length2;
							gboolean _tmp7_;
							if (!_tmp3_) {
								gint _tmp4_;
								_tmp4_ = l2;
								l2 = _tmp4_ + 1;
							}
							_tmp3_ = FALSE;
							_tmp5_ = self->priv->_cols;
							if (!(l2 < _tmp5_)) {
								break;
							}
							_tmp6_ = self->is_fixed;
							_tmp6__length1 = self->is_fixed_length1;
							_tmp6__length2 = self->is_fixed_length2;
							_tmp7_ = _tmp6_[(l1 * _tmp6__length2) + l2];
							if (!_tmp7_) {
								sudoku_board_remove (self, l1, l2, FALSE);
							}
						}
					}
				}
			}
		}
	}
}

void
sudoku_board_print (SudokuBoard* self,
                    gint indent)
{
	FILE* _tmp14_;
	g_return_if_fail (self != NULL);
	{
		gint l1 = 0;
		l1 = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				FILE* _tmp13_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = l1;
					l1 = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				if (!(l1 < 9)) {
					break;
				}
				{
					gint i = 0;
					i = 0;
					{
						gboolean _tmp2_ = FALSE;
						_tmp2_ = TRUE;
						while (TRUE) {
							FILE* _tmp4_;
							if (!_tmp2_) {
								gint _tmp3_;
								_tmp3_ = i;
								i = _tmp3_ + 1;
							}
							_tmp2_ = FALSE;
							if (!(i < indent)) {
								break;
							}
							_tmp4_ = stdout;
							fprintf (_tmp4_, " ");
						}
					}
				}
				{
					gint l2 = 0;
					l2 = 0;
					{
						gboolean _tmp5_ = FALSE;
						_tmp5_ = TRUE;
						while (TRUE) {
							gint* _tmp7_;
							gint _tmp7__length1;
							gint _tmp7__length2;
							gint _tmp8_;
							if (!_tmp5_) {
								gint _tmp6_;
								_tmp6_ = l2;
								l2 = _tmp6_ + 1;
							}
							_tmp5_ = FALSE;
							if (!(l2 < 9)) {
								break;
							}
							_tmp7_ = self->cells;
							_tmp7__length1 = self->cells_length1;
							_tmp7__length2 = self->cells_length2;
							_tmp8_ = _tmp7_[(l1 * _tmp7__length2) + l2];
							if (_tmp8_ != 0) {
								FILE* _tmp9_;
								gint* _tmp10_;
								gint _tmp10__length1;
								gint _tmp10__length2;
								gint _tmp11_;
								_tmp9_ = stdout;
								_tmp10_ = self->cells;
								_tmp10__length1 = self->cells_length1;
								_tmp10__length2 = self->cells_length2;
								_tmp11_ = _tmp10_[(l1 * _tmp10__length2) + l2];
								fprintf (_tmp9_, "%d ", _tmp11_);
							} else {
								FILE* _tmp12_;
								_tmp12_ = stdout;
								fprintf (_tmp12_, "  ");
							}
						}
					}
				}
				_tmp13_ = stdout;
				fprintf (_tmp13_, "\n");
			}
		}
	}
	_tmp14_ = stdout;
	fflush (_tmp14_);
}

void
sudoku_board_get_string (SudokuBoard* self)
{
	FILE* _tmp0_;
	FILE* _tmp12_;
	g_return_if_fail (self != NULL);
	_tmp0_ = stdout;
	fprintf (_tmp0_, "[ ");
	{
		gint l1 = 0;
		l1 = 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				FILE* _tmp3_;
				FILE* _tmp10_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = l1;
					l1 = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				if (!(l1 < 9)) {
					break;
				}
				_tmp3_ = stdout;
				fprintf (_tmp3_, "[ ");
				{
					gint l2 = 0;
					l2 = 0;
					{
						gboolean _tmp4_ = FALSE;
						_tmp4_ = TRUE;
						while (TRUE) {
							FILE* _tmp6_;
							gint* _tmp7_;
							gint _tmp7__length1;
							gint _tmp7__length2;
							gint _tmp8_;
							if (!_tmp4_) {
								gint _tmp5_;
								_tmp5_ = l2;
								l2 = _tmp5_ + 1;
							}
							_tmp4_ = FALSE;
							if (!(l2 < 9)) {
								break;
							}
							_tmp6_ = stdout;
							_tmp7_ = self->cells;
							_tmp7__length1 = self->cells_length1;
							_tmp7__length2 = self->cells_length2;
							_tmp8_ = _tmp7_[(l1 * _tmp7__length2) + l2];
							fprintf (_tmp6_, "%d", _tmp8_);
							if (l2 != 8) {
								FILE* _tmp9_;
								_tmp9_ = stdout;
								fprintf (_tmp9_, ",");
							}
						}
					}
				}
				_tmp10_ = stdout;
				fprintf (_tmp10_, " ]");
				if (l1 != 8) {
					FILE* _tmp11_;
					_tmp11_ = stdout;
					fprintf (_tmp11_, ",");
				}
			}
		}
	}
	_tmp12_ = stdout;
	fprintf (_tmp12_, " ]");
}

gchar*
sudoku_board_to_string (SudokuBoard* self,
                        gboolean get_original_state)
{
	gchar* board_string = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup ("");
	board_string = _tmp0_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				gint _tmp3_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				_tmp3_ = self->priv->_rows;
				if (!(i < _tmp3_)) {
					break;
				}
				{
					gint j = 0;
					j = 0;
					{
						gboolean _tmp4_ = FALSE;
						_tmp4_ = TRUE;
						while (TRUE) {
							gint _tmp6_;
							gboolean* _tmp7_;
							gint _tmp7__length1;
							gint _tmp7__length2;
							gboolean _tmp8_;
							if (!_tmp4_) {
								gint _tmp5_;
								_tmp5_ = j;
								j = _tmp5_ + 1;
							}
							_tmp4_ = FALSE;
							_tmp6_ = self->priv->_cols;
							if (!(j < _tmp6_)) {
								break;
							}
							_tmp7_ = self->is_fixed;
							_tmp7__length1 = self->is_fixed_length1;
							_tmp7__length2 = self->is_fixed_length2;
							_tmp8_ = _tmp7_[(i * _tmp7__length2) + j];
							if (_tmp8_) {
								const gchar* _tmp9_;
								gint* _tmp10_;
								gint _tmp10__length1;
								gint _tmp10__length2;
								gint _tmp11_;
								gchar* _tmp12_;
								gchar* _tmp13_;
								gchar* _tmp14_;
								_tmp9_ = board_string;
								_tmp10_ = self->cells;
								_tmp10__length1 = self->cells_length1;
								_tmp10__length2 = self->cells_length2;
								_tmp11_ = _tmp10_[(i * _tmp10__length2) + j];
								_tmp12_ = g_strdup_printf ("%i", _tmp11_);
								_tmp13_ = _tmp12_;
								_tmp14_ = g_strconcat (_tmp9_, _tmp13_, NULL);
								_g_free0 (board_string);
								board_string = _tmp14_;
								_g_free0 (_tmp13_);
							} else {
								gchar* _tmp15_ = NULL;
								const gchar* _tmp20_;
								gchar* _tmp21_;
								if (get_original_state) {
									gchar* _tmp16_;
									_tmp16_ = g_strdup ("0");
									_g_free0 (_tmp15_);
									_tmp15_ = _tmp16_;
								} else {
									gint* _tmp17_;
									gint _tmp17__length1;
									gint _tmp17__length2;
									gint _tmp18_;
									gchar* _tmp19_;
									_tmp17_ = self->cells;
									_tmp17__length1 = self->cells_length1;
									_tmp17__length2 = self->cells_length2;
									_tmp18_ = _tmp17_[(i * _tmp17__length2) + j];
									_tmp19_ = g_strdup_printf ("%i", _tmp18_);
									_g_free0 (_tmp15_);
									_tmp15_ = _tmp19_;
								}
								_tmp20_ = board_string;
								_tmp21_ = g_strconcat (_tmp20_, _tmp15_, NULL);
								_g_free0 (board_string);
								board_string = _tmp21_;
								_g_free0 (_tmp15_);
							}
						}
					}
				}
			}
		}
	}
	result = board_string;
	return result;
}

static gint*
_vala_array_dup9 (gint* self,
                  gssize length)
{
	if (length > 0) {
		return _vala_memdup2 (self, length * sizeof (gint));
	}
	return NULL;
}

gint*
sudoku_board_get_cells (SudokuBoard* self,
                        gint* result_length1,
                        gint* result_length2)
{
	gint* _tmp0_;
	gint _tmp0__length1;
	gint _tmp0__length2;
	gint* _tmp1_;
	gint _tmp1__length1;
	gint _tmp1__length2;
	gint* _tmp2_;
	gint _tmp2__length1;
	gint _tmp2__length2;
	gint* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->cells;
	_tmp0__length1 = self->cells_length1;
	_tmp0__length2 = self->cells_length2;
	_tmp1_ = (_tmp0_ != NULL) ? _vala_array_dup9 (_tmp0_, _tmp0__length1 * _tmp0__length2) : _tmp0_;
	_tmp1__length1 = _tmp0__length1;
	_tmp1__length2 = _tmp0__length2;
	_tmp2_ = _tmp1_;
	_tmp2__length1 = _tmp1__length1;
	_tmp2__length2 = _tmp1__length2;
	if (result_length1) {
		*result_length1 = _tmp2__length1;
	}
	if (result_length2) {
		*result_length2 = _tmp2__length2;
	}
	result = _tmp2_;
	return result;
}

GeeHashMap*
sudoku_board_calculate_open_squares (SudokuBoard* self)
{
	GeeHashMap* possibilities = NULL;
	GeeHashMap* _tmp0_;
	GeeHashMap* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = gee_hash_map_new (TYPE_COORD, (GBoxedCopyFunc) coord_dup, (GDestroyNotify) coord_free, GEE_TYPE_LIST, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, (GeeHashDataFunc) coord_hash, NULL, NULL, (GeeEqualDataFunc) coord_equal, NULL, NULL, NULL, NULL, NULL);
	possibilities = _tmp0_;
	{
		gint l1 = 0;
		l1 = 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				gint _tmp3_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = l1;
					l1 = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				_tmp3_ = self->priv->_rows;
				if (!(l1 < _tmp3_)) {
					break;
				}
				{
					gint l2 = 0;
					l2 = 0;
					{
						gboolean _tmp4_ = FALSE;
						_tmp4_ = TRUE;
						while (TRUE) {
							gint _tmp6_;
							gint* _tmp7_;
							gint _tmp7__length1;
							gint _tmp7__length2;
							gint _tmp8_;
							if (!_tmp4_) {
								gint _tmp5_;
								_tmp5_ = l2;
								l2 = _tmp5_ + 1;
							}
							_tmp4_ = FALSE;
							_tmp6_ = self->priv->_cols;
							if (!(l2 < _tmp6_)) {
								break;
							}
							_tmp7_ = self->cells;
							_tmp7__length1 = self->cells_length1;
							_tmp7__length2 = self->cells_length2;
							_tmp8_ = _tmp7_[(l1 * _tmp7__length2) + l2];
							if (_tmp8_ == 0) {
								GeeList* possArrayList = NULL;
								GeeArrayList* _tmp9_;
								gint* possArray = NULL;
								gint _tmp10_ = 0;
								gint* _tmp11_;
								gint possArray_length1;
								gint _possArray_size_;
								gint* _tmp12_;
								gint _tmp12__length1;
								GeeHashMap* _tmp14_;
								Coord _tmp15_ = {0};
								GeeList* _tmp16_;
								_tmp9_ = gee_array_list_new (G_TYPE_INT, NULL, NULL, NULL, NULL, NULL);
								possArrayList = (GeeList*) _tmp9_;
								_tmp11_ = sudoku_board_get_possibilities (self, l1, l2, &_tmp10_);
								possArray = _tmp11_;
								possArray_length1 = _tmp10_;
								_possArray_size_ = possArray_length1;
								_tmp12_ = possArray;
								_tmp12__length1 = possArray_length1;
								{
									gint* i_collection = NULL;
									gint i_collection_length1 = 0;
									gint _i_collection_size_ = 0;
									gint i_it = 0;
									i_collection = _tmp12_;
									i_collection_length1 = _tmp12__length1;
									for (i_it = 0; i_it < i_collection_length1; i_it = i_it + 1) {
										gint i = 0;
										i = i_collection[i_it];
										{
											GeeList* _tmp13_;
											_tmp13_ = possArrayList;
											gee_collection_add ((GeeCollection*) _tmp13_, (gpointer) ((gintptr) i));
										}
									}
								}
								_tmp14_ = possibilities;
								coord_init (&_tmp15_, l1, l2);
								_tmp16_ = possArrayList;
								gee_abstract_map_set ((GeeAbstractMap*) _tmp14_, &_tmp15_, _tmp16_);
								possArray = (g_free (possArray), NULL);
								_g_object_unref0 (possArrayList);
							}
						}
					}
				}
			}
		}
	}
	result = possibilities;
	return result;
}

gboolean
sudoku_board_is_finished (SudokuBoard* self)
{
	gchar* board_string = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* finishgame_file = NULL;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	GFile* file = NULL;
	GFile* _tmp7_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = sudoku_board_to_string (self, TRUE);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strconcat (_tmp1_, ".save", NULL);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	board_string = _tmp3_;
	_tmp4_ = sudoku_saver_get_finishgame_dir ();
	_tmp5_ = _tmp4_;
	_tmp6_ = g_build_path (G_DIR_SEPARATOR_S, _tmp5_, board_string, NULL);
	finishgame_file = _tmp6_;
	_tmp7_ = g_file_new_for_path (finishgame_file);
	file = _tmp7_;
	result = g_file_query_exists (file, NULL);
	_g_object_unref0 (file);
	_g_free0 (finishgame_file);
	_g_free0 (board_string);
	return result;
}

gboolean*
sudoku_board_get_earmarks (SudokuBoard* self,
                           gint row,
                           gint col,
                           gint* result_length1)
{
	gboolean* the_earmarks = NULL;
	gint _tmp0_;
	gint _tmp1_;
	gboolean* _tmp2_;
	gint the_earmarks_length1;
	gint _the_earmarks_size_;
	gboolean* _tmp10_;
	gint _tmp10__length1;
	gboolean* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = sudoku_board_get_max_val (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_new0 (gboolean, _tmp1_);
	the_earmarks = _tmp2_;
	the_earmarks_length1 = _tmp1_;
	_the_earmarks_size_ = the_earmarks_length1;
	{
		gint i = 0;
		i = 1;
		{
			gboolean _tmp3_ = FALSE;
			_tmp3_ = TRUE;
			while (TRUE) {
				gint _tmp5_;
				gint _tmp6_;
				gboolean* _tmp7_;
				gint _tmp7__length1;
				gboolean* _tmp8_;
				gint _tmp8__length1;
				gint _tmp8__length2;
				gint _tmp8__length3;
				gboolean _tmp9_;
				if (!_tmp3_) {
					gint _tmp4_;
					_tmp4_ = i;
					i = _tmp4_ + 1;
				}
				_tmp3_ = FALSE;
				_tmp5_ = sudoku_board_get_max_val (self);
				_tmp6_ = _tmp5_;
				if (!(i <= _tmp6_)) {
					break;
				}
				_tmp7_ = the_earmarks;
				_tmp7__length1 = the_earmarks_length1;
				_tmp8_ = self->priv->earmarks;
				_tmp8__length1 = self->priv->earmarks_length1;
				_tmp8__length2 = self->priv->earmarks_length2;
				_tmp8__length3 = self->priv->earmarks_length3;
				_tmp9_ = _tmp8_[(((row * _tmp8__length2) + col) * _tmp8__length3) + (i - 1)];
				_tmp7_[i - 1] = _tmp9_;
			}
		}
	}
	_tmp10_ = the_earmarks;
	_tmp10__length1 = the_earmarks_length1;
	if (result_length1) {
		*result_length1 = _tmp10__length1;
	}
	result = _tmp10_;
	return result;
}

gchar*
sudoku_board_get_earmarks_string (SudokuBoard* self,
                                  gint row,
                                  gint col)
{
	gchar* s = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup ("");
	s = _tmp0_;
	{
		gint i = 0;
		i = 1;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				gint _tmp3_;
				gint _tmp4_;
				gboolean* _tmp5_;
				gint _tmp5__length1;
				gint _tmp5__length2;
				gint _tmp5__length3;
				gboolean _tmp6_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				_tmp3_ = sudoku_board_get_max_val (self);
				_tmp4_ = _tmp3_;
				if (!(i <= _tmp4_)) {
					break;
				}
				_tmp5_ = self->priv->earmarks;
				_tmp5__length1 = self->priv->earmarks_length1;
				_tmp5__length2 = self->priv->earmarks_length2;
				_tmp5__length3 = self->priv->earmarks_length3;
				_tmp6_ = _tmp5_[(((row * _tmp5__length2) + col) * _tmp5__length3) + (i - 1)];
				if (_tmp6_) {
					const gchar* _tmp7_;
					gchar* _tmp8_;
					gchar* _tmp9_;
					gchar* _tmp10_;
					_tmp7_ = s;
					_tmp8_ = g_strdup_printf ("%i", i);
					_tmp9_ = _tmp8_;
					_tmp10_ = g_strconcat (_tmp7_, _tmp9_, NULL);
					_g_free0 (s);
					s = _tmp10_;
					_g_free0 (_tmp9_);
				}
			}
		}
	}
	result = s;
	return result;
}

static gint*
sudoku_board_convert_2d_to_1d (SudokuBoard* self,
                               gint* ints_2d,
                               gint ints_2d_length1,
                               gint ints_2d_length2,
                               gint* result_length1)
{
	gint* ints_1d = NULL;
	gint _tmp0_;
	gint _tmp1_;
	gint* _tmp2_;
	gint ints_1d_length1;
	gint _ints_1d_size_;
	gint i = 0;
	gint* _tmp15_;
	gint _tmp15__length1;
	gint* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_rows;
	_tmp1_ = self->priv->_cols;
	_tmp2_ = g_new0 (gint, _tmp0_ * _tmp1_);
	ints_1d = _tmp2_;
	ints_1d_length1 = _tmp0_ * _tmp1_;
	_ints_1d_size_ = ints_1d_length1;
	i = 0;
	{
		gint row = 0;
		row = 0;
		{
			gboolean _tmp3_ = FALSE;
			_tmp3_ = TRUE;
			while (TRUE) {
				gint _tmp5_;
				if (!_tmp3_) {
					gint _tmp4_;
					_tmp4_ = row;
					row = _tmp4_ + 1;
				}
				_tmp3_ = FALSE;
				_tmp5_ = self->priv->_rows;
				if (!(row < _tmp5_)) {
					break;
				}
				{
					gint col = 0;
					col = 0;
					{
						gboolean _tmp6_ = FALSE;
						_tmp6_ = TRUE;
						while (TRUE) {
							gint _tmp8_;
							gint* _tmp9_;
							gint _tmp9__length1;
							gint _tmp10_;
							gint* _tmp11_;
							gint _tmp11__length1;
							gint _tmp11__length2;
							gint _tmp12_;
							gint _tmp13_;
							gint _tmp14_;
							if (!_tmp6_) {
								gint _tmp7_;
								_tmp7_ = col;
								col = _tmp7_ + 1;
							}
							_tmp6_ = FALSE;
							_tmp8_ = self->priv->_cols;
							if (!(col < _tmp8_)) {
								break;
							}
							_tmp9_ = ints_1d;
							_tmp9__length1 = ints_1d_length1;
							_tmp10_ = i;
							i = _tmp10_ + 1;
							_tmp11_ = ints_2d;
							_tmp11__length1 = ints_2d_length1;
							_tmp11__length2 = ints_2d_length2;
							_tmp12_ = row;
							_tmp13_ = col;
							_tmp14_ = _tmp11_[(_tmp12_ * _tmp11__length2) + _tmp13_];
							_tmp9_[_tmp10_] = _tmp14_;
						}
					}
				}
			}
		}
	}
	_tmp15_ = ints_1d;
	_tmp15__length1 = ints_1d_length1;
	if (result_length1) {
		*result_length1 = _tmp15__length1;
	}
	result = _tmp15_;
	return result;
}

static gint*
sudoku_board_convert_1d_to_2d (SudokuBoard* self,
                               gint* ints_1d,
                               gint ints_1d_length1,
                               gint* result_length1,
                               gint* result_length2)
{
	gint* ints_2d = NULL;
	gint _tmp0_;
	gint _tmp1_;
	gint* _tmp2_;
	gint ints_2d_length1;
	gint ints_2d_length2;
	gint i = 0;
	gint* _tmp15_;
	gint _tmp15__length1;
	gint _tmp15__length2;
	gint* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_rows;
	_tmp1_ = self->priv->_cols;
	_tmp2_ = g_new0 (gint, _tmp0_ * _tmp1_);
	ints_2d = _tmp2_;
	ints_2d_length1 = _tmp0_;
	ints_2d_length2 = _tmp1_;
	i = 0;
	{
		gint row = 0;
		row = 0;
		{
			gboolean _tmp3_ = FALSE;
			_tmp3_ = TRUE;
			while (TRUE) {
				gint _tmp5_;
				if (!_tmp3_) {
					gint _tmp4_;
					_tmp4_ = row;
					row = _tmp4_ + 1;
				}
				_tmp3_ = FALSE;
				_tmp5_ = self->priv->_rows;
				if (!(row < _tmp5_)) {
					break;
				}
				{
					gint col = 0;
					col = 0;
					{
						gboolean _tmp6_ = FALSE;
						_tmp6_ = TRUE;
						while (TRUE) {
							gint _tmp8_;
							gint* _tmp9_;
							gint _tmp9__length1;
							gint _tmp9__length2;
							gint _tmp10_;
							gint _tmp11_;
							gint* _tmp12_;
							gint _tmp12__length1;
							gint _tmp13_;
							gint _tmp14_;
							if (!_tmp6_) {
								gint _tmp7_;
								_tmp7_ = col;
								col = _tmp7_ + 1;
							}
							_tmp6_ = FALSE;
							_tmp8_ = self->priv->_cols;
							if (!(col < _tmp8_)) {
								break;
							}
							_tmp9_ = ints_2d;
							_tmp9__length1 = ints_2d_length1;
							_tmp9__length2 = ints_2d_length2;
							_tmp10_ = row;
							_tmp11_ = col;
							_tmp12_ = ints_1d;
							_tmp12__length1 = ints_1d_length1;
							_tmp13_ = i;
							i = _tmp13_ + 1;
							_tmp14_ = _tmp12_[_tmp13_];
							_tmp9_[(_tmp10_ * _tmp9__length2) + _tmp11_] = _tmp14_;
						}
					}
				}
			}
		}
	}
	_tmp15_ = ints_2d;
	_tmp15__length1 = ints_2d_length1;
	_tmp15__length2 = ints_2d_length2;
	if (result_length1) {
		*result_length1 = _tmp15__length1;
	}
	if (result_length2) {
		*result_length2 = _tmp15__length2;
	}
	result = _tmp15_;
	return result;
}

gdouble
sudoku_board_get_previous_played_time (SudokuBoard* self)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->_previous_played_time;
	return result;
}

void
sudoku_board_set_previous_played_time (SudokuBoard* self,
                                       gdouble value)
{
	gdouble old_value;
	g_return_if_fail (self != NULL);
	old_value = sudoku_board_get_previous_played_time (self);
	if (old_value != value) {
		self->priv->_previous_played_time = value;
		g_object_notify_by_pspec ((GObject *) self, sudoku_board_properties[SUDOKU_BOARD_PREVIOUS_PLAYED_TIME_PROPERTY]);
	}
}

DifficultyCategory
sudoku_board_get_difficulty_category (SudokuBoard* self)
{
	DifficultyCategory result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_difficulty_category;
	return result;
}

void
sudoku_board_set_difficulty_category (SudokuBoard* self,
                                      DifficultyCategory value)
{
	DifficultyCategory old_value;
	g_return_if_fail (self != NULL);
	old_value = sudoku_board_get_difficulty_category (self);
	if (old_value != value) {
		self->priv->_difficulty_category = value;
		g_object_notify_by_pspec ((GObject *) self, sudoku_board_properties[SUDOKU_BOARD_DIFFICULTY_CATEGORY_PROPERTY]);
	}
}

gint
sudoku_board_get_block_rows (SudokuBoard* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_block_rows;
	return result;
}

static void
sudoku_board_set_block_rows (SudokuBoard* self,
                             gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = sudoku_board_get_block_rows (self);
	if (old_value != value) {
		self->priv->_block_rows = value;
		g_object_notify_by_pspec ((GObject *) self, sudoku_board_properties[SUDOKU_BOARD_BLOCK_ROWS_PROPERTY]);
	}
}

gint
sudoku_board_get_block_cols (SudokuBoard* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_block_cols;
	return result;
}

static void
sudoku_board_set_block_cols (SudokuBoard* self,
                             gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = sudoku_board_get_block_cols (self);
	if (old_value != value) {
		self->priv->_block_cols = value;
		g_object_notify_by_pspec ((GObject *) self, sudoku_board_properties[SUDOKU_BOARD_BLOCK_COLS_PROPERTY]);
	}
}

gint
sudoku_board_get_rows (SudokuBoard* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_rows;
	return result;
}

static void
sudoku_board_set_rows (SudokuBoard* self,
                       gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = sudoku_board_get_rows (self);
	if (old_value != value) {
		self->priv->_rows = value;
		g_object_notify_by_pspec ((GObject *) self, sudoku_board_properties[SUDOKU_BOARD_ROWS_PROPERTY]);
	}
}

gint
sudoku_board_get_cols (SudokuBoard* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_cols;
	return result;
}

static void
sudoku_board_set_cols (SudokuBoard* self,
                       gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = sudoku_board_get_cols (self);
	if (old_value != value) {
		self->priv->_cols = value;
		g_object_notify_by_pspec ((GObject *) self, sudoku_board_properties[SUDOKU_BOARD_COLS_PROPERTY]);
	}
}

gint
sudoku_board_get_max_val (SudokuBoard* self)
{
	gint result;
	gint _tmp0_;
	gint _tmp1_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_block_rows;
	_tmp1_ = self->priv->_block_cols;
	result = _tmp0_ * _tmp1_;
	return result;
}

gboolean
sudoku_board_get_broken (SudokuBoard* self)
{
	gboolean result;
	GeeSet* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->broken_coords;
	_tmp1_ = gee_collection_get_size ((GeeCollection*) _tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_ != 0;
	return result;
}

gint
sudoku_board_get_filled (SudokuBoard* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_filled;
	return result;
}

static void
sudoku_board_set_filled (SudokuBoard* self,
                         gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = sudoku_board_get_filled (self);
	if (old_value != value) {
		self->priv->_filled = value;
		g_object_notify_by_pspec ((GObject *) self, sudoku_board_properties[SUDOKU_BOARD_FILLED_PROPERTY]);
	}
}

gint
sudoku_board_get_fixed (SudokuBoard* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_fixed;
	return result;
}

static void
sudoku_board_set_fixed (SudokuBoard* self,
                        gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = sudoku_board_get_fixed (self);
	if (old_value != value) {
		self->priv->_fixed = value;
		g_object_notify_by_pspec ((GObject *) self, sudoku_board_properties[SUDOKU_BOARD_FIXED_PROPERTY]);
	}
}

gint
sudoku_board_get_size (SudokuBoard* self)
{
	gint result;
	gint _tmp0_;
	gint _tmp1_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_rows;
	_tmp1_ = self->priv->_cols;
	result = _tmp0_ * _tmp1_;
	return result;
}

gboolean
sudoku_board_get_complete (SudokuBoard* self)
{
	gboolean result;
	gboolean _tmp0_ = FALSE;
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = self->priv->_filled;
	_tmp2_ = self->priv->_cols;
	_tmp3_ = self->priv->_rows;
	if (_tmp1_ == (_tmp2_ * _tmp3_)) {
		gboolean _tmp4_;
		gboolean _tmp5_;
		_tmp4_ = sudoku_board_get_broken (self);
		_tmp5_ = _tmp4_;
		_tmp0_ = !_tmp5_;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static void
sudoku_board_class_init (SudokuBoardClass * klass,
                         gpointer klass_data)
{
	sudoku_board_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SudokuBoard_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_sudoku_board_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_sudoku_board_set_property;
	G_OBJECT_CLASS (klass)->finalize = sudoku_board_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_BOARD_PREVIOUS_PLAYED_TIME_PROPERTY, sudoku_board_properties[SUDOKU_BOARD_PREVIOUS_PLAYED_TIME_PROPERTY] = g_param_spec_double ("previous-played-time", "previous-played-time", "previous-played-time", -G_MAXDOUBLE, G_MAXDOUBLE, (gdouble) 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_BOARD_DIFFICULTY_CATEGORY_PROPERTY, sudoku_board_properties[SUDOKU_BOARD_DIFFICULTY_CATEGORY_PROPERTY] = g_param_spec_enum ("difficulty-category", "difficulty-category", "difficulty-category", TYPE_DIFFICULTY_CATEGORY, DIFFICULTY_CATEGORY_UNKNOWN, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_BOARD_BLOCK_ROWS_PROPERTY, sudoku_board_properties[SUDOKU_BOARD_BLOCK_ROWS_PROPERTY] = g_param_spec_int ("block-rows", "block-rows", "block-rows", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_BOARD_BLOCK_COLS_PROPERTY, sudoku_board_properties[SUDOKU_BOARD_BLOCK_COLS_PROPERTY] = g_param_spec_int ("block-cols", "block-cols", "block-cols", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_BOARD_ROWS_PROPERTY, sudoku_board_properties[SUDOKU_BOARD_ROWS_PROPERTY] = g_param_spec_int ("rows", "rows", "rows", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_BOARD_COLS_PROPERTY, sudoku_board_properties[SUDOKU_BOARD_COLS_PROPERTY] = g_param_spec_int ("cols", "cols", "cols", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_BOARD_MAX_VAL_PROPERTY, sudoku_board_properties[SUDOKU_BOARD_MAX_VAL_PROPERTY] = g_param_spec_int ("max-val", "max-val", "max-val", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_BOARD_BROKEN_PROPERTY, sudoku_board_properties[SUDOKU_BOARD_BROKEN_PROPERTY] = g_param_spec_boolean ("broken", "broken", "broken", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_BOARD_FILLED_PROPERTY, sudoku_board_properties[SUDOKU_BOARD_FILLED_PROPERTY] = g_param_spec_int ("filled", "filled", "filled", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_BOARD_FIXED_PROPERTY, sudoku_board_properties[SUDOKU_BOARD_FIXED_PROPERTY] = g_param_spec_int ("fixed", "fixed", "fixed", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_BOARD_SIZE_PROPERTY, sudoku_board_properties[SUDOKU_BOARD_SIZE_PROPERTY] = g_param_spec_int ("size", "size", "size", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_BOARD_COMPLETE_PROPERTY, sudoku_board_properties[SUDOKU_BOARD_COMPLETE_PROPERTY] = g_param_spec_boolean ("complete", "complete", "complete", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	sudoku_board_signals[SUDOKU_BOARD_COMPLETED_SIGNAL] = g_signal_new ("completed", TYPE_SUDOKU_BOARD, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
sudoku_board_instance_init (SudokuBoard * self,
                            gpointer klass)
{
	self->priv = sudoku_board_get_instance_private (self);
	self->priv->_previous_played_time = (gdouble) 0;
	self->priv->_difficulty_category = DIFFICULTY_CATEGORY_UNKNOWN;
}

static void
sudoku_board_finalize (GObject * obj)
{
	SudokuBoard * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SUDOKU_BOARD, SudokuBoard);
	self->cells = (g_free (self->cells), NULL);
	self->solution = (g_free (self->solution), NULL);
	self->is_fixed = (g_free (self->is_fixed), NULL);
	self->priv->possible_in_row = (g_free (self->priv->possible_in_row), NULL);
	self->priv->possible_in_col = (g_free (self->priv->possible_in_col), NULL);
	self->priv->possible_in_block = (g_free (self->priv->possible_in_block), NULL);
	self->priv->earmarks = (g_free (self->priv->earmarks), NULL);
	_g_object_unref0 (self->broken_coords);
	_g_object_unref0 (self->coords_for_col);
	_g_object_unref0 (self->coords_for_row);
	_g_object_unref0 (self->coords_for_block);
	G_OBJECT_CLASS (sudoku_board_parent_class)->finalize (obj);
}

static GType
sudoku_board_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SudokuBoardClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sudoku_board_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SudokuBoard), 0, (GInstanceInitFunc) sudoku_board_instance_init, NULL };
	GType sudoku_board_type_id;
	sudoku_board_type_id = g_type_register_static (G_TYPE_OBJECT, "SudokuBoard", &g_define_type_info, 0);
	SudokuBoard_private_offset = g_type_add_instance_private (sudoku_board_type_id, sizeof (SudokuBoardPrivate));
	return sudoku_board_type_id;
}

GType
sudoku_board_get_type (void)
{
	static volatile gsize sudoku_board_type_id__once = 0;
	if (g_once_init_enter (&sudoku_board_type_id__once)) {
		GType sudoku_board_type_id;
		sudoku_board_type_id = sudoku_board_get_type_once ();
		g_once_init_leave (&sudoku_board_type_id__once, sudoku_board_type_id);
	}
	return sudoku_board_type_id__once;
}

static void
_vala_sudoku_board_get_property (GObject * object,
                                 guint property_id,
                                 GValue * value,
                                 GParamSpec * pspec)
{
	SudokuBoard * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_SUDOKU_BOARD, SudokuBoard);
	switch (property_id) {
		case SUDOKU_BOARD_PREVIOUS_PLAYED_TIME_PROPERTY:
		g_value_set_double (value, sudoku_board_get_previous_played_time (self));
		break;
		case SUDOKU_BOARD_DIFFICULTY_CATEGORY_PROPERTY:
		g_value_set_enum (value, sudoku_board_get_difficulty_category (self));
		break;
		case SUDOKU_BOARD_BLOCK_ROWS_PROPERTY:
		g_value_set_int (value, sudoku_board_get_block_rows (self));
		break;
		case SUDOKU_BOARD_BLOCK_COLS_PROPERTY:
		g_value_set_int (value, sudoku_board_get_block_cols (self));
		break;
		case SUDOKU_BOARD_ROWS_PROPERTY:
		g_value_set_int (value, sudoku_board_get_rows (self));
		break;
		case SUDOKU_BOARD_COLS_PROPERTY:
		g_value_set_int (value, sudoku_board_get_cols (self));
		break;
		case SUDOKU_BOARD_MAX_VAL_PROPERTY:
		g_value_set_int (value, sudoku_board_get_max_val (self));
		break;
		case SUDOKU_BOARD_BROKEN_PROPERTY:
		g_value_set_boolean (value, sudoku_board_get_broken (self));
		break;
		case SUDOKU_BOARD_FILLED_PROPERTY:
		g_value_set_int (value, sudoku_board_get_filled (self));
		break;
		case SUDOKU_BOARD_FIXED_PROPERTY:
		g_value_set_int (value, sudoku_board_get_fixed (self));
		break;
		case SUDOKU_BOARD_SIZE_PROPERTY:
		g_value_set_int (value, sudoku_board_get_size (self));
		break;
		case SUDOKU_BOARD_COMPLETE_PROPERTY:
		g_value_set_boolean (value, sudoku_board_get_complete (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_sudoku_board_set_property (GObject * object,
                                 guint property_id,
                                 const GValue * value,
                                 GParamSpec * pspec)
{
	SudokuBoard * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_SUDOKU_BOARD, SudokuBoard);
	switch (property_id) {
		case SUDOKU_BOARD_PREVIOUS_PLAYED_TIME_PROPERTY:
		sudoku_board_set_previous_played_time (self, g_value_get_double (value));
		break;
		case SUDOKU_BOARD_DIFFICULTY_CATEGORY_PROPERTY:
		sudoku_board_set_difficulty_category (self, g_value_get_enum (value));
		break;
		case SUDOKU_BOARD_BLOCK_ROWS_PROPERTY:
		sudoku_board_set_block_rows (self, g_value_get_int (value));
		break;
		case SUDOKU_BOARD_BLOCK_COLS_PROPERTY:
		sudoku_board_set_block_cols (self, g_value_get_int (value));
		break;
		case SUDOKU_BOARD_ROWS_PROPERTY:
		sudoku_board_set_rows (self, g_value_get_int (value));
		break;
		case SUDOKU_BOARD_COLS_PROPERTY:
		sudoku_board_set_cols (self, g_value_get_int (value));
		break;
		case SUDOKU_BOARD_FILLED_PROPERTY:
		sudoku_board_set_filled (self, g_value_get_int (value));
		break;
		case SUDOKU_BOARD_FIXED_PROPERTY:
		sudoku_board_set_fixed (self, g_value_get_int (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static GType
house_get_type_once (void)
{
	static const GEnumValue values[] = {{HOUSE_ROW, "HOUSE_ROW", "row"}, {HOUSE_COLUMN, "HOUSE_COLUMN", "column"}, {HOUSE_BLOCK, "HOUSE_BLOCK", "block"}, {0, NULL, NULL}};
	GType house_type_id;
	house_type_id = g_enum_register_static ("House", values);
	return house_type_id;
}

GType
house_get_type (void)
{
	static volatile gsize house_type_id__once = 0;
	if (g_once_init_enter (&house_type_id__once)) {
		GType house_type_id;
		house_type_id = house_get_type_once ();
		g_once_init_leave (&house_type_id__once, house_type_id);
	}
	return house_type_id__once;
}

void
coord_init (Coord *self,
            gint row,
            gint col)
{
	memset (self, 0, sizeof (Coord));
	(*self).row = row;
	(*self).col = col;
}

gint
coord_hash (Coord* coord)
{
	Coord _tmp0_;
	Coord _tmp1_;
	gint result;
	g_return_val_if_fail (coord != NULL, 0);
	_tmp0_ = *coord;
	_tmp1_ = *coord;
	result = (_tmp0_.row * 33) ^ _tmp1_.col;
	return result;
}

gboolean
coord_equal (Coord* a,
             Coord* b)
{
	gboolean _tmp0_ = FALSE;
	Coord _tmp1_;
	Coord _tmp2_;
	gboolean result;
	g_return_val_if_fail (a != NULL, FALSE);
	g_return_val_if_fail (b != NULL, FALSE);
	_tmp1_ = *a;
	_tmp2_ = *b;
	if (_tmp1_.row == _tmp2_.row) {
		Coord _tmp3_;
		Coord _tmp4_;
		_tmp3_ = *a;
		_tmp4_ = *b;
		_tmp0_ = _tmp3_.col == _tmp4_.col;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

Coord*
coord_dup (const Coord* self)
{
	Coord* dup;
	dup = g_new0 (Coord, 1);
	memcpy (dup, self, sizeof (Coord));
	return dup;
}

void
coord_free (Coord* self)
{
	g_free (self);
}

static GType
coord_get_type_once (void)
{
	GType coord_type_id;
	coord_type_id = g_boxed_type_register_static ("Coord", (GBoxedCopyFunc) coord_dup, (GBoxedFreeFunc) coord_free);
	return coord_type_id;
}

GType
coord_get_type (void)
{
	static volatile gsize coord_type_id__once = 0;
	if (g_once_init_enter (&coord_type_id__once)) {
		GType coord_type_id;
		coord_type_id = coord_get_type_once ();
		g_once_init_leave (&coord_type_id__once, coord_type_id);
	}
	return coord_type_id__once;
}

void
cell_init (Cell *self,
           Coord* coord,
           gint val)
{
	Coord _tmp0_;
	g_return_if_fail (coord != NULL);
	memset (self, 0, sizeof (Cell));
	_tmp0_ = *coord;
	(*self).coord = _tmp0_;
	(*self).val = val;
}

gint
cell_hash (Cell* cell)
{
	Cell _tmp0_;
	Coord _tmp1_;
	Cell _tmp2_;
	gint result;
	g_return_val_if_fail (cell != NULL, 0);
	_tmp0_ = *cell;
	_tmp1_ = _tmp0_.coord;
	_tmp2_ = *cell;
	result = (coord_hash (&_tmp1_) * 33) ^ _tmp2_.val;
	return result;
}

gboolean
cell_equal (Cell* a,
            Cell* b)
{
	gboolean _tmp0_ = FALSE;
	Cell _tmp1_;
	Coord _tmp2_;
	Cell _tmp3_;
	Coord _tmp4_;
	gboolean result;
	g_return_val_if_fail (a != NULL, FALSE);
	g_return_val_if_fail (b != NULL, FALSE);
	_tmp1_ = *a;
	_tmp2_ = _tmp1_.coord;
	_tmp3_ = *b;
	_tmp4_ = _tmp3_.coord;
	if (coord_equal (&_tmp2_, &_tmp4_)) {
		Cell _tmp5_;
		Cell _tmp6_;
		_tmp5_ = *a;
		_tmp6_ = *b;
		_tmp0_ = _tmp5_.val == _tmp6_.val;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

Cell*
cell_dup (const Cell* self)
{
	Cell* dup;
	dup = g_new0 (Cell, 1);
	memcpy (dup, self, sizeof (Cell));
	return dup;
}

void
cell_free (Cell* self)
{
	g_free (self);
}

static GType
cell_get_type_once (void)
{
	GType cell_type_id;
	cell_type_id = g_boxed_type_register_static ("Cell", (GBoxedCopyFunc) cell_dup, (GBoxedFreeFunc) cell_free);
	return cell_type_id;
}

GType
cell_get_type (void)
{
	static volatile gsize cell_type_id__once = 0;
	if (g_once_init_enter (&cell_type_id__once)) {
		GType cell_type_id;
		cell_type_id = cell_get_type_once ();
		g_once_init_leave (&cell_type_id__once, cell_type_id);
	}
	return cell_type_id__once;
}

gchar*
difficulty_category_to_string (DifficultyCategory self)
{
	gchar* result;
	switch (self) {
		case DIFFICULTY_CATEGORY_UNKNOWN:
		{
			gchar* _tmp0_;
			_tmp0_ = g_strdup (_ ("Unknown Difficulty"));
			result = _tmp0_;
			return result;
		}
		case DIFFICULTY_CATEGORY_EASY:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup (_ ("Easy Difficulty"));
			result = _tmp1_;
			return result;
		}
		case DIFFICULTY_CATEGORY_MEDIUM:
		{
			gchar* _tmp2_;
			_tmp2_ = g_strdup (_ ("Medium Difficulty"));
			result = _tmp2_;
			return result;
		}
		case DIFFICULTY_CATEGORY_HARD:
		{
			gchar* _tmp3_;
			_tmp3_ = g_strdup (_ ("Hard Difficulty"));
			result = _tmp3_;
			return result;
		}
		case DIFFICULTY_CATEGORY_VERY_HARD:
		{
			gchar* _tmp4_;
			_tmp4_ = g_strdup (_ ("Very Hard Difficulty"));
			result = _tmp4_;
			return result;
		}
		case DIFFICULTY_CATEGORY_CUSTOM:
		{
			gchar* _tmp5_;
			_tmp5_ = g_strdup (_ ("Custom Puzzle"));
			result = _tmp5_;
			return result;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}

gchar*
difficulty_category_to_untranslated_string (DifficultyCategory self)
{
	gchar* result;
	switch (self) {
		case DIFFICULTY_CATEGORY_UNKNOWN:
		{
			gchar* _tmp0_;
			_tmp0_ = g_strdup ("Unknown Difficulty");
			result = _tmp0_;
			return result;
		}
		case DIFFICULTY_CATEGORY_EASY:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup ("Easy Difficulty");
			result = _tmp1_;
			return result;
		}
		case DIFFICULTY_CATEGORY_MEDIUM:
		{
			gchar* _tmp2_;
			_tmp2_ = g_strdup ("Medium Difficulty");
			result = _tmp2_;
			return result;
		}
		case DIFFICULTY_CATEGORY_HARD:
		{
			gchar* _tmp3_;
			_tmp3_ = g_strdup ("Hard Difficulty");
			result = _tmp3_;
			return result;
		}
		case DIFFICULTY_CATEGORY_VERY_HARD:
		{
			gchar* _tmp4_;
			_tmp4_ = g_strdup ("Very Hard Difficulty");
			result = _tmp4_;
			return result;
		}
		case DIFFICULTY_CATEGORY_CUSTOM:
		{
			gchar* _tmp5_;
			_tmp5_ = g_strdup ("Custom Puzzle");
			result = _tmp5_;
			return result;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}

DifficultyCategory
difficulty_category_from_string (const gchar* input)
{
	const gchar* _tmp0_;
	GQuark _tmp2_ = 0U;
	static GQuark _tmp1_label0 = 0;
	static GQuark _tmp1_label1 = 0;
	static GQuark _tmp1_label2 = 0;
	static GQuark _tmp1_label3 = 0;
	static GQuark _tmp1_label4 = 0;
	static GQuark _tmp1_label5 = 0;
	DifficultyCategory result;
	g_return_val_if_fail (input != NULL, 0);
	_tmp0_ = input;
	_tmp2_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
	if (_tmp2_ == ((0 != _tmp1_label0) ? _tmp1_label0 : (_tmp1_label0 = g_quark_from_static_string ("Unknown Difficulty")))) {
		switch (0) {
			default:
			{
				result = DIFFICULTY_CATEGORY_UNKNOWN;
				return result;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label1) ? _tmp1_label1 : (_tmp1_label1 = g_quark_from_static_string ("Easy Difficulty")))) {
		switch (0) {
			default:
			{
				result = DIFFICULTY_CATEGORY_EASY;
				return result;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label2) ? _tmp1_label2 : (_tmp1_label2 = g_quark_from_static_string ("Medium Difficulty")))) {
		switch (0) {
			default:
			{
				result = DIFFICULTY_CATEGORY_MEDIUM;
				return result;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label3) ? _tmp1_label3 : (_tmp1_label3 = g_quark_from_static_string ("Hard Difficulty")))) {
		switch (0) {
			default:
			{
				result = DIFFICULTY_CATEGORY_HARD;
				return result;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label4) ? _tmp1_label4 : (_tmp1_label4 = g_quark_from_static_string ("Very Hard Difficulty")))) {
		switch (0) {
			default:
			{
				result = DIFFICULTY_CATEGORY_VERY_HARD;
				return result;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label5) ? _tmp1_label5 : (_tmp1_label5 = g_quark_from_static_string ("Custom Puzzle")))) {
		switch (0) {
			default:
			{
				result = DIFFICULTY_CATEGORY_CUSTOM;
				return result;
			}
		}
	} else {
		switch (0) {
			default:
			{
				g_warning ("sudoku-board.vala:698: Could not parse difficulty level. Falling back " \
"to Easy difficulty");
				result = DIFFICULTY_CATEGORY_EASY;
				return result;
			}
		}
	}
}

static GType
difficulty_category_get_type_once (void)
{
	static const GEnumValue values[] = {{DIFFICULTY_CATEGORY_UNKNOWN, "DIFFICULTY_CATEGORY_UNKNOWN", "unknown"}, {DIFFICULTY_CATEGORY_EASY, "DIFFICULTY_CATEGORY_EASY", "easy"}, {DIFFICULTY_CATEGORY_MEDIUM, "DIFFICULTY_CATEGORY_MEDIUM", "medium"}, {DIFFICULTY_CATEGORY_HARD, "DIFFICULTY_CATEGORY_HARD", "hard"}, {DIFFICULTY_CATEGORY_VERY_HARD, "DIFFICULTY_CATEGORY_VERY_HARD", "very-hard"}, {DIFFICULTY_CATEGORY_CUSTOM, "DIFFICULTY_CATEGORY_CUSTOM", "custom"}, {0, NULL, NULL}};
	GType difficulty_category_type_id;
	difficulty_category_type_id = g_enum_register_static ("DifficultyCategory", values);
	return difficulty_category_type_id;
}

GType
difficulty_category_get_type (void)
{
	static volatile gsize difficulty_category_type_id__once = 0;
	if (g_once_init_enter (&difficulty_category_type_id__once)) {
		GType difficulty_category_type_id;
		difficulty_category_type_id = difficulty_category_get_type_once ();
		g_once_init_leave (&difficulty_category_type_id__once, difficulty_category_type_id);
	}
	return difficulty_category_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

