/*
 * Decompiled with CFR 0.152.
 */
package sun.security.pkcs11;

import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectStreamException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyRep;
import java.security.MessageDigest;
import java.security.PrivateKey;
import java.security.ProviderException;
import java.security.PublicKey;
import java.security.interfaces.DSAParams;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.DSAParameterSpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.SecretKey;
import javax.crypto.interfaces.DHPrivateKey;
import javax.crypto.interfaces.DHPublicKey;
import javax.crypto.spec.DHParameterSpec;
import javax.crypto.spec.DHPrivateKeySpec;
import javax.crypto.spec.DHPublicKeySpec;
import sun.security.internal.interfaces.TlsMasterSecret;
import sun.security.pkcs11.P11ECKeyFactory;
import sun.security.pkcs11.P11Util;
import sun.security.pkcs11.Session;
import sun.security.pkcs11.SessionKeyRef;
import sun.security.pkcs11.Token;
import sun.security.pkcs11.wrapper.CK_ATTRIBUTE;
import sun.security.pkcs11.wrapper.PKCS11Exception;
import sun.security.provider.DSAPrivateKey;
import sun.security.provider.DSAPublicKey;
import sun.security.rsa.RSAPublicKeyImpl;
import sun.security.util.DerValue;
import sun.security.util.ECUtil;
import sun.security.util.Length;

abstract class P11Key
implements Key,
Length {
    private static final String PUBLIC = "public";
    private static final String PRIVATE = "private";
    private static final String SECRET = "secret";
    final String type;
    final Token token;
    final String algorithm;
    final long keyID;
    final int keyLength;
    final boolean tokenObject;
    final boolean sensitive;
    final boolean extractable;
    private final SessionKeyRef sessionKeyRef;
    private static final CK_ATTRIBUTE[] A0 = new CK_ATTRIBUTE[0];

    P11Key(String type, Session session, long keyID, String algorithm, int keyLength, CK_ATTRIBUTE[] attributes) {
        this.type = type;
        this.token = session.token;
        this.keyID = keyID;
        this.algorithm = algorithm;
        this.keyLength = keyLength;
        boolean tokenObject = false;
        boolean sensitive = false;
        boolean extractable = true;
        int n = attributes == null ? 0 : attributes.length;
        for (int i = 0; i < n; ++i) {
            CK_ATTRIBUTE attr = attributes[i];
            if (attr.type == 1L) {
                tokenObject = attr.getBoolean();
                continue;
            }
            if (attr.type == 259L) {
                sensitive = attr.getBoolean();
                continue;
            }
            if (attr.type != 354L) continue;
            extractable = attr.getBoolean();
        }
        this.tokenObject = tokenObject;
        this.sensitive = sensitive;
        this.extractable = extractable;
        this.sessionKeyRef = !tokenObject ? new SessionKeyRef(this, keyID, session) : null;
    }

    @Override
    public final String getAlgorithm() {
        this.token.ensureValid();
        return this.algorithm;
    }

    @Override
    public final byte[] getEncoded() {
        byte[] b = this.getEncodedInternal();
        return b == null ? null : (byte[])b.clone();
    }

    abstract byte[] getEncodedInternal();

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!this.token.isValid()) {
            return false;
        }
        if (!(obj instanceof Key)) {
            return false;
        }
        String thisFormat = this.getFormat();
        if (thisFormat == null) {
            return false;
        }
        Key other = (Key)obj;
        if (!thisFormat.equals(other.getFormat())) {
            return false;
        }
        byte[] thisEnc = this.getEncodedInternal();
        byte[] otherEnc = obj instanceof P11Key ? ((P11Key)other).getEncodedInternal() : other.getEncoded();
        return MessageDigest.isEqual(thisEnc, otherEnc);
    }

    public int hashCode() {
        if (!this.token.isValid()) {
            return 0;
        }
        byte[] b1 = this.getEncodedInternal();
        if (b1 == null) {
            return 0;
        }
        int r = b1.length;
        for (int i = 0; i < b1.length; ++i) {
            r += (b1[i] & 0xFF) * 37;
        }
        return r;
    }

    protected Object writeReplace() throws ObjectStreamException {
        KeyRep.Type type;
        String format = this.getFormat();
        if (this.isPrivate() && "PKCS#8".equals(format)) {
            type = KeyRep.Type.PRIVATE;
        } else if (this.isPublic() && "X.509".equals(format)) {
            type = KeyRep.Type.PUBLIC;
        } else if (this.isSecret() && "RAW".equals(format)) {
            type = KeyRep.Type.SECRET;
        } else {
            throw new NotSerializableException("Cannot serialize sensitive and unextractable keys");
        }
        return new KeyRep(type, this.getAlgorithm(), format, this.getEncoded());
    }

    public String toString() {
        this.token.ensureValid();
        String s1 = this.token.provider.getName() + " " + this.algorithm + " " + this.type + " key, " + this.keyLength + " bits";
        s1 = s1 + " (id " + this.keyID + ", " + (this.tokenObject ? "token" : "session") + " object";
        if (this.isPublic()) {
            s1 = s1 + ")";
        } else {
            s1 = s1 + ", " + (this.sensitive ? "" : "not ") + "sensitive";
            s1 = s1 + ", " + (this.extractable ? "" : "un") + "extractable)";
        }
        return s1;
    }

    @Override
    public int length() {
        return this.keyLength;
    }

    boolean isPublic() {
        return this.type == PUBLIC;
    }

    boolean isPrivate() {
        return this.type == PRIVATE;
    }

    boolean isSecret() {
        return this.type == SECRET;
    }

    void fetchAttributes(CK_ATTRIBUTE[] attributes) {
        Session tempSession = null;
        try {
            tempSession = this.token.getOpSession();
            this.token.p11.C_GetAttributeValue(tempSession.id(), this.keyID, attributes);
        }
        catch (PKCS11Exception e) {
            throw new ProviderException(e);
        }
        finally {
            this.token.releaseSession(tempSession);
        }
    }

    private static CK_ATTRIBUTE[] getAttributes(Session session, long keyID, CK_ATTRIBUTE[] knownAttributes, CK_ATTRIBUTE[] desiredAttributes) {
        if (knownAttributes == null) {
            knownAttributes = A0;
        }
        for (int i = 0; i < desiredAttributes.length; ++i) {
            CK_ATTRIBUTE attr = desiredAttributes[i];
            for (CK_ATTRIBUTE known : knownAttributes) {
                if (attr.type != known.type || known.pValue == null) continue;
                attr.pValue = known.pValue;
                break;
            }
            if (attr.pValue != null) continue;
            for (int j = 0; j < i; ++j) {
                desiredAttributes[j].pValue = null;
            }
            try {
                session.token.p11.C_GetAttributeValue(session.id(), keyID, desiredAttributes);
                break;
            }
            catch (PKCS11Exception e) {
                throw new ProviderException(e);
            }
        }
        return desiredAttributes;
    }

    static SecretKey secretKey(Session session, long keyID, String algorithm, int keyLength, CK_ATTRIBUTE[] attributes) {
        attributes = P11Key.getAttributes(session, keyID, attributes, new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(1L), new CK_ATTRIBUTE(259L), new CK_ATTRIBUTE(354L)});
        return new P11SecretKey(session, keyID, algorithm, keyLength, attributes);
    }

    static SecretKey masterSecretKey(Session session, long keyID, String algorithm, int keyLength, CK_ATTRIBUTE[] attributes, int major, int minor) {
        attributes = P11Key.getAttributes(session, keyID, attributes, new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(1L), new CK_ATTRIBUTE(259L), new CK_ATTRIBUTE(354L)});
        return new P11TlsMasterSecretKey(session, keyID, algorithm, keyLength, attributes, major, minor);
    }

    static PublicKey publicKey(Session session, long keyID, String algorithm, int keyLength, CK_ATTRIBUTE[] attributes) {
        switch (algorithm) {
            case "RSA": {
                return new P11RSAPublicKey(session, keyID, algorithm, keyLength, attributes);
            }
            case "DSA": {
                return new P11DSAPublicKey(session, keyID, algorithm, keyLength, attributes);
            }
            case "DH": {
                return new P11DHPublicKey(session, keyID, algorithm, keyLength, attributes);
            }
            case "EC": {
                return new P11ECPublicKey(session, keyID, algorithm, keyLength, attributes);
            }
        }
        throw new ProviderException("Unknown public key algorithm " + algorithm);
    }

    static PrivateKey privateKey(Session session, long keyID, String algorithm, int keyLength, CK_ATTRIBUTE[] attributes) {
        if ((attributes = P11Key.getAttributes(session, keyID, attributes, new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(1L), new CK_ATTRIBUTE(259L), new CK_ATTRIBUTE(354L)}))[1].getBoolean() || !attributes[2].getBoolean()) {
            return new P11PrivateKey(session, keyID, algorithm, keyLength, attributes);
        }
        switch (algorithm) {
            case "RSA": {
                boolean crtKey;
                CK_ATTRIBUTE[] attrs2 = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(290L)};
                try {
                    session.token.p11.C_GetAttributeValue(session.id(), keyID, attrs2);
                    crtKey = attrs2[0].pValue instanceof byte[];
                }
                catch (PKCS11Exception e) {
                    crtKey = false;
                }
                if (crtKey) {
                    return new P11RSAPrivateKey(session, keyID, algorithm, keyLength, attributes);
                }
                return new P11RSAPrivateNonCRTKey(session, keyID, algorithm, keyLength, attributes);
            }
            case "DSA": {
                return new P11DSAPrivateKey(session, keyID, algorithm, keyLength, attributes);
            }
            case "DH": {
                return new P11DHPrivateKey(session, keyID, algorithm, keyLength, attributes);
            }
            case "EC": {
                return new P11ECPrivateKey(session, keyID, algorithm, keyLength, attributes);
            }
        }
        throw new ProviderException("Unknown private key algorithm " + algorithm);
    }

    private static final class P11ECPublicKey
    extends P11Key
    implements ECPublicKey {
        private static final long serialVersionUID = -6371481375154806089L;
        private ECPoint w;
        private ECParameterSpec params;
        private byte[] encoded;

        P11ECPublicKey(Session session, long keyID, String algorithm, int keyLength, CK_ATTRIBUTE[] attributes) {
            super(P11Key.PUBLIC, session, keyID, algorithm, keyLength, attributes);
        }

        private synchronized void fetchValues() {
            this.token.ensureValid();
            if (this.w != null) {
                return;
            }
            CK_ATTRIBUTE[] attributes = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(385L), new CK_ATTRIBUTE(384L)};
            this.fetchAttributes(attributes);
            try {
                this.params = P11ECKeyFactory.decodeParameters(attributes[1].getByteArray());
                byte[] ecKey = attributes[0].getByteArray();
                if (!this.token.config.getUseEcX963Encoding()) {
                    DerValue wECPoint = new DerValue(ecKey);
                    if (wECPoint.getTag() != 4) {
                        throw new IOException("Could not DER decode EC point. Unexpected tag: " + wECPoint.getTag());
                    }
                    this.w = P11ECKeyFactory.decodePoint(wECPoint.getDataBytes(), this.params.getCurve());
                } else {
                    this.w = P11ECKeyFactory.decodePoint(ecKey, this.params.getCurve());
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Could not parse key values", e);
            }
        }

        @Override
        public String getFormat() {
            this.token.ensureValid();
            return "X.509";
        }

        @Override
        synchronized byte[] getEncodedInternal() {
            this.token.ensureValid();
            if (this.encoded == null) {
                this.fetchValues();
                try {
                    return ECUtil.x509EncodeECPublicKey(this.w, this.params);
                }
                catch (InvalidKeySpecException e) {
                    throw new ProviderException(e);
                }
            }
            return this.encoded;
        }

        @Override
        public ECPoint getW() {
            this.fetchValues();
            return this.w;
        }

        @Override
        public ECParameterSpec getParams() {
            this.fetchValues();
            return this.params;
        }

        @Override
        public String toString() {
            this.fetchValues();
            return super.toString() + "\n  public x coord: " + this.w.getAffineX() + "\n  public y coord: " + this.w.getAffineY() + "\n  parameters: " + this.params;
        }
    }

    private static final class P11ECPrivateKey
    extends P11Key
    implements ECPrivateKey {
        private static final long serialVersionUID = -7786054399510515515L;
        private BigInteger s;
        private ECParameterSpec params;
        private byte[] encoded;

        P11ECPrivateKey(Session session, long keyID, String algorithm, int keyLength, CK_ATTRIBUTE[] attributes) {
            super(P11Key.PRIVATE, session, keyID, algorithm, keyLength, attributes);
        }

        private synchronized void fetchValues() {
            this.token.ensureValid();
            if (this.s != null) {
                return;
            }
            CK_ATTRIBUTE[] attributes = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(17L), new CK_ATTRIBUTE(384L, this.params)};
            this.fetchAttributes(attributes);
            this.s = attributes[0].getBigInteger();
            try {
                this.params = P11ECKeyFactory.decodeParameters(attributes[1].getByteArray());
            }
            catch (Exception e) {
                throw new RuntimeException("Could not parse key values", e);
            }
        }

        @Override
        public String getFormat() {
            this.token.ensureValid();
            return "PKCS#8";
        }

        @Override
        synchronized byte[] getEncodedInternal() {
            this.token.ensureValid();
            if (this.encoded == null) {
                this.fetchValues();
                try {
                    ECPrivateKey key = ECUtil.generateECPrivateKey(this.s, this.params);
                    this.encoded = key.getEncoded();
                }
                catch (InvalidKeySpecException e) {
                    throw new ProviderException(e);
                }
            }
            return this.encoded;
        }

        @Override
        public BigInteger getS() {
            this.fetchValues();
            return this.s;
        }

        @Override
        public ECParameterSpec getParams() {
            this.fetchValues();
            return this.params;
        }
    }

    private static final class P11DHPublicKey
    extends P11Key
    implements DHPublicKey {
        static final long serialVersionUID = -598383872153843657L;
        private BigInteger y;
        private DHParameterSpec params;
        private byte[] encoded;

        P11DHPublicKey(Session session, long keyID, String algorithm, int keyLength, CK_ATTRIBUTE[] attributes) {
            super(P11Key.PUBLIC, session, keyID, algorithm, keyLength, attributes);
        }

        private synchronized void fetchValues() {
            this.token.ensureValid();
            if (this.y != null) {
                return;
            }
            CK_ATTRIBUTE[] attributes = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(17L), new CK_ATTRIBUTE(304L), new CK_ATTRIBUTE(306L)};
            this.fetchAttributes(attributes);
            this.y = attributes[0].getBigInteger();
            this.params = new DHParameterSpec(attributes[1].getBigInteger(), attributes[2].getBigInteger());
        }

        @Override
        public String getFormat() {
            this.token.ensureValid();
            return "X.509";
        }

        @Override
        synchronized byte[] getEncodedInternal() {
            this.token.ensureValid();
            if (this.encoded == null) {
                this.fetchValues();
                try {
                    DHPublicKeySpec spec = new DHPublicKeySpec(this.y, this.params.getP(), this.params.getG());
                    KeyFactory kf = KeyFactory.getInstance("DH", P11Util.getSunJceProvider());
                    PublicKey key = kf.generatePublic(spec);
                    this.encoded = key.getEncoded();
                }
                catch (GeneralSecurityException e) {
                    throw new ProviderException(e);
                }
            }
            return this.encoded;
        }

        @Override
        public BigInteger getY() {
            this.fetchValues();
            return this.y;
        }

        @Override
        public DHParameterSpec getParams() {
            this.fetchValues();
            return this.params;
        }

        @Override
        public String toString() {
            this.fetchValues();
            return super.toString() + "\n  y: " + this.y + "\n  p: " + this.params.getP() + "\n  g: " + this.params.getG();
        }
    }

    private static final class P11DHPrivateKey
    extends P11Key
    implements DHPrivateKey {
        private static final long serialVersionUID = -1698576167364928838L;
        private BigInteger x;
        private DHParameterSpec params;
        private byte[] encoded;

        P11DHPrivateKey(Session session, long keyID, String algorithm, int keyLength, CK_ATTRIBUTE[] attributes) {
            super(P11Key.PRIVATE, session, keyID, algorithm, keyLength, attributes);
        }

        private synchronized void fetchValues() {
            this.token.ensureValid();
            if (this.x != null) {
                return;
            }
            CK_ATTRIBUTE[] attributes = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(17L), new CK_ATTRIBUTE(304L), new CK_ATTRIBUTE(306L)};
            this.fetchAttributes(attributes);
            this.x = attributes[0].getBigInteger();
            this.params = new DHParameterSpec(attributes[1].getBigInteger(), attributes[2].getBigInteger());
        }

        @Override
        public String getFormat() {
            this.token.ensureValid();
            return "PKCS#8";
        }

        @Override
        synchronized byte[] getEncodedInternal() {
            this.token.ensureValid();
            if (this.encoded == null) {
                this.fetchValues();
                try {
                    DHPrivateKeySpec spec = new DHPrivateKeySpec(this.x, this.params.getP(), this.params.getG());
                    KeyFactory kf = KeyFactory.getInstance("DH", P11Util.getSunJceProvider());
                    PrivateKey key = kf.generatePrivate(spec);
                    this.encoded = key.getEncoded();
                }
                catch (GeneralSecurityException e) {
                    throw new ProviderException(e);
                }
            }
            return this.encoded;
        }

        @Override
        public BigInteger getX() {
            this.fetchValues();
            return this.x;
        }

        @Override
        public DHParameterSpec getParams() {
            this.fetchValues();
            return this.params;
        }
    }

    private static final class P11DSAPrivateKey
    extends P11Key
    implements java.security.interfaces.DSAPrivateKey {
        private static final long serialVersionUID = 3119629997181999389L;
        private BigInteger x;
        private DSAParams params;
        private byte[] encoded;

        P11DSAPrivateKey(Session session, long keyID, String algorithm, int keyLength, CK_ATTRIBUTE[] attributes) {
            super(P11Key.PRIVATE, session, keyID, algorithm, keyLength, attributes);
        }

        private synchronized void fetchValues() {
            this.token.ensureValid();
            if (this.x != null) {
                return;
            }
            CK_ATTRIBUTE[] attributes = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(17L), new CK_ATTRIBUTE(304L), new CK_ATTRIBUTE(305L), new CK_ATTRIBUTE(306L)};
            this.fetchAttributes(attributes);
            this.x = attributes[0].getBigInteger();
            this.params = new DSAParameterSpec(attributes[1].getBigInteger(), attributes[2].getBigInteger(), attributes[3].getBigInteger());
        }

        @Override
        public String getFormat() {
            this.token.ensureValid();
            return "PKCS#8";
        }

        @Override
        synchronized byte[] getEncodedInternal() {
            this.token.ensureValid();
            if (this.encoded == null) {
                this.fetchValues();
                try {
                    DSAPrivateKey key = new DSAPrivateKey(this.x, this.params.getP(), this.params.getQ(), this.params.getG());
                    this.encoded = key.getEncoded();
                }
                catch (InvalidKeyException e) {
                    throw new ProviderException(e);
                }
            }
            return this.encoded;
        }

        @Override
        public BigInteger getX() {
            this.fetchValues();
            return this.x;
        }

        @Override
        public DSAParams getParams() {
            this.fetchValues();
            return this.params;
        }
    }

    private static final class P11DSAPublicKey
    extends P11Key
    implements java.security.interfaces.DSAPublicKey {
        private static final long serialVersionUID = 5989753793316396637L;
        private BigInteger y;
        private DSAParams params;
        private byte[] encoded;

        P11DSAPublicKey(Session session, long keyID, String algorithm, int keyLength, CK_ATTRIBUTE[] attributes) {
            super(P11Key.PUBLIC, session, keyID, algorithm, keyLength, attributes);
        }

        private synchronized void fetchValues() {
            this.token.ensureValid();
            if (this.y != null) {
                return;
            }
            CK_ATTRIBUTE[] attributes = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(17L), new CK_ATTRIBUTE(304L), new CK_ATTRIBUTE(305L), new CK_ATTRIBUTE(306L)};
            this.fetchAttributes(attributes);
            this.y = attributes[0].getBigInteger();
            this.params = new DSAParameterSpec(attributes[1].getBigInteger(), attributes[2].getBigInteger(), attributes[3].getBigInteger());
        }

        @Override
        public String getFormat() {
            this.token.ensureValid();
            return "X.509";
        }

        @Override
        synchronized byte[] getEncodedInternal() {
            this.token.ensureValid();
            if (this.encoded == null) {
                this.fetchValues();
                try {
                    DSAPublicKey key = new DSAPublicKey(this.y, this.params.getP(), this.params.getQ(), this.params.getG());
                    this.encoded = key.getEncoded();
                }
                catch (InvalidKeyException e) {
                    throw new ProviderException(e);
                }
            }
            return this.encoded;
        }

        @Override
        public BigInteger getY() {
            this.fetchValues();
            return this.y;
        }

        @Override
        public DSAParams getParams() {
            this.fetchValues();
            return this.params;
        }

        @Override
        public String toString() {
            this.fetchValues();
            return super.toString() + "\n  y: " + this.y + "\n  p: " + this.params.getP() + "\n  q: " + this.params.getQ() + "\n  g: " + this.params.getG();
        }
    }

    private static final class P11RSAPublicKey
    extends P11Key
    implements RSAPublicKey {
        private static final long serialVersionUID = -826726289023854455L;
        private BigInteger n;
        private BigInteger e;
        private byte[] encoded;

        P11RSAPublicKey(Session session, long keyID, String algorithm, int keyLength, CK_ATTRIBUTE[] attributes) {
            super(P11Key.PUBLIC, session, keyID, algorithm, keyLength, attributes);
        }

        private synchronized void fetchValues() {
            this.token.ensureValid();
            if (this.n != null) {
                return;
            }
            CK_ATTRIBUTE[] attributes = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(288L), new CK_ATTRIBUTE(290L)};
            this.fetchAttributes(attributes);
            this.n = attributes[0].getBigInteger();
            this.e = attributes[1].getBigInteger();
        }

        @Override
        public String getFormat() {
            this.token.ensureValid();
            return "X.509";
        }

        @Override
        synchronized byte[] getEncodedInternal() {
            this.token.ensureValid();
            if (this.encoded == null) {
                this.fetchValues();
                try {
                    this.encoded = new RSAPublicKeyImpl(this.n, this.e).getEncoded();
                }
                catch (InvalidKeyException e) {
                    throw new ProviderException(e);
                }
            }
            return this.encoded;
        }

        @Override
        public BigInteger getModulus() {
            this.fetchValues();
            return this.n;
        }

        @Override
        public BigInteger getPublicExponent() {
            this.fetchValues();
            return this.e;
        }

        @Override
        public String toString() {
            this.fetchValues();
            return super.toString() + "\n  modulus: " + this.n + "\n  public exponent: " + this.e;
        }
    }

    private static final class P11RSAPrivateNonCRTKey
    extends P11Key
    implements RSAPrivateKey {
        private static final long serialVersionUID = 1137764983777411481L;
        private BigInteger n;
        private BigInteger d;
        private byte[] encoded;

        P11RSAPrivateNonCRTKey(Session session, long keyID, String algorithm, int keyLength, CK_ATTRIBUTE[] attributes) {
            super(P11Key.PRIVATE, session, keyID, algorithm, keyLength, attributes);
        }

        private synchronized void fetchValues() {
            this.token.ensureValid();
            if (this.n != null) {
                return;
            }
            CK_ATTRIBUTE[] attributes = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(288L), new CK_ATTRIBUTE(291L)};
            this.fetchAttributes(attributes);
            this.n = attributes[0].getBigInteger();
            this.d = attributes[1].getBigInteger();
        }

        @Override
        public String getFormat() {
            this.token.ensureValid();
            return "PKCS#8";
        }

        @Override
        synchronized byte[] getEncodedInternal() {
            this.token.ensureValid();
            if (this.encoded == null) {
                this.fetchValues();
                try {
                    KeyFactory factory = KeyFactory.getInstance("RSA", P11Util.getSunRsaSignProvider());
                    Key newKey = factory.translateKey(this);
                    this.encoded = newKey.getEncoded();
                }
                catch (GeneralSecurityException e) {
                    throw new ProviderException(e);
                }
            }
            return this.encoded;
        }

        @Override
        public BigInteger getModulus() {
            this.fetchValues();
            return this.n;
        }

        @Override
        public BigInteger getPrivateExponent() {
            this.fetchValues();
            return this.d;
        }
    }

    private static final class P11RSAPrivateKey
    extends P11Key
    implements RSAPrivateCrtKey {
        private static final long serialVersionUID = 9215872438913515220L;
        private BigInteger n;
        private BigInteger e;
        private BigInteger d;
        private BigInteger p;
        private BigInteger q;
        private BigInteger pe;
        private BigInteger qe;
        private BigInteger coeff;
        private byte[] encoded;

        P11RSAPrivateKey(Session session, long keyID, String algorithm, int keyLength, CK_ATTRIBUTE[] attributes) {
            super(P11Key.PRIVATE, session, keyID, algorithm, keyLength, attributes);
        }

        private synchronized void fetchValues() {
            this.token.ensureValid();
            if (this.n != null) {
                return;
            }
            CK_ATTRIBUTE[] attributes = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(288L), new CK_ATTRIBUTE(290L), new CK_ATTRIBUTE(291L), new CK_ATTRIBUTE(292L), new CK_ATTRIBUTE(293L), new CK_ATTRIBUTE(294L), new CK_ATTRIBUTE(295L), new CK_ATTRIBUTE(296L)};
            this.fetchAttributes(attributes);
            this.n = attributes[0].getBigInteger();
            this.e = attributes[1].getBigInteger();
            this.d = attributes[2].getBigInteger();
            this.p = attributes[3].getBigInteger();
            this.q = attributes[4].getBigInteger();
            this.pe = attributes[5].getBigInteger();
            this.qe = attributes[6].getBigInteger();
            this.coeff = attributes[7].getBigInteger();
        }

        @Override
        public String getFormat() {
            this.token.ensureValid();
            return "PKCS#8";
        }

        @Override
        synchronized byte[] getEncodedInternal() {
            this.token.ensureValid();
            if (this.encoded == null) {
                this.fetchValues();
                try {
                    KeyFactory factory = KeyFactory.getInstance("RSA", P11Util.getSunRsaSignProvider());
                    Key newKey = factory.translateKey(this);
                    this.encoded = newKey.getEncoded();
                }
                catch (GeneralSecurityException e) {
                    throw new ProviderException(e);
                }
            }
            return this.encoded;
        }

        @Override
        public BigInteger getModulus() {
            this.fetchValues();
            return this.n;
        }

        @Override
        public BigInteger getPublicExponent() {
            this.fetchValues();
            return this.e;
        }

        @Override
        public BigInteger getPrivateExponent() {
            this.fetchValues();
            return this.d;
        }

        @Override
        public BigInteger getPrimeP() {
            this.fetchValues();
            return this.p;
        }

        @Override
        public BigInteger getPrimeQ() {
            this.fetchValues();
            return this.q;
        }

        @Override
        public BigInteger getPrimeExponentP() {
            this.fetchValues();
            return this.pe;
        }

        @Override
        public BigInteger getPrimeExponentQ() {
            this.fetchValues();
            return this.qe;
        }

        @Override
        public BigInteger getCrtCoefficient() {
            this.fetchValues();
            return this.coeff;
        }
    }

    private static class P11TlsMasterSecretKey
    extends P11SecretKey
    implements TlsMasterSecret {
        private static final long serialVersionUID = -1318560923770573441L;
        private final int majorVersion;
        private final int minorVersion;

        P11TlsMasterSecretKey(Session session, long keyID, String algorithm, int keyLength, CK_ATTRIBUTE[] attributes, int major, int minor) {
            super(session, keyID, algorithm, keyLength, attributes);
            this.majorVersion = major;
            this.minorVersion = minor;
        }

        @Override
        public int getMajorVersion() {
            return this.majorVersion;
        }

        @Override
        public int getMinorVersion() {
            return this.minorVersion;
        }
    }

    private static class P11SecretKey
    extends P11Key
    implements SecretKey {
        private static final long serialVersionUID = -7828241727014329084L;
        private volatile byte[] encoded;

        P11SecretKey(Session session, long keyID, String algorithm, int keyLength, CK_ATTRIBUTE[] attributes) {
            super(P11Key.SECRET, session, keyID, algorithm, keyLength, attributes);
        }

        @Override
        public String getFormat() {
            this.token.ensureValid();
            if (this.sensitive || !this.extractable) {
                return null;
            }
            return "RAW";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        byte[] getEncodedInternal() {
            this.token.ensureValid();
            if (this.getFormat() == null) {
                return null;
            }
            byte[] b = this.encoded;
            if (b == null) {
                P11SecretKey p11SecretKey = this;
                synchronized (p11SecretKey) {
                    b = this.encoded;
                    if (b == null) {
                        Session tempSession = null;
                        try {
                            tempSession = this.token.getOpSession();
                            CK_ATTRIBUTE[] attributes = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(17L)};
                            this.token.p11.C_GetAttributeValue(tempSession.id(), this.keyID, attributes);
                            b = attributes[0].getByteArray();
                        }
                        catch (PKCS11Exception e) {
                            throw new ProviderException(e);
                        }
                        finally {
                            this.token.releaseSession(tempSession);
                        }
                        this.encoded = b;
                    }
                }
            }
            return b;
        }
    }

    private static final class P11PrivateKey
    extends P11Key
    implements PrivateKey {
        private static final long serialVersionUID = -2138581185214187615L;

        P11PrivateKey(Session session, long keyID, String algorithm, int keyLength, CK_ATTRIBUTE[] attributes) {
            super(P11Key.PRIVATE, session, keyID, algorithm, keyLength, attributes);
        }

        @Override
        public String getFormat() {
            this.token.ensureValid();
            return null;
        }

        @Override
        byte[] getEncodedInternal() {
            this.token.ensureValid();
            return null;
        }
    }
}

