/* autosave-manager.c generated by valac 0.56.3, the Vala compiler
 * generated from autosave-manager.vala, do not modify */

/*
 * Copyright (C) 2011 Timo Kluck
 * Authors: Timo Kluck <tkluck@infty.nl>
 *          Robert Ancell <robert.ancell@canonical.com>
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <glib/gstdio.h>
#include <gobject/gvaluecollector.h>

#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_AUTOSAVE_MANAGER (autosave_manager_get_type ())
#define AUTOSAVE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_AUTOSAVE_MANAGER, AutosaveManager))
#define AUTOSAVE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_AUTOSAVE_MANAGER, AutosaveManagerClass))
#define IS_AUTOSAVE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_AUTOSAVE_MANAGER))
#define IS_AUTOSAVE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_AUTOSAVE_MANAGER))
#define AUTOSAVE_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_AUTOSAVE_MANAGER, AutosaveManagerClass))

typedef struct _AutosaveManager AutosaveManager;
typedef struct _AutosaveManagerClass AutosaveManagerClass;
typedef struct _AutosaveManagerPrivate AutosaveManagerPrivate;

#define TYPE_PAGE (page_get_type ())
#define PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PAGE, Page))
#define PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PAGE, PageClass))
#define IS_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PAGE))
#define IS_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PAGE))
#define PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PAGE, PageClass))

typedef struct _Page Page;
typedef struct _PageClass PageClass;

#define TYPE_BOOK (book_get_type ())
#define BOOK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BOOK, Book))
#define BOOK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BOOK, BookClass))
#define IS_BOOK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BOOK))
#define IS_BOOK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BOOK))
#define BOOK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BOOK, BookClass))

typedef struct _Book Book;
typedef struct _BookClass BookClass;
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_key_file_unref0(var) ((var == NULL) ? NULL : (var = (g_key_file_unref (var), NULL)))
typedef enum  {
	SCAN_DIRECTION_TOP_TO_BOTTOM,
	SCAN_DIRECTION_LEFT_TO_RIGHT,
	SCAN_DIRECTION_BOTTOM_TO_TOP,
	SCAN_DIRECTION_RIGHT_TO_LEFT
} ScanDirection;

#define TYPE_SCAN_DIRECTION (scan_direction_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_dir_close0(var) ((var == NULL) ? NULL : (var = (g_dir_close (var), NULL)))
typedef struct _ParamSpecAutosaveManager ParamSpecAutosaveManager;

struct _AutosaveManager {
	GTypeInstance parent_instance;
	volatile int ref_count;
	AutosaveManagerPrivate * priv;
};

struct _AutosaveManagerClass {
	GTypeClass parent_class;
	void (*finalize) (AutosaveManager *self);
};

struct _AutosaveManagerPrivate {
	guint update_timeout;
	GHashTable* page_filenames;
	Book* book_;
};

struct _ParamSpecAutosaveManager {
	GParamSpec parent_instance;
};

static gint AutosaveManager_private_offset;
static gpointer autosave_manager_parent_class = NULL;
static gchar* autosave_manager_AUTOSAVE_DIR;
static gchar* autosave_manager_AUTOSAVE_DIR = NULL;
static gchar* autosave_manager_AUTOSAVE_FILENAME;
static gchar* autosave_manager_AUTOSAVE_FILENAME = NULL;
static gchar* autosave_manager_AUTOSAVE_PATH;
static gchar* autosave_manager_AUTOSAVE_PATH = NULL;

VALA_EXTERN gpointer autosave_manager_ref (gpointer instance);
VALA_EXTERN void autosave_manager_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_autosave_manager (const gchar* name,
                                         const gchar* nick,
                                         const gchar* blurb,
                                         GType object_type,
                                         GParamFlags flags);
VALA_EXTERN void value_set_autosave_manager (GValue* value,
                                 gpointer v_object);
VALA_EXTERN void value_take_autosave_manager (GValue* value,
                                  gpointer v_object);
VALA_EXTERN gpointer value_get_autosave_manager (const GValue* value);
VALA_EXTERN GType autosave_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AutosaveManager, autosave_manager_unref)
VALA_EXTERN GType page_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Page, g_object_unref)
VALA_EXTERN GType book_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Book, g_object_unref)
VALA_EXTERN AutosaveManager* autosave_manager_new (void);
VALA_EXTERN AutosaveManager* autosave_manager_construct (GType object_type);
static void _g_object_unref0_ (gpointer var);
static void _g_free0_ (gpointer var);
VALA_EXTERN gboolean autosave_manager_exists (AutosaveManager* self);
VALA_EXTERN void autosave_manager_load (AutosaveManager* self);
VALA_EXTERN Book* autosave_manager_get_book (AutosaveManager* self);
VALA_EXTERN void book_clear (Book* self);
static gchar* autosave_manager_get_value (AutosaveManager* self,
                                   GKeyFile* file,
                                   const gchar* group_name,
                                   const gchar* key,
                                   const gchar* _default_);
static gint autosave_manager_get_integer (AutosaveManager* self,
                                   GKeyFile* file,
                                   const gchar* group_name,
                                   const gchar* key,
                                   gint _default_);
VALA_EXTERN GType scan_direction_get_type (void) G_GNUC_CONST ;
static gboolean autosave_manager_get_boolean (AutosaveManager* self,
                                       GKeyFile* file,
                                       const gchar* group_name,
                                       const gchar* key,
                                       gboolean _default_);
VALA_EXTERN Page* page_new_from_data (gint scan_width,
                          gint scan_height,
                          gint rowstride,
                          gint n_channels,
                          gint depth,
                          gint dpi,
                          ScanDirection scan_direction,
                          const gchar* color_profile,
                          guchar* pixels,
                          gint pixels_length1,
                          gboolean has_crop,
                          const gchar* crop_name,
                          gint crop_x,
                          gint crop_y,
                          gint crop_width,
                          gint crop_height);
VALA_EXTERN Page* page_construct_from_data (GType object_type,
                                gint scan_width,
                                gint scan_height,
                                gint rowstride,
                                gint n_channels,
                                gint depth,
                                gint dpi,
                                ScanDirection scan_direction,
                                const gchar* color_profile,
                                guchar* pixels,
                                gint pixels_length1,
                                gboolean has_crop,
                                const gchar* crop_name,
                                gint crop_x,
                                gint crop_y,
                                gint crop_width,
                                gint crop_height);
VALA_EXTERN void book_append_page (Book* self,
                       Page* page);
VALA_EXTERN void autosave_manager_cleanup (AutosaveManager* self);
VALA_EXTERN void autosave_manager_on_page_added (AutosaveManager* self,
                                     Page* page);
VALA_EXTERN void autosave_manager_on_scan_finished (AutosaveManager* self,
                                        Page* page);
static void _autosave_manager_on_scan_finished_page_scan_finished (Page* _sender,
                                                            gpointer self);
VALA_EXTERN void autosave_manager_on_changed (AutosaveManager* self);
static void _autosave_manager_on_changed_page_crop_changed (Page* _sender,
                                                     gpointer self);
VALA_EXTERN void autosave_manager_on_page_removed (AutosaveManager* self,
                                       Page* page);
static void autosave_manager_save_pixels (AutosaveManager* self,
                                   Page* page);
static void autosave_manager_save (AutosaveManager* self,
                            gboolean do_timeout);
VALA_EXTERN void autosave_manager_on_cleared (AutosaveManager* self);
static gboolean ___lambda25_ (AutosaveManager* self);
static void autosave_manager_real_save (AutosaveManager* self);
static gboolean ____lambda25__gsource_func (gpointer self);
VALA_EXTERN guint book_get_n_pages (Book* self);
VALA_EXTERN Page* book_get_page (Book* self,
                     gint page_number);
VALA_EXTERN gboolean page_get_has_data (Page* self);
VALA_EXTERN gint page_get_scan_width (Page* self);
VALA_EXTERN gint page_get_scan_height (Page* self);
VALA_EXTERN gint page_get_rowstride (Page* self);
VALA_EXTERN gint page_get_n_channels (Page* self);
VALA_EXTERN gint page_get_depth (Page* self);
VALA_EXTERN gint page_get_dpi (Page* self);
VALA_EXTERN ScanDirection page_get_scan_direction (Page* self);
VALA_EXTERN const gchar* page_get_color_profile (Page* self);
VALA_EXTERN gboolean page_get_has_crop (Page* self);
VALA_EXTERN const gchar* page_get_crop_name (Page* self);
VALA_EXTERN gint page_get_crop_x (Page* self);
VALA_EXTERN gint page_get_crop_y (Page* self);
VALA_EXTERN gint page_get_crop_width (Page* self);
VALA_EXTERN gint page_get_crop_height (Page* self);
VALA_EXTERN guchar* page_get_pixels (Page* self,
                         gint* result_length1);
VALA_EXTERN void autosave_manager_set_book (AutosaveManager* self,
                                Book* value);
static void _autosave_manager_on_page_added_book_page_added (Book* _sender,
                                                      Page* page,
                                                      gpointer self);
static void _autosave_manager_on_page_removed_book_page_removed (Book* _sender,
                                                          Page* page,
                                                          gpointer self);
static void _autosave_manager_on_changed_book_reordered (Book* _sender,
                                                  gpointer self);
static void _autosave_manager_on_cleared_book_cleared (Book* _sender,
                                                gpointer self);
static void autosave_manager_finalize (AutosaveManager * obj);
static GType autosave_manager_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
autosave_manager_get_instance_private (AutosaveManager* self)
{
	return G_STRUCT_MEMBER_P (self, AutosaveManager_private_offset);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

AutosaveManager*
autosave_manager_construct (GType object_type)
{
	AutosaveManager* self = NULL;
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GHashTable* _tmp2_;
	self = (AutosaveManager*) g_type_create_instance (object_type);
	_tmp0_ = g_direct_hash;
	_tmp1_ = g_direct_equal;
	_tmp2_ = g_hash_table_new_full (_tmp0_, _tmp1_, _g_object_unref0_, _g_free0_);
	_g_hash_table_unref0 (self->priv->page_filenames);
	self->priv->page_filenames = _tmp2_;
	return self;
}

AutosaveManager*
autosave_manager_new (void)
{
	return autosave_manager_construct (TYPE_AUTOSAVE_MANAGER);
}

gboolean
autosave_manager_exists (AutosaveManager* self)
{
	GFile* file = NULL;
	const gchar* _tmp0_;
	GFile* _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = autosave_manager_AUTOSAVE_PATH;
	_tmp1_ = g_file_new_for_path (_tmp0_);
	file = _tmp1_;
	result = g_file_query_exists (file, NULL);
	_g_object_unref0 (file);
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
autosave_manager_load (AutosaveManager* self)
{
	Book* _tmp0_;
	Book* _tmp1_;
	GHashTable* _tmp2_;
	GKeyFile* file = NULL;
	GKeyFile* _tmp3_;
	gchar* pages = NULL;
	GKeyFile* _tmp9_;
	gchar* _tmp10_;
	const gchar* _tmp11_;
	gchar** _tmp12_;
	gchar** _tmp13_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_debug ("autosave-manager.vala:70: Loading autosave information");
	_tmp0_ = autosave_manager_get_book (self);
	_tmp1_ = _tmp0_;
	book_clear (_tmp1_);
	_tmp2_ = self->priv->page_filenames;
	g_hash_table_remove_all (_tmp2_);
	_tmp3_ = g_key_file_new ();
	file = _tmp3_;
	{
		GKeyFile* _tmp4_;
		const gchar* _tmp5_;
		_tmp4_ = file;
		_tmp5_ = autosave_manager_AUTOSAVE_PATH;
		g_key_file_load_from_file (_tmp4_, _tmp5_, G_KEY_FILE_NONE, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp6_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp6_ = e;
		if (!g_error_matches (_tmp6_, G_FILE_ERROR, G_FILE_ERROR_NOENT)) {
			GError* _tmp7_;
			const gchar* _tmp8_;
			_tmp7_ = e;
			_tmp8_ = _tmp7_->message;
			g_warning ("autosave-manager.vala:83: Could not load autosave information; not res" \
"toring any autosaves: %s", _tmp8_);
		}
		_g_error_free0 (e);
		_g_key_file_unref0 (file);
		return;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_key_file_unref0 (file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp9_ = file;
	_tmp10_ = autosave_manager_get_value (self, _tmp9_, "simple-scan", "pages", "");
	pages = _tmp10_;
	_tmp11_ = pages;
	_tmp13_ = _tmp12_ = g_strsplit (_tmp11_, " ", 0);
	{
		gchar** page_name_collection = NULL;
		gint page_name_collection_length1 = 0;
		gint _page_name_collection_size_ = 0;
		gint page_name_it = 0;
		page_name_collection = _tmp13_;
		page_name_collection_length1 = _vala_array_length (_tmp12_);
		for (page_name_it = 0; page_name_it < page_name_collection_length1; page_name_it = page_name_it + 1) {
			gchar* _tmp14_;
			gchar* page_name = NULL;
			_tmp14_ = g_strdup (page_name_collection[page_name_it]);
			page_name = _tmp14_;
			{
				const gchar* _tmp15_;
				gint scan_width = 0;
				GKeyFile* _tmp16_;
				const gchar* _tmp17_;
				gint scan_height = 0;
				GKeyFile* _tmp18_;
				const gchar* _tmp19_;
				gint rowstride = 0;
				GKeyFile* _tmp20_;
				const gchar* _tmp21_;
				gint n_channels = 0;
				GKeyFile* _tmp22_;
				const gchar* _tmp23_;
				gint depth = 0;
				GKeyFile* _tmp24_;
				const gchar* _tmp25_;
				gint dpi = 0;
				GKeyFile* _tmp26_;
				const gchar* _tmp27_;
				gchar* scan_direction_name = NULL;
				GKeyFile* _tmp28_;
				const gchar* _tmp29_;
				gchar* _tmp30_;
				ScanDirection scan_direction = 0;
				const gchar* _tmp31_;
				const gchar* _tmp32_;
				GQuark _tmp34_ = 0U;
				static GQuark _tmp33_label0 = 0;
				static GQuark _tmp33_label1 = 0;
				static GQuark _tmp33_label2 = 0;
				static GQuark _tmp33_label3 = 0;
				gchar* color_profile = NULL;
				GKeyFile* _tmp35_;
				const gchar* _tmp36_;
				gchar* _tmp37_;
				const gchar* _tmp38_;
				gchar* pixels_filename = NULL;
				GKeyFile* _tmp39_;
				const gchar* _tmp40_;
				gchar* _tmp41_;
				gboolean has_crop = FALSE;
				GKeyFile* _tmp42_;
				const gchar* _tmp43_;
				gchar* crop_name = NULL;
				GKeyFile* _tmp44_;
				const gchar* _tmp45_;
				gchar* _tmp46_;
				const gchar* _tmp47_;
				gint crop_x = 0;
				GKeyFile* _tmp48_;
				const gchar* _tmp49_;
				gint crop_y = 0;
				GKeyFile* _tmp50_;
				const gchar* _tmp51_;
				gint crop_width = 0;
				GKeyFile* _tmp52_;
				const gchar* _tmp53_;
				gint crop_height = 0;
				GKeyFile* _tmp54_;
				const gchar* _tmp55_;
				guchar* pixels = NULL;
				gint pixels_length1;
				gint _pixels_size_;
				const gchar* _tmp56_;
				Page* page = NULL;
				const gchar* _tmp65_;
				guchar* _tmp66_;
				gint _tmp66__length1;
				const gchar* _tmp67_;
				Page* _tmp68_;
				GHashTable* _tmp69_;
				Page* _tmp70_;
				Page* _tmp71_;
				const gchar* _tmp72_;
				gchar* _tmp73_;
				Book* _tmp74_;
				Book* _tmp75_;
				Page* _tmp76_;
				_tmp15_ = page_name;
				g_debug ("autosave-manager.vala:89: Loading automatically saved page %s", _tmp15_);
				_tmp16_ = file;
				_tmp17_ = page_name;
				scan_width = autosave_manager_get_integer (self, _tmp16_, _tmp17_, "scan-width", 0);
				_tmp18_ = file;
				_tmp19_ = page_name;
				scan_height = autosave_manager_get_integer (self, _tmp18_, _tmp19_, "scan-height", 0);
				_tmp20_ = file;
				_tmp21_ = page_name;
				rowstride = autosave_manager_get_integer (self, _tmp20_, _tmp21_, "rowstride", 0);
				_tmp22_ = file;
				_tmp23_ = page_name;
				n_channels = autosave_manager_get_integer (self, _tmp22_, _tmp23_, "n-channels", 0);
				_tmp24_ = file;
				_tmp25_ = page_name;
				depth = autosave_manager_get_integer (self, _tmp24_, _tmp25_, "depth", 0);
				_tmp26_ = file;
				_tmp27_ = page_name;
				dpi = autosave_manager_get_integer (self, _tmp26_, _tmp27_, "dpi", 0);
				_tmp28_ = file;
				_tmp29_ = page_name;
				_tmp30_ = autosave_manager_get_value (self, _tmp28_, _tmp29_, "scan-direction", "");
				scan_direction_name = _tmp30_;
				scan_direction = SCAN_DIRECTION_TOP_TO_BOTTOM;
				_tmp31_ = scan_direction_name;
				_tmp32_ = _tmp31_;
				_tmp34_ = (NULL == _tmp32_) ? 0 : g_quark_from_string (_tmp32_);
				if (_tmp34_ == ((0 != _tmp33_label0) ? _tmp33_label0 : (_tmp33_label0 = g_quark_from_static_string ("TOP_TO_BOTTOM")))) {
					switch (0) {
						default:
						{
							scan_direction = SCAN_DIRECTION_TOP_TO_BOTTOM;
							break;
						}
					}
				} else if (_tmp34_ == ((0 != _tmp33_label1) ? _tmp33_label1 : (_tmp33_label1 = g_quark_from_static_string ("LEFT_TO_RIGHT")))) {
					switch (0) {
						default:
						{
							scan_direction = SCAN_DIRECTION_LEFT_TO_RIGHT;
							break;
						}
					}
				} else if (_tmp34_ == ((0 != _tmp33_label2) ? _tmp33_label2 : (_tmp33_label2 = g_quark_from_static_string ("BOTTOM_TO_TOP")))) {
					switch (0) {
						default:
						{
							scan_direction = SCAN_DIRECTION_BOTTOM_TO_TOP;
							break;
						}
					}
				} else if (_tmp34_ == ((0 != _tmp33_label3) ? _tmp33_label3 : (_tmp33_label3 = g_quark_from_static_string ("RIGHT_TO_LEFT")))) {
					switch (0) {
						default:
						{
							scan_direction = SCAN_DIRECTION_RIGHT_TO_LEFT;
							break;
						}
					}
				}
				_tmp35_ = file;
				_tmp36_ = page_name;
				_tmp37_ = autosave_manager_get_value (self, _tmp35_, _tmp36_, "color-profile", "");
				color_profile = _tmp37_;
				_tmp38_ = color_profile;
				if (g_strcmp0 (_tmp38_, "") == 0) {
					_g_free0 (color_profile);
					color_profile = NULL;
				}
				_tmp39_ = file;
				_tmp40_ = page_name;
				_tmp41_ = autosave_manager_get_value (self, _tmp39_, _tmp40_, "pixels-filename", "");
				pixels_filename = _tmp41_;
				_tmp42_ = file;
				_tmp43_ = page_name;
				has_crop = autosave_manager_get_boolean (self, _tmp42_, _tmp43_, "has-crop", FALSE);
				_tmp44_ = file;
				_tmp45_ = page_name;
				_tmp46_ = autosave_manager_get_value (self, _tmp44_, _tmp45_, "crop-name", "");
				crop_name = _tmp46_;
				_tmp47_ = crop_name;
				if (g_strcmp0 (_tmp47_, "") == 0) {
					_g_free0 (crop_name);
					crop_name = NULL;
				}
				_tmp48_ = file;
				_tmp49_ = page_name;
				crop_x = autosave_manager_get_integer (self, _tmp48_, _tmp49_, "crop-x", 0);
				_tmp50_ = file;
				_tmp51_ = page_name;
				crop_y = autosave_manager_get_integer (self, _tmp50_, _tmp51_, "crop-y", 0);
				_tmp52_ = file;
				_tmp53_ = page_name;
				crop_width = autosave_manager_get_integer (self, _tmp52_, _tmp53_, "crop-width", 0);
				_tmp54_ = file;
				_tmp55_ = page_name;
				crop_height = autosave_manager_get_integer (self, _tmp54_, _tmp55_, "crop-height", 0);
				pixels = NULL;
				pixels_length1 = 0;
				_pixels_size_ = pixels_length1;
				_tmp56_ = pixels_filename;
				if (g_strcmp0 (_tmp56_, "") != 0) {
					gchar* path = NULL;
					const gchar* _tmp57_;
					const gchar* _tmp58_;
					gchar* _tmp59_;
					GFile* f = NULL;
					const gchar* _tmp60_;
					GFile* _tmp61_;
					_tmp57_ = autosave_manager_AUTOSAVE_DIR;
					_tmp58_ = pixels_filename;
					_tmp59_ = g_build_filename (_tmp57_, _tmp58_, NULL);
					path = _tmp59_;
					_tmp60_ = path;
					_tmp61_ = g_file_new_for_path (_tmp60_);
					f = _tmp61_;
					{
						GFile* _tmp62_;
						guint8* _tmp63_ = NULL;
						gsize _tmp64_ = 0;
						_tmp62_ = f;
						g_file_load_contents (_tmp62_, NULL, &_tmp63_, &_tmp64_, NULL, &_inner_error0_);
						pixels = (g_free (pixels), NULL);
						pixels = _tmp63_;
						pixels_length1 = _tmp64_;
						_pixels_size_ = pixels_length1;
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
							goto __catch1_g_error;
						}
					}
					goto __finally1;
					__catch1_g_error:
					{
						g_clear_error (&_inner_error0_);
						g_warning ("autosave-manager.vala:138: Failed to load pixel information");
						_g_object_unref0 (f);
						_g_free0 (path);
						pixels = (g_free (pixels), NULL);
						_g_free0 (crop_name);
						_g_free0 (pixels_filename);
						_g_free0 (color_profile);
						_g_free0 (scan_direction_name);
						_g_free0 (page_name);
						continue;
					}
					__finally1:
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						_g_object_unref0 (f);
						_g_free0 (path);
						pixels = (g_free (pixels), NULL);
						_g_free0 (crop_name);
						_g_free0 (pixels_filename);
						_g_free0 (color_profile);
						_g_free0 (scan_direction_name);
						_g_free0 (page_name);
						page_name_collection = (_vala_array_free (page_name_collection, page_name_collection_length1, (GDestroyNotify) g_free), NULL);
						_g_free0 (pages);
						_g_key_file_unref0 (file);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return;
					}
					_g_object_unref0 (f);
					_g_free0 (path);
				}
				_tmp65_ = color_profile;
				_tmp66_ = pixels;
				_tmp66__length1 = pixels_length1;
				_tmp67_ = crop_name;
				_tmp68_ = page_new_from_data (scan_width, scan_height, rowstride, n_channels, depth, dpi, scan_direction, _tmp65_, _tmp66_, _tmp66__length1, has_crop, _tmp67_, crop_x, crop_y, crop_width, crop_height);
				page = _tmp68_;
				_tmp69_ = self->priv->page_filenames;
				_tmp70_ = page;
				_tmp71_ = _g_object_ref0 (_tmp70_);
				_tmp72_ = pixels_filename;
				_tmp73_ = g_strdup (_tmp72_);
				g_hash_table_insert (_tmp69_, _tmp71_, _tmp73_);
				_tmp74_ = autosave_manager_get_book (self);
				_tmp75_ = _tmp74_;
				_tmp76_ = page;
				book_append_page (_tmp75_, _tmp76_);
				_g_object_unref0 (page);
				pixels = (g_free (pixels), NULL);
				_g_free0 (crop_name);
				_g_free0 (pixels_filename);
				_g_free0 (color_profile);
				_g_free0 (scan_direction_name);
				_g_free0 (page_name);
			}
		}
		page_name_collection = (_vala_array_free (page_name_collection, page_name_collection_length1, (GDestroyNotify) g_free), NULL);
	}
	_g_free0 (pages);
	_g_key_file_unref0 (file);
}

static gchar*
autosave_manager_get_value (AutosaveManager* self,
                            GKeyFile* file,
                            const gchar* group_name,
                            const gchar* key,
                            const gchar* _default_)
{
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (file != NULL, NULL);
	g_return_val_if_fail (group_name != NULL, NULL);
	g_return_val_if_fail (key != NULL, NULL);
	g_return_val_if_fail (_default_ != NULL, NULL);
	{
		gchar* _tmp0_ = NULL;
		gchar* _tmp1_;
		gchar* _tmp2_;
		_tmp1_ = g_key_file_get_value (file, group_name, key, &_inner_error0_);
		_tmp0_ = _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp2_ = _tmp0_;
		_tmp0_ = NULL;
		result = _tmp2_;
		_g_free0 (_tmp0_);
		return result;
	}
	goto __finally0;
	__catch0_g_error:
	{
		gchar* _tmp3_;
		g_clear_error (&_inner_error0_);
		_tmp3_ = g_strdup (_default_);
		result = _tmp3_;
		return result;
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static gint
autosave_manager_get_integer (AutosaveManager* self,
                              GKeyFile* file,
                              const gchar* group_name,
                              const gchar* key,
                              gint _default_)
{
	gint _tmp1_ = -1;
	GError* _inner_error0_ = NULL;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (file != NULL, 0);
	g_return_val_if_fail (group_name != NULL, 0);
	g_return_val_if_fail (key != NULL, 0);
	{
		gint _tmp0_ = 0;
		_tmp0_ = g_key_file_get_integer (file, group_name, key, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		result = _tmp0_;
		return result;
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
		result = _default_;
		return result;
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return _tmp1_;
}

static gboolean
autosave_manager_get_boolean (AutosaveManager* self,
                              GKeyFile* file,
                              const gchar* group_name,
                              const gchar* key,
                              gboolean _default_)
{
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (file != NULL, FALSE);
	g_return_val_if_fail (group_name != NULL, FALSE);
	g_return_val_if_fail (key != NULL, FALSE);
	{
		gboolean _tmp0_ = FALSE;
		_tmp0_ = g_key_file_get_boolean (file, group_name, key, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		result = _tmp0_;
		return result;
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
		result = _default_;
		return result;
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return _tmp1_;
}

void
autosave_manager_cleanup (AutosaveManager* self)
{
	GDir* dir = NULL;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_debug ("autosave-manager.vala:201: Deleting autosave records");
	if (self->priv->update_timeout > ((guint) 0)) {
		g_source_remove (self->priv->update_timeout);
	}
	self->priv->update_timeout = (guint) 0;
	{
		GDir* _tmp0_ = NULL;
		const gchar* _tmp1_;
		GDir* _tmp2_;
		GDir* _tmp3_;
		_tmp1_ = autosave_manager_AUTOSAVE_DIR;
		_tmp2_ = g_dir_open (_tmp1_, (guint) 0, &_inner_error0_);
		_tmp0_ = _tmp2_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp3_ = _tmp0_;
		_tmp0_ = NULL;
		_g_dir_close0 (dir);
		dir = _tmp3_;
		_g_dir_close0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp4_;
		const gchar* _tmp5_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		g_warning ("autosave-manager.vala:214: Failed to delete autosaves: %s", _tmp5_);
		_g_error_free0 (e);
		_g_dir_close0 (dir);
		return;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_dir_close0 (dir);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	while (TRUE) {
		gchar* filename = NULL;
		GDir* _tmp6_;
		const gchar* _tmp7_;
		gchar* _tmp8_;
		const gchar* _tmp9_;
		gchar* path = NULL;
		const gchar* _tmp10_;
		const gchar* _tmp11_;
		gchar* _tmp12_;
		const gchar* _tmp13_;
		_tmp6_ = dir;
		_tmp7_ = g_dir_read_name (_tmp6_);
		_tmp8_ = g_strdup (_tmp7_);
		filename = _tmp8_;
		_tmp9_ = filename;
		if (_tmp9_ == NULL) {
			_g_free0 (filename);
			break;
		}
		_tmp10_ = autosave_manager_AUTOSAVE_DIR;
		_tmp11_ = filename;
		_tmp12_ = g_build_filename (_tmp10_, _tmp11_, NULL);
		path = _tmp12_;
		_tmp13_ = path;
		g_unlink (_tmp13_);
		_g_free0 (path);
		_g_free0 (filename);
	}
	_g_dir_close0 (dir);
}

static void
_autosave_manager_on_scan_finished_page_scan_finished (Page* _sender,
                                                       gpointer self)
{
	autosave_manager_on_scan_finished ((AutosaveManager*) self, _sender);
}

static void
_autosave_manager_on_changed_page_crop_changed (Page* _sender,
                                                gpointer self)
{
	autosave_manager_on_changed ((AutosaveManager*) self);
}

void
autosave_manager_on_page_added (AutosaveManager* self,
                                Page* page)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (page != NULL);
	g_signal_connect (page, "scan-finished", (GCallback) _autosave_manager_on_scan_finished_page_scan_finished, self);
	g_signal_connect (page, "crop-changed", (GCallback) _autosave_manager_on_changed_page_crop_changed, self);
}

void
autosave_manager_on_page_removed (AutosaveManager* self,
                                  Page* page)
{
	guint _tmp0_;
	guint _tmp1_;
	gchar* filename = NULL;
	GHashTable* _tmp2_;
	gconstpointer _tmp3_;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	GHashTable* _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (page != NULL);
	g_signal_parse_name ("scan-finished", TYPE_PAGE, &_tmp0_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (page, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp0_, 0, NULL, (GCallback) _autosave_manager_on_scan_finished_page_scan_finished, self);
	g_signal_parse_name ("crop-changed", TYPE_PAGE, &_tmp1_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (page, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _autosave_manager_on_changed_page_crop_changed, self);
	_tmp2_ = self->priv->page_filenames;
	_tmp3_ = g_hash_table_lookup (_tmp2_, page);
	_tmp4_ = g_strdup ((const gchar*) _tmp3_);
	filename = _tmp4_;
	_tmp5_ = filename;
	if (_tmp5_ != NULL) {
		const gchar* _tmp6_;
		_tmp6_ = filename;
		g_unlink (_tmp6_);
	}
	_tmp7_ = self->priv->page_filenames;
	g_hash_table_remove (_tmp7_, page);
	_g_free0 (filename);
}

void
autosave_manager_on_scan_finished (AutosaveManager* self,
                                   Page* page)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (page != NULL);
	autosave_manager_save_pixels (self, page);
	autosave_manager_save (self, FALSE);
}

void
autosave_manager_on_changed (AutosaveManager* self)
{
	g_return_if_fail (self != NULL);
	autosave_manager_save (self, TRUE);
}

void
autosave_manager_on_cleared (AutosaveManager* self)
{
	GHashTable* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->page_filenames;
	g_hash_table_remove_all (_tmp0_);
	autosave_manager_save (self, TRUE);
}

static gboolean
___lambda25_ (AutosaveManager* self)
{
	gboolean result;
	autosave_manager_real_save (self);
	self->priv->update_timeout = (guint) 0;
	result = FALSE;
	return result;
}

static gboolean
____lambda25__gsource_func (gpointer self)
{
	gboolean result;
	result = ___lambda25_ ((AutosaveManager*) self);
	return result;
}

static void
autosave_manager_save (AutosaveManager* self,
                       gboolean do_timeout)
{
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	if (self->priv->update_timeout == ((guint) 0)) {
		_tmp0_ = do_timeout;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		g_debug ("autosave-manager.vala:265: Waiting to autosave...");
	}
	if (self->priv->update_timeout > ((guint) 0)) {
		g_source_remove (self->priv->update_timeout);
	}
	self->priv->update_timeout = (guint) 0;
	if (do_timeout) {
		self->priv->update_timeout = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 100, ____lambda25__gsource_func, autosave_manager_ref (self), autosave_manager_unref);
	} else {
		autosave_manager_real_save (self);
	}
}

static void
autosave_manager_real_save (AutosaveManager* self)
{
	GKeyFile* file = NULL;
	GKeyFile* _tmp0_;
	gchar* page_names = NULL;
	gchar* _tmp1_;
	GKeyFile* _tmp106_;
	const gchar* _tmp107_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_debug ("autosave-manager.vala:287: Autosaving book information");
	_tmp0_ = g_key_file_new ();
	file = _tmp0_;
	_tmp1_ = g_strdup ("");
	page_names = _tmp1_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp2_ = FALSE;
			_tmp2_ = TRUE;
			while (TRUE) {
				Book* _tmp4_;
				Book* _tmp5_;
				guint _tmp6_;
				guint _tmp7_;
				Page* page = NULL;
				Book* _tmp8_;
				Book* _tmp9_;
				Page* _tmp10_;
				Page* _tmp11_;
				gboolean _tmp12_;
				gboolean _tmp13_;
				gchar* page_name = NULL;
				gchar* _tmp14_;
				const gchar* _tmp15_;
				const gchar* _tmp18_;
				const gchar* _tmp19_;
				gchar* _tmp20_;
				const gchar* _tmp21_;
				GKeyFile* _tmp22_;
				const gchar* _tmp23_;
				Page* _tmp24_;
				gint _tmp25_;
				gint _tmp26_;
				GKeyFile* _tmp27_;
				const gchar* _tmp28_;
				Page* _tmp29_;
				gint _tmp30_;
				gint _tmp31_;
				GKeyFile* _tmp32_;
				const gchar* _tmp33_;
				Page* _tmp34_;
				gint _tmp35_;
				gint _tmp36_;
				GKeyFile* _tmp37_;
				const gchar* _tmp38_;
				Page* _tmp39_;
				gint _tmp40_;
				gint _tmp41_;
				GKeyFile* _tmp42_;
				const gchar* _tmp43_;
				Page* _tmp44_;
				gint _tmp45_;
				gint _tmp46_;
				GKeyFile* _tmp47_;
				const gchar* _tmp48_;
				Page* _tmp49_;
				gint _tmp50_;
				gint _tmp51_;
				Page* _tmp52_;
				ScanDirection _tmp53_;
				ScanDirection _tmp54_;
				const gchar* _tmp63_ = NULL;
				Page* _tmp64_;
				const gchar* _tmp65_;
				const gchar* _tmp66_;
				GKeyFile* _tmp67_;
				const gchar* _tmp68_;
				const gchar* _tmp69_ = NULL;
				GHashTable* _tmp70_;
				Page* _tmp71_;
				gconstpointer _tmp72_;
				GKeyFile* _tmp73_;
				const gchar* _tmp74_;
				GKeyFile* _tmp75_;
				const gchar* _tmp76_;
				Page* _tmp77_;
				gboolean _tmp78_;
				gboolean _tmp79_;
				const gchar* _tmp80_ = NULL;
				Page* _tmp81_;
				const gchar* _tmp82_;
				const gchar* _tmp83_;
				GKeyFile* _tmp84_;
				const gchar* _tmp85_;
				GKeyFile* _tmp86_;
				const gchar* _tmp87_;
				Page* _tmp88_;
				gint _tmp89_;
				gint _tmp90_;
				GKeyFile* _tmp91_;
				const gchar* _tmp92_;
				Page* _tmp93_;
				gint _tmp94_;
				gint _tmp95_;
				GKeyFile* _tmp96_;
				const gchar* _tmp97_;
				Page* _tmp98_;
				gint _tmp99_;
				gint _tmp100_;
				GKeyFile* _tmp101_;
				const gchar* _tmp102_;
				Page* _tmp103_;
				gint _tmp104_;
				gint _tmp105_;
				if (!_tmp2_) {
					gint _tmp3_;
					_tmp3_ = i;
					i = _tmp3_ + 1;
				}
				_tmp2_ = FALSE;
				_tmp4_ = autosave_manager_get_book (self);
				_tmp5_ = _tmp4_;
				_tmp6_ = book_get_n_pages (_tmp5_);
				_tmp7_ = _tmp6_;
				if (!(((guint) i) < _tmp7_)) {
					break;
				}
				_tmp8_ = autosave_manager_get_book (self);
				_tmp9_ = _tmp8_;
				_tmp10_ = book_get_page (_tmp9_, i);
				page = _tmp10_;
				_tmp11_ = page;
				_tmp12_ = page_get_has_data (_tmp11_);
				_tmp13_ = _tmp12_;
				if (!_tmp13_) {
					_g_object_unref0 (page);
					continue;
				}
				_tmp14_ = g_strdup_printf ("page-%d", i);
				page_name = _tmp14_;
				_tmp15_ = page_names;
				if (g_strcmp0 (_tmp15_, "") != 0) {
					const gchar* _tmp16_;
					gchar* _tmp17_;
					_tmp16_ = page_names;
					_tmp17_ = g_strconcat (_tmp16_, " ", NULL);
					_g_free0 (page_names);
					page_names = _tmp17_;
				}
				_tmp18_ = page_names;
				_tmp19_ = page_name;
				_tmp20_ = g_strconcat (_tmp18_, _tmp19_, NULL);
				_g_free0 (page_names);
				page_names = _tmp20_;
				_tmp21_ = page_name;
				g_debug ("autosave-manager.vala:304: Autosaving page %s", _tmp21_);
				_tmp22_ = file;
				_tmp23_ = page_name;
				_tmp24_ = page;
				_tmp25_ = page_get_scan_width (_tmp24_);
				_tmp26_ = _tmp25_;
				g_key_file_set_integer (_tmp22_, _tmp23_, "scan-width", _tmp26_);
				_tmp27_ = file;
				_tmp28_ = page_name;
				_tmp29_ = page;
				_tmp30_ = page_get_scan_height (_tmp29_);
				_tmp31_ = _tmp30_;
				g_key_file_set_integer (_tmp27_, _tmp28_, "scan-height", _tmp31_);
				_tmp32_ = file;
				_tmp33_ = page_name;
				_tmp34_ = page;
				_tmp35_ = page_get_rowstride (_tmp34_);
				_tmp36_ = _tmp35_;
				g_key_file_set_integer (_tmp32_, _tmp33_, "rowstride", _tmp36_);
				_tmp37_ = file;
				_tmp38_ = page_name;
				_tmp39_ = page;
				_tmp40_ = page_get_n_channels (_tmp39_);
				_tmp41_ = _tmp40_;
				g_key_file_set_integer (_tmp37_, _tmp38_, "n-channels", _tmp41_);
				_tmp42_ = file;
				_tmp43_ = page_name;
				_tmp44_ = page;
				_tmp45_ = page_get_depth (_tmp44_);
				_tmp46_ = _tmp45_;
				g_key_file_set_integer (_tmp42_, _tmp43_, "depth", _tmp46_);
				_tmp47_ = file;
				_tmp48_ = page_name;
				_tmp49_ = page;
				_tmp50_ = page_get_dpi (_tmp49_);
				_tmp51_ = _tmp50_;
				g_key_file_set_integer (_tmp47_, _tmp48_, "dpi", _tmp51_);
				_tmp52_ = page;
				_tmp53_ = page_get_scan_direction (_tmp52_);
				_tmp54_ = _tmp53_;
				switch (_tmp54_) {
					case SCAN_DIRECTION_TOP_TO_BOTTOM:
					{
						GKeyFile* _tmp55_;
						const gchar* _tmp56_;
						_tmp55_ = file;
						_tmp56_ = page_name;
						g_key_file_set_value (_tmp55_, _tmp56_, "scan-direction", "TOP_TO_BOTTOM");
						break;
					}
					case SCAN_DIRECTION_LEFT_TO_RIGHT:
					{
						GKeyFile* _tmp57_;
						const gchar* _tmp58_;
						_tmp57_ = file;
						_tmp58_ = page_name;
						g_key_file_set_value (_tmp57_, _tmp58_, "scan-direction", "LEFT_TO_RIGHT");
						break;
					}
					case SCAN_DIRECTION_BOTTOM_TO_TOP:
					{
						GKeyFile* _tmp59_;
						const gchar* _tmp60_;
						_tmp59_ = file;
						_tmp60_ = page_name;
						g_key_file_set_value (_tmp59_, _tmp60_, "scan-direction", "BOTTOM_TO_TOP");
						break;
					}
					case SCAN_DIRECTION_RIGHT_TO_LEFT:
					{
						GKeyFile* _tmp61_;
						const gchar* _tmp62_;
						_tmp61_ = file;
						_tmp62_ = page_name;
						g_key_file_set_value (_tmp61_, _tmp62_, "scan-direction", "RIGHT_TO_LEFT");
						break;
					}
					default:
					break;
				}
				_tmp64_ = page;
				_tmp65_ = page_get_color_profile (_tmp64_);
				_tmp66_ = _tmp65_;
				_tmp63_ = _tmp66_;
				if (_tmp63_ == NULL) {
					_tmp63_ = "";
				}
				_tmp67_ = file;
				_tmp68_ = page_name;
				g_key_file_set_value (_tmp67_, _tmp68_, "color-profile", _tmp63_);
				_tmp70_ = self->priv->page_filenames;
				_tmp71_ = page;
				_tmp72_ = g_hash_table_lookup (_tmp70_, _tmp71_);
				_tmp69_ = (const gchar*) _tmp72_;
				if (_tmp69_ == NULL) {
					_tmp69_ = "";
				}
				_tmp73_ = file;
				_tmp74_ = page_name;
				g_key_file_set_value (_tmp73_, _tmp74_, "pixels-filename", _tmp69_);
				_tmp75_ = file;
				_tmp76_ = page_name;
				_tmp77_ = page;
				_tmp78_ = page_get_has_crop (_tmp77_);
				_tmp79_ = _tmp78_;
				g_key_file_set_boolean (_tmp75_, _tmp76_, "has-crop", _tmp79_);
				_tmp81_ = page;
				_tmp82_ = page_get_crop_name (_tmp81_);
				_tmp83_ = _tmp82_;
				_tmp80_ = _tmp83_;
				if (_tmp80_ == NULL) {
					_tmp80_ = "";
				}
				_tmp84_ = file;
				_tmp85_ = page_name;
				g_key_file_set_value (_tmp84_, _tmp85_, "crop-name", _tmp80_);
				_tmp86_ = file;
				_tmp87_ = page_name;
				_tmp88_ = page;
				_tmp89_ = page_get_crop_x (_tmp88_);
				_tmp90_ = _tmp89_;
				g_key_file_set_integer (_tmp86_, _tmp87_, "crop-x", _tmp90_);
				_tmp91_ = file;
				_tmp92_ = page_name;
				_tmp93_ = page;
				_tmp94_ = page_get_crop_y (_tmp93_);
				_tmp95_ = _tmp94_;
				g_key_file_set_integer (_tmp91_, _tmp92_, "crop-y", _tmp95_);
				_tmp96_ = file;
				_tmp97_ = page_name;
				_tmp98_ = page;
				_tmp99_ = page_get_crop_width (_tmp98_);
				_tmp100_ = _tmp99_;
				g_key_file_set_integer (_tmp96_, _tmp97_, "crop-width", _tmp100_);
				_tmp101_ = file;
				_tmp102_ = page_name;
				_tmp103_ = page;
				_tmp104_ = page_get_crop_height (_tmp103_);
				_tmp105_ = _tmp104_;
				g_key_file_set_integer (_tmp101_, _tmp102_, "crop-height", _tmp105_);
				_g_free0 (page_name);
				_g_object_unref0 (page);
			}
		}
	}
	_tmp106_ = file;
	_tmp107_ = page_names;
	g_key_file_set_value (_tmp106_, "simple-scan", "pages", _tmp107_);
	{
		const gchar* _tmp108_;
		const gchar* _tmp109_;
		GKeyFile* _tmp110_;
		gchar* _tmp111_;
		gchar* _tmp112_;
		_tmp108_ = autosave_manager_AUTOSAVE_DIR;
		g_mkdir_with_parents (_tmp108_, 0700);
		_tmp109_ = autosave_manager_AUTOSAVE_PATH;
		_tmp110_ = file;
		_tmp111_ = g_key_file_to_data (_tmp110_, NULL, NULL);
		_tmp112_ = _tmp111_;
		g_file_set_contents (_tmp109_, _tmp112_, (gssize) -1, &_inner_error0_);
		_g_free0 (_tmp112_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp113_;
		const gchar* _tmp114_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp113_ = e;
		_tmp114_ = _tmp113_->message;
		g_warning ("autosave-manager.vala:345: Failed to write autosave: %s", _tmp114_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (page_names);
		_g_key_file_unref0 (file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_free0 (page_names);
	_g_key_file_unref0 (file);
}

static void
autosave_manager_save_pixels (AutosaveManager* self,
                              Page* page)
{
	gchar* filename = NULL;
	GHashFunc _tmp0_;
	gchar* _tmp1_;
	gchar* path = NULL;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	GHashTable* _tmp4_;
	Page* _tmp5_;
	gchar* _tmp6_;
	GFile* file = NULL;
	GFile* _tmp7_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (page != NULL);
	_tmp0_ = g_direct_hash;
	_tmp1_ = g_strdup_printf ("%u.pixels", _tmp0_ (page));
	filename = _tmp1_;
	_tmp2_ = autosave_manager_AUTOSAVE_DIR;
	_tmp3_ = g_build_filename (_tmp2_, filename, NULL);
	path = _tmp3_;
	_tmp4_ = self->priv->page_filenames;
	_tmp5_ = _g_object_ref0 (page);
	_tmp6_ = g_strdup (filename);
	g_hash_table_insert (_tmp4_, _tmp5_, _tmp6_);
	g_debug ("autosave-manager.vala:355: Autosaving page pixels to %s", path);
	_tmp7_ = g_file_new_for_path (path);
	file = _tmp7_;
	{
		gint _tmp8_ = 0;
		guchar* _tmp9_;
		_tmp9_ = page_get_pixels (page, &_tmp8_);
		g_file_replace_contents (file, _tmp9_, (gsize) _tmp8_, NULL, FALSE, G_FILE_CREATE_NONE, NULL, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp10_;
		const gchar* _tmp11_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp10_ = e;
		_tmp11_ = _tmp10_->message;
		g_warning ("autosave-manager.vala:364: Failed to autosave page contents: %s", _tmp11_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (file);
		_g_free0 (path);
		_g_free0 (filename);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_object_unref0 (file);
	_g_free0 (path);
	_g_free0 (filename);
}

Book*
autosave_manager_get_book (AutosaveManager* self)
{
	Book* result;
	Book* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->book_;
	result = _tmp0_;
	return result;
}

static void
_autosave_manager_on_page_added_book_page_added (Book* _sender,
                                                 Page* page,
                                                 gpointer self)
{
	autosave_manager_on_page_added ((AutosaveManager*) self, page);
}

static void
_autosave_manager_on_page_removed_book_page_removed (Book* _sender,
                                                     Page* page,
                                                     gpointer self)
{
	autosave_manager_on_page_removed ((AutosaveManager*) self, page);
}

static void
_autosave_manager_on_changed_book_reordered (Book* _sender,
                                             gpointer self)
{
	autosave_manager_on_changed ((AutosaveManager*) self);
}

static void
_autosave_manager_on_cleared_book_cleared (Book* _sender,
                                           gpointer self)
{
	autosave_manager_on_cleared ((AutosaveManager*) self);
}

void
autosave_manager_set_book (AutosaveManager* self,
                           Book* value)
{
	Book* _tmp0_;
	Book* _tmp17_;
	Book* _tmp18_;
	Book* _tmp19_;
	Book* _tmp20_;
	Book* _tmp21_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->book_;
	if (_tmp0_ != NULL) {
		Book* _tmp9_;
		guint _tmp10_;
		Book* _tmp11_;
		guint _tmp12_;
		Book* _tmp13_;
		guint _tmp14_;
		Book* _tmp15_;
		guint _tmp16_;
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp1_ = FALSE;
				_tmp1_ = TRUE;
				while (TRUE) {
					Book* _tmp3_;
					guint _tmp4_;
					guint _tmp5_;
					Page* page = NULL;
					Book* _tmp6_;
					Page* _tmp7_;
					Page* _tmp8_;
					if (!_tmp1_) {
						gint _tmp2_;
						_tmp2_ = i;
						i = _tmp2_ + 1;
					}
					_tmp1_ = FALSE;
					_tmp3_ = self->priv->book_;
					_tmp4_ = book_get_n_pages (_tmp3_);
					_tmp5_ = _tmp4_;
					if (!(((guint) i) < _tmp5_)) {
						break;
					}
					_tmp6_ = self->priv->book_;
					_tmp7_ = book_get_page (_tmp6_, i);
					page = _tmp7_;
					_tmp8_ = page;
					autosave_manager_on_page_removed (self, _tmp8_);
					_g_object_unref0 (page);
				}
			}
		}
		_tmp9_ = self->priv->book_;
		g_signal_parse_name ("page-added", TYPE_BOOK, &_tmp10_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (_tmp9_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp10_, 0, NULL, (GCallback) _autosave_manager_on_page_added_book_page_added, self);
		_tmp11_ = self->priv->book_;
		g_signal_parse_name ("page-removed", TYPE_BOOK, &_tmp12_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (_tmp11_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp12_, 0, NULL, (GCallback) _autosave_manager_on_page_removed_book_page_removed, self);
		_tmp13_ = self->priv->book_;
		g_signal_parse_name ("reordered", TYPE_BOOK, &_tmp14_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (_tmp13_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp14_, 0, NULL, (GCallback) _autosave_manager_on_changed_book_reordered, self);
		_tmp15_ = self->priv->book_;
		g_signal_parse_name ("cleared", TYPE_BOOK, &_tmp16_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (_tmp15_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp16_, 0, NULL, (GCallback) _autosave_manager_on_cleared_book_cleared, self);
	}
	_tmp17_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->book_);
	self->priv->book_ = _tmp17_;
	_tmp18_ = self->priv->book_;
	g_signal_connect (_tmp18_, "page-added", (GCallback) _autosave_manager_on_page_added_book_page_added, self);
	_tmp19_ = self->priv->book_;
	g_signal_connect (_tmp19_, "page-removed", (GCallback) _autosave_manager_on_page_removed_book_page_removed, self);
	_tmp20_ = self->priv->book_;
	g_signal_connect (_tmp20_, "reordered", (GCallback) _autosave_manager_on_changed_book_reordered, self);
	_tmp21_ = self->priv->book_;
	g_signal_connect (_tmp21_, "cleared", (GCallback) _autosave_manager_on_cleared_book_cleared, self);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp22_ = FALSE;
			_tmp22_ = TRUE;
			while (TRUE) {
				Book* _tmp24_;
				guint _tmp25_;
				guint _tmp26_;
				Page* page = NULL;
				Book* _tmp27_;
				Page* _tmp28_;
				Page* _tmp29_;
				if (!_tmp22_) {
					gint _tmp23_;
					_tmp23_ = i;
					i = _tmp23_ + 1;
				}
				_tmp22_ = FALSE;
				_tmp24_ = self->priv->book_;
				_tmp25_ = book_get_n_pages (_tmp24_);
				_tmp26_ = _tmp25_;
				if (!(((guint) i) < _tmp26_)) {
					break;
				}
				_tmp27_ = self->priv->book_;
				_tmp28_ = book_get_page (_tmp27_, i);
				page = _tmp28_;
				_tmp29_ = page;
				autosave_manager_on_page_added (self, _tmp29_);
				_g_object_unref0 (page);
			}
		}
	}
}

static void
value_autosave_manager_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
value_autosave_manager_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		autosave_manager_unref (value->data[0].v_pointer);
	}
}

static void
value_autosave_manager_copy_value (const GValue* src_value,
                                   GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = autosave_manager_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
value_autosave_manager_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
value_autosave_manager_collect_value (GValue* value,
                                      guint n_collect_values,
                                      GTypeCValue* collect_values,
                                      guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		AutosaveManager * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = autosave_manager_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
value_autosave_manager_lcopy_value (const GValue* value,
                                    guint n_collect_values,
                                    GTypeCValue* collect_values,
                                    guint collect_flags)
{
	AutosaveManager ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = autosave_manager_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
param_spec_autosave_manager (const gchar* name,
                             const gchar* nick,
                             const gchar* blurb,
                             GType object_type,
                             GParamFlags flags)
{
	ParamSpecAutosaveManager* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_AUTOSAVE_MANAGER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
value_get_autosave_manager (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_AUTOSAVE_MANAGER), NULL);
	return value->data[0].v_pointer;
}

void
value_set_autosave_manager (GValue* value,
                            gpointer v_object)
{
	AutosaveManager * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_AUTOSAVE_MANAGER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_AUTOSAVE_MANAGER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		autosave_manager_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		autosave_manager_unref (old);
	}
}

void
value_take_autosave_manager (GValue* value,
                             gpointer v_object)
{
	AutosaveManager * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_AUTOSAVE_MANAGER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_AUTOSAVE_MANAGER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		autosave_manager_unref (old);
	}
}

static void
autosave_manager_class_init (AutosaveManagerClass * klass,
                             gpointer klass_data)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	autosave_manager_parent_class = g_type_class_peek_parent (klass);
	((AutosaveManagerClass *) klass)->finalize = autosave_manager_finalize;
	g_type_class_adjust_private_offset (klass, &AutosaveManager_private_offset);
	_tmp0_ = g_get_user_cache_dir ();
	_tmp1_ = g_build_filename (_tmp0_, "simple-scan", "autosaves", NULL);
	autosave_manager_AUTOSAVE_DIR = _tmp1_;
	_tmp2_ = g_strdup ("autosave.book");
	autosave_manager_AUTOSAVE_FILENAME = _tmp2_;
	_tmp3_ = autosave_manager_AUTOSAVE_DIR;
	_tmp4_ = autosave_manager_AUTOSAVE_FILENAME;
	_tmp5_ = g_build_filename (_tmp3_, _tmp4_, NULL);
	autosave_manager_AUTOSAVE_PATH = _tmp5_;
}

static void
autosave_manager_instance_init (AutosaveManager * self,
                                gpointer klass)
{
	self->priv = autosave_manager_get_instance_private (self);
	self->priv->update_timeout = (guint) 0;
	self->priv->book_ = NULL;
	self->ref_count = 1;
}

static void
autosave_manager_finalize (AutosaveManager * obj)
{
	AutosaveManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_AUTOSAVE_MANAGER, AutosaveManager);
	g_signal_handlers_destroy (self);
	_g_hash_table_unref0 (self->priv->page_filenames);
	_g_object_unref0 (self->priv->book_);
}

static GType
autosave_manager_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { value_autosave_manager_init, value_autosave_manager_free_value, value_autosave_manager_copy_value, value_autosave_manager_peek_pointer, "p", value_autosave_manager_collect_value, "p", value_autosave_manager_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (AutosaveManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) autosave_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AutosaveManager), 0, (GInstanceInitFunc) autosave_manager_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType autosave_manager_type_id;
	autosave_manager_type_id = g_type_register_fundamental (g_type_fundamental_next (), "AutosaveManager", &g_define_type_info, &g_define_type_fundamental_info, 0);
	AutosaveManager_private_offset = g_type_add_instance_private (autosave_manager_type_id, sizeof (AutosaveManagerPrivate));
	return autosave_manager_type_id;
}

GType
autosave_manager_get_type (void)
{
	static volatile gsize autosave_manager_type_id__once = 0;
	if (g_once_init_enter (&autosave_manager_type_id__once)) {
		GType autosave_manager_type_id;
		autosave_manager_type_id = autosave_manager_get_type_once ();
		g_once_init_leave (&autosave_manager_type_id__once, autosave_manager_type_id);
	}
	return autosave_manager_type_id__once;
}

gpointer
autosave_manager_ref (gpointer instance)
{
	AutosaveManager * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
autosave_manager_unref (gpointer instance)
{
	AutosaveManager * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		AUTOSAVE_MANAGER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

