/*
 * Decompiled with CFR 0.152.
 */
package com.github.ajalt.mordant.table;

import com.github.ajalt.mordant.rendering.BorderStyle;
import com.github.ajalt.mordant.rendering.OverflowWrap;
import com.github.ajalt.mordant.rendering.TextAlign;
import com.github.ajalt.mordant.rendering.TextStyle;
import com.github.ajalt.mordant.rendering.TextStyleKt;
import com.github.ajalt.mordant.rendering.VerticalAlign;
import com.github.ajalt.mordant.rendering.Whitespace;
import com.github.ajalt.mordant.rendering.Widget;
import com.github.ajalt.mordant.table.Borders;
import com.github.ajalt.mordant.table.Cell;
import com.github.ajalt.mordant.table.CellBuilderInstance;
import com.github.ajalt.mordant.table.CellContent;
import com.github.ajalt.mordant.table.CellStyleBuilder;
import com.github.ajalt.mordant.table.ColumnBuilder;
import com.github.ajalt.mordant.table.ColumnWidth;
import com.github.ajalt.mordant.table.RowBuilderInstance;
import com.github.ajalt.mordant.table.SectionBuilderInstance;
import com.github.ajalt.mordant.table.TableBuilderInstance;
import com.github.ajalt.mordant.table.TableImpl;
import com.github.ajalt.mordant.table.TableLayout;
import com.github.ajalt.mordant.table.TableLayoutKt;
import com.github.ajalt.mordant.widgets.Padding;
import com.github.ajalt.mordant.widgets.PaddingKt;
import com.github.ajalt.mordant.widgets.Text;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J(\u0010\u0005\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u00070\u0006j\u0002`\b0\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0006\u0010\r\u001a\u00020\u000eJH\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\t\u001a\u00020\n2\u0016\u0010\u0013\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u00070\u0006j\u0002`\b0\u00062\u0006\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/github/ajalt/mordant/table/TableLayout;", "", "table", "Lcom/github/ajalt/mordant/table/TableBuilderInstance;", "(Lcom/github/ajalt/mordant/table/TableBuilderInstance;)V", "buildSection", "", "Lcom/github/ajalt/mordant/table/Cell;", "Lcom/github/ajalt/mordant/table/MutableRow;", "section", "Lcom/github/ajalt/mordant/table/SectionBuilderInstance;", "builderWidth", "", "buildTable", "Lcom/github/ajalt/mordant/table/TableImpl;", "insertCell", "", "cell", "Lcom/github/ajalt/mordant/table/CellBuilderInstance;", "rows", "startingX", "startingY", "mordant"})
public final class TableLayout {
    @NotNull
    private final TableBuilderInstance table;

    public TableLayout(@NotNull TableBuilderInstance table) {
        Intrinsics.checkNotNullParameter(table, "table");
        this.table = table;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final TableImpl buildTable() {
        Map map;
        void $this$mapValuesTo$iv$iv;
        void $this$mapValues$iv;
        int it222;
        Object object;
        Iterator<Object> r;
        Iterator<Object> iterator2;
        Object object2 = new SectionBuilderInstance[]{this.table.getHeaderSection(), this.table.getBodySection(), this.table.getFooterSection()};
        object2 = CollectionsKt.listOf(object2);
        boolean bl = false;
        Iterator iterator3 = object2.iterator();
        if (!iterator3.hasNext()) {
            throw (Throwable)new NoSuchElementException();
        }
        SectionBuilderInstance it222 = (SectionBuilderInstance)iterator3.next();
        boolean bl2 = false;
        Iterable iterable = it222.getRows();
        boolean bl3 = false;
        Iterator iterator4 = iterable.iterator();
        if (!iterator4.hasNext()) {
            iterator2 = null;
        } else {
            r = (RowBuilderInstance)iterator4.next();
            boolean bl4 = false;
            r = ((RowBuilderInstance)((Object)r)).getCells().size();
            while (iterator4.hasNext()) {
                Object r2 = (RowBuilderInstance)iterator4.next();
                bl6 = false;
                if (r.compareTo((Object)(r2 = (Comparable)Integer.valueOf(((RowBuilderInstance)r2).getCells().size()))) >= 0) continue;
                r = r2;
            }
            iterator2 = r;
        }
        Integer n = (Integer)((Object)iterator2);
        int n2 = it222 = n == null ? 0 : n;
        while (iterator3.hasNext()) {
            Object object3;
            SectionBuilderInstance it = (SectionBuilderInstance)iterator3.next();
            $i$a$-maxOf-TableLayout$buildTable$builderWidth$2 = false;
            Iterable iterable2 = it.getRows();
            boolean bl5 = false;
            r = iterable2.iterator();
            if (!r.hasNext()) {
                object3 = null;
            } else {
                Object r3 = (RowBuilderInstance)r.next();
                boolean bl6 = false;
                r3 = ((RowBuilderInstance)r3).getCells().size();
                while (r.hasNext()) {
                    RowBuilderInstance r4 = (RowBuilderInstance)r.next();
                    $i$a$-maxOfOrNull-TableLayout$buildTable$builderWidth$1$1 = false;
                    Comparable comparable = Integer.valueOf(r4.getCells().size());
                    if (r3.compareTo(comparable) >= 0) continue;
                    r3 = comparable;
                }
                object3 = r3;
            }
            if (it222 >= (it = (object = (Integer)object3) == null ? 0 : (Integer)object)) continue;
            it222 = it;
        }
        int builderWidth = it222;
        List<List<Cell>> header = this.buildSection(this.table.getHeaderSection(), builderWidth);
        List<List<Cell>> body = this.buildSection(this.table.getBodySection(), builderWidth);
        List<List<Cell>> footer = this.buildSection(this.table.getFooterSection(), builderWidth);
        Object it222 = new List[]{header, body, footer};
        List list = CollectionsKt.flatten((Iterable)CollectionsKt.listOf(it222));
        it222 = this.table.getColumns();
        int n3 = footer.size();
        int n4 = header.size();
        TextStyle textStyle = this.table.getBorderTextStyle();
        BorderStyle borderStyle = this.table.getBorderStyle();
        List list2 = list;
        boolean $i$f$mapValues = false;
        void $i$a$-maxOf-TableLayout$buildTable$builderWidth$2 = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity($this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it;
            void it$iv$iv;
            object = (Map.Entry)element$iv$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl7 = false;
            Object k = it$iv$iv.getKey();
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Object k2 = k;
            map = map2;
            boolean bl8 = false;
            ColumnWidth columnWidth = ((ColumnBuilder)it.getValue()).getWidth();
            map.put(k2, columnWidth);
        }
        map = destination$iv$iv;
        boolean bl9 = this.table.getOuterBorder();
        Map map3 = map;
        int n5 = n3;
        int n6 = n4;
        TextStyle textStyle2 = textStyle;
        BorderStyle borderStyle2 = borderStyle;
        List list3 = list2;
        return new TableImpl(list3, borderStyle2, textStyle2, n6, n5, map3, bl9);
    }

    private final List<List<Cell>> buildSection(SectionBuilderInstance section, int builderWidth) {
        int n = section.getRows().size();
        int n2 = 0;
        ArrayList<List> arrayList = new ArrayList<List>(n);
        boolean bl = false;
        int n3 = 0;
        n3 = 0;
        int n4 = n;
        while (n3 < n4) {
            int n5 = n3++;
            boolean bl2 = false;
            int n6 = n5;
            ArrayList<List> arrayList2 = arrayList;
            boolean bl3 = false;
            List list = new ArrayList(section.getRows().size());
            arrayList2.add(list);
        }
        List rows = arrayList;
        Iterator<RowBuilderInstance> iterator2 = section.getRows().iterator();
        n2 = 0;
        while (iterator2.hasNext()) {
            int y = n2++;
            RowBuilderInstance row2 = iterator2.next();
            int x = 0;
            for (CellBuilderInstance cellBuilder : row2.getCells()) {
                x = TableLayoutKt.access$findEmptyColumn(rows, x, y);
                this.insertCell(cellBuilder, section, rows, x, y, builderWidth);
                ++x;
            }
        }
        return rows;
    }

    private final void insertCell(CellBuilderInstance cell2, SectionBuilderInstance section, List<List<Cell>> rows, int startingX, int startingY, int builderWidth) {
        Widget widget;
        Comparable comparable;
        ColumnBuilder tableCol = this.table.getColumns().get(startingX);
        CellStyleBuilder sectionCol = section.getColumns().get(startingX);
        RowBuilderInstance row2 = section.getRows().get(startingY);
        Iterable iterable = RangesKt.until(startingY, startingY + cell2.getRowSpan());
        boolean bl = false;
        Iterator iterator2 = iterable.iterator();
        if (!iterator2.hasNext()) {
            comparable = null;
        } else {
            int n;
            Object object;
            int it22 = ((IntIterator)iterator2).nextInt();
            boolean bl2 = false;
            RowBuilderInstance rowBuilderInstance = CollectionsKt.getOrNull(section.getRows(), it22);
            Comparable it22 = Integer.valueOf(rowBuilderInstance == null ? 0 : ((object = rowBuilderInstance.getCells()) == null ? 0 : (n = object.size())));
            while (iterator2.hasNext()) {
                int n2;
                List<CellBuilderInstance> list;
                int it32 = ((IntIterator)iterator2).nextInt();
                $i$a$-maxOfOrNull-TableLayout$insertCell$maxRowSize$1 = false;
                object = CollectionsKt.getOrNull(section.getRows(), it32);
                Comparable it32 = Integer.valueOf(object == null ? 0 : ((list = ((RowBuilderInstance)object).getCells()) == null ? 0 : (n2 = list.size())));
                if (it22.compareTo(it32) >= 0) continue;
                it22 = it32;
            }
            comparable = it22;
        }
        Integer n = (Integer)comparable;
        int maxRowSize = n == null ? 0 : n;
        int columnSpan = RangesKt.coerceAtMost(cell2.getColumnSpan(), builderWidth - maxRowSize + 1);
        int rowSpan = RangesKt.coerceAtMost(cell2.getRowSpan(), rows.size() - startingY);
        Borders borders2 = TableLayout.insertCell$getStyle(cell2, row2, sectionCol, tableCol, section, this, Borders.ALL, insertCell.borders.1.INSTANCE);
        Padding padding2 = TableLayout.insertCell$getStyle(cell2, row2, sectionCol, tableCol, section, this, Padding.Companion.horizontal(1), insertCell.padding.1.INSTANCE);
        Whitespace whitespace2 = TableLayout.insertCell$getStyle(cell2, row2, sectionCol, tableCol, section, this, Whitespace.PRE, insertCell.whitespace.1.INSTANCE);
        TextAlign textAlign2 = TableLayout.insertCell$getStyle(cell2, row2, sectionCol, tableCol, section, this, TextAlign.LEFT, insertCell.textAlign.1.INSTANCE);
        VerticalAlign verticalAlign2 = TableLayout.insertCell$getStyle(cell2, row2, sectionCol, tableCol, section, this, VerticalAlign.TOP, insertCell.verticalAlign.1.INSTANCE);
        OverflowWrap overflowWrap2 = TableLayout.insertCell$getStyle(cell2, row2, sectionCol, tableCol, section, this, OverflowWrap.ELLIPSES, insertCell.overflowWrap.1.INSTANCE);
        Collection collection = section.getRowStyles();
        boolean bl3 = false;
        TextStyle stripedStyle = !collection.isEmpty() ? section.getRowStyles().get(startingY % section.getRowStyles().size()) : null;
        TextStyle[] textStyleArray = new TextStyle[7];
        textStyleArray[0] = cell2.getStyle();
        textStyleArray[1] = row2.getStyle();
        textStyleArray[2] = stripedStyle;
        Object object = sectionCol;
        textStyleArray[3] = object == null ? null : object.getStyle();
        object = tableCol;
        textStyleArray[4] = object == null ? null : object.getStyle();
        textStyleArray[5] = section.getStyle();
        textStyleArray[6] = this.table.getStyle();
        TextStyle style = TextStyleKt.foldStyles(textStyleArray);
        object = cell2.getContent();
        if (object instanceof CellContent.WidgetContent) {
            widget = ((CellContent.WidgetContent)cell2.getContent()).getWidget();
        } else if (object instanceof CellContent.TextContent) {
            widget = new Text(((CellContent.TextContent)cell2.getContent()).getText(), whitespace2, textAlign2, overflowWrap2, null, null, 48, null);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        Widget content = PaddingKt.withPadding$default(widget, padding2, false, 2, null);
        Boolean bl4 = borders2.getRight();
        int n3 = 0;
        boolean bl5 = false;
        boolean bl6 = bl4;
        Boolean bl7 = borders2.getTop();
        Boolean bl8 = borders2.getLeft();
        int n4 = columnSpan;
        int n5 = rowSpan;
        Object object2 = content;
        boolean bl9 = false;
        boolean bl10 = columnSpan == 1;
        Boolean bl11 = bl10 ? bl4 : null;
        bl4 = borders2.getBottom();
        n3 = 0;
        bl5 = false;
        boolean it = bl4;
        Boolean bl12 = bl11;
        boolean bl13 = false;
        boolean bl14 = rowSpan == 1;
        VerticalAlign verticalAlign3 = verticalAlign2;
        TextAlign textAlign3 = textAlign2;
        TextStyle textStyle = style;
        Boolean bl15 = bl14 ? bl4 : null;
        Boolean bl16 = bl12;
        Boolean bl17 = bl7;
        Boolean bl18 = bl8;
        int n6 = n4;
        int n7 = n5;
        Widget widget2 = object2;
        Cell.Content builtCell = new Cell.Content(widget2, n7, n6, bl18, bl17, bl16, bl15, textStyle, textAlign3, verticalAlign3);
        int lastX = startingX + columnSpan - 1;
        n3 = startingX;
        if (n3 <= lastX) {
            int x;
            do {
                int y;
                x = n3++;
                int n8 = startingY;
                int lastY = startingY + rowSpan - 1;
                if (n8 > lastY) continue;
                do {
                    boolean bl19;
                    boolean bl20;
                    Cell cell3;
                    y = n8++;
                    if (x == startingX && y == startingY) {
                        cell3 = builtCell;
                    } else {
                        Boolean bl21 = borders2.getLeft();
                        boolean bl22 = false;
                        bl20 = false;
                        bl19 = bl21;
                        object2 = builtCell;
                        boolean bl23 = false;
                        n5 = x == startingX ? 1 : 0;
                        Boolean bl24 = n5 != 0 ? bl21 : null;
                        bl21 = borders2.getTop();
                        bl22 = false;
                        bl20 = false;
                        boolean it2 = bl21;
                        Boolean bl25 = bl24;
                        boolean bl26 = false;
                        n4 = y == startingY ? 1 : 0;
                        Boolean bl27 = n4 != 0 ? bl21 : null;
                        bl21 = borders2.getRight();
                        bl22 = false;
                        bl20 = false;
                        it2 = bl21;
                        Boolean bl28 = bl27;
                        boolean bl29 = false;
                        boolean bl30 = x == lastX;
                        Boolean bl31 = bl30 ? bl21 : null;
                        bl21 = borders2.getBottom();
                        bl22 = false;
                        bl20 = false;
                        it2 = bl21;
                        bl8 = bl31;
                        boolean bl32 = false;
                        bl7 = y == lastY;
                        Boolean bl33 = bl7 != false ? bl21 : null;
                        Boolean bl34 = bl8;
                        Boolean bl35 = bl28;
                        Boolean bl36 = bl25;
                        Object object3 = object2;
                        cell3 = new Cell.SpanRef((Cell.Content)object3, bl36, bl35, bl34, bl33);
                    }
                    Cell c = cell3;
                    List tableRow = TableLayoutKt.access$getRow(rows, y);
                    Cell existing = TableLayoutKt.access$getCell(tableRow, x);
                    bl20 = existing == Cell.Empty.INSTANCE;
                    bl19 = false;
                    boolean bl37 = false;
                    if (!bl20) {
                        boolean bl38 = false;
                        String string = "Invalid table: cell spans cannot overlap";
                        throw (Throwable)new IllegalArgumentException(string.toString());
                    }
                    tableRow.set(x, c);
                } while (y != lastY);
            } while (x != lastX);
        }
    }

    private static final <T> T insertCell$getStyle(CellBuilderInstance $cell, RowBuilderInstance row2, CellStyleBuilder sectionCol, ColumnBuilder tableCol, SectionBuilderInstance $section, TableLayout this$0, T t, Function1<? super CellStyleBuilder, ? extends T> getter) {
        Object object;
        T t2 = getter.invoke($cell);
        if (t2 == null) {
            T t3 = getter.invoke(row2);
            if (t3 == null) {
                Object var10_16;
                boolean bl;
                CellStyleBuilder cellStyleBuilder;
                Object v0;
                CellStyleBuilder cellStyleBuilder2 = sectionCol;
                if (cellStyleBuilder2 == null) {
                    v0 = null;
                } else {
                    cellStyleBuilder = cellStyleBuilder2;
                    boolean bl2 = false;
                    bl = false;
                    v0 = var10_16 = getter.invoke(cellStyleBuilder);
                }
                if (var10_16 == null) {
                    T t4;
                    CellStyleBuilder cellStyleBuilder3;
                    cellStyleBuilder = tableCol;
                    if (cellStyleBuilder == null) {
                        cellStyleBuilder3 = null;
                    } else {
                        CellStyleBuilder cellStyleBuilder4 = cellStyleBuilder;
                        bl = false;
                        boolean bl3 = false;
                        cellStyleBuilder3 = cellStyleBuilder2 = (CellStyleBuilder)getter.invoke(cellStyleBuilder4);
                    }
                    object = cellStyleBuilder2 == null ? ((cellStyleBuilder = getter.invoke($section)) == null ? ((t4 = getter.invoke(this$0.table)) == null ? t : t4) : cellStyleBuilder) : cellStyleBuilder2;
                } else {
                    object = var10_16;
                }
            } else {
                object = t3;
            }
        } else {
            object = t2;
        }
        return object;
    }
}

