/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.naming.NamingException;
import javax.servlet.AsyncContext;
import javax.servlet.AsyncEvent;
import javax.servlet.AsyncListener;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.AsyncDispatcher;
import org.apache.catalina.Context;
import org.apache.catalina.Globals;
import org.apache.catalina.Host;
import org.apache.catalina.connector.Request;
import org.apache.catalina.core.AsyncListenerWrapper;
import org.apache.catalina.core.StandardHostValve;
import org.apache.coyote.ActionCode;
import org.apache.coyote.AsyncContextCallback;
import org.apache.coyote.RequestInfo;
import org.apache.coyote.Response;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.buf.UDecoder;
import org.apache.tomcat.util.res.StringManager;

public class AsyncContextImpl
implements AsyncContext,
AsyncContextCallback {
    private static final Log log = LogFactory.getLog(AsyncContextImpl.class);
    protected static final StringManager sm = StringManager.getManager(AsyncContextImpl.class);
    private final Object asyncContextLock = new Object();
    private volatile ServletRequest servletRequest = null;
    private volatile ServletResponse servletResponse = null;
    private final List<AsyncListenerWrapper> listeners = new ArrayList<AsyncListenerWrapper>();
    private boolean hasOriginalRequestAndResponse = true;
    private volatile Runnable dispatch = null;
    private Context context = null;
    private long timeout = -1L;
    private AsyncEvent event = null;
    private volatile Request request;

    public AsyncContextImpl(Request request) {
        if (log.isDebugEnabled()) {
            this.logDebug("Constructor");
        }
        this.request = request;
    }

    public void complete() {
        if (log.isDebugEnabled()) {
            this.logDebug("complete   ");
        }
        this.check();
        this.request.getCoyoteRequest().action(ActionCode.ASYNC_COMPLETE, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireOnComplete() {
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("asyncContextImpl.fireOnComplete"));
        }
        ArrayList<AsyncListenerWrapper> arrayList = new ArrayList<AsyncListenerWrapper>(this.listeners);
        ClassLoader classLoader = this.context.bind(Globals.IS_SECURITY_ENABLED, null);
        try {
            for (AsyncListenerWrapper asyncListenerWrapper : arrayList) {
                try {
                    asyncListenerWrapper.fireOnComplete(this.event);
                }
                catch (Throwable throwable) {
                    ExceptionUtils.handleThrowable((Throwable)throwable);
                    log.warn((Object)sm.getString("asyncContextImpl.onCompleteError", new Object[]{asyncListenerWrapper.getClass().getName()}), throwable);
                }
            }
        }
        finally {
            this.context.fireRequestDestroyEvent((ServletRequest)this.request.getRequest());
            this.clearServletRequestResponse();
            this.context.unbind(Globals.IS_SECURITY_ENABLED, classLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean timeout() {
        AtomicBoolean atomicBoolean = new AtomicBoolean();
        this.request.getCoyoteRequest().action(ActionCode.ASYNC_TIMEOUT, (Object)atomicBoolean);
        Context context = this.context;
        if (atomicBoolean.get()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)sm.getString("asyncContextImpl.fireOnTimeout"));
            }
            ClassLoader classLoader = context.bind(false, null);
            try {
                ArrayList<AsyncListenerWrapper> arrayList = new ArrayList<AsyncListenerWrapper>(this.listeners);
                for (AsyncListenerWrapper asyncListenerWrapper : arrayList) {
                    try {
                        asyncListenerWrapper.fireOnTimeout(this.event);
                    }
                    catch (Throwable throwable) {
                        ExceptionUtils.handleThrowable((Throwable)throwable);
                        log.warn((Object)sm.getString("asyncContextImpl.onTimeoutError", new Object[]{asyncListenerWrapper.getClass().getName()}), throwable);
                    }
                }
                this.request.getCoyoteRequest().action(ActionCode.ASYNC_IS_TIMINGOUT, (Object)atomicBoolean);
            }
            finally {
                context.unbind(false, classLoader);
            }
        }
        return !atomicBoolean.get();
    }

    public void dispatch() {
        String string;
        String string2;
        this.check();
        ServletRequest servletRequest = this.getRequest();
        if (servletRequest instanceof HttpServletRequest) {
            HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
            string2 = httpServletRequest.getRequestURI();
            string = httpServletRequest.getContextPath();
        } else {
            string2 = this.request.getRequestURI();
            string = this.request.getContextPath();
        }
        if (string.length() > 1) {
            string2 = string2.substring(string.length());
        }
        if (!this.context.getDispatchersUseEncodedPaths()) {
            string2 = UDecoder.URLDecode((String)string2, (Charset)StandardCharsets.UTF_8);
        }
        this.dispatch(string2);
    }

    public void dispatch(String string) {
        this.check();
        this.dispatch(this.getRequest().getServletContext(), string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispatch(ServletContext servletContext, String string) {
        Object object = this.asyncContextLock;
        synchronized (object) {
            RequestDispatcher requestDispatcher;
            if (log.isDebugEnabled()) {
                this.logDebug("dispatch   ");
            }
            this.check();
            if (this.dispatch != null) {
                throw new IllegalStateException(sm.getString("asyncContextImpl.dispatchingStarted"));
            }
            if (this.request.getAttribute("javax.servlet.async.request_uri") == null) {
                this.request.setAttribute("javax.servlet.async.request_uri", this.request.getRequestURI());
                this.request.setAttribute("javax.servlet.async.context_path", this.request.getContextPath());
                this.request.setAttribute("javax.servlet.async.servlet_path", this.request.getServletPath());
                this.request.setAttribute("javax.servlet.async.path_info", this.request.getPathInfo());
                this.request.setAttribute("javax.servlet.async.query_string", this.request.getQueryString());
            }
            if (!((requestDispatcher = servletContext.getRequestDispatcher(string)) instanceof AsyncDispatcher)) {
                throw new UnsupportedOperationException(sm.getString("asyncContextImpl.noAsyncDispatcher"));
            }
            AsyncDispatcher asyncDispatcher = (AsyncDispatcher)requestDispatcher;
            ServletRequest servletRequest = this.getRequest();
            ServletResponse servletResponse = this.getResponse();
            this.dispatch = new AsyncRunnable(this.request, asyncDispatcher, servletRequest, servletResponse);
            this.request.getCoyoteRequest().action(ActionCode.ASYNC_DISPATCH, null);
            this.clearServletRequestResponse();
        }
    }

    public ServletRequest getRequest() {
        this.check();
        if (this.servletRequest == null) {
            throw new IllegalStateException(sm.getString("asyncContextImpl.request.ise"));
        }
        return this.servletRequest;
    }

    public ServletResponse getResponse() {
        this.check();
        if (this.servletResponse == null) {
            throw new IllegalStateException(sm.getString("asyncContextImpl.response.ise"));
        }
        return this.servletResponse;
    }

    public void start(Runnable runnable) {
        if (log.isDebugEnabled()) {
            this.logDebug("start      ");
        }
        this.check();
        RunnableWrapper runnableWrapper = new RunnableWrapper(runnable, this.context, this.request.getCoyoteRequest());
        this.request.getCoyoteRequest().action(ActionCode.ASYNC_RUN, (Object)runnableWrapper);
    }

    public void addListener(AsyncListener asyncListener) {
        this.check();
        AsyncListenerWrapper asyncListenerWrapper = new AsyncListenerWrapper();
        asyncListenerWrapper.setListener(asyncListener);
        this.listeners.add(asyncListenerWrapper);
    }

    public void addListener(AsyncListener asyncListener, ServletRequest servletRequest, ServletResponse servletResponse) {
        this.check();
        AsyncListenerWrapper asyncListenerWrapper = new AsyncListenerWrapper();
        asyncListenerWrapper.setListener(asyncListener);
        asyncListenerWrapper.setServletRequest(servletRequest);
        asyncListenerWrapper.setServletResponse(servletResponse);
        this.listeners.add(asyncListenerWrapper);
    }

    public <T extends AsyncListener> T createListener(Class<T> clazz) throws ServletException {
        this.check();
        AsyncListener asyncListener = null;
        try {
            asyncListener = (AsyncListener)this.context.getInstanceManager().newInstance(clazz.getName(), clazz.getClassLoader());
        }
        catch (ReflectiveOperationException | NamingException exception) {
            ServletException servletException = new ServletException((Throwable)exception);
            throw servletException;
        }
        catch (Exception exception) {
            ExceptionUtils.handleThrowable((Throwable)exception.getCause());
            ServletException servletException = new ServletException((Throwable)exception);
            throw servletException;
        }
        return (T)asyncListener;
    }

    public void recycle() {
        if (log.isDebugEnabled()) {
            this.logDebug("recycle    ");
        }
        this.context = null;
        this.dispatch = null;
        this.event = null;
        this.hasOriginalRequestAndResponse = true;
        this.listeners.clear();
        this.request = null;
        this.clearServletRequestResponse();
        this.timeout = -1L;
    }

    private void clearServletRequestResponse() {
        this.servletRequest = null;
        this.servletResponse = null;
    }

    public boolean isStarted() {
        AtomicBoolean atomicBoolean = new AtomicBoolean(false);
        this.request.getCoyoteRequest().action(ActionCode.ASYNC_IS_STARTED, (Object)atomicBoolean);
        return atomicBoolean.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStarted(Context context, ServletRequest servletRequest, ServletResponse servletResponse, boolean bl) {
        Object object = this.asyncContextLock;
        synchronized (object) {
            this.request.getCoyoteRequest().action(ActionCode.ASYNC_START, (Object)this);
            this.context = context;
            context.incrementInProgressAsyncCount();
            this.servletRequest = servletRequest;
            this.servletResponse = servletResponse;
            this.hasOriginalRequestAndResponse = bl;
            this.event = new AsyncEvent((AsyncContext)this, servletRequest, servletResponse);
            ArrayList<AsyncListenerWrapper> arrayList = new ArrayList<AsyncListenerWrapper>(this.listeners);
            this.listeners.clear();
            if (log.isDebugEnabled()) {
                log.debug((Object)sm.getString("asyncContextImpl.fireOnStartAsync"));
            }
            for (AsyncListenerWrapper asyncListenerWrapper : arrayList) {
                try {
                    asyncListenerWrapper.fireOnStartAsync(this.event);
                }
                catch (Throwable throwable) {
                    ExceptionUtils.handleThrowable((Throwable)throwable);
                    log.warn((Object)sm.getString("asyncContextImpl.onStartAsyncError", new Object[]{asyncListenerWrapper.getClass().getName()}), throwable);
                }
            }
        }
    }

    public boolean hasOriginalRequestAndResponse() {
        this.check();
        return this.hasOriginalRequestAndResponse;
    }

    protected void doInternalDispatch() throws ServletException, IOException {
        if (log.isDebugEnabled()) {
            this.logDebug("intDispatch");
        }
        try {
            Runnable runnable = this.dispatch;
            this.dispatch = null;
            runnable.run();
            if (!this.request.isAsync()) {
                this.fireOnComplete();
            }
        }
        catch (RuntimeException runtimeException) {
            if (runtimeException.getCause() instanceof ServletException) {
                throw (ServletException)runtimeException.getCause();
            }
            if (runtimeException.getCause() instanceof IOException) {
                throw (IOException)runtimeException.getCause();
            }
            throw new ServletException((Throwable)runtimeException);
        }
    }

    public long getTimeout() {
        this.check();
        return this.timeout;
    }

    public void setTimeout(long l) {
        this.check();
        this.timeout = l;
        this.request.getCoyoteRequest().action(ActionCode.ASYNC_SETTIMEOUT, (Object)l);
    }

    public boolean isAvailable() {
        Context context = this.context;
        if (context == null) {
            return false;
        }
        return context.getState().isAvailable();
    }

    public void setErrorState(Throwable throwable, boolean bl) {
        Object object;
        Object object2;
        Object object3;
        AtomicBoolean atomicBoolean;
        if (throwable != null) {
            this.request.setAttribute("javax.servlet.error.exception", throwable);
        }
        this.request.getCoyoteRequest().action(ActionCode.ASYNC_ERROR, null);
        if (bl) {
            if (log.isDebugEnabled()) {
                log.debug((Object)sm.getString("asyncContextImpl.fireOnError"));
            }
            atomicBoolean = new AsyncEvent(this.event.getAsyncContext(), this.event.getSuppliedRequest(), this.event.getSuppliedResponse(), throwable);
            object3 = new ArrayList<AsyncListenerWrapper>(this.listeners);
            object2 = object3.iterator();
            while (object2.hasNext()) {
                object = (AsyncListenerWrapper)object2.next();
                try {
                    ((AsyncListenerWrapper)object).fireOnError((AsyncEvent)atomicBoolean);
                }
                catch (Throwable throwable2) {
                    ExceptionUtils.handleThrowable((Throwable)throwable2);
                    log.warn((Object)sm.getString("asyncContextImpl.onErrorError", new Object[]{object.getClass().getName()}), throwable2);
                }
            }
        }
        atomicBoolean = new AtomicBoolean();
        this.request.getCoyoteRequest().action(ActionCode.ASYNC_IS_ERROR, (Object)atomicBoolean);
        if (atomicBoolean.get()) {
            object3 = this.servletResponse;
            if (object3 instanceof HttpServletResponse) {
                ((HttpServletResponse)object3).setStatus(500);
            }
            if ((object = (object2 = (Host)this.context.getParent()).getPipeline().getBasic()) instanceof StandardHostValve) {
                ((StandardHostValve)object).throwable(this.request, this.request.getResponse(), throwable);
            }
            this.request.getCoyoteRequest().action(ActionCode.ASYNC_IS_ERROR, (Object)atomicBoolean);
            if (atomicBoolean.get()) {
                this.complete();
            }
        }
    }

    public void incrementInProgressAsyncCount() {
        this.context.incrementInProgressAsyncCount();
    }

    public void decrementInProgressAsyncCount() {
        this.context.decrementInProgressAsyncCount();
    }

    private void logDebug(String string) {
        Object object;
        String string2;
        String string3;
        String string4;
        String string5;
        StringBuilder stringBuilder = new StringBuilder();
        if (this.request == null) {
            string5 = "null";
            string4 = "null";
            string3 = "null";
            string2 = "-";
            stringBuilder.append("N/A");
        } else {
            string5 = Integer.toHexString(this.request.hashCode());
            object = this.request.getCoyoteRequest();
            if (object == null) {
                string4 = "null";
                string3 = "null";
                string2 = "-";
            } else {
                string4 = Integer.toHexString(object.hashCode());
                RequestInfo requestInfo = object.getRequestProcessor();
                if (requestInfo == null) {
                    string3 = "null";
                    string2 = "-";
                } else {
                    string3 = Integer.toHexString(requestInfo.hashCode());
                    string2 = Integer.toString(requestInfo.getStage());
                }
            }
            stringBuilder.append(this.request.getRequestURI());
            if (this.request.getQueryString() != null) {
                stringBuilder.append('?');
                stringBuilder.append(this.request.getQueryString());
            }
        }
        object = Thread.currentThread().getName();
        int n = ((String)object).length();
        if (n > 20) {
            object = ((String)object).substring(n - 20, n);
        }
        String string6 = String.format("Req: %1$8s  CReq: %2$8s  RP: %3$8s  Stage: %4$s  Thread: %5$20s  State: %6$20s  Method: %7$11s  URI: %8$s", string5, string4, string3, string2, object, "N/A", string, stringBuilder);
        if (log.isTraceEnabled()) {
            log.trace((Object)string6, (Throwable)new DebugException());
        } else {
            log.debug((Object)string6);
        }
    }

    private void check() {
        if (this.request == null) {
            throw new IllegalStateException(sm.getString("asyncContextImpl.requestEnded"));
        }
    }

    private static class AsyncRunnable
    implements Runnable {
        private final AsyncDispatcher applicationDispatcher;
        private final Request request;
        private final ServletRequest servletRequest;
        private final ServletResponse servletResponse;

        public AsyncRunnable(Request request, AsyncDispatcher asyncDispatcher, ServletRequest servletRequest, ServletResponse servletResponse) {
            this.request = request;
            this.applicationDispatcher = asyncDispatcher;
            this.servletRequest = servletRequest;
            this.servletResponse = servletResponse;
        }

        @Override
        public void run() {
            this.request.getCoyoteRequest().action(ActionCode.ASYNC_DISPATCHED, null);
            try {
                this.applicationDispatcher.dispatch(this.servletRequest, this.servletResponse);
            }
            catch (Exception exception) {
                throw new RuntimeException(sm.getString("asyncContextImpl.asyncDispatchError"), exception);
            }
        }
    }

    private static class RunnableWrapper
    implements Runnable {
        private final Runnable wrapped;
        private final Context context;
        private final org.apache.coyote.Request coyoteRequest;

        public RunnableWrapper(Runnable runnable, Context context, org.apache.coyote.Request request) {
            this.wrapped = runnable;
            this.context = context;
            this.coyoteRequest = request;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ClassLoader classLoader = this.context.bind(Globals.IS_SECURITY_ENABLED, null);
            try {
                this.wrapped.run();
            }
            catch (Throwable throwable) {
                ExceptionUtils.handleThrowable((Throwable)throwable);
                this.context.getLogger().error((Object)sm.getString("asyncContextImpl.asyncRunnableError"), throwable);
                this.coyoteRequest.setAttribute("javax.servlet.error.exception", (Object)throwable);
                Response response = this.coyoteRequest.getResponse();
                response.setStatus(500);
                response.setError();
            }
            finally {
                this.context.unbind(Globals.IS_SECURITY_ENABLED, classLoader);
            }
            this.coyoteRequest.action(ActionCode.DISPATCH_EXECUTE, null);
        }
    }

    private static class DebugException
    extends Exception {
        private static final long serialVersionUID = 1L;

        private DebugException() {
        }
    }
}

