/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.http11.upgrade;

import java.util.ArrayList;
import java.util.List;
import org.apache.coyote.http11.upgrade.UpgradeInfo;
import org.apache.tomcat.util.modeler.BaseModelMBean;

public class UpgradeGroupInfo
extends BaseModelMBean {
    private final List<UpgradeInfo> upgradeInfos = new ArrayList<UpgradeInfo>();
    private long deadBytesReceived = 0L;
    private long deadBytesSent = 0L;
    private long deadMsgsReceived = 0L;
    private long deadMsgsSent = 0L;

    public synchronized void addUpgradeInfo(UpgradeInfo upgradeInfo) {
        this.upgradeInfos.add(upgradeInfo);
    }

    public synchronized void removeUpgradeInfo(UpgradeInfo upgradeInfo) {
        if (upgradeInfo != null) {
            this.deadBytesReceived += upgradeInfo.getBytesReceived();
            this.deadBytesSent += upgradeInfo.getBytesSent();
            this.deadMsgsReceived += upgradeInfo.getMsgsReceived();
            this.deadMsgsSent += upgradeInfo.getMsgsSent();
            this.upgradeInfos.remove(upgradeInfo);
        }
    }

    public synchronized long getBytesReceived() {
        long l = this.deadBytesReceived;
        for (UpgradeInfo upgradeInfo : this.upgradeInfos) {
            l += upgradeInfo.getBytesReceived();
        }
        return l;
    }

    public synchronized void setBytesReceived(long l) {
        this.deadBytesReceived = l;
        for (UpgradeInfo upgradeInfo : this.upgradeInfos) {
            upgradeInfo.setBytesReceived(l);
        }
    }

    public synchronized long getBytesSent() {
        long l = this.deadBytesSent;
        for (UpgradeInfo upgradeInfo : this.upgradeInfos) {
            l += upgradeInfo.getBytesSent();
        }
        return l;
    }

    public synchronized void setBytesSent(long l) {
        this.deadBytesSent = l;
        for (UpgradeInfo upgradeInfo : this.upgradeInfos) {
            upgradeInfo.setBytesSent(l);
        }
    }

    public synchronized long getMsgsReceived() {
        long l = this.deadMsgsReceived;
        for (UpgradeInfo upgradeInfo : this.upgradeInfos) {
            l += upgradeInfo.getMsgsReceived();
        }
        return l;
    }

    public synchronized void setMsgsReceived(long l) {
        this.deadMsgsReceived = l;
        for (UpgradeInfo upgradeInfo : this.upgradeInfos) {
            upgradeInfo.setMsgsReceived(l);
        }
    }

    public synchronized long getMsgsSent() {
        long l = this.deadMsgsSent;
        for (UpgradeInfo upgradeInfo : this.upgradeInfos) {
            l += upgradeInfo.getMsgsSent();
        }
        return l;
    }

    public synchronized void setMsgsSent(long l) {
        this.deadMsgsSent = l;
        for (UpgradeInfo upgradeInfo : this.upgradeInfos) {
            upgradeInfo.setMsgsSent(l);
        }
    }

    public void resetCounters() {
        this.setBytesReceived(0L);
        this.setBytesSent(0L);
        this.setMsgsReceived(0L);
        this.setMsgsSent(0L);
    }
}

