/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.http.fileupload.disk;

import java.io.File;
import org.apache.tomcat.util.http.fileupload.FileItem;
import org.apache.tomcat.util.http.fileupload.FileItemFactory;
import org.apache.tomcat.util.http.fileupload.disk.DiskFileItem;

public class DiskFileItemFactory
implements FileItemFactory {
    public static final int DEFAULT_SIZE_THRESHOLD = 10240;
    private File repository;
    private int sizeThreshold = 10240;
    private String defaultCharset = "ISO-8859-1";

    public DiskFileItemFactory() {
        this(10240, null);
    }

    public DiskFileItemFactory(int n, File file) {
        this.sizeThreshold = n;
        this.repository = file;
    }

    public File getRepository() {
        return this.repository;
    }

    public void setRepository(File file) {
        this.repository = file;
    }

    public int getSizeThreshold() {
        return this.sizeThreshold;
    }

    public void setSizeThreshold(int n) {
        this.sizeThreshold = n;
    }

    @Override
    public FileItem createItem(String string, String string2, boolean bl, String string3) {
        DiskFileItem diskFileItem = new DiskFileItem(string, string2, bl, string3, this.sizeThreshold, this.repository);
        diskFileItem.setDefaultCharset(this.defaultCharset);
        return diskFileItem;
    }

    public String getDefaultCharset() {
        return this.defaultCharset;
    }

    public void setDefaultCharset(String string) {
        this.defaultCharset = string;
    }
}

