/* contacts-import-operation.c generated by valac 0.56.3, the Vala compiler
 * generated from contacts-import-operation.vala, do not modify */

/*
 * Copyright (C) 2021 Niels De Graef <nielsdegraef@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "contacts.h"
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>
#include <folks/folks.h>

enum  {
	CONTACTS_IMPORT_OPERATION_0_PROPERTY,
	CONTACTS_IMPORT_OPERATION_REVERSABLE_PROPERTY,
	CONTACTS_IMPORT_OPERATION_DESCRIPTION_PROPERTY,
	CONTACTS_IMPORT_OPERATION_NUM_PROPERTIES
};
static GParamSpec* contacts_import_operation_properties[CONTACTS_IMPORT_OPERATION_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _ContactsImportOperationExecuteData ContactsImportOperationExecuteData;
typedef struct _ContactsImportOperationUndoData ContactsImportOperationUndoData;

struct _ContactsImportOperationPrivate {
	GHashTable** to_import;
	gint to_import_length1;
	gint _to_import_size_;
	ContactsStore* store;
	gchar* _description;
};

struct _ContactsImportOperationExecuteData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ContactsImportOperation* self;
	FolksPersonaStore* primary_store;
	ContactsStore* _tmp0_;
	FolksIndividualAggregator* _tmp1_;
	FolksIndividualAggregator* _tmp2_;
	FolksPersonaStore* _tmp3_;
	FolksPersonaStore* _tmp4_;
	GHashTable** _tmp5_;
	gint _tmp5__length1;
	FolksPersonaStore* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	guint new_count;
	GHashTable** _tmp9_;
	gint _tmp9__length1;
	GHashTable** hashtable_collection;
	gint hashtable_collection_length1;
	gint _hashtable_collection_size_;
	gint hashtable_it;
	GHashTable* hashtable;
	FolksPersona* persona;
	FolksPersonaStore* _tmp10_;
	GHashTable* _tmp11_;
	FolksPersona* _tmp12_;
	FolksPersona* _tmp13_;
	guint _tmp14_;
	GError* _inner_error0_;
};

struct _ContactsImportOperationUndoData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ContactsImportOperation* self;
};

static gint ContactsImportOperation_private_offset;
static gpointer contacts_import_operation_parent_class = NULL;

static GHashTable** _vala_array_dup1 (GHashTable** self,
                               gssize length);
static void contacts_import_operation_real_execute_data_free (gpointer _data);
static void contacts_import_operation_real_execute (ContactsOperation* base,
                                             GAsyncReadyCallback _callback_,
                                             gpointer _user_data_);
static gboolean contacts_import_operation_real_execute_co (ContactsImportOperationExecuteData* _data_);
static void contacts_import_operation_execute_ready (GObject* source_object,
                                              GAsyncResult* _res_,
                                              gpointer _user_data_);
static void contacts_import_operation_real__undo_data_free (gpointer _data);
static void contacts_import_operation_real__undo (ContactsOperation* base,
                                           GAsyncReadyCallback _callback_,
                                           gpointer _user_data_);
static gboolean contacts_import_operation_real__undo_co (ContactsImportOperationUndoData* _data_);
static void contacts_import_operation_finalize (GObject * obj);
static GType contacts_import_operation_get_type_once (void);
static void _vala_contacts_import_operation_get_property (GObject * object,
                                                   guint property_id,
                                                   GValue * value,
                                                   GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
contacts_import_operation_get_instance_private (ContactsImportOperation* self)
{
	return G_STRUCT_MEMBER_P (self, ContactsImportOperation_private_offset);
}

static gpointer
_g_hash_table_ref0 (gpointer self)
{
	return self ? g_hash_table_ref (self) : NULL;
}

static GHashTable**
_vala_array_dup1 (GHashTable** self,
                  gssize length)
{
	if (length >= 0) {
		GHashTable** result;
		gssize i;
		result = g_new0 (GHashTable*, length + 1);
		for (i = 0; i < length; i++) {
			GHashTable* _tmp0_;
			_tmp0_ = _g_hash_table_ref0 (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

ContactsImportOperation*
contacts_import_operation_construct (GType object_type,
                                     ContactsStore* store,
                                     GHashTable** to_import,
                                     gint to_import_length1)
{
	ContactsImportOperation * self = NULL;
	GHashTable** _tmp0_;
	gint _tmp0__length1;
	gchar* _tmp1_;
	g_return_val_if_fail (store != NULL, NULL);
	self = (ContactsImportOperation*) contacts_operation_construct (object_type);
	_tmp0_ = (to_import != NULL) ? _vala_array_dup1 (to_import, to_import_length1) : to_import;
	_tmp0__length1 = to_import_length1;
	self->priv->to_import = (_vala_array_free (self->priv->to_import, self->priv->to_import_length1, (GDestroyNotify) g_hash_table_unref), NULL);
	self->priv->to_import = _tmp0_;
	self->priv->to_import_length1 = _tmp0__length1;
	self->priv->_to_import_size_ = self->priv->to_import_length1;
	self->priv->store = store;
	_tmp1_ = g_strdup_printf (ngettext ("Imported %u contact", "Imported %u contacts", (gulong) to_import_length1), (guint) to_import_length1);
	_g_free0 (self->priv->_description);
	self->priv->_description = _tmp1_;
	return self;
}

ContactsImportOperation*
contacts_import_operation_new (ContactsStore* store,
                               GHashTable** to_import,
                               gint to_import_length1)
{
	return contacts_import_operation_construct (CONTACTS_TYPE_IMPORT_OPERATION, store, to_import, to_import_length1);
}

static void
contacts_import_operation_real_execute_data_free (gpointer _data)
{
	ContactsImportOperationExecuteData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (ContactsImportOperationExecuteData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
contacts_import_operation_real_execute (ContactsOperation* base,
                                        GAsyncReadyCallback _callback_,
                                        gpointer _user_data_)
{
	ContactsImportOperation * self;
	ContactsImportOperationExecuteData* _data_;
	ContactsImportOperation* _tmp0_;
	self = (ContactsImportOperation*) base;
	_data_ = g_slice_new0 (ContactsImportOperationExecuteData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, contacts_import_operation_real_execute_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	contacts_import_operation_real_execute_co (_data_);
}

static void
contacts_import_operation_execute_finish (ContactsOperation* base,
                                          GAsyncResult* _res_,
                                          GError** error)
{
	ContactsImportOperationExecuteData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

static void
contacts_import_operation_execute_ready (GObject* source_object,
                                         GAsyncResult* _res_,
                                         gpointer _user_data_)
{
	ContactsImportOperationExecuteData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	contacts_import_operation_real_execute_co (_data_);
}

static gboolean
contacts_import_operation_real_execute_co (ContactsImportOperationExecuteData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->store;
	_data_->_tmp1_ = contacts_store_get_aggregator (_data_->_tmp0_);
	_data_->_tmp2_ = _data_->_tmp1_;
	_data_->_tmp3_ = folks_individual_aggregator_get_primary_store (_data_->_tmp2_);
	_data_->_tmp4_ = _data_->_tmp3_;
	_data_->primary_store = _data_->_tmp4_;
	_data_->_tmp5_ = _data_->self->priv->to_import;
	_data_->_tmp5__length1 = _data_->self->priv->to_import_length1;
	_data_->_tmp6_ = _data_->primary_store;
	_data_->_tmp7_ = folks_persona_store_get_display_name (_data_->_tmp6_);
	_data_->_tmp8_ = _data_->_tmp7_;
	g_debug ("contacts-import-operation.vala:47: Importing %u contacts to primary st" \
"ore '%s'", (guint) _data_->_tmp5__length1, _data_->_tmp8_);
	_data_->new_count = (guint) 0;
	_data_->_tmp9_ = _data_->self->priv->to_import;
	_data_->_tmp9__length1 = _data_->self->priv->to_import_length1;
	{
		_data_->hashtable_collection_length1 = 0;
		_data_->_hashtable_collection_size_ = 0;
		_data_->hashtable_collection = _data_->_tmp9_;
		_data_->hashtable_collection_length1 = _data_->_tmp9__length1;
		for (_data_->hashtable_it = 0; _data_->hashtable_it < _data_->hashtable_collection_length1; _data_->hashtable_it = _data_->hashtable_it + 1) {
			_data_->hashtable = _data_->hashtable_collection[_data_->hashtable_it];
			{
				_data_->_tmp10_ = _data_->primary_store;
				_data_->_tmp11_ = _data_->hashtable;
				_data_->_state_ = 1;
				folks_persona_store_add_persona_from_details (_data_->_tmp10_, _data_->_tmp11_, contacts_import_operation_execute_ready, _data_);
				return FALSE;
				_state_1:
				_data_->_tmp12_ = folks_persona_store_add_persona_from_details_finish (_data_->_tmp10_, _data_->_res_, &_data_->_inner_error0_);
				_data_->persona = _data_->_tmp12_;
				if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
					g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
					g_object_unref (_data_->_async_result);
					return FALSE;
				}
				_data_->_tmp13_ = _data_->persona;
				if (_data_->_tmp13_ != NULL) {
					g_debug ("contacts-import-operation.vala:54: Created new persona");
					_data_->_tmp14_ = _data_->new_count;
					_data_->new_count = _data_->_tmp14_ + 1;
				} else {
					g_debug ("contacts-import-operation.vala:57: Added persona; no new created");
				}
				_g_object_unref0 (_data_->persona);
			}
		}
	}
	g_debug ("contacts-import-operation.vala:61: Done importing; got %u new contacts", _data_->new_count);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
contacts_import_operation_real__undo_data_free (gpointer _data)
{
	ContactsImportOperationUndoData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (ContactsImportOperationUndoData, _data_);
}

static void
contacts_import_operation_real__undo (ContactsOperation* base,
                                      GAsyncReadyCallback _callback_,
                                      gpointer _user_data_)
{
	ContactsImportOperation * self;
	ContactsImportOperationUndoData* _data_;
	ContactsImportOperation* _tmp0_;
	self = (ContactsImportOperation*) base;
	_data_ = g_slice_new0 (ContactsImportOperationUndoData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, contacts_import_operation_real__undo_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	contacts_import_operation_real__undo_co (_data_);
}

static void
_contacts_import_operation_undo_finish (ContactsOperation* base,
                                        GAsyncResult* _res_,
                                        GError** error)
{
	ContactsImportOperationUndoData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

static gboolean
contacts_import_operation_real__undo_co (ContactsImportOperationUndoData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	g_return_if_reached ();
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static gboolean
contacts_import_operation_real_get_reversable (ContactsOperation* base)
{
	gboolean result;
	ContactsImportOperation* self;
	self = (ContactsImportOperation*) base;
	result = FALSE;
	return result;
}

static gchar*
contacts_import_operation_real_get_description (ContactsOperation* base)
{
	gchar* result;
	ContactsImportOperation* self;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	self = (ContactsImportOperation*) base;
	_tmp0_ = self->priv->_description;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}

static void
contacts_import_operation_class_init (ContactsImportOperationClass * klass,
                                      gpointer klass_data)
{
	contacts_import_operation_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ContactsImportOperation_private_offset);
	((ContactsOperationClass *) klass)->execute = (void (*) (ContactsOperation*, GAsyncReadyCallback, gpointer)) contacts_import_operation_real_execute;
	((ContactsOperationClass *) klass)->execute_finish = (void (*) (ContactsOperation*, GAsyncResult*, GError**)) contacts_import_operation_execute_finish;
	((ContactsOperationClass *) klass)->_undo = (void (*) (ContactsOperation*, GAsyncReadyCallback, gpointer)) contacts_import_operation_real__undo;
	((ContactsOperationClass *) klass)->_undo_finish = (void (*) (ContactsOperation*, GAsyncResult*, GError**)) _contacts_import_operation_undo_finish;
	CONTACTS_OPERATION_CLASS (klass)->get_reversable = contacts_import_operation_real_get_reversable;
	CONTACTS_OPERATION_CLASS (klass)->get_description = contacts_import_operation_real_get_description;
	G_OBJECT_CLASS (klass)->get_property = _vala_contacts_import_operation_get_property;
	G_OBJECT_CLASS (klass)->finalize = contacts_import_operation_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONTACTS_IMPORT_OPERATION_REVERSABLE_PROPERTY, contacts_import_operation_properties[CONTACTS_IMPORT_OPERATION_REVERSABLE_PROPERTY] = g_param_spec_boolean ("reversable", "reversable", "reversable", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONTACTS_IMPORT_OPERATION_DESCRIPTION_PROPERTY, contacts_import_operation_properties[CONTACTS_IMPORT_OPERATION_DESCRIPTION_PROPERTY] = g_param_spec_string ("description", "description", "description", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
contacts_import_operation_instance_init (ContactsImportOperation * self,
                                         gpointer klass)
{
	self->priv = contacts_import_operation_get_instance_private (self);
}

static void
contacts_import_operation_finalize (GObject * obj)
{
	ContactsImportOperation * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CONTACTS_TYPE_IMPORT_OPERATION, ContactsImportOperation);
	self->priv->to_import = (_vala_array_free (self->priv->to_import, self->priv->to_import_length1, (GDestroyNotify) g_hash_table_unref), NULL);
	_g_free0 (self->priv->_description);
	G_OBJECT_CLASS (contacts_import_operation_parent_class)->finalize (obj);
}

/**
 * A ImportOperation takes an array of serialized contacts (represented by
 * {@link GLib.HashTable}s) which can then be imported using
 * {@link Folks.PersonaStore.add_persona_from_details}.
 */
 G_GNUC_NO_INLINE static GType
contacts_import_operation_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ContactsImportOperationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) contacts_import_operation_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ContactsImportOperation), 0, (GInstanceInitFunc) contacts_import_operation_instance_init, NULL };
	GType contacts_import_operation_type_id;
	contacts_import_operation_type_id = g_type_register_static (CONTACTS_TYPE_OPERATION, "ContactsImportOperation", &g_define_type_info, 0);
	ContactsImportOperation_private_offset = g_type_add_instance_private (contacts_import_operation_type_id, sizeof (ContactsImportOperationPrivate));
	return contacts_import_operation_type_id;
}

GType
contacts_import_operation_get_type (void)
{
	static volatile gsize contacts_import_operation_type_id__once = 0;
	if (g_once_init_enter (&contacts_import_operation_type_id__once)) {
		GType contacts_import_operation_type_id;
		contacts_import_operation_type_id = contacts_import_operation_get_type_once ();
		g_once_init_leave (&contacts_import_operation_type_id__once, contacts_import_operation_type_id);
	}
	return contacts_import_operation_type_id__once;
}

static void
_vala_contacts_import_operation_get_property (GObject * object,
                                              guint property_id,
                                              GValue * value,
                                              GParamSpec * pspec)
{
	ContactsImportOperation * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CONTACTS_TYPE_IMPORT_OPERATION, ContactsImportOperation);
	switch (property_id) {
		case CONTACTS_IMPORT_OPERATION_REVERSABLE_PROPERTY:
		g_value_set_boolean (value, contacts_operation_get_reversable ((ContactsOperation*) self));
		break;
		case CONTACTS_IMPORT_OPERATION_DESCRIPTION_PROPERTY:
		g_value_take_string (value, contacts_operation_get_description ((ContactsOperation*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

